/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public abstract class ViewerBehavior
extends Behavior {
    protected TransformGroup subjectTransformGroup = null;
    protected WakeupCriterion[] mouseEvents = null;
    protected WakeupOr mouseCriterion = null;
    protected static final int BUTTONNONE = -1;
    protected static final int BUTTON1 = 0;
    protected static final int BUTTON2 = 1;
    protected static final int BUTTON3 = 2;
    protected int buttonPressed = -1;
    protected Transform3D currentTransform = new Transform3D();
    protected Transform3D transform1 = new Transform3D();
    protected Transform3D transform2 = new Transform3D();
    protected Matrix4d matrix = new Matrix4d();
    protected Vector3d origin = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d translate = new Vector3d(0.0, 0.0, 0.0);
    protected static final int UNUSUAL_XDELTA = 400;
    protected static final int UNUSUAL_YDELTA = 400;
    protected Component parentComponent = null;
    public static final double DEFAULT_XROTATION_FACTOR = 0.02;
    public static final double DEFAULT_YROTATION_FACTOR = 0.005;
    public static final double DEFAULT_XTRANSLATION_FACTOR = 0.02;
    public static final double DEFAULT_YTRANSLATION_FACTOR = 0.02;
    public static final double DEFAULT_ZTRANSLATION_FACTOR = 0.04;
    protected double XRotationFactor = 0.02;
    protected double YRotationFactor = 0.005;
    protected double XTranslationFactor = 0.02;
    protected double YTranslationFactor = 0.02;
    protected double ZTranslationFactor = 0.04;

    public ViewerBehavior() {
    }

    public ViewerBehavior(Component parent) {
        this.parentComponent = parent;
    }

    public ViewerBehavior(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
    }

    public ViewerBehavior(TransformGroup transformGroup, Component parent) {
        this.subjectTransformGroup = transformGroup;
        this.parentComponent = parent;
    }

    public void setTransformGroup(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
    }

    public TransformGroup getTransformGroup() {
        return this.subjectTransformGroup;
    }

    public void setParentComponent(Component parent) {
        this.parentComponent = parent;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void initialize() {
        this.mouseEvents = new WakeupCriterion[3];
        this.mouseEvents[0] = new WakeupOnAWTEvent(506);
        this.mouseEvents[1] = new WakeupOnAWTEvent(501);
        this.mouseEvents[2] = new WakeupOnAWTEvent(502);
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void processStimulus(Enumeration criteria) {
        WakeupCriterion wakeup = null;
        AWTEvent[] event = null;
        int whichButton = -1;
        while (criteria.hasMoreElements()) {
            wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                for (int i = 0; i < event.length; ++i) {
                    if (event[i].getID() != 501 && event[i].getID() != 502 && event[i].getID() != 506 || event[i].getID() == 501 && this.buttonPressed != -1 || event[i].getID() == 502 && this.buttonPressed == -1 || event[i].getID() == 506 && this.buttonPressed == -1) continue;
                    MouseEvent mev = (MouseEvent)event[i];
                    int modifiers = mev.getModifiers();
                    if (this.buttonPressed == -1) {
                        whichButton = (modifiers & 4) != 0 || (modifiers & 0x10) != 0 && (modifiers & 2) == 2 ? 2 : ((modifiers & 8) != 0 ? 1 : 0);
                        if (event[i].getID() == 501) {
                            this.buttonPressed = whichButton;
                        }
                    } else {
                        whichButton = this.buttonPressed;
                    }
                    switch (whichButton) {
                        case 0: {
                            this.onButton1(mev);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    if (event[i].getID() != 502) continue;
                    this.buttonPressed = -1;
                }
                continue;
            }
            if (!(wakeup instanceof WakeupOnElapsedFrames)) continue;
            this.onElapsedFrames((WakeupOnElapsedFrames)wakeup);
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void setXRotationFactor(double factor) {
        this.XRotationFactor = factor;
    }

    public double getXRotationFactor() {
        return this.XRotationFactor;
    }

    public void setYRotationFactor(double factor) {
        this.YRotationFactor = factor;
    }

    public double getYRotationFactor() {
        return this.YRotationFactor;
    }

    public void setXTranslationFactor(double factor) {
        this.XTranslationFactor = factor;
    }

    public double getXTranslationFactor() {
        return this.XTranslationFactor;
    }

    public void setYTranslationFactor(double factor) {
        this.YTranslationFactor = factor;
    }

    public double getYTranslationFactor() {
        return this.YTranslationFactor;
    }

    public void setZTranslationFactor(double factor) {
        this.ZTranslationFactor = factor;
    }

    public double getZTranslationFactor() {
        return this.ZTranslationFactor;
    }

    public abstract void onButton1(MouseEvent var1);

    public abstract void onButton2(MouseEvent var1);

    public abstract void onButton3(MouseEvent var1);

    public abstract void onElapsedFrames(WakeupOnElapsedFrames var1);
}

