/*
 * Decompiled with CFR 0.152.
 */
import GUI.MainGUI;
import GUI.MyJInternalFrame;
import java.awt.Color;
import threads.ExtractMap;

public class BMapBuilder {
    static BMapBuilder bMapBuilder;

    public static boolean getSimpleArgument(String[] args, String argument) {
        String all = "-" + argument;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(all)) continue;
            return true;
        }
        return false;
    }

    public static boolean findNoGUI(String[] args) {
        return BMapBuilder.getSimpleArgument(args, "ng");
    }

    public static boolean getHelp(String[] args) {
        return BMapBuilder.getSimpleArgument(args, "h");
    }

    public static boolean hasHeading(String[] args) {
        return BMapBuilder.getSimpleArgument(args, "head");
    }

    public static String getComposedArgument(String[] args, String argument) {
        String first = "-" + argument;
        for (int i = 0; i < args.length; ++i) {
            String[] splits = args[i].split("=");
            if (!splits[0].equals(first)) continue;
            return splits[1];
        }
        return null;
    }

    public static String getInputFile(String[] args) {
        return BMapBuilder.getComposedArgument(args, "f");
    }

    public static String getOutputFile(String[] args) {
        String outputFile = "outputFile.png";
        String of = BMapBuilder.getComposedArgument(args, "o");
        if (of != null) {
            outputFile = of;
        }
        return outputFile;
    }

    public static String getAnnotatedFile1(String[] args) {
        return BMapBuilder.getComposedArgument(args, "an1");
    }

    public static String getAnnotatedFile2(String[] args) {
        return BMapBuilder.getComposedArgument(args, "an2");
    }

    public static int getSNP1Column(String[] args) {
        String snp1 = BMapBuilder.getComposedArgument(args, "snp1");
        int SNP1 = 0;
        if (snp1 != null) {
            SNP1 = Integer.parseInt(snp1);
        }
        return SNP1;
    }

    public static int getSNP2Column(String[] args) {
        String snp2 = BMapBuilder.getComposedArgument(args, "snp2");
        int SNP2 = 1;
        if (snp2 != null) {
            SNP2 = Integer.parseInt(snp2);
        }
        return SNP2;
    }

    public static int getSNP1AColumn(String[] args) {
        String snp1A = BMapBuilder.getComposedArgument(args, "snp1A");
        int SNP1A = -1;
        if (snp1A != null) {
            SNP1A = Integer.parseInt(snp1A);
        }
        return SNP1A;
    }

    public static int getSNP2AColumn(String[] args) {
        String snp2A = BMapBuilder.getComposedArgument(args, "snp2A");
        int SNP2A = -1;
        if (snp2A != null) {
            SNP2A = Integer.parseInt(snp2A);
        }
        return SNP2A;
    }

    public static int getEstimatorColumn(String[] args) {
        String est = BMapBuilder.getComposedArgument(args, "est");
        int EST = 2;
        if (est != null) {
            EST = Integer.parseInt(est);
        }
        return EST;
    }

    public static int getMAF1Column(String[] args) {
        String maf1 = BMapBuilder.getComposedArgument(args, "MAF1");
        int MAF1 = -1;
        if (maf1 != null) {
            MAF1 = Integer.parseInt(maf1);
        }
        return MAF1;
    }

    public static int getMAF2Column(String[] args) {
        String maf2 = BMapBuilder.getComposedArgument(args, "MAF2");
        int MAF2 = -1;
        if (maf2 != null) {
            MAF2 = Integer.parseInt(maf2);
        }
        return MAF2;
    }

    public static int getFirstPosition(String[] args) {
        String fp = BMapBuilder.getComposedArgument(args, "firstPos");
        int FP = 0;
        if (fp != null) {
            FP = Integer.parseInt(fp);
        }
        return FP;
    }

    public static int getLastPosition(String[] args) {
        String lp = BMapBuilder.getComposedArgument(args, "lastPos");
        int LP = Integer.MAX_VALUE;
        if (lp != null) {
            LP = Integer.parseInt(lp);
        }
        return LP;
    }

    public static int getResolution(String[] args) {
        String res = BMapBuilder.getComposedArgument(args, "res");
        int RES = 1;
        if (res != null) {
            RES = Integer.parseInt(res);
        }
        return RES;
    }

    public static float getMAF(String[] args) {
        String maf = BMapBuilder.getComposedArgument(args, "MAF");
        float MAF = 0.0f;
        if (maf != null) {
            MAF = Float.parseFloat(maf);
        }
        return MAF;
    }

    public static long getMaxDistance(String[] args) {
        String md = BMapBuilder.getComposedArgument(args, "MD");
        long MD = 500000L;
        if (md != null) {
            MD = Long.parseLong(md);
        }
        return MD;
    }

    public static Color getColor(String[] args) {
        String c = BMapBuilder.getComposedArgument(args, "c");
        Color color = Color.red;
        if (c != null) {
            switch (c.charAt(0)) {
                case 'g': {
                    color = Color.green;
                    break;
                }
                case 'b': {
                    color = Color.blue;
                }
            }
        }
        return color;
    }

    public static void printHelp() {
        System.out.println("To use more memory, -Xmx?M, where ? must be replaced by the memory in Megabytes to be used");
        System.out.println("To use command line interface to produce 2D LD maps (png format), -ng. In this case you need to add the following arguments:");
        System.out.println("Input file (mandatory):  -f=?, where ? must be replace by the name (including path) where the input file is placed");
        System.out.println("Output file (default: outputFile.png):  -o=?, where ? must be replace by the name (including path) where the output file should be placed");
        System.out.println("SNP1 column (default: 0):  -snp1=?, where ? must be replace by the column (starting at 0) where the position for SNP1 is placed in the file");
        System.out.println("SNP2 column (default: 0):  -snp2=?, where ? must be replace by the column (starting at 0) where the position for SNP2 is placed in the file");
        System.out.println("Estimator column (default: 2):  -est=?, where ? must be replace by the column (starting at 0) where the estimated value is placed in the file");
        System.out.println("Map color (default: red):  -c=?, where ? must be replace by 'g' for green or 'b' for blue");
        System.out.println("Max distance (default: 500Kbp):  MD=?, where ? must be replace by the maximum distance (in base pairs)");
        System.out.println("Map resolution (default: 1): res=?, where ? must be replace by the resolution chosen (an integer in the interval [1,20]");
        System.out.println("First position (default: 0):  firstPos=?, where ? must be replace by the first position in the file to be used for the map");
        System.out.println("First position (default: last position in the file):  lastPos=?, where ? must be replace by the last position in the file to be used for the map");
        System.out.println("MAF1 position (default: non used):  MAF1=?, where ? must be replace by the column in the file where the MAF for the SNP 1 is placed");
        System.out.println("MAF2 position (default: non used):  MAF2=?, where ? must be replace by the column in the file where the MAF for the SNP 2 is placed");
        System.out.println("Minor allele frencuecy (MAF) (default: ]0):  MAF=?, where ? must be replace by the MAF");
        System.out.println("Annotated file 1 (default: none):  -an1=?, where ? must be replace by the name (including path) where the annotated file 1 is placed");
        System.out.println("Annotated file 2 (default: none):  -an2=?, where ? must be replace by the name (including path) where the annotated file 2 is placed");
        System.out.println("SNP1 column for annotated file (default: none):  -snp1A=?, where ? must be replace by the column (starting at 0) where the position for SNP1 for annotated file is placed in the file");
        System.out.println("SNP2 column for annotated file (default: none):  -snp2A=?, where ? must be replace by the column (starting at 0) where the position for SNP2 for annotated file is placed in the file");
    }

    public static void main(String[] args) {
        if (!BMapBuilder.findNoGUI(args)) {
            MainGUI.launchMainGUI();
            return;
        }
        if (BMapBuilder.getInputFile(args) == null) {
            System.err.println("You must enter a file name");
            BMapBuilder.printHelp();
            return;
        }
        if (BMapBuilder.getHelp(args)) {
            BMapBuilder.printHelp();
            return;
        }
        MainGUI mainGUI = null;
        MyJInternalFrame myJInternalFrame = null;
        ExtractMap extractMap = new ExtractMap(mainGUI, myJInternalFrame, BMapBuilder.getSNP1Column(args), BMapBuilder.getSNP2Column(args), BMapBuilder.getSNP1AColumn(args), BMapBuilder.getSNP2AColumn(args), BMapBuilder.getEstimatorColumn(args), BMapBuilder.getMAF1Column(args), BMapBuilder.getMAF2Column(args), BMapBuilder.hasHeading(args), BMapBuilder.getMAF(args), BMapBuilder.getMaxDistance(args), BMapBuilder.getFirstPosition(args), BMapBuilder.getLastPosition(args), BMapBuilder.getInputFile(args), BMapBuilder.getAnnotatedFile1(args), BMapBuilder.getAnnotatedFile2(args), BMapBuilder.getColor(args), BMapBuilder.getResolution(args), BMapBuilder.getOutputFile(args));
    }
}

