/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FilterPanel
extends JPanel {
    float MAF;
    long maxDistance;
    int firstPosition;
    int lastPosition;
    JLabel lMAF;
    JLabel lmaxDistance;
    JLabel lFirstPosition;
    JLabel lLastPosition;
    JTextField tMAF;
    JTextField tmaxDistance;
    JTextField tMAF2;
    JTextField tmaxDistance2;
    JTextField tFirstPosition;
    JTextField tLastPosition;
    JTextField tFirstPosition2;
    JTextField tLastPosition2;
    JButton bMAF;
    JButton bMaxDistance;
    JButton bFirstPosition;
    JButton bLastPosition;

    public FilterPanel(float MAF, int maxDistance, int firstPosition, int lastPosition) {
        this.MAF = MAF;
        this.maxDistance = maxDistance;
        this.firstPosition = firstPosition;
        this.lastPosition = lastPosition;
        this.printPanel();
    }

    public FilterPanel() {
        this.MAF = 0.0f;
        this.maxDistance = 500000L;
        this.firstPosition = 0;
        this.lastPosition = Integer.MAX_VALUE;
        this.printPanel();
    }

    public FilterPanel(FilterPanel fP) {
        this.MAF = fP.getMAF();
        this.maxDistance = fP.getMaxDistance();
        this.firstPosition = fP.getFirstPosition();
        this.lastPosition = fP.getLastPosition();
        this.printPanel();
    }

    public void disableMAF() {
        this.tMAF.setEnabled(false);
    }

    public void printPanel() {
        this.setLayout(new GridLayout(5, 3));
        this.lMAF = new JLabel(" MAF:");
        this.bMAF = new JButton(">>");
        this.tMAF = new JTextField(String.valueOf(this.MAF), 4);
        this.bMAF.addActionListener(new F1ActionListener());
        this.tMAF2 = new JTextField(String.valueOf(this.MAF), 4);
        this.tMAF2.setEditable(false);
        this.tMAF2.setBackground(Color.orange);
        this.lmaxDistance = new JLabel(" Max. distance (kb):");
        this.bMaxDistance = new JButton(">>");
        this.tmaxDistance = new JTextField(String.valueOf(this.maxDistance / 1000L), 7);
        this.bMaxDistance.addActionListener(new F2ActionListener());
        this.tmaxDistance2 = new JTextField(String.valueOf(this.maxDistance / 1000L), 7);
        this.tmaxDistance2.setEditable(false);
        this.tmaxDistance2.setBackground(Color.orange);
        this.lFirstPosition = new JLabel(" Initial SNP position:");
        this.bFirstPosition = new JButton(">>");
        this.tFirstPosition = new JTextField(String.valueOf(this.firstPosition), 7);
        this.bFirstPosition.addActionListener(new F3ActionListener());
        if (this.firstPosition == 0) {
            this.tFirstPosition2 = new JTextField("First SNP position in file");
        }
        this.tFirstPosition2 = new JTextField(String.valueOf(this.firstPosition), 7);
        this.tFirstPosition2.setEditable(false);
        this.tFirstPosition2.setBackground(Color.orange);
        this.lLastPosition = new JLabel(" Last SNP position:");
        this.bLastPosition = new JButton(">>");
        this.tLastPosition = new JTextField(String.valueOf(this.lastPosition), 7);
        this.bLastPosition.addActionListener(new F4ActionListener());
        this.tLastPosition2 = this.lastPosition == Integer.MAX_VALUE ? new JTextField("Last SNP position in file") : new JTextField(String.valueOf(this.lastPosition), 7);
        this.tLastPosition2.setEditable(false);
        this.tLastPosition2.setBackground(Color.orange);
        this.add(this.lMAF);
        this.add(this.tMAF);
        this.add(this.bMAF);
        this.add(this.tMAF2);
        this.add(this.lmaxDistance);
        this.add(this.tmaxDistance);
        this.add(this.bMaxDistance);
        this.add(this.tmaxDistance2);
        this.add(this.lFirstPosition);
        this.add(this.tFirstPosition);
        this.add(this.bFirstPosition);
        this.add(this.tFirstPosition2);
        this.add(this.lLastPosition);
        this.add(this.tLastPosition);
        this.add(this.bLastPosition);
        this.add(this.tLastPosition2);
    }

    public float getMAF() {
        return this.MAF;
    }

    public long getMaxDistance() {
        return this.maxDistance;
    }

    public int getFirstPosition() {
        return this.firstPosition;
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    class F4ActionListener
    implements ActionListener {
        F4ActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FilterPanel.this.lastPosition = Integer.parseInt(FilterPanel.this.tLastPosition.getText());
            FilterPanel.this.tLastPosition2.setText("" + FilterPanel.this.lastPosition);
        }
    }

    class F3ActionListener
    implements ActionListener {
        F3ActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FilterPanel.this.firstPosition = Integer.parseInt(FilterPanel.this.tFirstPosition.getText());
            FilterPanel.this.tFirstPosition2.setText("" + FilterPanel.this.firstPosition);
        }
    }

    class F2ActionListener
    implements ActionListener {
        F2ActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FilterPanel.this.maxDistance = Long.parseLong(FilterPanel.this.tmaxDistance.getText()) * 1000L;
            FilterPanel.this.tmaxDistance2.setText("" + FilterPanel.this.maxDistance / 1000L);
        }
    }

    class F1ActionListener
    implements ActionListener {
        F1ActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FilterPanel.this.MAF = Float.parseFloat(FilterPanel.this.tMAF.getText());
            FilterPanel.this.tMAF2.setText("" + FilterPanel.this.MAF);
        }
    }
}

