/*
 * Decompiled with CFR 0.152.
 */
package BMap2D;

import BMap2D.Image;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Panel2D
extends JPanel {
    JComboBox cColor;
    JComboBox cResolution;
    JLabel lColor;
    JLabel lResolution;
    JTextField[] tColor;
    JTextField tResolution;
    Color c;
    int resolution;
    int R;
    int G;
    int B;
    Image im;
    int scale;
    Color c2;

    public Panel2D(Color c, int resolution) {
        this.c = c;
        this.resolution = resolution;
        this.printPanel();
    }

    public Panel2D(Panel2D p2) {
        this.c = p2.getColor();
        this.resolution = p2.getResolution();
        this.printPanel();
    }

    public Panel2D() {
        this.resolution = 1;
        this.c = Color.red;
        this.printPanel();
    }

    public void printPanel() {
        int i;
        this.setLayout(new GridLayout(2, 3));
        this.tColor = new JTextField[10];
        JPanel jP = new JPanel();
        jP.setLayout(new GridLayout(1, 10));
        for (i = 0; i < 10; ++i) {
            this.tColor[i] = new JTextField("");
            this.scale = Math.round((float)Math.ceil(i));
            this.im = new Image();
            this.G = this.R = Image.GetColorLevel(this.scale);
            this.B = this.R;
            if (this.c == Color.red) {
                this.R = 255;
            }
            if (this.c == Color.green) {
                this.G = 255;
            }
            if (this.c == Color.blue) {
                this.B = 255;
            }
            this.c2 = new Color(this.R, this.G, this.B);
            this.tColor[i].setBackground(this.c2);
            this.tColor[i].setEditable(false);
            jP.add(this.tColor[i]);
        }
        this.tResolution = new JTextField(String.valueOf(this.resolution));
        this.tResolution.setEditable(false);
        this.lColor = new JLabel(" Color scale: \n- -> + LD");
        this.lResolution = new JLabel(" Resolution:");
        this.cColor = new JComboBox();
        this.cResolution = new JComboBox();
        for (i = 0; i < 20; ++i) {
            this.cResolution.addItem(new String(" " + (i + 1)));
        }
        this.cResolution.setSelectedIndex(this.resolution - 1);
        this.cResolution.addActionListener(new ResolutionActionListener());
        this.cColor.addItem(new String("red"));
        this.cColor.addItem(new String("green"));
        this.cColor.addItem(new String("blue"));
        if (this.c == Color.red) {
            this.cColor.setSelectedIndex(0);
        }
        if (this.c == Color.green) {
            this.cColor.setSelectedIndex(1);
        }
        if (this.c == Color.blue) {
            this.cColor.setSelectedIndex(2);
        }
        this.cColor.addActionListener(new ColorActionListener());
        this.add(this.lColor);
        this.add(this.cColor);
        this.add(jP);
        this.add(this.lResolution);
        this.add(this.cResolution);
        this.add(this.tResolution);
    }

    public Color getColor() {
        return this.c;
    }

    public int getResolution() {
        return this.resolution;
    }

    class ColorActionListener
    implements ActionListener {
        ColorActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int i = ((JComboBox)e.getSource()).getSelectedIndex();
            if (i == 0) {
                Panel2D.this.c = Color.red;
            }
            if (i == 1) {
                Panel2D.this.c = Color.green;
            }
            if (i == 2) {
                Panel2D.this.c = Color.blue;
            }
            for (int j = 0; j < 10; ++j) {
                Panel2D.this.scale = Math.round((float)Math.ceil(j));
                Image cfr_ignored_0 = Panel2D.this.im;
                Panel2D.this.G = Panel2D.this.R = Image.GetColorLevel(Panel2D.this.scale);
                Panel2D.this.B = Panel2D.this.R;
                if (Panel2D.this.c == Color.red) {
                    Panel2D.this.R = 255;
                }
                if (Panel2D.this.c == Color.green) {
                    Panel2D.this.G = 255;
                }
                if (Panel2D.this.c == Color.blue) {
                    Panel2D.this.B = 255;
                }
                Panel2D.this.c2 = new Color(Panel2D.this.R, Panel2D.this.G, Panel2D.this.B);
                Panel2D.this.tColor[j].setBackground(Panel2D.this.c2);
            }
        }
    }

    class ResolutionActionListener
    implements ActionListener {
        ResolutionActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Panel2D.this.resolution = ((JComboBox)e.getSource()).getSelectedIndex() + 1;
            Panel2D.this.tResolution.setText(String.valueOf(Panel2D.this.resolution));
        }
    }
}

