/*
 * Decompiled with CFR 0.152.
 */
package BMap3D;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashWindow
extends JWindow {
    private static final long serialVersionUID = 4217646116974753632L;
    private static SplashWindow splashWindow = null;
    private SplashPanel panel = null;

    public SplashWindow(String imageResourceName) {
        this.initComponents();
        URL imageURL = this.getClass().getClassLoader().getResource(imageResourceName);
        Image image = Toolkit.getDefaultToolkit().createImage(imageURL);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 1);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.panel = new SplashPanel(image);
        this.getContentPane().add("Center", this.panel);
        this.pack();
        Dimension windowDim = this.getPreferredSize();
        ((Component)this).setLocation(screenDim.width / 2 - windowDim.width / 2, screenDim.height / 2 - windowDim.height / 2);
    }

    public static void showSplashscreen(String imageResourceName) {
        if (splashWindow == null) {
            splashWindow = new SplashWindow(imageResourceName);
        }
        splashWindow.setVisible(true);
        splashWindow.toFront();
    }

    public static void destroySplashscreen() {
        splashWindow.setVisible(false);
        splashWindow.dispose();
        splashWindow = null;
    }

    public static void showMessage(String message) {
        if (splashWindow != null) {
            splashWindow.actualShowMessage(message);
        }
    }

    protected void actualShowMessage(String message) {
        this.panel.showMessage(message);
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SplashWindow.this.exitForm(evt);
            }
        });
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    class SplashPanel
    extends JPanel {
        private static final long serialVersionUID = -8764714009318517738L;
        private BufferedImage image;
        private BufferedImage messageImage = null;
        private String message = "";
        private int messageX = 40;
        private int messageY = 55;
        private int messageH = 20;
        private int messageW = 200;
        private int ascent;

        public SplashPanel(Image im) {
            int width = im.getWidth(null);
            int height = im.getHeight(null);
            this.image = new BufferedImage(width, height, 1);
            this.image.getGraphics().drawImage(im, 0, 0, null);
            Dimension d = new Dimension(width, height);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.ascent = this.getFontMetrics(this.getFont()).getMaxAscent();
            this.messageH = this.getFontMetrics(this.getFont()).getMaxDescent() + this.ascent;
            this.messageW = width - this.messageX;
            this.messageImage = this.image.getSubimage(this.messageX, this.messageY - this.ascent, this.messageW, this.messageH);
        }

        public void showMessage(String message) {
            this.message = message;
            Graphics g = this.getGraphics();
            g.drawImage(this.messageImage, this.messageX, this.messageY - this.ascent, null);
            g.drawString(message, this.messageX, this.messageY);
        }

        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, null);
            g.drawString(this.message, this.messageX, this.messageY);
        }
    }
}

