/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.geometry;

import BMap3D.geometry.AnnotationLine;
import com.sun.j3d.utils.geometry.Cone;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public class AnnotationArrow
extends AnnotationLine {
    private Color3f arrowColor = new Color3f(1.0f, 1.0f, 1.0f);
    private float arrowRadius = 0.1f;
    private float arrowLength = 0.2f;
    private float lineWidth = 3.0f;
    private int radialDivisions = 8;
    private int sideDivisions = 1;
    private Cone arrowHead = null;
    private Appearance arrowAppearance = null;
    private TransformGroup arrowTrans = null;
    private ColoringAttributes coloringAttributes = null;

    public AnnotationArrow(float x2, float y2, float z2) {
        this(0.0f, 0.0f, 0.0f, x2, y2, z2);
    }

    public AnnotationArrow(float x, float y, float z, float x2, float y2, float z2) {
        super(x, y, z, x2, y2, z2);
        this.setLineWidth(this.lineWidth);
        float deltaX = x2 - x;
        float deltaY = y2 - y;
        float deltaZ = z2 - z;
        float theta = -((float)Math.atan2(deltaZ, deltaX));
        float phi = (float)Math.atan2(deltaY, deltaX);
        if (deltaX < 0.0f) {
            phi = (float)Math.PI - phi;
        }
        Matrix4f mat = new Matrix4f();
        Matrix4f mat2 = new Matrix4f();
        mat.setIdentity();
        mat2.setIdentity();
        mat2.setTranslation(new Vector3f(x2, y2, z2));
        mat.mul(mat2);
        mat2.setIdentity();
        mat2.rotY(theta);
        mat.mul(mat2);
        mat2.setIdentity();
        mat2.rotZ(phi);
        mat.mul(mat2);
        mat2.setIdentity();
        mat2.rotZ(-1.571f);
        mat.mul(mat2);
        this.arrowTrans = new TransformGroup();
        this.arrowTrans.setCapability(13);
        Transform3D trans = new Transform3D(mat);
        this.arrowTrans.setTransform(trans);
        this.arrowAppearance = new Appearance();
        this.arrowAppearance.setCapability(9);
        this.getLineColor(this.arrowColor);
        this.coloringAttributes = new ColoringAttributes();
        this.coloringAttributes.setColor(this.arrowColor);
        this.coloringAttributes.setShadeModel(2);
        this.arrowAppearance.setColoringAttributes(this.coloringAttributes);
        this.arrowHead = new Cone(this.arrowRadius, this.arrowLength, 0, this.radialDivisions, this.sideDivisions, this.arrowAppearance);
        this.arrowTrans.addChild((Node)this.arrowHead);
        this.addChild((Node)this.arrowTrans);
    }

    public void setArrowHeadRadius(float radius) {
        this.arrowRadius = radius;
        this.arrowTrans.removeChild(0);
        this.arrowHead = new Cone(this.arrowRadius, this.arrowLength, 0, this.radialDivisions, this.sideDivisions, this.arrowAppearance);
        this.arrowTrans.addChild((Node)this.arrowHead);
    }

    public void setArrowHeadLength(float length) {
        this.arrowLength = length;
        this.arrowTrans.removeChild(0);
        this.arrowHead = new Cone(this.arrowRadius, this.arrowLength, 0, this.radialDivisions, this.sideDivisions, this.arrowAppearance);
        this.arrowTrans.addChild((Node)this.arrowHead);
    }

    public float getArrowHeadRadius() {
        return this.arrowRadius;
    }

    public float getArrowHeadLength() {
        return this.arrowLength;
    }

    public void setLineColor(Color3f color) {
        super.setLineColor(color);
        this.getLineColor(this.arrowColor);
        this.coloringAttributes.setColor(this.arrowColor);
        this.arrowAppearance.setColoringAttributes(this.coloringAttributes);
        this.arrowHead.setAppearance(this.arrowAppearance);
    }

    public void setLineColor(float r, float g, float b) {
        super.setLineColor(r, g, b);
        this.getLineColor(this.arrowColor);
        this.coloringAttributes.setColor(this.arrowColor);
        this.arrowAppearance.setColoringAttributes(this.coloringAttributes);
        this.arrowHead.setAppearance(this.arrowAppearance);
    }

    public void setLineColor(float[] color) {
        super.setLineColor(color);
        this.getLineColor(this.arrowColor);
        this.coloringAttributes.setColor(this.arrowColor);
        this.arrowAppearance.setColoringAttributes(this.coloringAttributes);
        this.arrowHead.setAppearance(this.arrowAppearance);
    }

    public void setAppearance(Appearance app) {
        super.setAppearance(app);
        this.arrowAppearance = app;
        this.arrowAppearance.setCapability(9);
        this.arrowAppearance.setColoringAttributes(this.coloringAttributes);
        this.arrowHead.setAppearance(this.arrowAppearance);
    }

    public Shape3D getShape(int partid) {
        if (partid == 0) {
            return this.arrowHead.getShape(0);
        }
        if (partid == 1) {
            return this.arrowHead.getShape(1);
        }
        return super.getShape(partid);
    }

    public int getNumTriangles() {
        return this.arrowHead.getNumTriangles();
    }

    public int getNumVertices() {
        return this.arrowHead.getNumVertices() + super.getNumVertices();
    }
}

