/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MultipleOptionPanel;
import GUI.UI;
import file.MyFile;
import file.TextFile;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class MAFPanel
extends MultipleOptionPanel {
    int MAF1;
    int MAF2;
    JLabel lMAF1;
    JLabel lMAF2;
    JTextField tMAF1;
    JTextField tMAF2;
    JComboBox cMAF1;
    JComboBox cMAF2;
    JButton hMAF1;
    JButton hMAF2;
    FileActionListener fileActionListener2;
    CB3ActionListener cB3ActionListener;
    CB4ActionListener cB4ActionListener;

    public MAFPanel(String text, String text2, String text3, int r, int c) {
        super(text, text2, text3, r, c);
        this.MAF1 = -1;
        this.MAF2 = -1;
        this.printMAFPanel();
    }

    public MAFPanel(String text, String text2, String text3, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int binaryEstimatorColumn, ArrayList columns, boolean hasHeading, int MAF1, int MAF2, String fileName, String AnnotationFileName, String Annotation2FileName, int r, int c) {
        super(text, text2, text3, SNP1, SNP2, SNP1A, SNP2A, estimatorColumn, binaryEstimatorColumn, columns, hasHeading, fileName, AnnotationFileName, Annotation2FileName, r, c);
        this.MAF1 = MAF1;
        this.MAF2 = MAF2;
        this.printMAFPanel();
    }

    public MAFPanel(String text, String text2, String text3, MAFPanel cP) {
        super(text, text2, text3, cP.getSNP1(), cP.getSNP2(), cP.getSNP1A(), cP.getSNP2A(), cP.getEstimatorColumn(), cP.getBinaryEstimatorColumn(), cP.getColumns(), cP.getHasHeading(), cP.getFileName(), cP.getAnnotationFileName(), cP.getAnnotation2FileName(), cP.getRows(), cP.getCols());
        this.MAF1 = cP.getMAF1();
        this.MAF2 = cP.getMAF2();
        this.printMAFPanel();
    }

    public void printMAFPanel() {
        this.lMAF1 = new JLabel(" MAF1 column:");
        this.lMAF2 = new JLabel(" MAF2 column:");
        this.tMAF1 = new JTextField("");
        this.tMAF2 = new JTextField("");
        this.tMAF1.setEditable(false);
        this.tMAF2.setEditable(false);
        if (this.columns.size() > 0) {
            if (this.MAF1 == -1) {
                this.tMAF1.setText("-");
            } else {
                this.tMAF1.setText(this.MAF1 + 1 + ": " + (String)this.columns.get(this.MAF1));
            }
            if (this.MAF2 == -1) {
                this.tMAF2.setText("-");
            } else {
                this.tMAF2.setText(this.MAF2 + 1 + ": " + (String)this.columns.get(this.MAF2));
            }
        } else {
            this.tMAF1.setText("-");
            this.tMAF2.setText("-");
        }
        this.tMAF1.setBackground(Color.orange);
        this.tMAF2.setBackground(Color.orange);
        this.cMAF1 = new JComboBox();
        this.cMAF2 = new JComboBox();
        if (!this.fileName.equals("")) {
            this.removeAllItems();
            this.addItems(this.columns);
        } else {
            this.cMAF1.setEnabled(false);
            this.cMAF2.setEnabled(false);
        }
        if (this.cSNP1.getItemCount() > 0) {
            this.cSNP1.setSelectedIndex(this.SNP1);
            this.cSNP2.setSelectedIndex(this.SNP2);
            this.cEstimatorColumn.setSelectedIndex(this.estimatorColumn);
            this.cBinaryEstimatorColumn.setSelectedIndex(this.binaryEstimatorColumn);
        }
        if (this.cSNP1A.getItemCount() > 0) {
            this.cSNP1A.setSelectedIndex(this.SNP1A + 1);
            this.cSNP2A.setSelectedIndex(this.SNP2A + 1);
        }
        if (this.cMAF1.getItemCount() > 0) {
            this.cMAF1.setSelectedIndex(this.MAF1 + 1);
            this.cMAF2.setSelectedIndex(this.MAF2 + 1);
        }
        this.open.removeActionListener(this.fileActionListener);
        this.fileActionListener2 = new FileActionListener();
        this.cB3ActionListener = new CB3ActionListener();
        this.cB4ActionListener = new CB4ActionListener();
        this.open.addActionListener(this.fileActionListener2);
        URL imageURL = this.getClass().getClassLoader().getResource("helpSmall.png");
        ImageIcon icon = new ImageIcon(imageURL, "help icon");
        this.hMAF1 = new JButton(icon);
        this.hMAF2 = new JButton(icon);
        HMAFActionListener hMAFActionListener = new HMAFActionListener();
        this.hMAF1.addActionListener(hMAFActionListener);
        this.hMAF2.addActionListener(hMAFActionListener);
        this.add(this.lMAF1);
        this.add(this.hMAF1);
        this.add(this.cMAF1);
        this.add(this.tMAF1);
        this.add(this.lMAF2);
        this.add(this.hMAF2);
        this.add(this.cMAF2);
        this.add(this.tMAF2);
    }

    public int getMAF1() {
        return this.MAF1;
    }

    public int getMAF2() {
        return this.MAF2;
    }

    protected void removeAllItems() {
        super.removeAllItems();
        if (this.cMAF1 != null) {
            ActionListener[] l = this.cMAF1.getActionListeners();
            for (int i = 0; i < l.length; ++i) {
                this.cMAF1.removeActionListener(l[i]);
            }
            this.cMAF1.removeAllItems();
            ActionListener[] l2 = this.cMAF2.getActionListeners();
            for (int i = 0; i < l2.length; ++i) {
                this.cMAF2.removeActionListener(l2[i]);
            }
            this.cMAF2.removeAllItems();
        }
    }

    protected void addItems(ArrayList cols) {
        super.addItems(cols);
        if (this.cMAF1 != null) {
            int i;
            if (cols.size() > 0) {
                this.cMAF1.addItem(new String("-"));
                this.cMAF2.addItem(new String("-"));
                this.cMAF1.addActionListener(this.cB3ActionListener);
                this.cMAF2.addActionListener(this.cB4ActionListener);
            }
            for (i = 0; i < cols.size(); ++i) {
                this.cMAF1.addItem(new String(" " + (i + 1) + ": " + cols.get(i)));
            }
            this.cMAF1.addActionListener(this.cB3ActionListener);
            for (i = 0; i < cols.size(); ++i) {
                this.cMAF2.addItem(new String(" " + (i + 1) + ": " + cols.get(i)));
                this.cMAF2.addActionListener(this.cB4ActionListener);
            }
        }
    }

    class FileActionListener
    implements ActionListener {
        FileActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MAFPanel.this.fileName = MyFile.getFileName(true, ((JButton)e.getSource()).getParent());
            if (MAFPanel.this.fileName != null) {
                TextFile tFile = new TextFile(MAFPanel.this.fileName);
                MAFPanel.this.columns = tFile.getWordsInLine(0, ",\t", true);
                MAFPanel.this.tFileName.setText(MAFPanel.this.fileName);
                MAFPanel.this.totalColumns = MAFPanel.this.columns.size();
                if (!MAFPanel.this.hasHeading) {
                    MAFPanel.this.columns = new ArrayList();
                    for (int i = 0; i < MAFPanel.this.totalColumns; ++i) {
                        MAFPanel.this.columns.add("NA");
                    }
                }
                MAFPanel.this.removeAllItems();
                MAFPanel.this.addItems(MAFPanel.this.columns);
                MAFPanel.this.cSNP1.setEnabled(true);
                MAFPanel.this.cSNP2.setEnabled(true);
                MAFPanel.this.cEstimatorColumn.setEnabled(true);
                MAFPanel.this.cBinaryEstimatorColumn.setEnabled(true);
                MAFPanel.this.cSNP1A.setEnabled(true);
                MAFPanel.this.cSNP2A.setEnabled(true);
                MAFPanel.this.cMAF1.setEnabled(true);
                MAFPanel.this.cMAF2.setEnabled(true);
                MAFPanel.this.open2.setBorder(new BevelBorder(0));
                MAFPanel.this.open2.setEnabled(true);
            } else {
                MAFPanel.this.fileName = null;
                MAFPanel.this.tFileName.setText("");
            }
        }
    }

    class HMAFActionListener
    implements ActionListener {
        HMAFActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if ((JButton)e.getSource() == MAFPanel.this.hMAF1) {
                UI.print("Minor allele frequency (MAF) for the first snp. This information must be ptovided to impose some MAF threshold");
            } else {
                UI.print("Minor allele frequency (MAF) for the second snp. This information must be ptovided to impose some MAF threshold");
            }
        }
    }

    class CB4ActionListener
    implements ActionListener {
        CB4ActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
            MAFPanel.this.tMAF2.setText(s);
            MAFPanel.this.MAF2 = s.equals("-") ? -1 : Integer.parseInt(s.substring(1, s.indexOf(58, 0))) - 1;
        }
    }

    class CB3ActionListener
    implements ActionListener {
        CB3ActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
            MAFPanel.this.tMAF1.setText(s);
            MAFPanel.this.MAF1 = s.equals("-") ? -1 : Integer.parseInt(s.substring(1, s.indexOf(58, 0))) - 1;
        }
    }
}

