/*
 * Decompiled with CFR 0.152.
 */
package BMap2D;

import GUI.MyJInternalFrame;
import GUI.UI;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class Image {
    public BufferedImage image = null;
    String fileName;

    public void save(String fileName, int fileExtension) throws IOException {
        File file = new File(fileName);
        if (this.image == null) {
            throw new IOException();
        }
        if (fileExtension == 1) {
            ImageIO.write((RenderedImage)this.image, "png", file);
        } else if (fileExtension == 2) {
            ImageIO.write((RenderedImage)this.image, "jpg", file);
        }
    }

    public void checkFile(String fileNam) {
        this.fileName = fileNam;
        try {
            File file = new File(this.fileName);
            this.image = ImageIO.read(file);
            if (this.image == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            UI.print("Error in file format");
        }
    }

    public void loadFile(String fileNam) throws Exception {
        this.fileName = fileNam;
        File file = new File(this.fileName);
        this.image = ImageIO.read(file);
        if (this.image == null) {
            throw new Exception();
        }
        if (new ImageIcon(this.image) == null) {
            throw new Exception();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void SetImage(BufferedImage bImage) {
        this.image = bImage;
    }

    public void show(MyJInternalFrame jInternalFrame) {
        try {
            boolean error = false;
            JLabel jLabel = new JLabel(new ImageIcon(this.getImage()));
            JScrollPane jScrollPane = new JScrollPane(jLabel);
            jInternalFrame.getContentPane().add((Component)jScrollPane, "Center");
        }
        catch (Exception e) {
            UI.print("Error in file format");
        }
    }

    public static int GetBlue(int level) {
        return 255 - Math.round((float)Math.ceil((float)level / 10.0f * 255.0f));
    }

    public static int GetRed(int level) {
        return 255;
    }

    public static int GetGreen(int level) {
        return 255 - Math.round((float)Math.ceil((float)level / 10.0f * 255.0f));
    }

    public static int GetColorLevel(int level) {
        return 255 - Math.round((float)Math.ceil((float)level / 10.0f * 255.0f));
    }

    public static Color getClarifiedColor(Color color, int scale) {
        int R = Image.GetColorLevel(scale);
        int G = Image.GetColorLevel(scale);
        int B = Image.GetColorLevel(scale);
        if (color == Color.red) {
            R = 255;
        }
        if (color == Color.green) {
            G = 255;
        }
        if (color == Color.blue) {
            B = 255;
        }
        return new Color(R, G, B);
    }

    public static Color getClarifiedColor(Color color, int scale, int scale2) {
        int R = Image.GetColorLevel(scale);
        int G = Image.GetColorLevel(scale);
        int B = Image.GetColorLevel(scale);
        if (color == Color.red) {
            R = 255;
            G = Image.GetColorLevel(scale);
            B = Image.GetColorLevel(scale2);
        }
        if (color == Color.green) {
            G = 255;
            R = Image.GetColorLevel(scale);
            B = Image.GetColorLevel(scale2);
        }
        if (color == Color.blue) {
            B = 255;
            R = Image.GetColorLevel(scale2);
            G = Image.GetColorLevel(scale);
        }
        return new Color(R, G, B);
    }
}

