/*
 * Decompiled with CFR 0.152.
 */
package BMap3D;

import BMap3D.universe.UserData;
import com.sun.j3d.utils.geometry.Box;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class Blocks3D
extends BranchGroup {
    private float side;
    private Vector3f[] blocks;
    private int nu;
    private int nv;
    private int ntotal;
    private float du;
    private float dv;
    private boolean demo;
    private TransformGroup globalRotation;
    private BranchGroup grid;

    public Blocks3D() {
        this.side = 1.0f;
        this.nv = 9;
        this.nu = 9;
        this.du = this.dv = 1.0f / (float)this.nu;
        this.ntotal = (this.nu + 1) * (this.nv + 1);
        this.grid = new BranchGroup();
        int i = 0;
        this.blocks = new Vector3f[1600];
        for (float x = 0.0f; x < 40.0f; x += this.side) {
            for (float z = x + this.side; z < 40.0f; z += this.side) {
                float r = z / 40.0f;
                BranchGroup box = this.createBoxOnGrid(x, r, z, new Color3f(0.0f, 0.0f, r));
                this.blocks[i] = new Vector3f(x, z, r);
                ++i;
                this.grid.addChild((Node)box);
            }
        }
        this.demo = false;
        this.twist();
    }

    public Blocks3D(Vector3f[] data, int resolution, int maxDistance, Color3f[] colors, int[] position) {
        this.side = 0.5f;
        this.blocks = data;
        int tama = data.length;
        this.grid = new BranchGroup();
        this.nu = this.nv = (int)Math.sqrt(tama) - 1;
        this.dv = 1.0f;
        this.du = 1.0f;
        this.ntotal = (this.nu + 1) * (this.nv + 1);
        for (int i = 0; i < tama; ++i) {
            int x = (int)data[i].x;
            int y = (int)data[i].y;
            double d = Math.abs(position[x] - position[y]);
            if (!(d < (double)maxDistance)) continue;
            this.grid.addChild((Node)this.createBoxOnGrid(data[i].x, data[i].z, data[i].y, colors[i]));
        }
        this.demo = false;
        this.twist();
    }

    private void twist() {
        this.globalRotation = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 0.7853982f));
        this.globalRotation.setTransform(t);
        this.globalRotation.addChild((Node)this.grid);
        this.addChild((Node)this.globalRotation);
    }

    private BranchGroup createBoxOnGrid(float x, float r, float z, Color3f c) {
        BranchGroup element = new BranchGroup();
        TransformGroup alignOnGrid = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(x, r, z));
        alignOnGrid.setTransform(t);
        Appearance sameApp = new Appearance();
        Material sameMat = new Material();
        sameMat.setAmbientColor(0.6f, 0.6f, 0.6f);
        sameMat.setDiffuseColor(c);
        sameMat.setSpecularColor(0.0f, 0.0f, 0.0f);
        sameApp.setMaterial(sameMat);
        TransparencyAttributes ta = new TransparencyAttributes(2, 1.0f - r);
        sameApp.setTransparencyAttributes(ta);
        Box cubo = new Box(this.side, r, this.side, sameApp);
        UserData ud = new UserData("Block3D", 1.0f - r);
        cubo.getShape(1).setUserData((Object)ud);
        cubo.getShape(5).setUserData((Object)ud);
        cubo.getShape(0).setUserData((Object)ud);
        cubo.getShape(3).setUserData((Object)ud);
        cubo.getShape(2).setUserData((Object)ud);
        cubo.getShape(4).setUserData((Object)ud);
        alignOnGrid.addChild((Node)cubo);
        element.addChild((Node)alignOnGrid);
        return element;
    }

    public StringBuffer export() {
        StringBuffer grf = new StringBuffer();
        Date today = new Date();
        SimpleDateFormat simpledateformat = new SimpleDateFormat("MMM dd, yyyy, hh:mm");
        grf.append("//Generated by BMap3D application - " + simpledateformat.format(today) + "\n\n");
        this.genmalla(grf);
        return grf;
    }

    public Color3f randomColor() {
        float mr = (float)(0.9 + 0.2 * Math.random());
        float mg = (float)(0.8 + 0.1 * Math.random());
        float mb = (float)(0.8 + 0.2 * Math.random());
        return new Color3f(mr, mg, mb);
    }

    private void genmalla(StringBuffer grf) {
        int iv;
        int iu;
        grf.append("\nbegin mesh");
        grf.append("\n   begin vertexs");
        for (int i = 0; i < this.ntotal; ++i) {
            Vector3f p10;
            Vector3f p01;
            Vector3f p;
            iu = i % (this.nu + 1);
            iv = i / (this.nu + 1);
            float u = (float)iu / (float)this.nu;
            float v = (float)iv / (float)this.nv;
            System.out.println(u + " // " + v);
            if (this.demo) {
                p = new Vector3f(u, 0.0f, v);
                p01 = new Vector3f(u, 0.0f, v + this.dv);
                p10 = new Vector3f(u + this.du, 0.0f, v);
            } else {
                p = this.getBlock(u, v);
                p01 = this.getBlock(u, v + this.dv);
                p10 = this.getBlock(u + this.du, v);
            }
            this.transf(p);
            this.transf(p01);
            this.transf(p10);
            float dx0 = p01.x - p.x;
            float dy0 = p01.y - p.y;
            float dz0 = p01.z - p.z;
            float dx1 = p10.x - p.x;
            float dy1 = p10.y - p.y;
            float dz1 = p10.z - p.z;
            float nx = dy0 * dz1 - dy1 * dz0;
            float ny = dz0 * dx1 - dz1 * dx0;
            float nz = dx0 * dy1 - dx1 * dy0;
            float mn = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            System.out.println(" --------- " + mn);
            grf.append("\n      normal (" + nx / mn + "," + ny / mn + "," + nz / mn + ")");
            grf.append("\n      (" + p.x + "," + p.y + "," + p.z + ")");
        }
        grf.append("\n   end vertexs");
        grf.append("\n   begin faces");
        if (this.demo) {
            Color3f colorMalla = this.randomColor();
            grf.append("\n      rgb " + colorMalla);
        }
        for (iu = 0; iu < this.nu; ++iu) {
            for (iv = 0; iv < this.nv; ++iv) {
                int i00 = this.index(iu, iv);
                int i01 = this.index(iu, iv + 1);
                int i10 = this.index(iu + 1, iv);
                int i11 = this.index(iu + 1, iv + 1);
                if (!this.demo) {
                    Vector3f v = this.getBlock(iu, iv);
                    Color3f c = new Color3f(v.x, v.y, v.z);
                    grf.append("\n      rgb " + c);
                }
                grf.append("\n      (" + i00 + "," + i01 + "," + i10 + ")");
                grf.append("\n      (" + i10 + "," + i01 + "," + i11 + ")");
            }
        }
        grf.append("\n   end faces");
        grf.append("\nend mesh");
        grf.append("\n\n");
    }

    private Vector3f getBlock(float u, float v) {
        int iu = (int)(u * 10.0f);
        int iv = (int)(v * 10.0f);
        return this.getBlock(iu, iv);
    }

    private Vector3f getBlock(int iu, int iv) {
        float incx = 0.0f;
        float incz = 0.0f;
        if (iu > this.nu) {
            --iu;
            incx = this.du;
        }
        if (iv > this.nv) {
            --iv;
            incz = this.dv;
        }
        int i = iu * 10 + iv;
        System.out.println(i + " i>=ntotal " + (i >= this.ntotal));
        if (i >= this.ntotal) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        float x = this.blocks[i].x + incx;
        float y = this.blocks[i].z;
        float z = this.blocks[i].y + incz;
        return new Vector3f(x, y, z);
    }

    void transf(Vector3f p) {
        float tx = 0.0f;
        float ty = 0.0f;
        float tz = 0.0f;
        float e = 1.0f;
        float crx = 0.0f;
        float crz = 0.0f;
        float angr = 0.0f;
        float tmpx = p.x - crx;
        float tmpz = p.z - crz;
        p.x = (float)((double)tmpx * Math.cos(angr) + (double)tmpz * Math.sin(angr));
        p.z = (float)((double)(-tmpx) * Math.sin(angr) + (double)tmpz * Math.cos(angr));
        p.x = p.x * e + tx + crx;
        p.y = p.y * e + ty;
        p.z = p.z * e + tz + crz;
    }

    private int index(int iu, int iv) {
        return iv * (this.nu + 1) + iu;
    }
}

