/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import BMap3D.universe.DevelopmentLocale;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.Locale;
import javax.media.j3d.VirtualUniverse;

public class DevelopmentSimpleUniverse
extends VirtualUniverse {
    protected DevelopmentLocale locale;
    protected Viewer viewer;
    protected ViewingPlatform vwp;

    public DevelopmentSimpleUniverse() {
        this(null, 1, null, null);
    }

    public DevelopmentSimpleUniverse(int numTransforms) {
        this(null, numTransforms, null, null);
    }

    public DevelopmentSimpleUniverse(Canvas3D canvas) {
        this(null, 1, canvas, null);
    }

    public DevelopmentSimpleUniverse(Canvas3D canvas, int numTransforms) {
        this(null, numTransforms, canvas, null);
    }

    public DevelopmentSimpleUniverse(HiResCoord origin, int numTransforms, Canvas3D canvas, URL userConfig) {
        this.locale = origin == null ? new DevelopmentLocale(this) : new DevelopmentLocale(this, origin);
        this.vwp = new ViewingPlatform(numTransforms);
        this.viewer = new Viewer(canvas);
        this.viewer.setViewingPlatform(this.vwp);
        this.locale.addBranchGraph((BranchGroup)this.vwp);
    }

    public DevelopmentSimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        this.locale = new DevelopmentLocale(this);
        this.viewer = viewer;
        this.viewer.setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph((BranchGroup)viewingPlatform);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public ViewingPlatform getViewingPlatform() {
        return this.vwp;
    }

    public Canvas3D getCanvas() {
        return this.getCanvas(0);
    }

    public Canvas3D getCanvas(int canvasNum) {
        return this.viewer.getCanvas3D();
    }

    public void addBranchGraph(BranchGroup bg) {
        this.locale.addBranchGraph(bg);
    }

    public static GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        String stereo = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (stereo != null) {
            if (stereo.equals("REQUIRED")) {
                template.setStereo(1);
            } else if (stereo.equals("PREFERRED")) {
                template.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
    }

    public BranchGroup[] getBranchGraphs() {
        return this.locale.getBranchGraphs();
    }

    public void setLive(boolean live) {
        this.locale.setLive(live);
    }

    public boolean getLive() {
        return this.locale.getLive();
    }
}

