/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import BMap3D.universe.ProcessNodeInterface;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Switch;

public class TreeScan {
    private static HashSet visitedSharedGroups = null;

    public static void findNode(Node treeRoot, Class nodeClass, ProcessNodeInterface processor, boolean onlyEnabledSwitchChildren, boolean sharedGroupsOnce) throws CapabilityNotSetException {
        Class[] nodeClasses = new Class[]{nodeClass};
        TreeScan.findNode(treeRoot, nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
    }

    public static void findNode(Node treeRoot, Class[] nodeClasses, ProcessNodeInterface processor, boolean onlyEnabledSwitchChildren, boolean sharedGroupsOnce) throws CapabilityNotSetException {
        if (sharedGroupsOnce && visitedSharedGroups == null) {
            visitedSharedGroups = new HashSet();
        }
        TreeScan.actualFindNode(treeRoot, nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
        if (sharedGroupsOnce) {
            visitedSharedGroups.clear();
        }
    }

    public static Class getClass(String str) {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("BAD CLASS " + str);
        }
    }

    private static void actualFindNode(Node treeRoot, Class[] nodeClasses, ProcessNodeInterface processor, boolean onlyEnabledSwitchChildren, boolean sharedGroupsOnce) throws CapabilityNotSetException {
        if (treeRoot == null) {
            return;
        }
        if (treeRoot instanceof SharedGroup && sharedGroupsOnce) {
            if (visitedSharedGroups.contains(treeRoot)) {
                return;
            }
            visitedSharedGroups.add(treeRoot);
        }
        for (int i = 0; i < nodeClasses.length; ++i) {
            if (!nodeClasses[i].isAssignableFrom(treeRoot.getClass())) continue;
            processor.processNode(treeRoot);
        }
        if (onlyEnabledSwitchChildren && treeRoot instanceof Switch) {
            int whichChild = ((Switch)treeRoot).getWhichChild();
            if (whichChild == -2) {
                Enumeration e = ((Group)treeRoot).getAllChildren();
                while (e.hasMoreElements()) {
                    TreeScan.actualFindNode((Node)e.nextElement(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
                }
            } else if (whichChild == -3) {
                BitSet set = ((Switch)treeRoot).getChildMask();
                for (int s = 0; s < set.length(); ++s) {
                    if (!set.get(s)) continue;
                    TreeScan.actualFindNode(((Switch)treeRoot).getChild(s), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
                }
            } else if (whichChild != -1) {
                TreeScan.actualFindNode(((Switch)treeRoot).currentChild(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
            }
        } else if (treeRoot instanceof Group) {
            Enumeration e = ((Group)treeRoot).getAllChildren();
            while (e.hasMoreElements()) {
                TreeScan.actualFindNode((Node)e.nextElement(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
            }
        } else if (treeRoot instanceof Link) {
            TreeScan.actualFindNode((Node)((Link)treeRoot).getSharedGroup(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
        }
    }
}

