/*
 * Decompiled with CFR 0.152.
 */
package threads;

import BMap2D.Image;
import BMap2D.My2DJInternalFrame;
import BMap3D.My3DJInternalFrame;
import GUI.MainGUI;
import GUI.MyJInternalFrame;
import GUI.UI;
import file.FileExtension;
import file.TextLine;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import threads.GUILongTask;
import threads.SwingWorker;

public class ExtractMap
extends GUILongTask {
    String completeFileNameSource;
    String annotationFile;
    String annotationFile2;
    String indFile;
    String completeFileNameTarget;
    public int error = 0;
    String argument;
    int argumentLine;
    int SNP1;
    int SNP2;
    int SNP1A;
    int SNP2A;
    int estimatorColumn;
    int binaryEstimatorColumn;
    int confidenceLevelColumn;
    int MAFColumn;
    int MAFColumn2;
    int resolution;
    int alleles1;
    int alleles2;
    int distance2D;
    int existSelected = 0;
    int existMarked = 0;
    int inCommon = 0;
    long maxDistance;
    long trueMaxDistance;
    float MAF;
    boolean hasHeading;
    boolean useMAF;
    boolean D3;
    boolean GUI = true;
    boolean useBIN;
    boolean useCONFIDENCE;
    boolean useIndPos;
    boolean useDelimiters;
    boolean useBlocks;
    int totalPairs;
    int totalSNPs;
    int line = 0;
    int firstPosition;
    int lastPosition;
    Vector3f[] positions;
    float[] confidenceLevel;
    MyJInternalFrame myJInternalFrame;
    My3DJInternalFrame my3DJInternalFrame;
    My2DJInternalFrame my2DJInternalFrame;
    int[] SNPPositions;
    ArrayList<ArrayList<Integer>> indPositions;
    ArrayList<Integer>[] indPositionsTable;
    float[] MAFValues;
    String[] Annotation;
    int[] binaryEstimatorSignal;
    Color color;
    boolean rs;
    boolean annotation;
    boolean annotation2;
    Color3f[][] colorCode;
    Color3f[] colorArray;
    MainGUI mainGUI;
    Image im;
    TreeSet blocks = null;
    TreeSet delimiters = null;
    ArrayList markedSNPs;
    ArrayList selectedSNPs;
    ArrayList firstSNPArray;
    ArrayList secondSNPArray;
    ArrayList firstSNPAArray;
    ArrayList secondSNPAArray;
    ArrayList firstMajorArray;
    ArrayList firstMinorArray;
    ArrayList secondMajorArray;
    ArrayList secondMinorArray;
    ArrayList estimationArray;
    ArrayList binaryEstimationArray;
    ArrayList confidenceLevelArray;
    ArrayList MAF1Array;
    ArrayList MAF2Array;
    boolean[] marked;
    boolean[] selected;
    HashMap hashSNPPos;

    public ExtractMap(MainGUI mainGUI, MyJInternalFrame myJInternalFrame, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int binaryEstimatorColumn, int confidenceLevelColumn, int MAFColum, int MAFColumn2, boolean hasHeading, float MAF, long maxDistance, int firstPosition, int lastPosition, String completeFileNameSource, String annotationFile1, String annotationFile2, String indFile, Color color, int resolution, String completeFileNameTarget) {
        super(myJInternalFrame);
        if (mainGUI == null) {
            this.GUI = false;
        }
        this.D3 = false;
        this.color = color;
        this.set(mainGUI, myJInternalFrame, SNP1, SNP2, SNP1A, SNP2A, estimatorColumn, binaryEstimatorColumn, confidenceLevelColumn, MAFColum, MAFColumn2, -1, -1, hasHeading, MAF, maxDistance, firstPosition, lastPosition, resolution, completeFileNameSource, annotationFile1, annotationFile2, indFile, completeFileNameTarget);
    }

    public ExtractMap(MainGUI mainGUI, MyJInternalFrame myJInternalFrame, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int MAFColum, int MAFColumn2, int alleles1, int alleles2, boolean hasHeading, float MAF, long maxDistance, int firstPosition, int lastPosition, String completeFileNameSource, Color3f[][] colorCode) {
        super(myJInternalFrame);
        this.D3 = true;
        this.alleles1 = alleles1;
        this.alleles2 = alleles2;
        this.colorCode = colorCode;
        this.set(mainGUI, myJInternalFrame, SNP1, SNP2, SNP1A, SNP2A, estimatorColumn, -1, -1, MAFColum, MAFColumn2, alleles1, alleles2, hasHeading, MAF, maxDistance, firstPosition, lastPosition, this.resolution, completeFileNameSource, null, null, null, null);
    }

    protected void set(MainGUI mainGUI, MyJInternalFrame myJInternalFrame, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int binaryEstimatorColumn, int confidenceLevelColumn, int MAFColumn, int MAFColumn2, int alleles1, int alleles2, boolean hasHeading, float MAF, long maxDistance, int firstPosition, int lastPosition, int resolution, String completeFileNameSource, String annotationFile, String annotationFile2, String indFile, String completeFileNameTarget) {
        this.mainGUI = mainGUI;
        this.myJInternalFrame = myJInternalFrame;
        this.resolution = resolution;
        this.completeFileNameSource = completeFileNameSource;
        this.completeFileNameTarget = completeFileNameTarget;
        this.confidenceLevelColumn = confidenceLevelColumn;
        this.annotationFile = annotationFile;
        this.annotationFile2 = annotationFile2;
        this.indFile = indFile;
        this.SNP1 = SNP1;
        this.SNP2 = SNP2;
        this.SNP1A = SNP1A;
        this.SNP2A = SNP2A;
        this.estimatorColumn = estimatorColumn;
        this.binaryEstimatorColumn = binaryEstimatorColumn;
        this.MAFColumn = MAFColumn;
        this.MAFColumn2 = MAFColumn2;
        this.hasHeading = hasHeading;
        this.MAF = MAF;
        this.maxDistance = maxDistance;
        this.firstPosition = firstPosition;
        this.lastPosition = lastPosition;
        this.annotation = annotationFile != null && !annotationFile.equals("");
        this.annotation2 = annotationFile2 != null && !annotationFile2.equals("");
        this.useIndPos = indFile != null && !indFile.equals("") && !this.GUI && resolution >= 3;
        this.argument = new String("");
        this.go();
    }

    public Image getImage() {
        return this.im;
    }

    public int getSize() {
        return this.totalPairs;
    }

    public Vector3f[] getPositions() {
        return this.positions;
    }

    public void go() {
        super.go(this.GUI);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                ActualTask actualTask = new ActualTask();
                return actualTask.error;
            }

            @Override
            public void finished() {
                ExtractMap.this.error = (Integer)this.get();
                if (ExtractMap.this.GUI) {
                    ExtractMap.this.myJInternalFrame.getContentPane().setCursor(Cursor.getDefaultCursor());
                    String title = ExtractMap.this.myJInternalFrame.getTitle();
                }
                switch (ExtractMap.this.error) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        UI.print("Error: input file " + ExtractMap.this.completeFileNameSource + " not found");
                        break;
                    }
                    case -2: {
                        UI.print("Input/output error");
                        break;
                    }
                    case -3: {
                        UI.print("Error: not enough memory");
                        break;
                    }
                    case -4: {
                        UI.print("Error: trying to read some null value at line " + ExtractMap.this.argumentLine + ", value is " + ExtractMap.this.argument);
                        break;
                    }
                    case -5: {
                        UI.print("Error: Illegal Type1 or Type2 values at line " + ExtractMap.this.argumentLine + ". Legal values are \"[a]/[b]\", with [a] and [b] values in the set {A,C,G,T}");
                        break;
                    }
                    case -6: {
                        UI.print("Error: no SNPs have been selected");
                        break;
                    }
                    case -7: {
                        UI.print("Error: annotation file has a wrong format");
                        break;
                    }
                    case -8: {
                        UI.print("Error: general exception in getSNPs");
                        break;
                    }
                    case -9: {
                        UI.print("Error: general exception in ExtractMap::readFile");
                        break;
                    }
                    case -10: {
                        UI.print("Error: ArrayIndexOutOfBounds in ExtractMap::readFile");
                        break;
                    }
                    case -11: {
                        UI.print("Error: Not a number ExtractMap::getSNPs when reading line " + ExtractMap.this.argumentLine + " in annotation file , value is " + ExtractMap.this.argument);
                        break;
                    }
                    case -12: {
                        UI.print("Error: binary signal value is not 0, 1 or -1 at line " + ExtractMap.this.argumentLine + ", value is " + ExtractMap.this.argument);
                        break;
                    }
                    case -13: {
                        UI.print("Error: MAF value for SNP1 should be inside interval [0-0.5] at line " + ExtractMap.this.argumentLine + ", value is " + ExtractMap.this.argument);
                        break;
                    }
                    case -14: {
                        UI.print("Error: MAF value for SNP2 should be inside interval [0-0.5] at line " + ExtractMap.this.argumentLine + ", value is " + ExtractMap.this.argument);
                        break;
                    }
                    case -15: {
                        UI.print("Error: SNP1 position in indFile at line " + ExtractMap.this.argumentLine + " should be " + ExtractMap.this.argument);
                        break;
                    }
                    case -16: {
                        UI.print("Error: SNP2 position in indFile at line " + ExtractMap.this.argumentLine + " should be " + ExtractMap.this.argument);
                        break;
                    }
                    case -17: {
                        UI.print("Error: estimator value is not a number in the interval [0,1] at line " + ExtractMap.this.argumentLine + ", value is " + ExtractMap.this.argument);
                        break;
                    }
                    default: {
                        UI.print("Unsupported error at line" + ExtractMap.this.argumentLine);
                    }
                }
                if (ExtractMap.this.error == 0) {
                    if (ExtractMap.this.GUI) {
                        ExtractMap.this.myJInternalFrame.close();
                        if (ExtractMap.this.error == 0) {
                            if (!ExtractMap.this.D3) {
                                ExtractMap.this.my2DJInternalFrame = new My2DJInternalFrame(ExtractMap.this.mainGUI, ExtractMap.this.myJInternalFrame.getTitle(), true, true, true, true, ExtractMap.this.im);
                                ExtractMap.this.im.show(ExtractMap.this.my2DJInternalFrame);
                                ExtractMap.this.my2DJInternalFrame.updateUI();
                            } else {
                                if (ExtractMap.this.maxDistance == 0L || ExtractMap.this.trueMaxDistance < ExtractMap.this.maxDistance) {
                                    ExtractMap.this.maxDistance = ExtractMap.this.trueMaxDistance;
                                }
                                ExtractMap.this.my3DJInternalFrame = new My3DJInternalFrame(ExtractMap.this.mainGUI, ExtractMap.this.myJInternalFrame.getTitle(), true, true, true, true, ExtractMap.this.positions, ExtractMap.this.resolution, ExtractMap.this.maxDistance, ExtractMap.this.colorArray, ExtractMap.this.SNPPositions);
                            }
                        }
                    } else {
                        try {
                            System.out.println("\nMap will be drawn in png file: " + ExtractMap.this.completeFileNameTarget);
                            ExtractMap.this.im.save(ExtractMap.this.completeFileNameTarget, 1);
                        }
                        catch (IOException io) {
                            System.out.println("Write error");
                        }
                    }
                }
            }
        };
        if (this.error == 0) {
            worker.start();
        }
    }

    class ActualTask {
        protected Integer error = new Integer(0);
        ArrayList firstSNPList = new ArrayList();
        ArrayList secondSNPList = new ArrayList();
        ArrayList estimationList = new ArrayList();
        ArrayList firstMajorList = new ArrayList();
        ArrayList binaryEstimationList = new ArrayList();
        ArrayList firstMinorList = new ArrayList();
        ArrayList secondMajorList = new ArrayList();
        ArrayList secondMinorList = new ArrayList();
        TreeSet foundSNP = new TreeSet();

        ActualTask() {
            this.init();
            this.readFile();
            if (this.error == 0) {
                this.orderingSNPs();
            }
            if (this.error == 0 && ExtractMap.this.D3) {
                this.filtering3D();
            }
            if (this.error == 0) {
                this.convertArrays();
                if (ExtractMap.this.annotation) {
                    this.readDelimiters();
                }
                this.readBlocks();
                if (ExtractMap.this.annotation) {
                    this.getSNPs(false);
                }
                if (ExtractMap.this.annotation2) {
                    this.getSNPs(true);
                }
                if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                    this.emptyArrays();
                }
            }
            if (this.error == 0 && !ExtractMap.this.D3) {
                this.create2DMap();
            }
        }

        public boolean isProb(float num) {
            return num >= 0.0f && num <= 1.0f;
        }

        int getAllele(String val, boolean major) throws DataFormatException {
            int pos = 2;
            if (major) {
                pos = 0;
            }
            if (val.charAt(pos) == 'A') {
                return 0;
            }
            if (val.charAt(pos) == 'C') {
                return 1;
            }
            if (val.charAt(pos) == 'G') {
                return 2;
            }
            if (val.charAt(pos) == 'T') {
                return 3;
            }
            throw new DataFormatException();
        }

        public void init() {
            ExtractMap.this.useMAF = false;
            ExtractMap.this.useBIN = false;
            ExtractMap.this.useCONFIDENCE = false;
            if (ExtractMap.this.MAFColumn != -1 && ExtractMap.this.MAFColumn2 != -1) {
                ExtractMap.this.useMAF = true;
                ExtractMap.this.MAF1Array = new ArrayList();
                ExtractMap.this.MAF2Array = new ArrayList();
            } else {
                ExtractMap.this.MAF1Array = null;
                ExtractMap.this.MAF2Array = null;
            }
            if (ExtractMap.this.binaryEstimatorColumn != -1) {
                ExtractMap.this.useBIN = true;
            }
            if (ExtractMap.this.confidenceLevelColumn != -1) {
                ExtractMap.this.useCONFIDENCE = true;
            }
            ExtractMap.this.firstSNPArray = new ArrayList();
            ExtractMap.this.secondSNPArray = new ArrayList();
            ExtractMap.this.estimationArray = new ArrayList();
            if (ExtractMap.this.useBIN) {
                ExtractMap.this.binaryEstimationArray = new ArrayList();
            }
            if (ExtractMap.this.useCONFIDENCE) {
                ExtractMap.this.confidenceLevelArray = new ArrayList();
            }
            if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                ExtractMap.this.firstMajorArray = new ArrayList();
                ExtractMap.this.firstMinorArray = new ArrayList();
                ExtractMap.this.secondMajorArray = new ArrayList();
                ExtractMap.this.secondMinorArray = new ArrayList();
            } else {
                ExtractMap.this.firstMajorArray = null;
                ExtractMap.this.firstMinorArray = null;
                ExtractMap.this.secondMajorArray = null;
                ExtractMap.this.secondMinorArray = null;
            }
            ExtractMap.this.firstSNPAArray = new ArrayList();
            ExtractMap.this.secondSNPAArray = new ArrayList();
        }

        public void readDelimiters() {
            FileExtension fileExtension = new FileExtension(ExtractMap.this.completeFileNameSource);
            String fileBlocks = fileExtension.changeExtension("del");
            File file = new File(fileBlocks);
            try {
                if (file.exists()) {
                    ExtractMap.this.useDelimiters = true;
                    ExtractMap.this.delimiters = new TreeSet();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(fileBlocks));
                    TextLine textLine = new TextLine(bufferedReader, ",\t\n ");
                    Object textLine2 = null;
                    int res = textLine.readLine();
                    while (res == 0) {
                        String val = (String)textLine.getWordsInLine().get(0);
                        boolean found = false;
                        for (int pos = 0; pos < ExtractMap.this.Annotation.length && !found; ++pos) {
                            if (!ExtractMap.this.Annotation[pos].equals(val)) continue;
                            found = true;
                            ExtractMap.this.delimiters.add(pos);
                        }
                        res = textLine.readLine();
                    }
                }
            }
            catch (IOException e) {
                this.error = new Integer(-2);
            }
        }

        public void readBlocks() {
            FileExtension fileExtension = new FileExtension(ExtractMap.this.completeFileNameSource);
            String fileBlocks = fileExtension.changeExtension("bl");
            File file = new File(fileBlocks);
            try {
                if (file.exists()) {
                    ExtractMap.this.useBlocks = true;
                    ExtractMap.this.blocks = new TreeSet();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(fileBlocks));
                    TextLine textLine = new TextLine(bufferedReader, ",\t\n ");
                    Object textLine2 = null;
                    int res = textLine.readLine();
                    while (res == 0) {
                        ArrayList row = textLine.getWordsInLine();
                        ExtractMap.this.blocks.add(Integer.parseInt((String)row.get(row.size() - 1)) - 1);
                        res = textLine.readLine();
                    }
                }
            }
            catch (IOException e) {
                this.error = new Integer(-2);
            }
        }

        public void readFile() {
            ArrayList head = null;
            ArrayList inds = null;
            ArrayList<Integer> numInds = null;
            ExtractMap.this.line = 0;
            float est = 0.0f;
            float MAF1 = 0.0f;
            float MAF2 = 0.0f;
            float binaryEst = 0.0f;
            float confidence = 0.0f;
            int bEst = 0;
            try {
                int approxSize = 0;
                File file = new File(ExtractMap.this.completeFileNameSource);
                approxSize = Math.round(file.length());
                BufferedReader bufferedReader = new BufferedReader(new FileReader(ExtractMap.this.completeFileNameSource));
                TextLine textLine = new TextLine(bufferedReader, ",\t\n ");
                TextLine textLine2 = null;
                int res = 0;
                if (ExtractMap.this.hasHeading) {
                    res = textLine.readLine();
                }
                if (ExtractMap.this.useIndPos) {
                    File file2 = new File(ExtractMap.this.indFile);
                    BufferedReader bufferedReader2 = new BufferedReader(new FileReader(ExtractMap.this.indFile));
                    textLine2 = new TextLine(bufferedReader2, ",\t\n ");
                    ExtractMap.this.indPositions = new ArrayList();
                }
                ExtractMap.this.iniBar(ExtractMap.this.GUI, approxSize /= textLine.getLineSize(), "reading input file");
                int currentSize = 0;
                ExtractMap.this.totalPairs = 0;
                int i = 0;
                String snp1a = "";
                String snp2a = "";
                String s = new String("");
                while (res == 0) {
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, i);
                    }
                    head = textLine.getWordsInLine();
                    if (i == 0) {
                        currentSize = head.size();
                    } else if (head.size() != currentSize) {
                        throw new IllegalArgumentException();
                    }
                    snp1a = (String)head.get(ExtractMap.this.SNP1A);
                    snp2a = (String)head.get(ExtractMap.this.SNP2A);
                    int snp1 = Integer.parseInt((String)head.get(ExtractMap.this.SNP1));
                    int snp2 = Integer.parseInt((String)head.get(ExtractMap.this.SNP2));
                    if (ExtractMap.this.useIndPos) {
                        inds = textLine2.getWordsInLine();
                        numInds = new ArrayList<Integer>();
                        if (!((String)inds.get(0)).equals(head.get(ExtractMap.this.SNP1))) {
                            throw new DataFormatException("inds1");
                        }
                        if (!((String)inds.get(1)).equals(head.get(ExtractMap.this.SNP2))) {
                            throw new DataFormatException("inds2");
                        }
                        for (int a = 2; a < inds.size(); ++a) {
                            numInds.add(Integer.valueOf((String)inds.get(a)));
                        }
                    }
                    est = Float.parseFloat((String)head.get(ExtractMap.this.estimatorColumn));
                    if (ExtractMap.this.useCONFIDENCE) {
                        confidence = Float.parseFloat((String)head.get(ExtractMap.this.confidenceLevelColumn));
                    }
                    if (ExtractMap.this.useBIN) {
                        binaryEst = Float.parseFloat((String)head.get(ExtractMap.this.binaryEstimatorColumn));
                        if (binaryEst == 2.0f) {
                            binaryEst = -1.0f;
                        }
                        if (binaryEst != 0.0f && binaryEst != 1.0f && binaryEst != -1.0f) {
                            throw new DataFormatException("signal");
                        }
                        bEst = (int)binaryEst;
                    }
                    if (ExtractMap.this.useMAF) {
                        MAF1 = !((String)head.get(ExtractMap.this.MAFColumn)).equals("") ? Float.parseFloat((String)head.get(ExtractMap.this.MAFColumn)) : 0.0f;
                        MAF2 = !((String)head.get(ExtractMap.this.MAFColumn2)).equals("") ? Float.parseFloat((String)head.get(ExtractMap.this.MAFColumn2)) : 0.0f;
                    }
                    if (est >= 0.0f && snp1 >= ExtractMap.this.firstPosition && snp1 <= ExtractMap.this.lastPosition && snp2 >= ExtractMap.this.firstPosition && snp2 <= ExtractMap.this.lastPosition && (ExtractMap.this.maxDistance == 0L || (long)Math.abs(snp1 - snp2) < ExtractMap.this.maxDistance) && (!ExtractMap.this.useMAF || MAF1 > ExtractMap.this.MAF && MAF2 > ExtractMap.this.MAF)) {
                        ExtractMap.this.firstSNPAArray.add(snp1a);
                        ExtractMap.this.secondSNPAArray.add(snp2a);
                        ExtractMap.this.firstSNPArray.add(new Integer(snp1));
                        ExtractMap.this.secondSNPArray.add(new Integer(snp2));
                        ExtractMap.this.estimationArray.add(new Float(est));
                        if (ExtractMap.this.useIndPos) {
                            ExtractMap.this.indPositions.add(numInds);
                        }
                        if (ExtractMap.this.useBIN) {
                            ExtractMap.this.binaryEstimationArray.add(new Integer(bEst));
                        }
                        if (ExtractMap.this.useCONFIDENCE) {
                            if (!this.isProb(confidence)) {
                                throw new ClassNotFoundException("confidence");
                            }
                            ExtractMap.this.confidenceLevelArray.add(new Float(confidence));
                        }
                        if (!this.isProb(est)) {
                            throw new ClassNotFoundException("signal");
                        }
                        if (ExtractMap.this.useMAF) {
                            if ((double)MAF1 > 0.5) {
                                MAF1 = 1.0f - MAF1;
                            }
                            if ((double)MAF2 > 0.5) {
                                MAF2 = 1.0f - MAF2;
                            }
                            ExtractMap.this.MAF1Array.add(new Float(MAF1));
                            ExtractMap.this.MAF2Array.add(new Float(MAF2));
                            if ((double)MAF1 > 0.5 || MAF1 < 0.0f) {
                                throw new DataFormatException("MAF1");
                            }
                            if ((double)MAF2 > 0.5 || MAF2 < 0.0f) {
                                throw new DataFormatException("MAF2");
                            }
                        }
                        if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                            ExtractMap.this.firstMajorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles1), true)));
                            ExtractMap.this.firstMinorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles1), false)));
                            ExtractMap.this.secondMajorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles2), true)));
                            ExtractMap.this.secondMinorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles2), false)));
                        }
                        ++ExtractMap.this.totalPairs;
                    }
                    ++i;
                    head.clear();
                    head = null;
                    ++ExtractMap.this.line;
                    res = textLine.readLine();
                    if (!ExtractMap.this.useIndPos) continue;
                    textLine2.readLine();
                }
            }
            catch (FileNotFoundException e) {
                this.error = new Integer(-1);
            }
            catch (IOException e) {
                this.error = new Integer(-2);
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
            catch (IllegalArgumentException e) {
                this.error = new Integer(-4);
                ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                if (ExtractMap.this.hasHeading) {
                    ++ExtractMap.this.argumentLine;
                }
                ExtractMap.this.argument = ExtractMap.this.argument + "\"" + head + "\"";
            }
            catch (ClassNotFoundException e) {
                this.error = new Integer(-17);
                ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                if (ExtractMap.this.hasHeading) {
                    ++ExtractMap.this.argumentLine;
                }
                if (e.getMessage().equals("signal")) {
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.estimatorColumn) + "\"";
                }
                if (e.getMessage().equals("confidence")) {
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.confidenceLevelColumn) + "\"";
                    ExtractMap.this.argument = ExtractMap.this.argument + "\" at col: " + ExtractMap.this.confidenceLevelColumn + "\"";
                }
            }
            catch (DataFormatException e) {
                if (e.getMessage() == null) {
                    this.error = new Integer(-5);
                } else if (e.getMessage().equals("signal")) {
                    this.error = new Integer(-12);
                    ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                    if (ExtractMap.this.hasHeading) {
                        ++ExtractMap.this.argumentLine;
                    }
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.binaryEstimatorColumn) + "\"";
                } else if (e.getMessage().equals("MAF1")) {
                    this.error = new Integer(-13);
                    ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                    if (ExtractMap.this.hasHeading) {
                        ++ExtractMap.this.argumentLine;
                    }
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.MAFColumn) + "\"";
                } else if (e.getMessage().equals("MAF2")) {
                    this.error = new Integer(-14);
                    ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                    if (ExtractMap.this.hasHeading) {
                        ++ExtractMap.this.argumentLine;
                    }
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.MAFColumn2) + "\"";
                } else if (e.getMessage().equals("inds1")) {
                    this.error = new Integer(-15);
                    ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                    if (ExtractMap.this.hasHeading) {
                        ++ExtractMap.this.argumentLine;
                    }
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.SNP1) + "\"";
                } else if (e.getMessage().equals("inds2")) {
                    this.error = new Integer(-16);
                    ExtractMap.this.argumentLine = ExtractMap.this.line + 1;
                    if (ExtractMap.this.hasHeading) {
                        ++ExtractMap.this.argumentLine;
                    }
                    ExtractMap.this.argument = ExtractMap.this.argument + "\"" + (String)head.get(ExtractMap.this.SNP2) + "\"";
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.error = new Integer(-10);
            }
            catch (Exception e) {
                this.error = new Integer(-9);
            }
        }

        void orderingSNPs() {
            try {
                ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalPairs, "ordering SNPs");
                for (int i = 0; i < ExtractMap.this.totalPairs; ++i) {
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, i);
                    }
                    this.foundSNP.add(new Integer((Integer)ExtractMap.this.firstSNPArray.get(i)));
                    this.foundSNP.add(new Integer((Integer)ExtractMap.this.secondSNPArray.get(i)));
                }
                ExtractMap.this.totalSNPs = this.foundSNP.size();
                if (ExtractMap.this.totalSNPs == 0) {
                    this.error = new Integer(-6);
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }

        void filtering3D() {
            try {
                int filter = 50;
                int lastSNP = Integer.MAX_VALUE;
                if (filter > ExtractMap.this.totalSNPs) {
                    filter = ExtractMap.this.totalSNPs;
                }
                ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalSNPs - filter, "filtering SNPs for 3D");
                for (int i = filter; i < ExtractMap.this.totalSNPs; ++i) {
                    if (i % 100 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, i);
                    }
                    this.foundSNP.remove(this.foundSNP.last());
                }
                ExtractMap.this.totalSNPs = this.foundSNP.size();
                lastSNP = (Integer)this.foundSNP.last();
                if (ExtractMap.this.totalSNPs == 0) {
                    this.error = new Integer(-6);
                }
                ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalPairs, "filtering pairs for 3D");
                boolean c = false;
                for (int i = ExtractMap.this.totalPairs - 1; i >= 0; --i) {
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, ExtractMap.this.totalPairs - i);
                    }
                    if ((Integer)ExtractMap.this.firstSNPArray.get(i) <= lastSNP && (Integer)ExtractMap.this.secondSNPArray.get(i) <= lastSNP) continue;
                    ExtractMap.this.firstSNPArray.remove(i);
                    ExtractMap.this.secondSNPArray.remove(i);
                    ExtractMap.this.estimationArray.remove(i);
                    if (ExtractMap.this.useMAF) {
                        ExtractMap.this.MAF1Array.remove(i);
                        ExtractMap.this.MAF2Array.remove(i);
                    }
                    if (ExtractMap.this.useBIN) {
                        ExtractMap.this.binaryEstimationArray.remove(i);
                    }
                    if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                        ExtractMap.this.firstSNPAArray.remove(i);
                        ExtractMap.this.secondSNPAArray.remove(i);
                    }
                    if (ExtractMap.this.alleles1 < 0 || ExtractMap.this.alleles2 < 0) continue;
                    ExtractMap.this.firstMajorArray.remove(i);
                    ExtractMap.this.firstMinorArray.remove(i);
                    ExtractMap.this.secondMajorArray.remove(i);
                    ExtractMap.this.secondMinorArray.remove(i);
                }
                ExtractMap.this.totalPairs = ExtractMap.this.firstSNPArray.size();
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }

        public void convertArrays() {
            try {
                ExtractMap.this.hashSNPPos = new HashMap();
                Iterator it = this.foundSNP.iterator();
                ExtractMap.this.SNPPositions = new int[ExtractMap.this.totalSNPs];
                ExtractMap.this.Annotation = new String[ExtractMap.this.totalSNPs];
                if (ExtractMap.this.useMAF) {
                    ExtractMap.this.MAFValues = new float[ExtractMap.this.totalSNPs];
                }
                ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalSNPs, "computing coordinates");
                for (int i = 0; i < ExtractMap.this.totalSNPs; ++i) {
                    Object v = it.next();
                    ExtractMap.this.hashSNPPos.put(v, new Integer(i));
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, i);
                    }
                    ExtractMap.this.SNPPositions[i] = (Integer)v;
                }
                ExtractMap.this.trueMaxDistance = 0L;
                ExtractMap.this.distance2D = 0;
                ExtractMap.this.positions = new Vector3f[ExtractMap.this.totalPairs];
                ExtractMap.this.indPositionsTable = null;
                if (ExtractMap.this.useIndPos) {
                    ExtractMap.this.indPositionsTable = new ArrayList[ExtractMap.this.totalPairs];
                }
                if (ExtractMap.this.useBIN) {
                    ExtractMap.this.binaryEstimatorSignal = new int[ExtractMap.this.totalPairs];
                }
                if (ExtractMap.this.useCONFIDENCE) {
                    ExtractMap.this.confidenceLevel = new float[ExtractMap.this.totalPairs];
                }
                ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalPairs * 2, "reformating");
                ExtractMap.this.colorArray = ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3 ? new Color3f[ExtractMap.this.totalPairs] : null;
                for (int i = 0; i < ExtractMap.this.totalPairs; ++i) {
                    Integer in = new Integer((Integer)ExtractMap.this.firstSNPArray.get(i));
                    float x = ((Integer)ExtractMap.this.hashSNPPos.get(in)).intValue();
                    if (ExtractMap.this.useMAF) {
                        ExtractMap.this.MAFValues[(int)x] = ((Float)ExtractMap.this.MAF1Array.get(i)).floatValue();
                    }
                    ExtractMap.this.Annotation[(int)x] = (String)ExtractMap.this.firstSNPAArray.get(i);
                    in = new Integer((Integer)ExtractMap.this.secondSNPArray.get(i));
                    float y = ((Integer)ExtractMap.this.hashSNPPos.get(in)).intValue();
                    if (ExtractMap.this.useMAF) {
                        ExtractMap.this.MAFValues[(int)y] = ((Float)ExtractMap.this.MAF2Array.get(i)).floatValue();
                    }
                    ExtractMap.this.Annotation[(int)y] = (String)ExtractMap.this.secondSNPAArray.get(i);
                    float z = ((Float)ExtractMap.this.estimationArray.get(i)).floatValue();
                    if (ExtractMap.this.useIndPos) {
                        ExtractMap.this.indPositionsTable[i] = ExtractMap.this.indPositions.get(i);
                    }
                    if (ExtractMap.this.useBIN) {
                        ExtractMap.this.binaryEstimatorSignal[i] = (Integer)ExtractMap.this.binaryEstimationArray.get(i);
                    }
                    if (ExtractMap.this.useCONFIDENCE) {
                        ExtractMap.this.confidenceLevel[i] = ((Float)ExtractMap.this.confidenceLevelArray.get(i)).intValue();
                    }
                    ExtractMap.this.positions[i] = new Vector3f(x, y, z);
                    if ((float)ExtractMap.this.distance2D < y - x) {
                        ExtractMap.this.distance2D = (int)y - (int)x;
                    }
                    if (ExtractMap.this.trueMaxDistance < (long)(ExtractMap.this.SNPPositions[(int)y] - ExtractMap.this.SNPPositions[(int)x] + 1)) {
                        ExtractMap.this.trueMaxDistance = ExtractMap.this.SNPPositions[(int)y] - ExtractMap.this.SNPPositions[(int)x] + 1;
                    }
                    if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                        ExtractMap.this.colorArray[i] = this.setColor(this.getPosColor((Integer)ExtractMap.this.firstMajorArray.get(i), (Integer)ExtractMap.this.firstMinorArray.get(i)), this.getPosColor((Integer)ExtractMap.this.secondMajorArray.get(i), (Integer)ExtractMap.this.secondMinorArray.get(i)));
                    }
                    if (i % 1000 != 0) continue;
                    ExtractMap.this.updateStatus(ExtractMap.this.GUI, ExtractMap.this.totalPairs + i);
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }

        public void emptyArrays() {
            try {
                if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                    ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalSNPs, "indexing markers for annotation");
                }
                ExtractMap.this.hashSNPPos.clear();
                ExtractMap.this.hashSNPPos = null;
                this.foundSNP.clear();
                this.foundSNP = null;
                ExtractMap.this.firstSNPArray.clear();
                ExtractMap.this.secondSNPArray.clear();
                ExtractMap.this.estimationArray.clear();
                if (ExtractMap.this.useMAF) {
                    ExtractMap.this.MAF1Array.clear();
                    ExtractMap.this.MAF2Array.clear();
                }
                if (ExtractMap.this.useBIN) {
                    ExtractMap.this.binaryEstimationArray.clear();
                }
                if (ExtractMap.this.useCONFIDENCE) {
                    ExtractMap.this.confidenceLevelArray.clear();
                }
                ExtractMap.this.confidenceLevelArray = null;
                ExtractMap.this.firstSNPArray = null;
                ExtractMap.this.secondSNPArray = null;
                ExtractMap.this.estimationArray = null;
                if (ExtractMap.this.useBIN) {
                    ExtractMap.this.binaryEstimationArray = null;
                }
                if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                    ExtractMap.this.firstMajorArray.clear();
                    ExtractMap.this.firstMinorArray.clear();
                    ExtractMap.this.secondMajorArray.clear();
                    ExtractMap.this.secondMinorArray.clear();
                    ExtractMap.this.firstMajorArray = null;
                    ExtractMap.this.firstMinorArray = null;
                    ExtractMap.this.secondMajorArray = null;
                    ExtractMap.this.secondMinorArray = null;
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
            System.gc();
        }

        public void getSNPs(boolean isMarked) {
            int i;
            ExtractMap.this.line = 0;
            ArrayList head = null;
            String s1 = new String("");
            if (isMarked) {
                ExtractMap.this.marked = new boolean[ExtractMap.this.totalSNPs];
                for (i = 0; i < ExtractMap.this.totalSNPs; ++i) {
                    ExtractMap.this.marked[i] = false;
                }
            } else {
                ExtractMap.this.selected = new boolean[ExtractMap.this.totalSNPs];
                for (i = 0; i < ExtractMap.this.totalSNPs; ++i) {
                    ExtractMap.this.selected[i] = false;
                }
            }
            try {
                File file = isMarked ? new File(ExtractMap.this.annotationFile2) : new File(ExtractMap.this.annotationFile);
                int approxSize = Math.round(file.length());
                BufferedReader bufferedReader = isMarked ? new BufferedReader(new FileReader(ExtractMap.this.annotationFile2)) : new BufferedReader(new FileReader(ExtractMap.this.annotationFile));
                TextLine textLine = new TextLine(bufferedReader, ",\t ");
                approxSize /= textLine.getLineSize();
                if (isMarked) {
                    ExtractMap.this.iniBar(ExtractMap.this.GUI, approxSize, "reading annotation file 2");
                } else {
                    ExtractMap.this.iniBar(ExtractMap.this.GUI, approxSize, "reading annotation file");
                }
                int c = 0;
                do {
                    if (c % 100 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, c);
                    }
                    head = textLine.getWordsInLine();
                    s1 = (String)head.get(0);
                    boolean found = false;
                    int cont = 0;
                    while (cont < ExtractMap.this.totalSNPs && !found) {
                        if (s1.equals(ExtractMap.this.Annotation[cont])) {
                            found = true;
                            continue;
                        }
                        ++cont;
                    }
                    if (found) {
                        if (isMarked) {
                            ExtractMap.this.marked[cont] = true;
                            ++ExtractMap.this.existMarked;
                            if (ExtractMap.this.selected[cont]) {
                                ++ExtractMap.this.inCommon;
                            }
                        } else {
                            ExtractMap.this.selected[cont] = true;
                            ++ExtractMap.this.existSelected;
                        }
                    }
                    ++c;
                    ++ExtractMap.this.line;
                } while (textLine.readLine() == 0);
            }
            catch (FileNotFoundException e) {
                this.error = new Integer(-7);
            }
            catch (IOException e) {
                this.error = new Integer(-2);
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
            catch (NumberFormatException e) {
                this.error = new Integer(-11);
                ExtractMap.this.argument = "\"" + s1 + "\"";
            }
        }

        Color3f setColor(int val1, int val2) {
            return ExtractMap.this.colorCode[val1][val2];
        }

        int getPosColor(int a1, int a2) {
            return a1 * 4 + a2;
        }

        public int getNeighbour(int SNP1, int SNP2, int orientation) {
            int SNP1N = SNP1;
            int SNP2N = SNP2;
            switch (orientation) {
                case 0: {
                    SNP2N = SNP2 - 1;
                    break;
                }
                case 1: {
                    SNP1N = SNP1 - 1;
                    break;
                }
                case 2: {
                    SNP2N = SNP2 + 1;
                    break;
                }
                case 3: {
                    SNP1N = SNP1 + 1;
                }
            }
            int c = 0;
            boolean found = false;
            while (c < ExtractMap.this.totalPairs && !found) {
                if (ExtractMap.this.positions[c].x == (float)SNP1N && ExtractMap.this.positions[c].y == (float)SNP2N) {
                    found = true;
                    continue;
                }
                ++c;
            }
            return c;
        }

        public Color getColorWilk(boolean consistent) {
            Color result = consistent ? (ExtractMap.this.color == Color.green ? Color.BLUE : Color.GREEN) : (ExtractMap.this.color == Color.red ? Color.BLUE : Color.RED);
            return result;
        }

        public void create2DMap() {
            int scale = 0;
            int scale2 = 0;
            int SNP = 0;
            try {
                Color color2;
                int lefty;
                int leftx;
                int width = 1;
                int width2 = 1;
                if (ExtractMap.this.resolution > 1) {
                    width = (int)Math.round(Math.sqrt(ExtractMap.this.resolution * ExtractMap.this.resolution * 2));
                    width2 = (int)Math.round(Math.sqrt((ExtractMap.this.resolution - 2) * (ExtractMap.this.resolution - 2) * 2));
                    width2 = (int)Math.round(Math.sqrt(ExtractMap.this.resolution / 4 * (ExtractMap.this.resolution / 4)));
                    if (width % 2 != 0) {
                        ++width;
                    }
                    if (width2 % 2 != 0) {
                        ++width2;
                    }
                }
                int horizontalSize = ExtractMap.this.totalSNPs * width;
                int verticalSize = ExtractMap.this.distance2D * width;
                ExtractMap.this.im = new Image();
                int[] xvals = new int[4];
                int[] yvals = new int[4];
                int vertDesp = 20 + 2 * width;
                int head = 80;
                int horDesp = 20;
                ExtractMap.this.im.image = new BufferedImage(horizontalSize + horDesp * 2, verticalSize + vertDesp + head, 1);
                Graphics2D g2d = ExtractMap.this.im.image.createGraphics();
                g2d.setColor(Color.GRAY);
                g2d.fillRect(0, 0, horizontalSize + horDesp * 2, verticalSize + vertDesp + head);
                g2d.setFont(g2d.getFont().deriveFont(15.0f));
                String st = new String();
                int R = 255;
                int B = 255;
                int G = 255;
                for (SNP = 0; SNP < ExtractMap.this.totalSNPs; ++SNP) {
                    if (!ExtractMap.this.annotation && !ExtractMap.this.annotation2 && SNP % (50 / ExtractMap.this.resolution) == 0 || ExtractMap.this.annotation2 && ExtractMap.this.marked[SNP] || ExtractMap.this.annotation && ExtractMap.this.selected[SNP]) {
                        g2d.setColor(Color.black);
                        if (ExtractMap.this.annotation2 && ExtractMap.this.marked[SNP]) {
                            if (ExtractMap.this.annotation && !ExtractMap.this.selected[SNP]) {
                                g2d.setColor(Color.red);
                            } else {
                                g2d.setColor(Color.green);
                            }
                        }
                        st = ExtractMap.this.Annotation[SNP];
                        g2d.translate(horDesp, head + vertDesp / 2);
                        g2d.rotate(5.497787143782138);
                        int yRot = (int)Math.ceil((double)(SNP * width) * Math.sin(0.7853981633974483));
                        int xRot = (int)Math.ceil((double)(SNP * width) * Math.cos(0.7853981633974483));
                        g2d.drawString("" + st, xRot, yRot);
                        g2d.rotate(0.7853981633974483);
                        g2d.translate(-horDesp, -head - vertDesp / 2);
                        leftx = SNP * width + horDesp;
                        lefty = head + vertDesp / 2;
                        if (!ExtractMap.this.useMAF) {
                            g2d.drawLine(leftx, lefty, leftx, head + vertDesp + width / 2);
                        } else {
                            g2d.drawLine(leftx, lefty, leftx, head + vertDesp - width + width / 2);
                        }
                    }
                    if (ExtractMap.this.useDelimiters && ExtractMap.this.delimiters.contains(SNP)) {
                        leftx = SNP * width + horDesp - width / 2;
                        lefty = 0;
                        g2d.setColor(Color.WHITE);
                        for (int i = 0; i <= vertDesp; ++i) {
                            if (i % 2 != 0) continue;
                            g2d.drawLine(leftx, lefty + i * vertDesp / 10, leftx, lefty + (i + 1) * vertDesp / 10);
                        }
                    }
                    if (ExtractMap.this.useBlocks && ExtractMap.this.blocks.contains(SNP)) {
                        leftx = SNP * width + horDesp - width / 2;
                        lefty = head + vertDesp - width;
                        g2d.setColor(Color.BLACK);
                        g2d.drawLine(leftx, lefty, leftx, verticalSize);
                    }
                    if (!ExtractMap.this.useMAF) continue;
                    leftx = SNP * width + horDesp - width / 2;
                    lefty = head + vertDesp - width;
                    scale = Math.round((float)Math.ceil(ExtractMap.this.MAFValues[SNP] * 20.0f));
                    color2 = Image.getClarifiedColor(ExtractMap.this.color, scale);
                    g2d.setColor(color2);
                    if (width > 0) {
                        xvals[0] = leftx;
                        xvals[1] = leftx + width;
                        xvals[2] = leftx + width;
                        xvals[3] = leftx;
                        yvals[0] = lefty;
                        yvals[1] = lefty;
                        yvals[2] = lefty + width;
                        yvals[3] = lefty + width;
                        g2d.fillPolygon(xvals, yvals, 4);
                        continue;
                    }
                    g2d.drawLine(leftx, lefty, leftx, lefty);
                }
                ExtractMap.this.iniBar(ExtractMap.this.GUI, ExtractMap.this.totalPairs, "building map");
                for (int c = 0; c < ExtractMap.this.totalPairs; ++c) {
                    R = 0;
                    B = 0;
                    G = 0;
                    if (c % 1000 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.GUI, c);
                    }
                    SNP = (int)ExtractMap.this.positions[c].x;
                    int SNP2 = (int)ExtractMap.this.positions[c].y;
                    int distance = SNP2 - SNP;
                    scale = Math.round((float)Math.ceil(ExtractMap.this.positions[c].z * 10.0f));
                    Color colorWilk = ExtractMap.this.color;
                    if (ExtractMap.this.useBIN && ExtractMap.this.binaryEstimatorSignal[c] != 0) {
                        colorWilk = this.getColorWilk(ExtractMap.this.binaryEstimatorSignal[c] == 1);
                    }
                    if (!ExtractMap.this.useCONFIDENCE) {
                        color2 = Image.getClarifiedColor(colorWilk, scale);
                    } else {
                        scale2 = Math.round((float)Math.ceil(ExtractMap.this.confidenceLevel[c] * 10.0f));
                        color2 = Image.getClarifiedColor(colorWilk, scale, scale2);
                    }
                    g2d.setColor(color2);
                    leftx = SNP * width + distance * width / 2 - width / 2 + horDesp;
                    lefty = distance * width / 2 + head + vertDesp;
                    if (width > 1) {
                        xvals[0] = leftx;
                        xvals[1] = leftx + width / 2;
                        xvals[2] = leftx + width;
                        xvals[3] = leftx + width / 2;
                        yvals[0] = lefty;
                        yvals[1] = lefty - width / 2;
                        yvals[2] = lefty;
                        yvals[3] = lefty + width / 2;
                        g2d.fillPolygon(xvals, yvals, 4);
                        if (!ExtractMap.this.useIndPos) continue;
                        if (ExtractMap.this.indPositionsTable[c].size() > 0) {
                            for (int orientation = 0; orientation < 4; ++orientation) {
                                int differentSNPN;
                                int differentSNP;
                                int c2 = this.getNeighbour(SNP, SNP2, orientation);
                                if (c2 >= ExtractMap.this.totalPairs) continue;
                                if (orientation == 0 || orientation == 2) {
                                    differentSNP = SNP2;
                                    differentSNPN = (int)ExtractMap.this.positions[c2].y;
                                } else {
                                    differentSNP = SNP;
                                    differentSNPN = (int)ExtractMap.this.positions[c2].x;
                                }
                                color2 = ExtractMap.this.MAFValues[differentSNP] <= ExtractMap.this.MAFValues[differentSNPN] && !ExtractMap.this.indPositionsTable[c2].containsAll(ExtractMap.this.indPositionsTable[c]) || ExtractMap.this.MAFValues[differentSNP] >= ExtractMap.this.MAFValues[differentSNPN] && !ExtractMap.this.indPositionsTable[c].containsAll(ExtractMap.this.indPositionsTable[c2]) ? this.getColorWilk(false) : this.getColorWilk(true);
                                g2d.setColor(color2);
                                int px0 = leftx + width2 / 2;
                                int px1 = leftx + width / 2 - width2 / 2;
                                int px2 = leftx + width / 2;
                                int px3 = leftx + width2;
                                int py0 = lefty - width2 / 2;
                                int py1 = lefty - width / 2 + width2 / 2;
                                int py2 = lefty - width / 2 + width2;
                                int py3 = lefty;
                                switch (orientation) {
                                    case 0: {
                                        xvals[0] = px0;
                                        xvals[1] = px1;
                                        xvals[2] = px2;
                                        xvals[3] = px3;
                                        yvals[0] = py0;
                                        yvals[1] = py1;
                                        yvals[2] = py2;
                                        yvals[3] = py3;
                                        break;
                                    }
                                    case 1: {
                                        xvals[0] = px0;
                                        xvals[1] = px3;
                                        xvals[2] = px2;
                                        xvals[3] = px1;
                                        yvals[0] = py0 + width2;
                                        yvals[1] = py3;
                                        yvals[2] = lefty + width / 2 - width2;
                                        yvals[3] = lefty + width / 2 - width2 / 2;
                                        break;
                                    }
                                    case 2: {
                                        xvals[0] = px2;
                                        xvals[1] = leftx + width - width2;
                                        xvals[2] = leftx + width - width2 / 2;
                                        xvals[3] = px2 + width2 / 2;
                                        yvals[0] = lefty + width / 2 - width2;
                                        yvals[2] = py0 + width2;
                                        yvals[1] = py3;
                                        yvals[3] = lefty + width / 2 - width2 / 2;
                                        break;
                                    }
                                    case 3: {
                                        xvals[1] = px2 + width2 / 2;
                                        xvals[2] = leftx + width - width2 / 2;
                                        xvals[3] = leftx + width - width2;
                                        xvals[0] = px2;
                                        yvals[0] = py2;
                                        yvals[1] = py1;
                                        yvals[2] = py0;
                                        yvals[3] = py3;
                                    }
                                }
                                g2d.fillPolygon(xvals, yvals, 4);
                            }
                            if (ExtractMap.this.resolution == 50) {
                                g2d.setFont(new Font("monospaced", 0, 9).deriveFont(AffineTransform.getRotateInstance(5.497787143782138)));
                                g2d.setColor(Color.BLACK);
                                int offset = 0;
                                int p = 0;
                                for (int n = 0; n < ExtractMap.this.indPositionsTable[c].size(); ++n) {
                                    p = n % 4;
                                    if (n % 4 == 0) {
                                        offset = n / 4 * width2 / 2;
                                    }
                                    g2d.drawString(ExtractMap.this.indPositionsTable[c].get(n) + "-", leftx + width2 / 2 + 2 * p * 5 + offset, lefty + width2 / 2 - 2 * p * 5 + offset);
                                }
                            }
                        }
                        xvals[0] = leftx;
                        xvals[1] = leftx + width / 2;
                        xvals[2] = leftx + width;
                        xvals[3] = leftx + width / 2;
                        yvals[0] = lefty;
                        yvals[1] = lefty - width / 2;
                        yvals[2] = lefty;
                        yvals[3] = lefty + width / 2;
                        g2d.setColor(Color.BLACK);
                        g2d.drawPolygon(xvals, yvals, 4);
                        continue;
                    }
                    g2d.drawLine(leftx, lefty, leftx, lefty);
                }
                if (ExtractMap.this.annotation) {
                    UI.print("" + (ExtractMap.this.existSelected - ExtractMap.this.inCommon) + " SNPs in file " + ExtractMap.this.annotationFile + " have been marked in black.");
                }
                if (ExtractMap.this.annotation2) {
                    UI.print("" + (ExtractMap.this.existMarked - ExtractMap.this.inCommon) + " SNPs in file " + ExtractMap.this.annotationFile2 + " have been marked in red.");
                }
                if (ExtractMap.this.annotation2 && ExtractMap.this.annotation) {
                    UI.print("" + ExtractMap.this.inCommon + " SNPs in common in files " + ExtractMap.this.annotationFile + " and " + ExtractMap.this.annotationFile2 + " have been marked in green.");
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }
    }
}

