/* File: UndirectedBN.cpp */


#ifndef __UndirectedBN_cpp__
#define __UndirectedBN_cpp__


#include "UndirectedBN.h"





//using namespace UTILS;


namespace BIOS
{


	/*
	// ________________________________________________________________________________
	____ */

	UndirectedBN::UndirectedBN()
	{
		this->set();
	}


	/*
	________________________________________________________________________________
	__ */

	UndirectedBN::UndirectedBN ( intMLSample* sample, float alpha, intList** parents, CPT** probTables, VerbosityClass *verbosity )
	{
		if ( parents==NULL || sample==NULL || probTables==NULL )
		{
			cout <<"Error in UndirectedBN:set";
			end();
		}
		this->verbosity=verbosity;
		UndirectedBN::set();
		this->sample=sample;
		this->parents=parents;
		this->alpha=alpha;
		this->probTables=probTables;
		totalAttributes=sample->listOfAttributes->GetTotalAttributes();
		//totalSelectedAttributes=sample->listOfAttributes->getTotalSelectedAttributes();
		//  setJunctionTree();

	};

	/*____________________________________________________________________________________ */

	JunctionTree* UndirectedBN::getJunctionTree()
	{
		return junctionTree;
	};
	/*____________________________________________________________________________________ */

	void UndirectedBN::setJunctionTree()
	{
		throw NonImplemented ( "UndirectedBN::setJunctionTree()" );
	};

	/*  try
	    {
	      SimpleDAG *dAG=getDAG();
	      UndirectedArc<Node*, void>* uarc;
	  //    DirectedArc<Node*>* darc;
	      UGraph<UndirectedArc, Node*>* uGraph=dAG->getMoralGraph();
	      zap(dAG);
	      TriangulatedUG* triangulatedUG=new TriangulatedUG(*uGraph);
	      zap(uGraph);
	      cliques=new SetOfCliques(*triangulatedUG->nodes);
	      zap(triangulatedUG);
	      CompleteUG<EnrichedDirectedArc, Clique*>* completeUG=new CompleteUG<EnrichedDirectedArc, Clique*>(cliques);
	      UTree<EnrichedDirectedArc, Clique*>* uTree=completeUG->getMWST();
	      zap(completeUG);
	      Separator *s;
	      junctionTree=uTree->getDirectedTree(&uTree->nodes->getFirstElement(), s);
	//cout <<*junctionTree;
	//end();
	      zap(uTree);
	      setPotentials();
	    }
	    catch (NullValue NV ) {NV.PrintMessage("in UndirectedBN::UndirectedBN");}
	  };


	/*____________________________________________________________________________________ */

	void UndirectedBN::setJunctionTreeNB ( int classPosition )
	{
		DirectedSeparatorOfCliques* separator=NULL;
		SeparatorContent* separatorContent=NULL;
		Clique* clique=NULL;
// create a list of non-class attributes
		intList* inputAttributes=new intList();
		for ( int i=0;i<totalAttributes;i++ )
			if ( i!=classPosition ) inputAttributes->insertElement ( i );
// create junctionTree and nodes
		if ( verbosity!=NULL && verbosity->verbosityR.progress ) cout <<"\ncreating junction tree ...";
		junctionTree= new JunctionTree();
// insert rootClique
		if ( verbosity!=NULL && verbosity->verbosityR.progress ) cout <<"\ninsert cliques for att " << inputAttributes->getFirstElement() <<" (root) of " << totalAttributes;
		Clique* rootClique=new Clique();// create clique
//cout << "inputatts:" << *inputAttributes << "\n";
		if ( inputAttributes->size() >0 ) rootClique->insertElement ( new Node ( inputAttributes->getFirstElement() ) );//insert first non-class att
		rootClique->insertElement ( new Node ( classPosition ) );// insert class
		junctionTree->nodes->insertElement ( rootClique );
		junctionTree->setRoot ( junctionTree->nodes->begin() );
// create the commonNodes with the nodeClass
		NodeSet* commonNodes=NULL;
// insert remaining cliques and separators
//cout << "tree after adding the root is: "<< *junctionTree << "\n";

		for ( int i=1;i<totalAttributes-1;i++ )
		{
			commonNodes=new NodeSet();
			commonNodes->insertElement ( new Node ( classPosition ) );

//commonNodes->insertElement(new Node(inputAttributes->getElement(i)));
			if ( verbosity!=NULL && verbosity->verbosityR.progress ) if ( i%10==0 ) cout <<"\ninserting cliques for att at pos " << i+1 << " (att " << inputAttributes->getElement ( i ) <<") of " << totalAttributes;

			clique=new Clique();
			clique->insertElement ( new Node ( classPosition ) );
			clique->insertElement ( new Node ( inputAttributes->getElement ( i ) ) );
//			junctionTree->nodes->insertElement ( clique );
			separatorContent=new SeparatorContent ( NULL, commonNodes );


		//	separator=new DirectedSeparatorOfCliques ( ( float ) 1, junctionTree->nodes->find ( rootClique ), junctionTree->nodes->find ( clique ), separatorContent );
//cout << "separator to be added to the junction tree (tree of separators):\n" << *separator << "\n";

			junctionTree->insertElement (junctionTree->nodes->find(rootClique), clique, separatorContent, (float)1, true );
			zap ( commonNodes );
		}
		zap ( inputAttributes );
		setPotentials ( classPosition );
//cout << "junctiontree is:" << *junctionTree << "\n";
//exit(0);
	};
	/*____________________________________________________________________________________ */

	void UndirectedBN::setJunctionTreeTAN ( int classPosition )
	{
		junctionTree= new JunctionTree();
		junctionTree->nodes=new SetOfCliques();
		Clique* clique=NULL;
		Node* node=NULL, *nodeClass=NULL;
		nodeClass=new Node ( classPosition );
		intList* inputAttributes=new intList();
		for ( int i=0;i<totalAttributes;i++ )
			if ( i!=classPosition ) inputAttributes->insertElement ( i );
		for ( int i=0;i<inputAttributes->size();i++ )
		{
			clique=new Clique();
			clique->insertElement ( nodeClass );
			node=new Node ( inputAttributes->getElement ( i ) );
			clique->insertElement ( node );
			zap ( node );
			if ( parents[inputAttributes->getElement ( i ) ]->size() >1 )
			{
				node=new Node ( parents[inputAttributes->getElement ( i ) ]->getElement ( 1 ) );
				clique->insertElement ( node );
				zap ( node );
			}
			junctionTree->nodes->insertElement ( clique );
			zap ( clique );
		}
		if ( inputAttributes->size() ==0 )
		{
			clique=new Clique();
			clique->insertElement ( nodeClass );
			junctionTree->nodes->insertElement ( clique );
			zap ( clique );
		}
		SeparatorContent *separatorContent;
		NodeSet* commonNodes=NULL;
		DirectedSeparatorOfCliques* separator=NULL;
		int parent;
		if ( inputAttributes->size() >1 )
			for ( int i=1;i<inputAttributes->size();i++ )
			{
				commonNodes=new NodeSet();
				commonNodes->insertElement ( nodeClass );
				if ( ( junctionTree->nodes->getElement ( i ) )->size() >2 )
				{
					parent=parents[inputAttributes->getElement ( i ) ]->getElement ( 1 );
//cout << "parent" << parent << ", i: " << i << ", element" << inputAttributes->getElement(i) << "\n";
//cout << "inputatt: " << *inputAttributes;
					node=new Node ( parent );
					commonNodes->insertElement ( node );
					zap ( node );
					if ( parent>classPosition ) parent--;
					separatorContent=new SeparatorContent ( NULL, new NodeSet ( *commonNodes ) );
					separator=new DirectedSeparatorOfCliques ( ( float ) 1, junctionTree->nodes->getNode ( parent ), junctionTree->nodes->getNode ( i ), separatorContent );
				}
				else
				{
					separatorContent=new SeparatorContent ( NULL, new NodeSet ( *commonNodes ) );
					separator=new DirectedSeparatorOfCliques ( ( float ) 1, junctionTree->nodes->getNode ( 0 ), junctionTree->nodes->getNode ( i ), separatorContent );
				}
				zap ( commonNodes );
				junctionTree->insertElement ( separator );
				zap ( separator );
			}
// zap(nodeClass);
		zap ( inputAttributes );
		setPotentials ( classPosition );
//cout << *junctionTree;
	};
	/*____________________________________________________________________________________ */

	void UndirectedBN::set()
	{
		parents=NULL;
		junctionTree=NULL;
		commonConditionals=NULL;
	};

	/*
	________________________________________________________________________________
	____ */

	NodeSet* UndirectedBN::getNodeList()
	{
		NodeSet* nodeList=new NodeSet();
		for ( int i=0;i<totalAttributes;i++ )
			if ( sample->listOfAttributes->getElement ( i )->isSelected() )
				nodeList->insertElement ( new Node ( i ) );
		return nodeList;
	};


	/*
	________________________________________________________________________________
	____ */

	UndirectedBN::~UndirectedBN()
	{
		if ( junctionTree!=NULL && junctionTree->nodes!=NULL )
			zaparr ( commonConditionals );
		zap ( junctionTree );
		if ( junctionTree!=NULL )
		{
			cout <<"error in ~UndirectedBN";
			end();
		}
	};


	/*
	____________________________________________________________________________________ */
	/*
	  PotentialList* UndirectedBN::createPotentialSeparator(intList* varList)
	  {
	PotentialList* result=new PotentialList();
	PotentialTable* pt, *pt2;
	intList *vList=new intList(*varList), *l;

	for(int i=0;i<totalAttributes;i++)
	{
	l=new intList();
	l->insertElement(i);
	if (vList->includes(l))
	if (vList->includes(parents[i]))
	{
	 pt=probTables[i]->convertToPotential();
	l->copyPaste(parents[i]);
	pt2=pt->marginalize(l);
	zap(pt);
	pt2->initialize(1);
	   result->insertElement(pt2);
	   zap(pt2);
	vList->removeNode(vList->findElement(i));
	for (int j=0;j<parents[i]->size();j++)
	 vList->removeNode(vList->findElement(parents[i]->getElement(j)));
	}
	zap(l);
	}
	return result;

	return NULL;
	}
	/*____________________________________________________________________________________ */
	/*
	  Set<intList, ListOfPointers>* UndirectedBN::getRelativeVarPotentials (intList* commonVars, Clique* firstClique, Clique* secondClique)
	 // it returns a set of factor lists with vars in commonVars but not included in the current potential
	  {
	  Set<intList, ListOfPointers>* marginalVars=new Set<intList, ListOfPointers>();
	  intList* varList;
	  int optimalBlanket;
	  bool found;
	  Set<Integer, ListOfPointers>* commonNodes=commonVars->getIntegerSet(), *jointSet;//, *firstJointSet,
	  SampleOfSets<Integer>* firstVarSets=firstClique->getPotential()->getVarSets(), *secondVarSets=secondClique->getPotential()->getVarSets(), *filteredFirstVarSets=firstVarSets->getCommonNodes(commonNodes);
	  SampleOfSets<Integer>::iterator p=filteredFirstVarSets->getFirst(), p2;
	  Set<intList, ListOfPointers>::iterator p3;
	    while (p!=NULL)
	  {
	  optimalBlanket=secondVarSets->getOptimalBlanket(filteredFirstVarSets->getElement(p));
	  if (optimalBlanket==-1)
	 // if (filteredFirstVarSets->getElement(p)->size()!=0)
	  {
	  varList=filteredFirstVarSets->getElement(p)->getIntList();
	   marginalVars->insertElement(varList);
	   zap(varList);
	   }
	   //else 	  cout <<"\nfound blanket " << *secondVarSets->getElement(optimalBlanket);


	  // zap(optimalBlanket);
	   p=filteredFirstVarSets->getNext(p);
	   };
	  marginalVars->removeSubsets();
	   return marginalVars;
	  }
	 /*____________________________________________________________________________________ */
	/*
	  PotentialList* UndirectedBN::addRelativePotentials (intList* commonVars, Clique* firstClique, Clique* secondClique)
	  {
	   Set<intList, ListOfPointers>* marginalVars= getRelativeVarPotentials(commonVars, firstClique, secondClique);
	   if (marginalVars==NULL || marginalVars->size()==0) return NULL;
	   //cout << "\nmarg:" << *marginalVars <<"size:" << marginalVars->size();
	  // end();
	  Set<intList, ListOfPointers>::iterator p3;
	  PotentialList* pL=new PotentialList();
	  PotentialTable * pT;
	  intList* dimensionList;
	  if (marginalVars->size()>0)
	  {
	  p3=marginalVars->getFirst();

	  while (p3!=NULL)
	  {
		  if (marginalVars->getElement(p3)->size()>0)
		  {
	  dimensionList=sample->listOfAttributes->getDimensionList(marginalVars->getElement(p3));
	  pT=new PotentialTable(marginalVars->getElement(p3), dimensionList, alpha);
	  pT->initialize(1);
	   pL->insertElement(pT);
	  zap(pT);
	  zap(dimensionList);
		  }
		  p3=marginalVars->getNext(p3);

	  }

	  }
	  else zap(pL);
	 zap(marginalVars);
	  return pL;

	  //return NULL;
	  }

	/*____________________________________________________________________________________ */

	PotentialList* UndirectedBN::createPotentialClique ( intList* varList, intList** remainingParents )
	{
// it creates the potentials associated with clique defined with varList, using the parents of those variables in the clique
		PotentialList* potentialTableList=new PotentialList(), *potentialTableList2;
		PotentialTable* potentialTable;
		for ( int i=0; i<totalAttributes; i++ )
			if ( varList->findElement ( i ) !=varList->end() && remainingParents[i]!=NULL && ( varList->includes ( remainingParents[i] ) ) )
			{
				potentialTable=probTables[i]->convertToPotential();
				potentialTableList->insertElement ( potentialTable );
			}
		if ( potentialTableList->size() !=0 )
		{
			potentialTableList2=potentialTableList->eliminate();
			zap ( potentialTableList );
			potentialTableList=potentialTableList2;
		}
		else
		{
			intList* dimensionList=sample->listOfAttributes->getDimensionList ( varList );
			potentialTable=new PotentialTable ( varList, dimensionList );
			potentialTable->initialize ( 1 );
			potentialTableList->insertElement ( potentialTable );
			zap ( dimensionList );
		}
		return potentialTableList;
	};
	/*_______________________________________________________________________________________ */
	/*
	  PotentialList* UndirectedBN::createPotential (Set<Node>* nodeSet, bool
	isSeparator, intList** remainingParents, int cliqueNumber)
	  {
	    PotentialList* potentialTable=NULL;

	    if (nodeSet==NULL)
	    {
	      cout <<"Error in UndirectedBN::createPotential, null set of common nodes";
	      end();
	    }
	    intList* varList=nodeSet->Container<Node, ListOfPointers>::getIntList();

	    if (isSeparator) potentialTable=createPotentialSeparator(varList);
	    else potentialTable=createPotentialClique(varList, remainingParents, cliqueNumber);
	    zap(varList);

	    return potentialTable;

	  };

	/*
	________________________________________________________________________________
	____ */

	void UndirectedBN::setPotentials ( int classPosition )
	{
//if (junctionTree==NULL) setJunctionTree();
		commonConditionals=new intList*[junctionTree->nodes->size() ];
		for ( int i=0;i<junctionTree->nodes->size();i++ )
			commonConditionals[i]=new intList();

		intList** parents2=new intList*[totalAttributes];

		for ( int i=0;i<totalAttributes;i++ )
			if ( sample->listOfAttributes->getElement ( i )->isSelected() )
				parents2[i]=new intList ( *parents[i] );
		SetOfCliques::iterator pC=junctionTree->nodes->getFirst();
		Clique* clique;
		PotentialList* potentialTableList, *potentialTableList2;
		PotentialTable* potentialTable;
		int i=0;
		intList* varList;

		if ( verbosity!=NULL && verbosity->verbosityR.progress ) cout <<"\ncomputing potentials";

		while ( pC!=junctionTree->nodes->end() )
		{
			clique=junctionTree->nodes->getElement ( pC );
			varList= ( ( NodeSet* ) clique )->getPrimitiveContainerFromPointerContainer ( varList );
			potentialTableList=createPotentialClique ( varList, parents2 );
			clique->setPotentialList ( potentialTableList );
			zap ( potentialTableList );
			pC=junctionTree->nodes->getNext ( pC );
			i++;
			zap ( varList );
		}
		zaparr ( parents2 );
// class potential will be added to the root node

		clique=*junctionTree->getRoot();
		potentialTableList=clique->getPotentialList();


		potentialTable=probTables[classPosition]->convertToPotential();
		potentialTableList->insertElement ( potentialTable );
		potentialTableList2=potentialTableList->simplify();
		zap ( potentialTableList );
		clique->setPotentialList ( potentialTableList2 );
		zap ( potentialTableList2 );

	};


	/*
	________________________________________________________________________ */

	SimpleDAG* UndirectedBN::getDAG()
	{
		SimpleDAG* dAG;
		intList::iterator p;
		dAG=new SimpleDAG();
		Node* node=NULL;
		NodeSet::iterator pN, pN2;
		DirectedArc<Node*>* arc;
		NodeSet* nodeList=getNodeList();
		if ( nodeList==NULL ) throw NullValue();
		dAG->setNodes ( nodeList );
		for ( int i=0;i<totalAttributes;i++ )
			if ( sample->listOfAttributes->getElement ( i )->isSelected() )
				if ( parents[i]!=NULL )
				{
					node=new Node ( i );
					pN=dAG->getNodes()->findElement ( node );
					if ( pN==dAG->getNodes()->end() ) throw NullValue();

					zap ( node );
					p=parents[i]->getFirst();

					while ( p!=parents[i]->end() )
					{
						node=new Node ( parents[i]->getElement ( p ) );
						pN2=dAG->getNodes()->findElement ( node );
						if ( pN2==dAG->getNodes()->end() ) throw NullValue();

						zap ( node );
						arc=new DirectedArc<Node*> ( 0, pN2, pN );

						dAG->insertElement ( arc );
						zap ( arc );
						p=parents[i]->getNext ( p );
					}
				}
		return dAG;
	}

	/*
	____________________________________________________________________________________ */

	void UndirectedBN::removeInconsistenciesWithEvidence ( int att, intList*
	        inputPattern, JunctionTree* junctionTree2 )
	{
try
{
		for ( SetOfCliques::iterator pC=junctionTree2->nodes->begin();pC!=junctionTree2->nodes->end();pC++ )
		{
			if ( junctionTree2->nodes->getElement ( pC )->getPotentialList() ==NULL )
				throw NullValue ( "UndirectedBN::removeInconsistenciesWithEvidence(int att, intList*inputPattern, JunctionTree* junctionTree2)" );
			junctionTree2->nodes->getElement ( pC )->getPotentialList()->removeInconsistenciesWithEvidence ( inputPattern );
		}
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void UndirectedBN::removeInconsistenciesWithEvidence ( int att, intList*	        inputPattern, JunctionTree* junctionTree2 )" ); throw;};

	}
	/*____________________________________________________________________________________ */

	void UndirectedBN::marginalizeSeparator ( JunctionTree* junctionTree2, DirectedSeparatorOfCliques* separator, SetOfCliques::iterator clique, intList* inputPattern )
	{
		if ( separator->getDescription()->getCommonNodes() ==NULL )
		{
			cout <<"Separator is "  << *separator <<"\n";
			throw NullValue ( "UndirectedBN::marginalizeSeparator(JunctionTree* junctionTree2, DirectedSeparatorOfCliques* separator, SetOfCliques::iterator clique, intList* inputPattern)" );
		}
		intSet* commonList=separator->getDescription()->getCommonNodes()->getPrimitiveContainerFromPointerContainer ( commonList );
//if (separatorPotential!=NULL)
//cout <<"\nSEPRATOR IS:" << *separatorPotential;
//cout << *junctionTree2->getNodes()->getElement(clique)->getPotentialList() <<"\n";
		PotentialList* marginalSeparator=junctionTree2->getNodes()->getElement ( clique )->getPotentialList()->marginalize ( commonList );
//cout <<"POT:" << *clique->getPotential();
//cout <<"\nCLIQUEPOT IS:" << *marginalSeparator;
		PotentialList *marginalSeparator2=marginalSeparator->eliminate();
//cout << *separatorPotential <<"\n";

		separator->getDescription()->setPotential ( marginalSeparator2 );
		zap ( marginalSeparator );
		zap ( marginalSeparator2 );
		zap ( commonList );


//if (separator->getPotential()!=NULL)
//cout <<"\nSEPRATOR END IS:" << *separator->getPotential();

	}

	/*____________________________________________________________________________________ */

	void UndirectedBN::finalUpdate ( JunctionTree* junctionTree2, DirectedSeparatorOfCliques* separator, SetOfCliques::iterator cliqueSource, SetOfCliques::iterator cliqueTarget, intList* inputPattern )
	{
try
{
		PotentialList* cliquePotential=junctionTree2->getNodes()->getElement ( cliqueTarget )->getPotentialList(), *new2CliquePotential=NULL, *new3CliquePotential=NULL, *oldSeparatorPotential=NULL;
		if ( separator->getDescription()->getPotential() !=NULL ) // initial potential (equal to 1 for math description)
			oldSeparatorPotential=new PotentialList ( *separator->getDescription()->getPotential() );
		marginalizeSeparator ( junctionTree2, separator, cliqueSource, inputPattern );
		new2CliquePotential=*cliquePotential*separator->getDescription()->getPotential();
		if ( oldSeparatorPotential!=NULL )
			new3CliquePotential=*new2CliquePotential/oldSeparatorPotential;
		else new3CliquePotential=new PotentialList ( *new2CliquePotential );
		zap ( cliquePotential );
		junctionTree2->getNodes()->getElement ( cliqueTarget )->setPotentialList ( new3CliquePotential );
		zap ( new2CliquePotential );
		zap ( new3CliquePotential );
		zap ( oldSeparatorPotential );
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void UndirectedBN::finalUpdate ( JunctionTree* junctionTree2, DirectedSeparatorOfCliques* separator, SetOfCliques::iterator cliqueSource, SetOfCliques::iterator cliqueTarget, intList* inputPattern )" ); throw;};
	}

	/*____________________________________________________________________________________ */

	void UndirectedBN::updateEvidence ( JunctionTree* junctionTree2, SetOfCliques::iterator pointer, bool collect, intList* inputPattern )
	{
try
{
		
		DirectedSeparatorOfCliques* separator;
		for (JunctionTree::iterator p=junctionTree2->begin(); p!=junctionTree2->end(); p++ )
		{
			separator=junctionTree2->getElement ( p );
			if ( separator->getFirst() ==pointer )
			{
				if ( collect )
				{
					updateEvidence ( junctionTree2, separator->getSecond(), true, inputPattern );
					finalUpdate ( junctionTree2, separator, separator->getSecond(), separator->getFirst(), inputPattern );
				}
				else
				{
					finalUpdate ( junctionTree2, separator, separator->getFirst(), separator->getSecond(), inputPattern );
					updateEvidence ( junctionTree2, separator->getSecond(), false, inputPattern );
				}
			}
		}
	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void UndirectedBN::updateEvidence ( JunctionTree* junctionTree2, SetOfCliques::iterator pointer, bool collect, intList* inputPattern )" ); throw;};

}
	/*
	____________________________________________________________________________________ */

	double* UndirectedBN::getPosteriorProb ( int att, intList* inputPattern )
	{
try
{
		JunctionTree* junctionTree2=new JunctionTree ( *junctionTree );
		Node* node=new Node ( att );
		SetOfCliques::iterator it=junctionTree2->nodes->findElementContainingInternalElement ( node );
		if ( it==junctionTree2->nodes->end() )
			throw NullValue ( "double* UndirectedBN::getPosteriorProb(int att, intList* inputPattern)" );
		Clique* clique=*it;
//  cout << "junction tree before infering: " << *junctionTree2 << "\n";
		removeInconsistenciesWithEvidence ( att, inputPattern, junctionTree2 );
//cout << "rootclcique is:" << **junctionTree2->getRoot() << "\n";
		updateEvidence ( junctionTree2, junctionTree2->getRoot(), true, inputPattern ); //collect
		updateEvidence ( junctionTree2, junctionTree2->getRoot(), false, inputPattern );//distribute

//cout << "junction tree after infering: " << *junctionTree2 << "\n";
		if ( junctionTree2->nodes->findElementContainingInternalElement ( node ) ==junctionTree2->nodes->end() )
			throw NullValue ( "UndirectedBN::getPosteriorProb(int att, intList* inputPattern)" );
		intList* l=new intList();
		l->insertElement ( att );
		double *result=NULL;
//cout << "clique:" << * clique << "\n";
		try
		{
			result=clique->getProbs ( l );//, sample->sample->size(), alphaNumerator, alphaDenominator);
		}
		catch ( ZeroValue & zv )
		{
			cout <<"\nError when trying to obtain probs for atts at " << *l << " from potential clique: " << *clique->getPotentialList(); cout << "\ninput pattern is " << *inputPattern; // << " and clique with inconsistencies is " << *junctionTree;//->nodes->getElement(junctionTree->nodes->findFinalElement(node));
			cout <<"\nPlease, try a prior uniform";
			zv.PrintMessage ( "UndirectedBN::getPosteriorProb" );
		};
		zap ( node );
		zap ( l );
		zap ( junctionTree2 );
		return result;
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	double* UndirectedBN::getPosteriorProb ( int att, intList* inputPattern )" ); throw;};

	}
	/*___________________________________________________________ */




}
;  // Fin del Namespace

#endif

/* Fin Fichero: UndirectedBN.cpp */
