/***************************************************************************
 *   Copyright (C) 2007 by M. Mar Abad Grau and Paola Sebastiani				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ComputeMissingImputationAccuracies
#define __ComputeMissingImputationAccuracies_cpp__

#include "ComputeMissingImputationAccuracies.h"//

namespace BIOS
{

  /*_________________________________________________________________________*/

ComputeMissingImputationAccuracies::ComputeMissingImputationAccuracies(int argc, char *argv[])
{
//inputTUI=new InputTUI(argc, argv, "ComputeMissingImputationAccuracies");
char fileSample[256], originalFileSample[256], fileMas[256], originalFileMas[256], missingFile[256], missingFileMas[256];

if (argc!=4)
{
 cerr << "Error: you have to specify the following information:" << endl;
 cerr  << argv[0] << " <originalFile> " << " <completeFile> " << " <missingFile> ";
throw MissingArguments();
end();
}

strcpy(originalFileSample, argv[1]);
strcpy(fileSample, argv[2]);
strcpy(missingFile, argv[3]);
ChangeExtension (fileSample, fileMas, "mas");
ChangeExtension (originalFileSample, originalFileMas, "mas");
ChangeExtension (missingFile, missingFileMas, "mas");
if (!existFile(fileMas))
FileCopy(originalFileMas, fileMas);

floatMLSample* sample=new floatMLSample(fileSample);



floatMLSample *originalSample=new floatMLSample(originalFileSample), *missingSample=new floatMLSample(missingFile); 

floatSample::NodePointer p1, p2, p3;


if ((sample->getSize()!=originalSample->getSize()) ||
(sample->listOfAttributes->GetSize()!=originalSample->listOfAttributes->GetSize()))
{
throw BadFormat();
end();
}

if ((sample->getSize()!=missingSample->getSize()) ||
(sample->listOfAttributes->GetSize()!=missingSample->listOfAttributes->GetSize()))
{
throw BadFormat();
end();
}


floatList *pattern1, *pattern2, *pattern3;
Attribute* attribute;
int val1, val2, val3, total, totalCorrect, totalP, totalCorrectP;
float mean;
ClassificationResults* tasaAciertos, *averages=new ClassificationResults();
tasaAciertos= new ClassificationResults();
 total=0;
 totalCorrect=0;
float freq=0;
try
{
for (int i=0;i<sample->listOfAttributes->GetSize();i++)
{
freq=0;
totalP=0;
totalCorrectP=0;
 //tasaAciertos[i]=new ClassificationResults();
 p1=sample->sample->GetFirst();
 p2=originalSample->sample->GetFirst();
 p3=missingSample->sample->GetFirst();


while (p1!=NULL)
{
pattern1=sample->sample->GetElement(p1);
pattern2=originalSample->sample->GetElement(p2);
pattern3=missingSample->sample->GetElement(p3);
attribute=sample->listOfAttributes->GetElement(i);
//cout << *pattern3 <<"\n";
//cout << *pattern2 <<"\n";
//cout << *pattern1 <<"\n";


val1=(int)pattern1->GetElement(i);
val2=(int)pattern2->GetElement(i);
val3=(int)pattern3->GetElement(i);
if (!attribute->isMissing(val1) && !attribute->isMissing(val2) && attribute->isMissing(val3))
{
if (val2==0)
freq++;
total++;
totalP++;
if (val1==val2) 
{
totalCorrect++;
totalCorrectP++;
}
}
p1=sample->sample->GetNext(p1);
p2=originalSample->sample->GetNext(p2);
p3=missingSample->sample->GetNext(p3);
}
//if (total==0) mean=0;
//else mean=totalCorrect/(float)total;
//tasaAciertos[i]->set.averageAccuracy=mean;
//if (total==0) tasaAciertos[i]->set.sd=0;
//else tasaAciertos[i]->set.sd=getAccuraciesSampleSD(totalCorrect, total);
//cout <<"totalCorre:" << totalCorrect <<", total: " << total;
//cout << "\n" <<  mean  <<" +- " << tasaAciertos[i]->set.sd;
cout <<"\natt: " << i <<"\t total correct:" << totalCorrectP <<"\ttotal:" << totalP << "\tprob: " << totalCorrectP/(float)totalP << "\tfreq A " << freq/totalP;
}
tasaAciertos->set.averageAccuracy=totalCorrect/(float)total;
tasaAciertos->set.sd=getAccuraciesSampleSD(totalCorrect, total);
cout <<"total correct:" << totalCorrect <<", total:" << total;
}
catch (NanValue zv)
{
cout << "There is no any missing value at " << missingFile << " that was known at " << originalFileSample << " and completed with " << fileSample;
zv.PrintMessage("ComputeMissingImputationAccuracies");end();
}

//averages->GetMean(tasaAciertos, sample->listOfAttributes->GetSize());
//cout << "\n Mean accuracies:\n"  << averages->set.averageAccuracy  <<" +- " << averages->set.sd;
//cout << "\n";
cout << tasaAciertos->set.averageAccuracy; 
zap(tasaAciertos);
};

}

using namespace BIOS;

int main(int argc, char *argv[])
{

  ComputeMissingImputationAccuracies *mi;

  mi=new ComputeMissingImputationAccuracies(argc, argv);

};



#endif




