/***************************************************************************
 *   Copyright (C) 2007 by M. Mar Abad Grau and Paola Sebastiani				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ComputeMissingImputationDistances
#define __ComputeMissingImputationDistances_cpp__
#include "ComputeMissingImputationDistances.h"//

namespace BIOS
{

  /*_________________________________________________________________________*/

ComputeMissingImputationDistances::ComputeMissingImputationDistances(int argc, char *argv[])
{
//inputTUI=new InputTUI(argc, argv, "ComputeMissingImputationDistances");
char originalFile[256], completeFile[256], originalFileMas[256], completeFileMas[256];

if (argc!=3)
{
 cerr << "Error: you have to specify the following information:" << endl;
 cerr  << argv[0] << " <originalFile> " << " <completeFile> ";
throw MissingArguments();
end();
}
strcpy(originalFile, argv[1]);
strcpy(completeFile, argv[2]);
ChangeExtension (originalFile, originalFileMas, "mas");
ChangeExtension (completeFile, completeFileMas, "mas");
if (!existFile(completeFileMas))
FileCopy(originalFileMas, completeFileMas);

floatMLSample* originalSample=new floatMLSample(originalFile), *completeSample=new floatMLSample(completeFile); 

if ((completeSample->getSize()!=originalSample->getSize()) ||
(completeSample->listOfAttributes->GetSize()!=originalSample->listOfAttributes->GetSize()))
{
throw BadFormat();
end();
}


float* distances=Initialize(originalSample->listOfAttributes->GetSize(), (float)0);
MIDistances *mIDistances=new MIDistances(originalSample, completeSample);

for (int i=0;i<originalSample->listOfAttributes->GetSize();i++)
{
distances[i] = mIDistances->getEuclideanDistance(i)/sqrt(2);
//cout << "\n" <<  distances[i];
}

cout << GetMean(distances, originalSample->listOfAttributes->GetSize());
zaparr(distances);
zap(mIDistances);
zap(originalSample);
zap(completeSample);
};

}

using namespace BIOS;

int main(int argc, char *argv[])
{

  ComputeMissingImputationDistances *mi;

  mi=new ComputeMissingImputationDistances(argc, argv);

};



#endif




