#ifndef Estimator_h//
#define Estimator_h//

#include "Pattern.h"
#include "ListOfAttributes.h"
#include "../commonc++/Sample.h"

namespace BIOS 
{


////////////////////////////

class Estimator: public floatMLSample
{

private 

EstType estType;
int alpha;





public:



  Estimator():MLSample<T>(EstType estType=MLE) {this->estType=estType;};

    Estimator(EstType estType, Estimator &source, intList *Sampling=NULL):MLSample<T>(source, Sampling){this->estType=estType;};

    Estimator(EstType estType, char* filename, ListOfAttributes *listOfAttributes):MLSample(filename, listOfAttributes){this->estType=estType;};

~Estimator();



//void HardCopy();

int GetTotalInputAttributes();


void HardCopy(char filename[256], ListOfAttributes* listOfAttributes, bool discretized);

void HardCopy(char filename[256], ListOfAttributes* listOfAttributes, bool* seleccionados, bool* integer);

Estimator<T>*  moveColumn(int oldPos, int newPos);

void removeMissingAttribute(Attribute* attribute, int attNumber);


Estimator<int>* Discretize(ListOfAttributes* listOfAttributes);

float GetMutualInformation();

float GetEntropy();  

};//

/*___________________________________________________________________*/

template <class T> Estimator<T>::Estimator(char* filename, ListOfAttributes *listOfAttributes):Sample<T>()
{ 
   //list<stringList*> *l;
   bool atts=true;
   
  // l =  new list<stringList*>(filename);
   
   //
   
   Sample<string>* l=new Sample<string>(filename);
   
 
 
   
   int totalAttributes=listOfAttributes->size();
   //list<list<T> >();
   typename Sample<string>::iterator p=l->getFirst();
 //  cout << l->getElement(p)->size() <<"\n";
 //  cout << l->getElement(p)->Print() << "\n";

   ListOfAttributes::iterator pA;
   list<T> *pattern;
   stringList *patternL;
   stringList::iterator pL;
   string name;
//   cout <<"size" << l->size();

   try
   {
   while (p!=NULL)
   {
   patternL=l->GetPointerToElement(p);
   //cout <<patternL->Print() <<"x\n";
 //  exit(0);
   if (totalAttributes!=(patternL->size()-listOfAttributes->itHasID())) 
   throw BadSize();

   pL=patternL->getFirst();
   pA=listOfAttributes->getFirst();
   pattern=new list<T>();
     
   if (pA!=NULL)
   if (listOfAttributes->itHasID()==true)
   pL=patternL->getNext(pL);
   
   
   while (pA!=NULL && pL!=NULL)
   {
  
   if (listOfAttributes->GetPointerToElement(pA)->IsContinuous())
   pattern->insertElement((T)atof(pL->element.c_str()));
   else 
   {
    name=patternL->getElement(pL);
    pattern->insertElement(listOfAttributes->GetPointerToElement(pA)->GetPosition(name));
    }
   
   pA=listOfAttributes->getNext(pA);
   pL=patternL->getNext(pL);
   }
 
   insertElement(pattern);
   
   p=l->getNext(p);
   }
   }
  catch (BadSize bs) {bs.PrintMessage("Estimator::Estimator", totalAttributes, patternL->size()); };
//  cout <<"jj";
//  exit(0);
//exit(0);
};

/*___________________________________________________________________*/

template <class T> Estimator<T>::~Estimator() { 
//~list<T>();
};
/*___________________________________________________________________*/
/*
template <class T> template <class U> void Estimator<T>::CheckRange(list<U>) 
{ 
};
/*___________________________________________________________________________________*/

 template <class T>  char* Estimator<T>::print(ListOfAttributes* listOfAttributes, bool* seleccionados, bool* integer)
  {
//  exit(0);
zaparr(this->line);
      this->line=new char[this->Size*this->GetPointerToElement((int)0)->size()*20];
  //  char* l=&sline[0];
    strcpy(this->line, "\0");
 //  ofstream  OutputFile;
    //OpenOutput(filename, &OutputFile);
    list<T> *pattern;
    typename Sample<T>::iterator p=this->getFirst();
     int totalAttributes=listOfAttributes->GetTotalAttributes();
     bool missing[totalAttributes];
   
    while (p!=NULL)
    {
      pattern=GetPointerToElement(p);
      for (int i=0;i<totalAttributes;i++)
       if (pattern->getElement(i)==listOfAttributes->GetPointerToElement(i)->GetTotalModalidades())
        missing[i]=true;
	else missing[i]=false;
     // cout << pattern->print() <<"\n";
      strcat(this->line, pattern->print(seleccionados, integer, missing));
      strcat(this->line, "\n");
      p=getNext(p);
    }
    
   // OutputFile.close();
return this->line;
  }
   /*___________________________________________________________________________________*/

 template <class T>  void Estimator<T>::removeMissingAttribute(Attribute* attribute, int attNumber)
  {
//  exit(0);
//if (clas==NULL) clase=this->GetPointerToElement((int)0)->size()-1;
     list<T> *pattern;
    typename Sample<T>::iterator p=this->getFirst(), p2;
    
    while (p!=NULL)
    {
      pattern=GetPointerToElement(p);
  //    cout << pattern->getElement(attNumber) <<" ";
      if (attribute->isMissing(pattern->getElement(attNumber)))
      {
      p2=getNext(p);
    this->RemoveElement(p);
    p=p2;
    }
      else
      p=getNext(p);
    }
    
      }
  /*___________________________________________________________________________________*/

 template <class T>  void Estimator<T>::HardCopy(char filename[256], ListOfAttributes* listOfAttributes, bool* seleccionados, bool* integer)
  {
//  exit(0);
     ofstream  OutputFile;
    OpenOutput(filename, &OutputFile);
    //  exit(0);
    list<T> *pattern;
    typename Sample<T>::iterator p=this->getFirst();
     int totalAttributes=listOfAttributes->GetTotalAttributes();
     bool missing[totalAttributes];
   
    while (p!=NULL)
    {
      pattern=GetPointerToElement(p);
      for (int i=0;i<totalAttributes;i++)
       if (listOfAttributes->GetPointerToElement(i)->isMissing(pattern->getElement(i)))
        missing[i]=true;
	else missing[i]=false;
     // cout << pattern->print() <<"\n";
      OutputFile <<  pattern->print(seleccionados, integer, missing);
     OutputFile <<  "\n";
      p=getNext(p);
    }
    
    OutputFile.close();
  }

/*___________________________________________________________________________________*/

 template <class T>  void Estimator<T>::HardCopy(char filename[256], ListOfAttributes* listOfAttributes, bool discretized)
  {



bool * selected=listOfAttributes->getSelected();
//bool *integer; //=listOfAttributes->getDiscrete();

if (listOfAttributes->isDiscretized() && discretized)
{
Estimator<int>* sample2;
 sample2=this->Discretize(listOfAttributes);
sample2->HardCopy(filename, listOfAttributes, selected, NULL);
delete sample2;
}
else
{
bool* integer =listOfAttributes->getDiscrete();
//cout << listOfAttributes->print();
HardCopy(filename, listOfAttributes, selected, integer);
zap(integer);
}
zap(selected);
  }
  /*___________________________________________________________________________________*/

 template <class T>  Estimator<T>*  Estimator<T>::moveColumn(int oldPos, int newPos)
  {
Estimator<T>* sample2=new Estimator();
typename Estimator<T>::iterator p=this->getFirst();
list<T>* pattern, *sourcePattern;
typename list<T>::iterator pp;

 while (p!=NULL)
{
//cout <<"\n\n";
sourcePattern=this->GetPointerToElement(p);
pp=sourcePattern->getFirst();
pattern=new list<T>(*sourcePattern);
pattern->moveElement(oldPos, newPos);
// cout << sourcePattern->print(NULL, NULL, NULL);
// cout <<"\nversus:\n" ;
//  cout << pattern->print(NULL, NULL, NULL);
sample2->insertElement(pattern);
p=this->getNext(p);
}


return sample2;
  }
/*___________________________________________________________________________________*/

 template <>  Estimator<int>* Estimator<float>::Discretize(ListOfAttributes* listOfAttributes)
  {
    Estimator<int>* discreteEstimator;
    discreteEstimator=new Estimator<int>();
    Estimator<float>::iterator p=this->getFirst();
    ListOfAttributes::iterator pA=listOfAttributes->getFirst();
    floatList::iterator pp;
    intList* pattern;
    floatList *sourcePattern;

while (p!=NULL)
{
sourcePattern=this->GetPointerToElement(p);
pp=sourcePattern->getFirst();
pattern=new intList();
 while(pA!=NULL)
    {
    if (!listOfAttributes->GetPointerToElement(pA)->IsContinuous())
      pattern->insertElement((int)sourcePattern->getElement(pp));
  pattern->insertElement(listOfAttributes->GetPointerToElement(pA)->GetValue(sourcePattern->getElement(pp)));
    pA=listOfAttributes->getNext(pA);
    pp=sourcePattern->getNext(pp);
}
discreteEstimator->insertElement(pattern);
p=this->getNext(p);
}


    return discreteEstimator;
 
  }

  
} // end namespace
#endif
