#ifndef SampleTest_h//
#define SampleTest_h//

#include "../commonc++/list.h"//
#include "../commonc++/basic.h"//
#include "../commonc++/ChangeColumns.h"//
#include <math.h>
#include "KNN.h"//
#include "C45.h"//
#include "NB.h"//
#include "TAN.h"//
#include "discretizacion.h"//
#include "SampleTest.h"//
#include "Selection.h"//
#include "Selection.h"

namespace BIOS {

// Input variables: filename with the sample, discMode, testMethod, numberofFolds, algType, parameters
// It returns Pair<double> with the accuracy and sd.


/*____________________________________________________________________*/

Pair<double> GetAccuracy(char filename[128], DiscMode & discMode, TestMethod & testMethod, unsigned int & 				 numberOfFolds, AlgType & algType, intList * parameters)
{
SampleTest<KNN<int>, int> *testKNN;
SampleTest<C45<int>, int> *testC45;
SampleTest<NB<int>,  int> *testNB;
SampleTest<TAN<int>, int> *testTAN;

list<intList > *sample;
unsigned int dependiente;
Pair<double> acc;
char texto2[128], textoa[128], texto3[128], texto[128], text[128], filename2[128];

ChangeExtension(filename, texto2, "mas");
list<Attribute*> listOfAttributes(texto2);
Attribute *clase, *clase2;

int TotalRows=GetTotalLines(filename);
ChangeColumns * Cols;
list<Attribute*>::iterator pA=listOfAttributes.getFirst();
Attribute attribute;
unsigned int cm=0;
float *tasaAciertos; 
bool *seleccionados=NULL;
unsigned int totalselected;
list<unsigned int> *listSelected;
dependiente=listOfAttributes.size()-1;

switch (algorithm)
{
case aNB:
case aNBB:
testNB=new SampleTest<NB<int>, int>(texto, dependiente, testMethod, numberOfFolds, parameters);
break;
case aTAN:
case aTANB:
testTAN=new SampleTest<TAN<int>, int>(texto, dependiente, testMethod, numberOfFolds, parameters);
break;
//case GTAN:
//case GTANB:
//testGTAN=new SampleTest<GTAN<int>, int>(texto, dependiente, testMethod, numberOfFolds, parameters);
//break;
//case FUNC:
//DirectDependency* classifier;
//test=new SampleTest<DirectDependency>(texto, dependiente, testMethod, numberOfFolds, parameters);
//break;
case aC4_5:
//C45* classifier;
    testC45=new SampleTest<C45<int>, int>(texto, dependiente, testMethod, numberOfFolds, parameters);
    acc=testC45->GetAveragedAccuracy();
delete testC45;

break;
// case BT:
//  test=new SampleTest<M1nn>(texto, dependiente, testMethod, numberOfFolds, parameters);
// break;
case aNN:   
	testKNN=new SampleTest<KNN<int>, int>(texto, dependiente, testMethod, numberOfFolds, parameters);
	acc=testKNN->GetAveragedAccuracy();
	delete testKNN;
break;  
}



tasaAciertos=acc.First;
cout  << acc.First;

unlink(texto);
unlink(texto2);
unlink(texto3);
} // end if cm!=total_muestras
pA=listOfAttributes.getNext(pA);
cm++;
};// fin for each muestra

//InputFile.close();
cout <<"\n\nTotal prueba medio: " << GetMean(tasaAciertos, totalmuestras)  <<"+-" <<GetSampleSD(tasaAciertos, totalmuestras);
cout <<"\n";

 }






