/* File: AcyclicGraph.h */


#ifndef __AcyclicGraph_h__
#define __AcyclicGraph_h__







//using namespace UT, U>ILS;


namespace BIOS
{


	/************************/
	/* AcyclicGraph DEFINIT, U>ION */
	/************************/


	/**
	        @memo AcyclicGraph


	  	@doc 	An AcyclicGraph is a Graph with no cycles.


	IT, U> has a subclass:  UnchordGraph: those AcyclicGraphs that after changing directed arcs for undireted arcs. it still remains acyclic


	 Some known topologies are defined usingtypedef:
	 DAG: an AcyclicGraph with only DirectedArc-s
	 Utree: an AcyclicGraph with only UndirectedArc-s


		@doc

	    @author Maria Mar Abad Grau
		@version 1.0


	*/


	template <template<class T, class U> class Link, class T, class U>   class SingleAncestorGraph;

	template <template<class T, class U> class Link, class T, class U=int>


	class AcyclicGraph: public Graph<Link, T, U>
	{

			typedef  typename Set<T>::Class::iterator PNode;

		public:

			AcyclicGraph() :Graph<Link, T, U>() {};
			AcyclicGraph ( AcyclicGraph<Link, T, U>& uG ) :Graph<Link, T, U> ( uG ) {};
			virtual ~AcyclicGraph() {};
			template <template<class V, class W> class ULink, class V, class W>
			AcyclicGraph<ULink, T, U>* getUGraph();// it will only be defined for Link=DirectedArc, i.e. for DAG
			AcyclicGraph<UndirectedArc, T, U>* getMoralGraph();// it will only be defined for Link=DirectedArc, i.e. for DAG
   virtual void paste(AcyclicGraph<Link, T, U>* target)
{
throw NonImplemented("virtual void paste(AcyclicGraph<Link, T, U>* target)");
}



	//		template <template<class V, class W> class DLink, class V, class W>
//			SingleAncestorGraph<DLink, T, U>* getDirectedTree ( PNode root );

			// Graph<Link, T, U>* getDirectedTree(T& root);


			void checkArc ( Link<T, U>* arc )
			{
				try
				{
					this->Graph<Link, T, U>::checkArc ( arc );

					if ( this->formALoop ( arc ) ==true )

					{
						cout <<"Error in Graph::insertElement, arc for nodes " << *arc->getFirst()  << " and " << *arc->getSecond() << " will form a cycle in an Acyclic Graph";
						cout << *this;
						exit ( 0 );
					};
				}
 catch (BasicException & os) {
		 os.addMessage("\ncalled from void AcyclicGraph::checkArc ( Link<T, U>* arc )"); throw;}



			};






	};  // End of class AcyclicGraph



	/*_______________________________________________________________*/
	/*
	template <class T, class U> template<class V> UGraph<V,U>* DAG<T,U>::Class::getMoralGraph(V* type)
	{
	 UGraph<V,U> *moralGraph =this->getUGraph(type);
	 typename Set<U>::iterator p=this->nodes->getFirst();
	  Set<U>* nodeParents=NULL;
	    while (p!=NULL)
	  {
	     nodeParents = this->getParents(p);
	//cout <<"\nparents for node" << this->nodes->getElement(p)->print() <<" are :" << nodeParents->print();
	    moralGraph->complete(nodeParents);
	    zap(nodeParents);
	    p=this->nodes->getNext(p);
	  }
	 // cout <<moralGraph->print();
	//  end();
	      return moralGraph;

	}

	/*_______________________________________________________________*/


};  // Fin del Namespace

#endif

/* Fin Fichero: AcyclicGraph.h */
