/* File: CompleteGraph.cpp */


#ifndef __CompleteGraph_cpp__
#define __CompleteGraph_cpp__

//using namespace UTILS;

namespace BIOS
{
  /************************/
  /* CompleteGraph DEFINITION */
  /************************/
  /**
          @memo CompleteGraph 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */

template <template<class T, class U> class Link, class T, class U> CompleteGraph<Link, T, U>::CompleteGraph():Graph<Link, T, U>(){};

template <template<class T, class U> class Link, class T, class U> CompleteGraph<Link, T, U>::~CompleteGraph(){};


template <template<class T, class U> class Link, class T, class U> void CompleteGraph<Link, T, U>::insertElement(Link<T, U>* arc)
  {

    cout <<"Error, arc insertion is not allowed in CompleteGraph::insertElement";
    end();
  }

template <template<class T, class U> class Link, class T, class U> CompleteGraph<Link, T, U>* CompleteGraph<Link, T, U>::clone()
{
return new CompleteGraph<Link, T, U>(*this);
};
  
  /*_________________________________________________________________*/

template <template<class T, class U> class Link, class T, class U> void CompleteGraph<Link, T, U>::insertNode(T node, floatList* weightList, Container<vector<T>,T> *nodeList)
  {
if (this->nodes==NULL) this->nodes=new typename Set<T>::Class::Container();
    if (this->existNode(node))
    {
      cout <<"Error, node already exists in CompleteGraph::insertNode";
      end();
    }
        if (weightList->size()!=this->nodes->size())
    {
      cout <<"error in CompleteGraph::insertNode, there are " << weightList->size() << " weights and " << this->nodes->size() << " nodes";
      end();
    }
    this->nodes->insertElement(node);
    typename Set<T>::Class::iterator p2=this->nodes->findEqualElement(node), p;
    if (p2==this->nodes->end()) throw NullValue("void CompleteGraph<Link, T, U>::insertNode(T node, floatList* weightList)");
    Link<T, U>* arc=NULL;

    if (this->nodes->size()==0) return;

    for (int pos=0; pos<weightList->size(); pos++)
    {
    p=this->nodes->findEqualElement(nodeList->getElement(pos));
    if (p!=p2)
    {
      arc=new Link<T, U>(weightList->getElement(pos), p, p2);
      if (this->existArc(arc)!=this->end())
      {
        cout <<"Error, arc " << *arc << " already exists in CompleteGraph::insertNode:";
        cout << *this;
        end();
      };
    //  UGraph<T,U>::Class::insertElement(arc);
      Graph<Link, T, U>::insertElement(arc);
    }
  };
};
  
  //     template<class T, class U> void CompleteGraph<T,U>::insertNode(U* node, floatList* weightList, ListOfPointers<intList >* separationLists);

/*_________________________________________________________________*/

template <template<class T, class U> class Link, class T, class U> typename UTree<T, U>::Class* CompleteGraph<Link, T, U>::getMWST()
  {
throw NonImplemented("template <template<class T, class U> class Link, class T, class U> typename Tree<T, U>::Class* CompleteGraph<Link, T, U>::getMWST()"); // it only has sense for graphs with only undirected arcs
 };
  /*_________________________________________________________________*/
/*
template <template<class T, class U> class Link, class T, class U> typename Tree<T, U>::Class* CompleteGraph<Link, T, U>::getMWST()
  {
    //Kruskal algorithm
// 1) create a forest "forest" (a set of trees), where each vertex in the graph is a separate tree
 typename Vector<typename Tree<T, U>::Class*>::Class::iterator tree1P, tree2P;
 typename Vector<typename Tree<T, U>::Class*>::Class *forest=new typename Vector<typename Tree<T, U>::Class*>::Class::Container();
 typename Vector<typename Set<T>::Class*>::Class *forestListOfSetOfNodes=new  typename Vector<typename Set<T>::Class*>::Class::Container();
 typename Tree<T, U>::Class* tree=NULL;
 typename Vector<typename Set<T>::Class*>::Class::iterator nodeList1, nodeList2;
 T node=NULL;
 PNode pNode;
 for (typename Set<T>::Class::const_iterator it=this->nodes->begin(); it!=this->nodes->end(); it++)
{
node=this->nodes->getElement(it)->clone();
tree=new typename Tree<T, U>::Class::SingleAncestorGraph(node);
forest->insertElement(tree);
forestListOfSetOfNodes->insertElement(tree->nodes);
}
// 2) create a set "s" containing all the edges in the graph
 CompleteGraph<Link, T, U>* s=this->clone();
 s->sort(false);
// 3) while s is nonempty and forest is not yet spanning: a) remove an edge with minimum weight from s b) if that edge connects two different trees in the forest, then add it to the forest, combining two trees into a single tree, otherwise discard that edge.
Link<T,U>* arc=NULL;
while (forest->size()>1)
{
 arc=s->pop();
 nodeList1=forestListOfSetOfNodes->findElementContainingInternalElement(*arc->getFirst());
 nodeList2=forestListOfSetOfNodes->findElementContainingInternalElement(*arc->getSecond());
 tree1P=forest->getNode(forestListOfSetOfNodes->getPosition(nodeList1));
 tree2P=forest->getNode(forestListOfSetOfNodes->getPosition(nodeList2));
 pNode=forest->getElement(tree1P)->nodes->findElement(*arc->getFirst());
 if (tree1P!=tree2P) 
{
forest->getElement(tree2P)->setRoot(forest->getElement(tree2P)->nodes->findElement(*arc->getSecond()));
forest->getElement(tree1P)->addChild(pNode, arc->getWeight(), *tree2P);
forestListOfSetOfNodes->erase(nodeList2);
forest->erase(tree2P);
}
 zap(arc); 
}
typename Tree<T, U>::Class *result=forest->getFirstElement()->clone();
zap(s);
zap(forest);
return result;
 };
  /*______________________________________________________________________________________*/
/*
  template<> CompleteGraph<Separator, Clique>::CompleteGraph(Set<Clique>* cliques):UGraph<Separator, Clique>()
  {
    floatList* weightList=NULL;
    Set<Clique>::iterator p1=NULL, p2=NULL;
    Set<Node>* commonNodes=NULL;
    ListOfPointers<Set<Node> >* listOfCommonNodes=NULL;
     CompleteGraph<Separator, Clique> *ug2=new CompleteGraph<Separator, Clique>(); 
     ug2->nodes=new Set<Clique>();
    for (int j=0; j<cliques->size(); j++)
    {
      p1=cliques->GetNode(j);
       if (p1==NULL || cliques->getElement(p1)==NULL)
	 {
	 cout <<"EEE";
	 end();
	 }
      cout <<"\nvals:" << cliques->getElement(p1)->print();
      weightList=new floatList();
      listOfCommonNodes=new ListOfPointers<Set<Node> >();
      
      for (int k=0; k<j; k++)
      {
        p2=cliques->GetNode(k);
	cliques->getElement(p2)->print(); 
       	//commonNodes=cliques->getElement(p1)->getCommonNodes(cliques->getElement(p2));
	 cout <<" - int:" << cliques->getElement(p1)->print();
    
	
	commonNodes=new Set<Node>(*cliques->getElement(p1));
	weightList->insertElement(commonNodes->size());
        listOfCommonNodes->insertElement(commonNodes);
	//cout <<"common nodes" << commonNodes->print() <<" has been inserted in list:\n " << listOfCommonNodes->print();
	//zap(commonNodes);
	//listOfCommonNodes->insertElement(new Set<Node>());
      }
   //   cout <<"common nodes:" << listOfCommonNodes->print();
      //cout <<"af";
        ug2->insertNode(cliques->getElement(p1), weightList, listOfCommonNodes);
	
        cout << ug2->print()<<"\n";
    
    //  zap(listOfCommonNodes);
      zap(weightList);
      }
      end();
      if (*cliques!=*ug2->nodes)
      {
      cout <<"Error in CompleteGraph(Set<Clique>* cliques), cliques are\n" << cliques->print() << " while nodes are \n" << ug2->nodes->print();
      end();
      }
      cout << ug2->print()<<"\n";
      //cout<<"LLL";
       end();

      this->nodes=cliques;
      this->UGraph<Separator, Clique>::copyArcs(ug2);
      zap(ug2->nodes);
      zap(ug2);
      cout <<this->print();
      end();

    }
 /*______________________________________________________________________________________*/

 //template <template<class T, class U> class Link, class T, class U>
template<>   
CompleteDGOfCliques::CompleteGraph(SetOfCliques* cliques):DirectedGraphOfCliques()
  {
  this->nodes=cliques;
  NodeSet* commonNodes=NULL;
  DirectedSeparatorOfCliques *s;
  SetOfCliques::iterator p1, p2;
  Clique *c1, *c2;
  SeparatorContent* separatorContent;
  for (int i=1;i<cliques->size();i++)
  {
   p1=this->nodes->getNode(i);
   c1=this->nodes->getElement(i);
   for (int j=0;j<i;j++)
   {
   p2=this->nodes->getNode(j);
   c2=this->nodes->getElement(j);
   commonNodes=c1->getCommonNodes(c2);
   separatorContent=new SeparatorContent(NULL, commonNodes);
   s=new DirectedSeparatorOfCliques(commonNodes->size(), p1, p2, separatorContent);
   this->Graph<DirectedArc, Clique*, SeparatorContent>::insertElement(s);
   }
 }
  }
};  // Fin del Namespace

#endif

/* Fin Fichero: CompleteGraph.h */
