/* File: Graph.h */


#ifndef __Graph_cpp__
#define __Graph_cpp__







//using namespace UTILS;


namespace BIOS
{


	/************************/
	/* Graph DEFINITION */
	/************************/




	/*______________________________________________________________________________________*/


//template <template<class T, class U> class Link, class T, class U=int>

	template <template<class T, class U> class Link, class T, class U>
	Graph<Link, T, U>::Graph() : Container<vector<Link<T,U>*>,Link<T,U>* >() //Set<Link<T, U>*>::Class()
	{
//  struct Container<set<Link<T,U>*>,Link<T,U> >* a=new Container<set<Link<T,U>*>,Link<T,U> >();
		nodes=NULL;//new Set<U>();g
	}
	/*______________________________________________________________________________________*/


//template <template<class T, class U> class Link, class T, class U=int>

	template <template<class T, class U> class Link, class T, class U>
	Graph<Link, T, U>::Graph ( T &node ) : Container<set<Link<T,U>*>,Link<T,U>* >() //Set<Link<T, U>*>::Class()
	{
		throw NonImplemented ( "  template <template<class T, class U> class Link, class T, class U> Graph<Link, T, U>::Graph(T & node): Container<set<Link<T,U>*>,Link<T,U>* >()" );
	}
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> Graph<Link, T, U>::Graph ( Graph & source ) : Container<vector<Link<T,U>*>,Link<T,U>* > ( source )
	{
  this->nodes=new  Container<set<T>, T >();
  for (typename Container<set<T>, T >::iterator itN=source.nodes->begin(); itN!=source.nodes->end(); itN++)
   this->nodes->insertElement(*itN);
  replaceNodesInArcs();
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::replaceNodesInArcs () 
	{
  Link<T,U>* arc;
  PNode nodeF, nodeS, nodeFH, nodeSH;
		for ( typename Graph<Link, T, U>::iterator it=this->begin(); it!=this->end(); it++ )
		{
   arc= this->getElement ( it );
   nodeF=arc->getFirst();nodeS=arc->getSecond();
   nodeFH=nodes->findEqualElement ( *nodeF ); nodeSH=nodes->findEqualElement ( *nodeS );
//cout << "firstnode:" << **nodeF << ",while second is: " << **nodeS << "\n";
//cout << "list of current nodes is: " << *nodes << "\n";

//  if (nodeFH ==nodes->end()) cout << "node " << **nodeF << "not found in " << *nodes << "\n"; 
//  if (nodeSH ==nodes->end()) cout << "node " << **nodeS << "not found in " << *nodes << "\n"; 

   if (nodeFH ==nodes->end() || nodeSH==nodes->end())
				throw NullValue ( "Graph<Link, T, U>::Graph(Graph &source)" );
			arc->setFirst ( nodeFH );	arc->setSecond (nodeSH );
		}
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::paste ( Graph<Link, T, U> * source )
	{
		try
		{
			nodes->paste ( source->nodes );
			Container<vector<Link<T,U>*>,Link<T,U>* >::paste ( source );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::paste(Graph<Link, T, U> * source)" ); throw;};
	};

	/*______________________________________________________*/

	//   template <template<class T, class U> class Link, class T, class U> ostream& operator<<(ostream& out, Graph<Link,T, U>& p)

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::print ( ostream& out )
	{
		out << "\nARCS:";
		for ( typename Graph<Link,T,U>::iterator it=this->begin(); it!=this->end(); it++ )
			out << *this->getElement ( it );

		if ( this->nodes==NULL ) cout << "There are 0 nodes in this graph\n";
		else
		{
			cout << "\nNODES:";
			out << *this->nodes <<"\n";
		}
	}
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> Graph<Link, T, U>::~Graph()
	{
		//zap(nodes);

	}

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> typename Graph<Link,T, U>::iterator
	Graph<Link, T, U>::getFirst()
	{
		return Vector<Link<T, U>* >::Class::getFirst();
	}

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> typename Set<T>::Class*
	Graph<Link, T, U>::getNodes()
	{
		return nodes;
	}
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void
	Graph<Link, T, U>::setNodes ( typename Set<T>::Class* nodes )
	{
		this->nodes=nodes;
	}
	/*______________________________________________________________________________________*/
	/*
	  template <template<class T, class U> class Link, class T, class U> T Graph<Link, T, U>::getFirst(Link<T, U>* arc)
	  {
	  if (arc->getFirst()==NULL || nodes->getElement(arc->getFirst())==NULL)
	  {
	  cout <<"error in getFirst()";
	  if (arc==NULL) cout <<"arc is null";
	  else if (arc->getFirst()==NULL) cout <<"arc->getFirst() is null";
	  else cout << "nodes->getElement(arc->getFirst()) is null";
	  throw NullValue();
	  end();
	  }
	    return nodes->getElement(arc->getFirst());
	  }
	  /*______________________________________________________________________________________*/
	/*
	  template <template<class T, class U> class Link, class T, class U> T Graph<Link, T, U>::getSecond(Link<T, U>* arc)
	  {

	  if (arc->getSecond()==NULL || nodes->getElement(arc->getSecond())==NULL)
	  {
	  cout <<"error in getSecond()";
	  if (arc==NULL) cout <<"arc is null";
	  else if (arc->getSecond()==NULL) cout <<"arc->getSecond() is null";
	  else cout << "nodes->getElement(arc->getSecond()) is null";
	 throw NullValue();

	  end();
	  }
	    return nodes->getElement(arc->getSecond());
	  }
	  /*______________________________________________________________________________________*/

	/*
	  template <class T, class U> string Graph<T,U>::print(bool forward)
	  {
	    char *line;
	    int totalNodes=nodes->size();
	    int totalArcs=this->size();
	    line = new char[totalNodes*10+totalArcs*50];
	    strcpy(line, "\nNodes:\n");
	    strcat(line, this->nodes->print().c_str());
	    strcat(line, "\nArcs:\n");
	    typename Set<T>::iterator p=this->getFirst();
	    T* arc;
	    while (p!=NULL)
	    {
	      arc=this->getElement(p);
	      sprintf(line, "%s(%s - %s): %s\n", line, this->getFirst(arc)->print().c_str(), this->getSecond(arc)->print().c_str(), arc->print().c_str());
	      p=this->getNext(p);
	    };
	    string  result = string(line);
	    zaparr(line);
	    return result;
	  };
	   /*______________________________________________________________________________________*/

	/*
	  template <> string Graph<Separator, Clique>::print(bool forward)
	  {

	    char *line;
	    int totalNodes=nodes->size();
	    int totalArcs=this->size();
	    line = new char[maxline];
	    strcpy(line, "\nNodes:\n");
	    Set<Clique>::iterator pN=this->nodes->getFirst();
	    while (pN!=NULL)
	    {
	    sprintf(line, "%s,%s\n", line, this->nodes->getElement(pN)->print().c_str());
	    pN=this->nodes->getNext(pN);
	    }
	    strcat(line, "\nArcs:\n");
	    Set<Separator, ListOfPointers>::iterator p=this->getFirst();
	    Separator* arc;
	    while (p!=NULL)
	    {
	      arc=this->getElement(p);
	      sprintf(line, "%s\n(%s - %s): %s", line, this->getFirst(arc)->print().c_str(), this->getSecond(arc)->print().c_str(), arc->print().c_str());
	  //    sprintf(line, "%s%s\0", line, arc->Arc<Clique>::print().c_str());

	      p=this->getNext(p);
	    };
	    string  result = string(line);
	    zaparr(line);
	    return result;
	  };
	  /*______________________________________________________________________________________*/

	/*
	  template <class T, class U> string Graph<T,U>::print(T*arc)
	  {
	  return arc->print(this->getFirst(arc)->print().c_str(), this->getSecond(arc)->print().c_str());
	  }
	  /*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> bool Graph<Link, T, U>::existNode ( T  node )
	{
		if ( this->nodes==NULL ) return false;
		return this->nodes->findEqualElement ( node ) !=this->nodes->end();
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::removeGraphNode ( PNode node )
	{

		this->removeNodeLinks ( node, 0 );
		if ( node!=this->nodes->end() )
			this->nodes->Set<T>::Class::removeNode ( node );
		else
		{
			cout <<"Error in Graph<T, U>::removeGraphNode, null value";
			end();
		}
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::removeArc ( Link<T, U>* arc )
	{
		typename Set<T>::Class::iterator p=this->getFirst();
		while ( p!=NULL )
		{
			if ( *this->getElement ( p ) ==arc )
			{
				this->Set<T>::Class::removeNode ( p );
				return;
			}
			p=this->nodes->getNext ( p );
		};
	};

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::insertElement ( Link<T, U>* arc )
	{
		try
		{
			this->checkArc ( arc );
			this->Vector<Link<T, U>*>::Class::insertElement ( arc );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Graph<Link, T, U>::insertElement(Link<T, U>* arc)" );};

	}
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::checkArc ( Link<T, U>* arc )
	{
		try
		{
//if (arc==NULL) throw NullValue();
			if ( this->existArc ( arc, true ) !=this->end() )

			{
				cout <<"Error in Graph::insertElement, arc for nodes " << *arc->getFirst()  << " and " << *arc->getSecond() << " already exist in Graph";
				cout << *this;
				exit ( 0 );
			};
			if ( arc->getFirst() ==arc->getSecond() )

			{
				cout <<"Error in Graph::insertElement, arc for nodes " << *arc->getFirst()  << " and " << *arc->getSecond() <<" is not allowed";
				end();
			};
			//   cout <<"\nAAA" << arc->print() <<"\n";
			if ( !this->existNode ( this->nodes->getElement ( arc->getFirst() ) ) || !this->existNode ( this->nodes->getElement ( arc->getSecond() ) ) )
			{
				//cout <<"Err";
				cout <<"Error in Graph::insertElement, node " <<* arc->getFirst() << " or node " << *arc->getSecond() <<" does not exist";
				end();

			}
}
	 catch (BasicException & os) {
		 os.addMessage("\ncalled from void  Graph::insertElement"); throw;}



	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> bool Graph<Link, T, U>::existSecondNode ( Link<T, U>* arc )
	{
		return this->existNode ( arc->getSecond() );
	};


	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> bool Graph<Link, T, U>::formALoop ( Link<T, U>* arc )
	{
		return this->existPath ( arc->getSecond(), arc->getFirst(), false );
	}


	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> bool Graph<Link, T, U>::formAChord ( Link<T, U>* arc )
	{
		return this->existPath ( arc->getFirst(), arc->getSecond(), true );
	}

	/*__________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> bool Graph<Link, T, U>::existPath ( PNode first, PNode second, bool anyway )
	{
		// complexity of this algorithm can be decreased by removing those arcs from the graph once explored

		Graph * auxGraph=this->clone();

		Link<T,U>* sourceArc=new Link<T,U> ( 0, first, second );
		PArc r=auxGraph->existArc ( sourceArc, anyway );
		delete sourceArc;
		if ( r!=auxGraph->end() ) return true;

		Link<T,U>* arc;
		typename Set<T>::Class::iterator partner;
		PArc p=auxGraph->getFirst(), p2, newP;
		bool exist=false;
		while ( p!=auxGraph->end() && !exist )
		{
			arc=auxGraph->getElement ( p );
			if ( arc->getFirst() ==first )
			{
				partner=arc->getSecond();
				p2=p--;
				auxGraph->removeNode ( p );
				p=p2;
				if ( auxGraph->size() ==0 ) p=auxGraph->end();
				if ( auxGraph->existPath ( partner, second, anyway ) )
				{
					zap ( auxGraph );
					exist=true;
				}
				else p=auxGraph->getNext ( p );
			}
			zap ( auxGraph );
			return exist;
		}
	}
	/*__________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::copyArcs ( Graph<Link, T, U>* target )
	{
//It copies arcs from the target graph to the current graph
// Only for objects, not intended for primitive types


		typename Vector<Link<T, U>* >::Class::iterator p=target->getFirst();
		Link<T,U>* arc;
		Link<T,U>* arc2;
		typename Set<T>::Class::iterator p1, p2;
		while ( p!=target->end() )
		{
			arc=target->getElement ( p );
			p1=arc->getFirst();
			p2=arc->getSecond();
			if ( p1==this->nodes->end() || p2==this->nodes->end() )
			{
				cout <<"Error in Graph<T, U>::copyArcs";
				end();
			}
			arc2=new Link<T,U> ( *arc );
			this->insertElement ( arc2 );
			//zap(arc2);
			p=target->getNext ( p );
		}
	}
	/*__________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> typename Graph<Link,T, U>::iterator Graph<Link, T, U>::existArc ( Link<T, U>* arc, bool anyway )
	{
//cout <<"here";
		typename Graph<Link, T, U>::iterator p=this->getFirst();
		Link<T, U>* arc2;
		while ( p!=this->end() )
		{
			arc2=this->getElement ( p );
			if ( arc2->hasSameNodes ( arc, anyway ) ) return p;
			p=this->getNext ( p );
		}
		return this->end();
	}
	/*__________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> typename Graph<Link,T, U>::iterator Graph<Link, T, U>::existArc ( PNode a, PNode b, bool anyway )
	{
//cout <<"here";
		PArc result=this->end();
		typename Graph<Link, T, U>::iterator p=this->getFirst();
		Link<T, U>* arc2, *arc=new Link<T,U> ( 0,a,b );
		result=existArc ( arc, anyway );
		zap ( arc );
		return result;
	}
	/*__________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::complete ( typename Set<T>::Class* nodeSet )
	{
// it adds arcs for the nodes in the argument to be fully connected
		PNode p1, p2;
		T *arc;
		for ( int j=0 ; j<nodeSet->size()-1 ; j++ )
		{
			p1=this->nodes->findElement ( nodeSet->getElement ( j ) );
			if ( p1==this->nodes->end() )
			{
				cout <<"Error in Graph::complete, null value";
				end();
			}
			for ( int k=j+1; k<nodeSet->size(); k++ )
			{
				p2=this->nodes->findElement ( nodeSet->getElement ( k ) );
				if ( p2==this->nodes->end() )
				{
					cout <<"Error in Graph::complete, null value";
					end();
				}
				arc= new T ( ( float ) 0, ( PNode ) p1, ( PNode ) p2 );
				if ( !this->existArc ( arc, true ) )
				{
					//   cout <<"\ninserting link between nodes " << nodes->getElement((int)j)->print() <<" and " << nodes->getElement((int)k)->print();

					this->insertElement ( *arc );
//cout <<"\nadded";
				}
				//  zap(arc);
			}
		}
	}
	/*_______________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> typename Set<T>::Class* Graph<Link, T, U>::getNeighborhood ( PNode node, int type )
	{
		typedef typename Set<T>::Class::iterator PNode;
//It gets all the neighbours of the node at the argument
		// type=0: all, 1: parents, 2: children
		if ( node==this->nodes->end() )
		{
			cout <<"Error in  Graph<T, U>::getNeighborhood, node is null";
			end();
		}
		typename Set<T>::Class* neighborhood = new typename Set<T>::Class::Container();
		Link<T, U>* arc;
		for ( typename Vector<Link<T,U>*>::Class::iterator p=this->getFirst(); p!=this->end(); p++ )
		{
			arc=this->getElement ( p );
			switch ( type )
			{
				case 0://all
					if ( *arc->getSecond() ==*node ) neighborhood->insertElement ( *arc->getFirst() );
					else if ( *arc->getFirst() ==*node ) neighborhood->insertElement ( *arc->getSecond() );
					break;
				case 1://only parents
					if ( arc->isDirected() && *arc->getSecond() ==*node )
						neighborhood->insertElement ( *arc->getFirst() );
					break;
				case 2:// only children
					if ( arc->isDirected() && *arc->getFirst() ==*node )
						neighborhood->insertElement ( *arc->getSecond() );
					break;
			}
		}
		return neighborhood;
	}

	/*_______________________________________________________________*/
	/*
	  template <template<class T, class U> class Link, class T, class U> void Graph<Link, T, U>::removeNodeLinks(PNode node, int type)
	  {
	     typename Graph<Link, T, U>::iterator p=this->getFirst();
	     T* arc;
	      if (node==NULL)
	     {
	     cout <<"Error in Graph<T, U>::removeNodeLinks, null value";
	     end();
	     }
	while (p!=NULL)
	{
	arc=this->getElement(p);
	switch (type)
	{
	case 0: if (arc->hasNode(node)) {p=this->removeNode(p);}else p=this->getNext(p); break;
	case 1: if (arc->getSecond()==node) p=this->removeNode(p); else p=this->getNext(p); break;
	case 2: if (arc->getFirst()==node) p=this->removeNode(p); else p=this->getNext(p); break;
	//case 0: if (arc->getSecond()==node || arc->getFirst()==node) {p=this->removeNode(p); cout <<"here";}else p=this->getNext(p); break;

	  }
	  }
	  }
	  /*_______________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> Graph<Link, T, U>* Graph<Link, T, U>::clone()
	{
		return new Graph<Link, T, U> ( *this );
	}

	/*_______________________________________________________________*/



	template <template<class T, class U> class Link, class T, class U>  typename Set<T>::Class* Graph<Link, T, U>::getParents ( PNode node )
	{
		return this->getNeighborhood ( node, 1 );
	}
	/*_______________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> typename Set<T>::Class* Graph<Link, T, U>::getChildren ( PNode node )
	{
		return this->getNeighborhood ( node, 2 );
	}
	/*_______________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> intList*  Graph<Link, T, U>::getTotalMissingConnections()
	{
		if ( this->nodes->GetSize() ==0 ) return NULL;
		typename Set<T>::Class::iterator p=this->nodes->GetFirst();
		intList* missingConnections=new intList();
		while ( p!=this->nodes->end() )
		{
			missingConnections->insertElement ( getTotalMissingConnections ( p ) );
			p=this->nodes->GetNext ( p );
		}
		return missingConnections;
	}

	/*_____________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> int  Graph<Link, T, U>::getTotalMissingConnections ( typename Set<T>::Class::iterator node )
	{
		typename Set<T>::Class* neighborhood=getNeighborhood ( node );
		int maxConnections= ( neighborhood->GetSize() * ( neighborhood->GetSize()-1 ) ) /2;
		typename Set<Link<T,U>*>::Class::iterator p=this->GetFirst();
		typename Set<U>::Class::NodePointer p1, p2;
		U* node1, *node2;
		Link<T, U>* arc=NULL;


		for ( int j=0; j<neighborhood->GetSize()-1 ; j++ )
		{
			node1 = neighborhood->GetElement ( ( int ) j );
			p1=this->nodes->findElement ( node1 );
//cout <<"first";
			for ( int k=j+1 ; k<neighborhood->GetSize() ; k++ )
			{
//cout <<"second";
				node2 = neighborhood->GetElement ( ( int ) k );
				p2=this->nodes->findElement ( node2 );
				arc=new T ( 0, p1, p2 );
				if ( existUnweightedArc ( arc ) )
				{
//cout <<"found";
					maxConnections--;
				}
				zap ( arc );
			}
		}
//end();
		zap ( neighborhood );
		return maxConnections;
	}

	/*_____________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> bool Graph<Link, T, U>::isAClique()
	{
		return ( ( this->nodes->size() * ( this->nodes->size()-1 ) ) /2 ) ==this->size();
	}
	/*_______________________________________________________________*/

	/*
	  template <> void Graph<Separator, Clique>::assignElement(Set<Separator>::iterator p, Separator* element)
	  {
	  this->SoftListOfPointers::assignElement(p, element);
	  }

	   /*_______________________________________________________________*/

//   template <> class Graph<Separator, Clique>: public SoftListOfPointers<Separator>;





};  // Fin del Namespace

#endif

/* Fin Fichero: Graph.h */
