/* File:
SingleAncestorGraph.cpp */


#ifndef __SingleAncestorGraph_cpp0__
#define __SingleAncestorGraph_cpp0__


#define debug_new_copy 1




//using namespace UTILS;


namespace BIOS
{



	template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph() :UnchordGraph<Link, T, U>()
	{
		init();
		this->nodes=new Container<set<T>, T >();
		this->root=this->nodes->end();

	};

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::init() //Set<Link<T, U>*>::Class()
	{
		this->best_k = -1;
		for ( int i=0; i<6; i++ ) best_nodes_found[i]=false;
	}

	/*______________________________________________________________________________________*/

//template <template<class T, class U> class Link, class T, class U=int>

	template <template<class T, class U> class Link, class T, class U> SingleAncestorGraph<Link, T, U>::SingleAncestorGraph ( T & node ) : UnchordGraph<Link,T,U >() //Set<Link<T, U>*>::Class()
	{
		init();
		this->nodes=new Container<set<T>, T >();
		this->nodes->insertElement ( node );
		this->root=this->nodes->getFirst();
//cout << "DDDDD "  << *this << "\n";
	}
	/*______________________________________________________________________________________*/


	template <template<class T, class U> class Link, class T, class U> SingleAncestorGraph<Link, T, U>::~SingleAncestorGraph()
	{
		this->nodes->clear();
		delete this->nodes;
	}

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::insertElement ( Link<T, U>* arc )
	{
// the second element in the arc should will be inserted in nodes and the arc second element should change to point to it
//cout << "this method should not be used for SingleAncestorGraphs, use void insertElement (PNode currentNode, T newNode, U* description, float weight, bool directed) instead\n";
//throw NonImplemented("void SingleAncestorGraph<Link, T, U>::insertElement ( Link<T, U>* arc )"); 
// 
	try
		{
   PNode newNode=arc->getSecond(), currentNode=arc->getFirst();
   bool directed=arc->isDirected();
// the first node must exist but not the second if a directed arc; only one of the nodes must exist if a non directed arc
   if ((directed==true && ( this->existNode ( *newNode ) || !this->existNode ( *currentNode ) ))
   || (directed==false && (( this->existNode (*newNode ) && this->existNode ( *currentNode ) ) || ( !this->existNode ( *newNode ) && !this->existNode ( *currentNode )))))
			{
//cout << "Trying to add\n";
				cout << "\nArc "  << *arc << " to node" << **newNode << " cannot be added to current SingleAncestorGraph: " << *this <<  "\n";      
exit(0);
    throw BadFormat ( "SingleAncestorGraph::checkArc-2" );
exit(0);
			}
 this->nodes->insertElement(*newNode);

  // Link<T,U>* arc=NULL;
  //  arc=new Link<T,U>(weight, currentNode, this->nodes->find(newNode), description);
    arc->setSecond( this->nodes->find(*newNode));
    this->Vector<Link<T, U>*>::Class::insertElement ( arc );
  
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Graph<Link, T, U>::insertElement(Link<T, U>* arc)" );};
	};

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  typename Set<T>::Class* SingleAncestorGraph<Link, T, U>::getChildren ( PNode node )
	{
		return Graph<Link, T, U>::getChildren ( node );
	};
	/*______________________________________________________________________________________*/


	template <template<class T, class U> class Link, class T, class U>  vector< typename Set<T>::Class::iterator > * SingleAncestorGraph<Link, T, U>::getChildrenIterators ( PNode node )
	{
// return Graph<Link, T, U>::getChildren(node);

		if ( node==this->nodes->end() )
		{
			cout <<"Error in  Graph<T, U>::getNeighborhood, node is null"<<endl;
			end();
			return NULL;
		}

		Link<T, U>* arc;
		typename Vector<Link<T,U>*>::Class::iterator p=this->getFirst();
		vector< typename Set<T>::Class::iterator > * v = new vector< typename Set<T>::Class::iterator >;

		if ( *node==NULL )
			return v;

		while ( p!=this->end() )
		{
			arc=this->getElement ( p );
			if ( arc->isDirected() && *arc->getFirst() ==*node )
				v->push_back ( arc->getSecond() );

			p=this->getNext ( p );
		}
		return v;
	};

// 	 template <template<class T, class U> class Link, class T, class U>
// 	 typename vector<PNode> SingleAncestorGraph<Link, T, U>::getChildrenArray(PNode node)
// 	 {
//
// 	 }
	/*______________________________________________________________________________________*/
/*
	template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::checkArc ( Link<T, U>* arc )
	{
		try
		{
// Arc must be new
			if ( existArc ( arc ) !=this->end() )
			{
				throw BadFormat ( "void SingleAncestorGraph<Link, T, U>::checkArc(Link<T, U>* arc)" );
				exit ( 0 );
			}
// the first node must exist but not the second if a directed arc; only one of the nodes must exist if a non directed arc
   if (((arc->isDirected()) && ( existNode ( *arc->getSecond() ) || !existNode ( *arc->getFirst() ) ))
   || ((!arc->isDirected()) && (( existNode ( *arc->getSecond() ) && existNode ( *arc->getFirst() ) ) || ( !existNode ( *arc->getSecond() ) && !existNode ( *arc->getFirst() )))))
			{
//cout << "Trying to add\n";
				cout << "\nArc " << *arc << " cannot be added to current SingleAncestorGraph: " << *this <<  "\n";      
    throw BadFormat ( "SingleAncestorGraph::checkArc-2" );
			}
  	this->nodes->insertElement ( *arc->getSecond() );
			if ( this->nodes->size() ==1 )
				root=this->nodes->getFirst();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::checkArc(Link<T, U>* arc)" ); throw;};
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::insertElement (PNode currentNode, T newNode, U* description, float weight, bool directed)
	{
		try
		{
// the first node must exist but not the second if a directed arc; only one of the nodes must exist if a non directed arc
   if ((directed==true && ( this->existNode ( newNode ) || !this->existNode ( *currentNode ) ))
   || (directed==false && (( this->existNode (newNode ) && this->existNode ( *currentNode ) ) || ( !this->existNode ( newNode ) && !this->existNode ( *currentNode )))))
			{
//cout << "Trying to add\n";
				cout << "\nArc to node" << *newNode << " cannot be added to current SingleAncestorGraph: " << *this <<  "\n";      
    throw BadFormat ( "SingleAncestorGraph::checkArc-2" );
			}
 this->nodes->insertElement(newNode);

   Link<T,U>* arc=NULL;
    arc=new Link<T,U>(weight, currentNode, this->nodes->find(newNode), description);
    this->Vector<Link<T, U>*>::Class::insertElement ( arc );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Graph<Link, T, U>::insertElement(Link<T, U>* arc)" );};

	}
	/*__________________________________________________________________*/
	/*
	  template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::copyArcs(SingleAncestorGraph<Link, T, U>* target)
	  {
	    Graph<Link,T, U>::copyArcs(target);
	    this->setRoot(target->getRoot());
	    }
	    /*______________________________________________________________________________________*/
	/*
		 template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph(T* node): UnchordGraph<Link, T, U>(node)
		  {
	this->root=this->nodes->getFirst;
	best_k=-1;
		  };
	    /*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph ( UnchordGraph<Link, T, U> & pt, PNode root ) : UnchordGraph<Link, T, U> ( pt )
	{
		this->root=this->nodes->findEqualElement ( *root );
		best_k=-1;
//int rootPos=pt.nodes->getPosition(root);
		//    this->root=this->nodes->getNode(rootPos);
	};

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  SingleAncestorGraph<Link, T, U>::SingleAncestorGraph ( SingleAncestorGraph<Link, T, U> & pt ) : UnchordGraph<Link, T, U> ( pt )
	{
		this->root=this->nodes->findEqualElement ( *pt.root );
		/*
		//             #define debug_new_copy 1

		// father: iterator to a node in the tree to be added (t)
		// child: iterator to a node in the tree to be added (t)
		// childCoy: iterator to a new node created in the tree pointed by input iterator "node"
		// fatherCopy: iterator to a new node created in the tree pointed by input iterator "node"
		// rootCopy: iterator to the copy of the root of "t" in the tree pointed by "node"
		PNode father, child, fatherCopy, childCopy, rootCopy;
		// arcCopy: new arc created between "fatherCopy" and "childCopy"
		Link<T,U>* arc, *arcCopy;
		// out: used to store the iterator to the new node inserted
		pair<PNode, bool> out;

		 
			this->nodes = new Container<set<T>, T >();
		 // When there are no arcs, insert the root node
		 if ( pt.begin() == pt.end() )
		 {
			if ( pt.nodes->size() > 0 ){
				PNode originalRoot = pt.getRoot();
		 		out = this->nodes->insert(*originalRoot);
				rootCopy = out.first;
			}
		 }


		// When there are arcs, copy the nodes and create new arcs
		for (PArc it=pt.begin(); it!=pt.end(); it++)
		{
			// Get elements
			arc=pt.getElement(it);
			father=arc->getFirst();
			child=arc->getSecond();
			
			// insert father
			out = this->nodes->insert(*father);
			fatherCopy = out.first; //fatherCopy=this->nodes->getNode(this->nodes->size()-1);
			if (pt.isRoot(father)) rootCopy=fatherCopy;
			
			// insert child
			out = this->nodes->insert(*child);  // childCopy=this->nodes->getNode(this->nodes->size()-1);
			childCopy = out.first;
			
			// create new arc
			arcCopy=new Link<T,U>(arc->getWeight(),fatherCopy, childCopy);
			insertElement(arcCopy);
			
			#ifdef debug_new_copy
			cout << endl;
			cout << "Father [" << *father << "]: " << **father << endl;
			cout << "child [" << *child << "]: " << **child << endl;
			cout << "FatherCopy [" << *fatherCopy << "]: " << **fatherCopy << endl;
			cout << "childCopy [" << *childCopy << "]: " << **childCopy << endl;
		 	cout << "arcCopy [ " << *arcCopy->getFirst() << " - "<< *arcCopy->getSecond() <<"]" << endl;
			
			
			#endif
			
		}

		this->root = rootCopy;
		*/
		for ( int i=0; i<6; i++ ) best_nodes_found[i]=pt.best_nodes_found[i];
		for ( int i=0; i<6; i++ ) best_nodes[i]=pt.best_nodes[i];
		best_k=pt.best_k;


	};

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::addChild ( PNode node, float weight, SingleAncestorGraph<Link, T, U> * t )
	{
		try
		{
// it adds (paste) the whole SingleAncestorGraph t to the current SingleAncestorGraph using node and the root node of t as the stick nodes.
// 			#define debug_addChild 1

			// father: iterator to a node in the tree to be added (t)
			// child: iterator to a node in the tree to be added (t)
			// childCopy: iterator to a new node created in the tree pointed by input iterator "node"
			// fatherCopy: iterator to a new node created in the tree pointed by input iterator "node"
			// rootCopy: iterator to the copy of the root of "t" in the tree pointed by "node"
			/*
						PNode father, child, fatherCopy, childCopy, rootCopy;
						// arcCopy: new arc created between "fatherCopy" and "childCopy"
						Link<T,U>* arc, *arcCopy;
						// out: used to store the iterator to the new node inserted
						pair<PNode, bool> out;


						 // When there are no arcs, insert the root node
						 if ( t->begin() == t->end() )
						 {
							PNode originalRoot = t->getRoot();
						 	out = this->nodes->insert(*originalRoot);
			// 				this->nodes->insertElement(*originalRoot);
							rootCopy = out.first;
						 }

						// When there are arcs, copy the nodes and create new arcs
						for (PArc it=t->begin(); it!=t->end(); it++)
						{
							// Get elements
							arc=t->getElement(it);
							father=arc->getFirst();
							child=arc->getSecond();

							// insert father
							out = this->nodes->insert(*father);
							fatherCopy = out.first; //fatherCopy=this->nodes->getNode(this->nodes->size()-1);
							if (t->isRoot(father)) rootCopy=fatherCopy;

							// insert child
							out = this->nodes->insert(*child);  // childCopy=this->nodes->getNode(this->nodes->size()-1);
							childCopy = out.first;

							// create new arc
							arcCopy=new Link<T,U>(arc->getWeight(),fatherCopy, childCopy);
							insertElement(arcCopy);

							#ifdef debug_addChild
							cout << endl;
			// 				cout << "Father [" << father._M_node << "]: " << **father << endl;
			// 				cout << "child [" << child._M_node << "]: " << **child << endl;
			// 				cout << "FatherCopy [" << fatherCopy._M_node << "]: " << **fatherCopy << endl;
			// 				cout << "childCopy [" << childCopy._M_node << "]: " << **childCopy << endl;
			//  				cout << "arcCopy [ " << arcCopy->getFirst()._M_node << " - "<< arcCopy->getSecond()._M_node <<"]" << endl;

							cout << "Father [" << *father << "]: " << **father << endl;
							cout << "child [" << *child << "]: " << **child << endl;
							cout << "FatherCopy [" << *fatherCopy << "]: " << **fatherCopy << endl;
							cout << "childCopy [" << *childCopy << "]: " << **childCopy << endl;
			 				cout << "arcCopy [ " << *arcCopy->getFirst() << " - "<< *arcCopy->getSecond() <<"]" << endl;


							#endif

						}
			*/
//SingleAncestorGraph<Link, T, U> *copy=t->clone();
			// Link the root of the inserted tree and the given node
			Link<T,U>* arcCopy=new Link<T,U> ( weight, node, t->getRoot() );
//cout << "root is: " << **copy->getRoot() << "\n";
//cout << "arc tobe inserted is: " << *arcCopy << "\n";
//cout << "current tree is: " << *this << "\n";
			insertElement ( arcCopy );

//cout << "aaa\n";

			paste ( t );
//cout << "aq\n";

#ifdef debug_addChild
			cout << "Link to node [" << *node << "]: " << **node << endl;
			cout << "arcCopy [ " << *arcCopy->getFirst() << " - "<< *arcCopy->getSecond() <<"]" << endl;
#endif

			// update the frequencies in the node
			/*
						HaplotypeTUCounts * h = *node;
						h->frequencyT += t->getTotalFrequencyT();
						h->frequencyU += t->getTotalFrequencyU();
			*/
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::addChild(PNode node, int weight, SingleAncestorGraph<Link, T, U> * t )" ); throw;};
	}

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::paste ( SingleAncestorGraph<Link, T, U> * source )
	{
// a common node must exist and then source graph is pasted by that node
		try
		{
			if ( this->nodes!=NULL && source->nodes!=NULL )
			{
    if (this->nodes->size()==0 && source->nodes->size()>0) 
{
this->nodes->insertElement(*source->getRoot());
this->setRoot(this->nodes->getFirst());
}

intList* commonNodes=this->nodes->copyPositionsWithElementsIn ( source->nodes, true );
				if ( commonNodes->size() !=1 ) // one and only one common node has to exist
				{
					cout << "There are " << commonNodes->size() << " common nodes while there should be one\n";
					cout << "current graph has nodes: " << *this->nodes << " while source has nodes: " << *source->nodes <<"\n";
					throw BadFormat ( "void SingleAncestorGraph<Link, T, U>::paste(SingleAncestorGraph<Link, T, U> * source)" );
				}
/*
for (typename SingleAncestorGraph<Link, T, U>::iterator it=source->begin(); it!=source->end(); it++)
 insertElement(*it);

cout << "this is:" << *this <<"\n";
*/
			Graph<Link, T, U>::paste ( source );// no more checking

			};
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void SingleAncestorGraph<Link, T, U>::paste(SingleAncestorGraph<Link, T, U> * source)" ); throw;};
	}
	/*______________________________________________________________________________________*/
/*
	template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::paste ( SingleAncestorGraph<Link, T, U> * source )
	{
// a common node must exist and then source graph is pasted by that node
		try
		{
			if ( this->nodes!=NULL && source->nodes!=NULL )
			{
    if (this->nodes->size()==0 && source->nodes->size()>0) 
{
this->nodes->insertElement(*source->getRoot());
this->setRoot(this->nodes->getFirst());
}
				intList* commonNodes=this->nodes->copyPositionsWithElementsIn ( source->nodes, true );
				if ( commonNodes->size() !=1 ) // one and only one common node has to exist
				{
					cout << "There are " << commonNodes->size() << " common nodes while there should be one\n";
					cout << "current graph has nodes: " << *this->nodes << " while source has nodes: " << *source->nodes <<"\n";
					throw BadFormat ( "void SingleAncestorGraph<Link, T, U>::paste(SingleAncestorGraph<Link, T, U> * source)" );
				}
				Graph<Link, T, U>::paste ( source );// no more checking
			};
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void SingleAncestorGraph<Link, T, U>::paste(SingleAncestorGraph<Link, T, U> * source)" ); throw;};
	}
	/*_______________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U> SingleAncestorGraph<Link, T, U>* SingleAncestorGraph<Link, T, U>::clone()
	{
		return new SingleAncestorGraph<Link, T, U> ( *this );
	}

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  bool SingleAncestorGraph<Link, T, U>::isRoot ( PNode node )
	{
		return ( node==root );
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  void SingleAncestorGraph<Link, T, U>::setRoot ( PNode node )
	{
		root=node;
	};
	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  typename Set<T>::Class::iterator SingleAncestorGraph<Link, T, U>::getRoot()
	{
		return ( root );
	};

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>  typename Set<T>::Class::iterator SingleAncestorGraph<Link, T, U>::getParent ( PNode node )
	{
		typename Set<T>::Class* parents=this->getParents ( node );
		PNode result=this->nodes->findElement ( *parents->getFirst() );
		parents->erase ( parents->begin(), parents->end() );
		return result;
	};

	/*______________________________________________________*/

//      template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::print (ostream& out, PNode& p)
//      {
// //      out << **p;
//      typename Set<T>::Class* children=this->getChildren(p);
//      for (PNode it= children->begin(); it!=children->end(); it++)
//       out << print(it);
//      }

	template <template<class T, class U> class Link, class T, class U>
	int SingleAncestorGraph<Link, T, U>::maxPossibleK()
	{

		if ( best_nodes_found[3] )
			return 2;
		else
			if ( best_nodes_found[2] )
				return 1;
			else
				return 0;

	}
	/*______________________________________________________*/

	/*
		  //!printLeaves &&
		  //if (  v->size() != 0){
			 // print haplotype pointed by this iterator
			 for(int i=0; i<level; i++) out << "\t";
			 out << "[" << *node << "]" << **node << endl;
		  //}
		  
		  
		  for(int i=0; i<v->size(); i++){
		  		print(out, (*v)[i], level+1, printLeaves);
		  }
		  
		  delete v;
		*/  
	template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::print ( ostream& out, PNode node, int level, bool printLeaves )
	{		  

		// print children
		vector<PNode> * v = this->getChildrenIterators ( node );


		if ( !printLeaves && v->size() != 0 )
		{
			// print haplotype pointed by this iterator
			for ( int i=0; i<level; i++ ) out << "\t";
			out << "[" << *node << "]" << **node << endl;
		}


		for ( int i=0; i<v->size(); i++ )
		{
			print ( out, ( *v ) [i], level+1, printLeaves );
		}

		delete v;





	}


	/*______________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::print()
	{
// 		  if (this->nodes->size() > 0 )
		cout << *this;
	};

	/*______________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::printSimple()
	{
// 		  if (this->nodes->size() > 0 )
		this->print ( cout, getRoot(), 0, false );
	};

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::printbn()
	{

		// print best nodes
		cout << "Best Nodes (" << this->best_k << "): " ;
		if ( this->best_k == 0 )
			cout << "[" << * ( this->best_nodes[0] ) << "] ";
		if ( this->best_k == 1 )
		{
			cout << "[" << * ( this->best_nodes[1] ) << "] ";
			cout << "[" << * ( this->best_nodes[2] ) << "] ";
		}
		if ( this->best_k == 2 )
		{
			cout << "[" << * ( this->best_nodes[3] ) << "] ";
			cout << "[" << * ( this->best_nodes[4] ) << "] ";
			cout << "[" << * ( this->best_nodes[5] ) << "] ";
		}
		//cout << endl;

	};

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::printNode ( PNode node )
	{
// 		  if (this->nodes->size() > 0 )
		print ( cout, node, 0 );
	};

// 		template <>
// 		void print(SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void> * t)
// 		{
// 		  cout << *t;
// 		}

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::updateTreeDTScore()
	{
		updateTreeDTScore ( getRoot() );
	}

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::updateTreeDTScore ( PNode node )
	{
		float sumT=0, sumU=0; // sum of frequencies of the cildren
		HaplotypeTUCounts * h = *node; // haplotype pointed by this node


		// update the frequencies of the children
		vector<PNode> * v = this->getChildrenIterators ( node );

		// leaf
		if ( v->empty() )
		{
			delete v;
			return;
		}

		for ( int i=0; i<v->size(); i++ )
		{
			updateTreeDTScore ( ( *v ) [i] );
			sumT += ( * ( *v ) [i] )->frequencyT;
			sumU += ( * ( *v ) [i] )->frequencyU;
		}

		delete v;

		// update current node
		h->setFirstFrequency(sumT);
		h->setSecondFrequency(sumU);

	}

	/*______________________________________________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::resetBestNodes()
	{
		for ( int i=0; i<6;i++ )
			this->best_nodes_found[i] = false;
	}

	template <template<class T, class U> class Link, class T, class U>
	GeneticUnitCountsVector * SingleAncestorGraph<Link, T, U>::getLeaves ( PNode node )
	{
		GeneticUnitCountsVector * v = new GeneticUnitCountsVector();
		rec_getLeaves ( node, v );
		return v;

	}

	/*______________________________________________________*/

	template <template<class T, class U> class Link, class T, class U>
	void SingleAncestorGraph<Link, T, U>::rec_getLeaves ( PNode node, GeneticUnitCountsVector *hv )
	{
		vector<PNode> * v = this->getChildrenIterators ( node );
		// leaf
		if ( v->empty() )
		{
			hv->push_back ( *node );
		}
		else
		{
			for ( int i=0; i<v->size(); i++ )
				rec_getLeaves ( ( *v ) [i] , hv );
		}

		delete v;

	}
	/*______________________________________________________*/
/*

	template <template<class T, class U> class Link, class T, class U>
	GeneticUnitCountsSample * SingleAncestorGraph<Link, T, U>::getBestLeaves()
	{
		GeneticUnitCountsSample * p = new GeneticUnitCountsSample();
		GeneticUnitCountsVector * hv;

		switch ( best_k )
		{

			case 0:
				hv = getLeaves ( best_nodes[0] );
				p->insertSubsetCopy ( hv );
				delete hv;
// 			  (*(p[0]))->collapse();
// 				GeneticUnitCountsVector * h;
				( *p ) [0]->collapse();
// 				h->collapse();
				break;

			case 1:
				hv = getLeaves ( best_nodes[1] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getLeaves ( best_nodes[2] );
				p->insertSubsetCopy ( hv );
				delete hv;
				( *p ) [0]->collapse();
				( *p ) [1]->collapse();
				break;

			case 2:
				hv = getLeaves ( best_nodes[3] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getLeaves ( best_nodes[4] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getLeaves ( best_nodes[5] );
				p->insertSubsetCopy ( hv );
				delete hv;
				( *p ) [0]->collapse();
				( *p ) [1]->collapse();
				( *p ) [2]->collapse();
				break;
		}

		return p;
	}




	/* For gdb debugging */
// 		template <template<class T, class U> class Link, class T, class U>
//  		void SingleAncestorGraph<Link, T, U>::print(PNode node){ cout << **node << endl ;};
// 		template <template<class T, class U> class Link, class T, class U>
// 		void SingleAncestorGraph<Link, T, U>::print(Link<T, U>* arc){ cout << *arc << endl; };
// 		template <template<class T, class U> class Link, class T, class U>
// 		void SingleAncestorGraph<Link, T, U>::
// void print(SingleAncestorGraph *s){ cout << *this << endl; };
// void print(SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void>  *s)
// { cout << *s << endl; };




	/*
	     template <template<class T, class U> class Link, class T, class U>  int SingleAncestorGraph<Link, T, U>::getParent(int value)
	     {
	   //   typename Set<U>::iterator pN=this->nodes->findElement(node);
	      typename SingleAncestorGraph<Link, T, U>::iterator p=this->getFirst();
	      T* arc;
	      while (p!=this->end())
	      {
	      arc=this->getElement(p);
	      if (this->getSecond(arc)->getValue()==value)
	       return this->getFirst(arc)->getValue();
	      p=getNext(p);
	      }
		  return -1;
		  //cout <<"error in SingleAncestorGraph::getParent(node), it could be the root";
	      //exit(0);
	     };

	     /*______________________________________________________________________________________*/
	/*
	  template<> SingleAncestorGraph<DirectedSeparator, Clique*>::SingleAncestorGraph(Set<Clique*>* cliques):UnchordGraph<Separator, Clique*>()
		  {// construct a junction SingleAncestorGraph
	    CompleteUG<UndirectedSeparator, Clique*>* completeUGraph=new CompleteUG<UndirectedSeparator, Clique*>();
		  intList* cliqueList1, *cliqueList2, *commonCliques;
		  floatList* weightList=NULL;
		  Set<Clique*>::iterator p=cliques->getFirst(), p2;
	          Set<Set<Node*>*>* separationList=NULL;
		  intList::iterator cP;
		  int c, i=0;
		  Clique* clique=NULL;
		  Set<Node*>* commonNodes=NULL;
		  end();
		  while (p!=cliques->end())
		  {
		  p2=cliques->getFirst();
		  while (p2!=p && p2!=cliques->end())
		  {
		  weightList=new floatList();
		  commonNodes=cliques->getElement(p)->getCommonNodes(cliques->getElement(p2));
		  weightList->insertElement(commonNodes->size());
		  zap(commonNodes);
		  p2=cliques->getNext(p2);
		  }
		  completeUGraph->insertNode(clique, weightList);
		  zap(weightList);
		  p=cliques->getNext(p);
		  }
		  USingleAncestorGraph<UndirectedSeparator, Clique*>* uSingleAncestorGraph=completeUGraph->getMWST();
		  SingleAncestorGraph<DirectedSeparator, Clique*>* SingleAncestorGraph=uSingleAncestorGraph->getDirectedSingleAncestorGraph(uSingleAncestorGraph->nodes->getFirstElement(), DirectedSeparatorOfCliques);
		  zap(uSingleAncestorGraph);
		  zap(completeUGraph);
	}
	/*
	  template<> SingleAncestorGraph<Separator, Clique>::SingleAncestorGraph(ListOfPointers<intList >* cliques)
		  {// construct a junction SingleAncestorGraph
	          CompleteUG<Separator, Clique>* completeUGraph=new CompleteUG<Separator, Clique>();
		  intList* cliqueList1, *cliqueList2, *commonCliques;
		  floatList* weightList=NULL;
		  ListOfPointers<intList >::iterator p=cliques->getFirst(), p2=NULL;
	          ListOfPointers<intList >* separationList=NULL;
		  intList::iterator cP;
		  int c, i=0;
		  Clique* clique=NULL;
		  ////////
		  while(p!=NULL)
		  {
		  p2=cliques->getFirst();
		  weightList=new floatList();
		  separationList=new ListOfPointers<intList >();
		  while(p2!=p)
		  {
		  cliqueList1=cliques->getElement(p);
		  cliqueList2=cliques->getElement(p2);
		  cP=cliqueList1->getFirst();
		  c=0;
		  commonCliques=new intList();
		  while (cP!=NULL)
		  {
		  if (cliqueList2->findElement(cliqueList1->getElement(cP)))
		  {
		   commonCliques->insertElement(cliqueList1->getElement(cP));
		   c++;
		  }
		  cP=cliqueList1->getNext(cP);
		  }
		  weightList->insertElement(c);
		  separationList->insertElement(commonCliques);
	  	  clique=new Clique(i, );
	 	  p2=cliques->getNext(p2);
		  }
	          completeUGraph->insertNode(clique, weightList, separationList);
		  i++;
		  p=cliques->getNext(p);
		  }
		  ///////////////
		  USingleAncestorGraph<Separator, Clique>* uSingleAncestorGraph=completeUGraph->getMWST();
		  SingleAncestorGraph<Separator, Clique>* SingleAncestorGraph=uSingleAncestorGraph->getDirectedSingleAncestorGraph(uSingleAncestorGraph->nodes->getFirst());
		  zap(uSingleAncestorGraph);
		  zap(completeUGraph);
	}
	*/
	/*_____________________________________________________________________________________*/

	template <template<class T, class U> class ULink, class T, class U>
	template <template<class V, class W> class DLink, class V, class W>
	void SingleAncestorGraph<ULink, T, U>::redirectAsATree ( typename Set<T>::Class::iterator root, SingleAncestorGraph<DLink, V, W> * result )
	{
		cout << "SingleAncestorGraph<Link, T, U>::getDirectedTree is not defined\n";
	};

	/*_____________________________________________________________________________________*/

	template <template<class T, class U> class ULink, class T, class U>
	template <template<class V, class W> class DLink, class V, class W>
	void SingleAncestorGraph<ULink, T, U>::getDirectedTree ( typename Set<T>::Class::iterator root, SingleAncestorGraph<DLink, V, W> * result )
	{
		cout << "SingleAncestorGraph<Link, T, U>::getDirectedTree is not defined\n";
	};
	/*______________________________________________________*/

	//   template <template<class T, class U> class Link, class T, class U> ostream& operator<<(ostream& out, SingleAncestorGraph<Link,T, U>& p)

	template <template<class T, class U> class Link, class T, class U> void SingleAncestorGraph<Link, T, U>::print ( ostream& out )
	{
// 		#define debug_operator

#ifdef debug_operator
		out << "List of nodes: ";
		Set<HaplotypeTUCounts*>::Class::iterator it;
		for ( it= this->nodes->begin(); it!=this->nodes->end(); it++ )
			out << "[" << **it << "] ";
		out << endl;

		out << "List of arcs: ";
		Graph<DirectedArc,HaplotypeTUCounts*, void>::iterator it2;
		for ( it2=this->begin(); it2!=this->end(); it2++ )
		{
			cout << "[ " << * ( *it2 )->getFirst() << " - "<< * ( *it2 )->getSecond() <<"], ";
		}
		out << endl;
#endif
		if ( this->getRoot() !=this->nodes->end() )
// {
			out << "\nRoot is: " << **this->getRoot();// it only has sense if there are directed arcs
		//this->print(out, this->getRoot());
// }
		Graph<Link, T, U>::print ( out );
		//out << (UnchordGraph<Link, T, U>&)p;


		out;
	}
}
;  // Fin del Namespace

#endif

/* Fin Fichero: SingleAncestorGraph.h */
