/* File: 
SingleAncestorGraph.cpp */


#ifndef __SingleAncestorGraph_h0__
#define __SingleAncestorGraph_h0__







//using namespace UTILS;


namespace BIOS
{


  /************************/
  /* SingleAncestorGraph DEFINITION */
  /************************/


  /**
          @memo SingleAncestorGraph 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */

//class PartitionHaplotypeTUCountsVector;
//class HaplotypeTUCountsVector;

class GeneticUnitCounts;
class GeneticUnit;
typedef VectorSample<GeneticUnitCounts*>::Class GeneticUnitCountsSample;
typedef Vector<GeneticUnitCounts*>::Class GeneticUnitCountsVector;
typedef Vector<GeneticUnit*>::Class GeneticUnitVector;

//class Tree;
//typedef Tree<Node*, int>::Class SimpleTree;


// A SingleAncestorGraph is an UnchordGraph with only one ancestor (ancestors are only defined for the directed arcs in the graph).

// If all arcs are directed, the graph is called a Tree
// If all arcs are undirected, the graph is called a UTree

 template <template<class T, class U> class Link, class T, class U>  class SingleAncestorGraph: public UnchordGraph<Link, T, U>
  {
public:

   typedef typename Set<T>::Class::iterator PNode;

  private:

    typedef  typename SingleAncestorGraph<Link,T, U>::iterator PArc;
    
    PNode root;
	 

  
  public:

	 	//! Nodes given the maximum statistic
		PNode best_nodes[6]; // [0] [1,2] [3,4,5]
		//! mapping for the best_nodes array
		bool best_nodes_found[6]; 
		//! Value of k given the best statistic: 0->[0]; 1->[1,2]; 3->[3,4,5] in the best nodes array.
		int best_k;
	 
virtual SingleAncestorGraph<Link, T, U>* clone();
	 
    SingleAncestorGraph();
        SingleAncestorGraph(T & node);
    virtual ~SingleAncestorGraph();
   // virtual void checkArc(Link<T, U>* arc);
    SingleAncestorGraph (UnchordGraph<Link, T, U> & pt, PNode root);
    SingleAncestorGraph (SingleAncestorGraph<Link, T, U> & pt);
   // SingleAncestorGraph(Set<Clique*>* cliques);
    bool isRoot(PNode node);
    PNode getRoot();
    void setRoot(PNode node);
    PNode getParent(PNode node);
	   virtual	void insertElement(Link<T, U>* arc);
virtual void paste(SingleAncestorGraph<Link, T, U>* target);
		string getClassName();
    void insertElement (PNode currentNode, T newNode, U* description, float weight, bool directed);
    template <template<class V, class W> class DLink, class V, class W>  void redirectAsATree(PNode node, SingleAncestorGraph<DLink, V, W>* result);
    template <template<class V, class W> class DLink, class V, class W>  void  getDirectedTree(PNode root, SingleAncestorGraph<DLink, V, W>* result);
		
		/**
		* reset the best_nodes[6] array.
		*/
		void resetBestNodes();
		
		/**
		* returns a set of copies of the elements pointed by node.
		* 
		* @param node Node from which to extract the  children.
		* @return A set of copies of elements pointed by the nodes.
		*/
		typename Set<T>::Class* getChildren(PNode node);
		
		/**
		returns a vector with the iterators to the children o node
		@param node Iterator to a node
		@return Vector with iterators to the children of node
		*/
		vector< typename Set<T>::Class::iterator > * getChildrenIterators(PNode node);

		
		/**
		* Add the given tree as a child of node
		* A copy of the tree is inserted in "this".
		*
		* @param node Node to which attach the tree
		* @param weigth Weight assigned to the link
		* @param t Tree to add 
		*/
		void addChild(PNode node, float weight, SingleAncestorGraph<Link, T, U> * t );
		
		/**
		* prints out a node and its children.
		* used in recursive printing.
		* @param out output stream
		* @param node Node to print 
		* @param level Depth in the tree (used to tab the levels)
		* @param printLeaves Indicates if the leaves will be printed. Default is true.
		*/
		void print (ostream& out, PNode node, int level=0, bool printLeaves=true);
		
		void print();
		void printSimple();
		
		void printbn();
		
		int maxPossibleK();
		
		void printNode(PNode node);
		
		virtual void print(ostream& os);
		
		// *******************
		// For haplotype tree
		// *******************
		
		/**
		* Returns the transmission of the tree.
		* The frequency must be correctly stored in the node. Use updateTreeDTScore to ensure that.
		* @see updateTreeDTScore
		* @return The total frequency of transmissions in the tree.
		*/
		float getTotalFrequencyT();
		
		/**
		* Returns the non-transmissions of the tree.
		* The frequency must be correctly stored in the node. Use updateTreeDTScore to ensure that.
		* @see updateTreeDTScore
		* @return The total frequency of non-transmissions in the tree.
		*/		
		float getTotalFrequencyU();
		
		/**
		* Updates the frequencies of the nodes summing up from the leaves. (only for haplotype trees)
		*/
 		void updateTreeDTScore();
		
		/**
		* Updates the frequencies of the nodes summing up from the leaves. (only for haplotype trees)
		* Starts at the node given.
		*/		
 		void updateTreeDTScore(PNode node);
		
		/**
		* Get a partition with the leaves of the best nodes.
		* For each subset given the best statistic, a new subset is created in the partition.
		* The haplotypes in the leaves are copies of the originals.
		* @return Partition with the leaves. Each subset in the partition corresponds to a subset in the tree.
		*/
		GeneticUnitCountsSample * getBestLeaves();
		
		/**
		* Get the leaves from a node. Recursively.
		* @return All the leaves belonging to a node.
		*/
		GeneticUnitCountsVector * getLeaves(PNode node);
		
		
	 private:
		void rec_getLeaves(PNode node, GeneticUnitCountsVector *v);
		void init();
		
		
		
		
// 		void print(PNode node);
// 		void print(Link<T, U>* arc);
		
		//void print (ostream& out);
 //   void copyArcs(Tree<Link, T, U>* target);

  };
//   class HaplotypeTUCounts;

  
// 	void print(SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void>  *s);


// 	void print(SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void> * t);

};  // Fin del Namespace

#endif

/* Fin Fichero: SingleAncestorGraph.h */
