/* File: Graph.h */


#ifndef __TriangulatedUG_cpp__
#define __TriangulatedUG_cpp__


namespace BIOS
{


  /************************/
  /* Graph DEFINITION */
  /************************/


  /**
          @memo Graph 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */


template<> TriangulatedUG::Graph(TriangulatedUG& uG): SetOfSimpleUndirectedArcs(uG)



//TriangulatedUG::Graph (Graph & uG)
//:Set<UndirectedArc<Node*, void>*>(uG)
    {

    nodes=uG.nodes;

      SetOfCliques* cliques=new SetOfCliques();
      TriangulatedUG* maskGraph=new TriangulatedUG();
      NodeSet* lNodes=new NodeSet(*this->nodes);
      maskGraph->nodes=lNodes;
      maskGraph->copyArcs(&uG);
      NodeSet*  neighborhood;
      int nodePos;
      Clique* clique=NULL;
      PNode node;
bool includes, included, found;
SetOfCliques::iterator pC, pC2;
intList* missingConnections=maskGraph->getTotalMissingConnections();
int* missingConnectionsArray=NULL;

        while (!maskGraph->isAClique())
      {
        missingConnectionsArray=missingConnections->getTable();
        nodePos=GetMinPos(missingConnectionsArray, maskGraph->nodes->size());
        node=maskGraph->nodes->getNode(nodePos);

        neighborhood=maskGraph->getNeighborhood(node);      
	maskGraph->complete(neighborhood);
	this->complete(neighborhood);
	clique=new Clique(*neighborhood);
	zap(neighborhood);

	clique->insertElement(maskGraph->nodes->getElement(nodePos));
        clique->order();
        pC=cliques->getFirst();
included=false, includes=false;
while (pC!=cliques->end() && !included && !includes)
{
if (cliques->getElement(pC)->includes(clique))
included=true;
pC=cliques->getNext(pC);
}
if (!included) cliques->insertElement(clique);// review: it was written "cliquevector" instead of "clique" but it is not declared 
    maskGraph->removeGraphNode(node);
        zap(clique);
 zaparr(missingConnectionsArray);
     }

zap(missingConnections);

      clique=new Clique(*maskGraph->nodes);
      clique->order();
   pC=cliques->getFirst();
found=false;
while (pC!=cliques->end() && !found)
{
if (cliques->getElement(pC)->includes(clique))
found=true;
pC=cliques->getNext(pC);
}
if (!found) cliques->insertElement(clique);

      zap(clique);
      zap(maskGraph);
      zap(lNodes);
    }






}
;  // Fin del Namespace

#endif

/* Fin Fichero: Graph.h */
