/***************************************************************************
 *   Copyright (C) 2007 by M. Mar Abad Grau and Paola Sebastiani				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __MI_cpp__
#define __MI_cpp__

#include "MI.h"//

namespace BIOS
{

  /*_________________________________________________________________________*/

MI::MI(int argc, char *argv[])
{
inputTUI=new InputMI_UI(argc, argv, "MI");
char fileSample[256], outputFile[256];
floatSample* completedSample=NULL;
ifstream InputFile;
ClassifierTest *classifierTest=NULL;
int classPosition;
LossFunction* lossFunction;
floatMLSample* sample=NULL, *testSample=NULL; 
ListOfAttributes* listOfAttributes=NULL;
ClassificationResults* currentTasaAciertos;
strcpy(fileSample, inputTUI->filename);
strcpy(outputFile, inputTUI->filename);
ofstream OutputFile;
strcat(outputFile, "Completed");
OpenOutput(outputFile, &OutputFile);
listOfAttributes=new ListOfAttributes(fileSample, inputTUI->verbosity.verbosityR.attributeDescription);
classPosition=inputTUI->selectedClassPosition;
sample=new floatMLSample(fileSample, inputTUI->verbosity);
bool noSelection=true;
CompleteMissing* completeMissing=NULL;
if (inputTUI->verbosity.verbosityR.completeSample)
completeMissing=new CompleteMissing(sample->sample);

for (int currentClass=0;currentClass<listOfAttributes->GetSize();currentClass++)
{  
if (inputTUI->selMode==manual && noSelection) 
inputTUI->selection->insertElement(currentClass);
lossFunction=new LossFunction(inputTUI->useFileForLossFunction, listOfAttributes->GetElement(currentClass)->GetTotalModalidades(), fileSample);
classifierTest=new ClassifierTest(sample, NULL, NULL, inputTUI->testMode, inputTUI->numberOfFolds, inputTUI->verbosity, currentClass, lossFunction);

currentTasaAciertos=classifierTest->getAveragedAccuracy(inputTUI->algType, inputTUI->discMode, inputTUI->algorithmParameters, inputTUI->discretization, inputTUI->selMode, inputTUI->selection, inputTUI->selSubmodeClass.selectionFile, inputTUI->stochastic);


if (inputTUI->verbosity.verbosityR.completeSample)
 completeMissing->completeAttribute(currentClass, classifierTest->completedClasses);

if (inputTUI->verbosity.verbosityR.accuracy)
{
cout   << currentTasaAciertos->set.averageAccuracy;
cout << "\n";
}
if (inputTUI->verbosity.verbosityR.true_predictedValues && currentTasaAciertos->set.true_PredictedTable!=NULL)
{
cout   << *currentTasaAciertos->set.true_PredictedTable;
cout << "\n";
}

if (inputTUI->verbosity.verbosityR.selection && classifierTest->selectedAttributes!=NULL) 
cout  << *classifierTest->selectedAttributes << "\n";

zap(classifierTest);
zap(lossFunction);
if (inputTUI->verbosity.verbosityR.progress)
cout   << "\nMissing data for attribute " << currentClass+1 << " has been imputed";
if (inputTUI->selMode==manual && noSelection) inputTUI->selection->Pop();
}
zap(listOfAttributes);
zap(sample);


if (inputTUI->verbosity.verbosityR.completeSample)
{
OutputFile << *completeMissing->completedSample  << "\n";
zap(completeMissing);
OutputFile.close();
cout <<"Results have been saved in file " << outputFile <<"\n";
}


cout << "\n";
};

}

using namespace BIOS;

int main(int argc, char *argv[])
{

  MI *mi;

  mi=new MI(argc, argv);

};



#endif




