
/* File: AlgTypeClass.h */

#ifndef __AlgTypeClass_h__
#define __AlgTypeClass_h__



//using namespace UTILS;


namespace BIOS
{

  enum AlgType
  {
    nil = -1,
    aNB = 0,
    aTAN = 1,
    aGTAN = 2,
    aUAN = 8,
    aFUNC = 3,
    aC45 = 4,
    aContinuousC45 = 5,
    aBT = 6,
    aNN = 7,
    aEM = 9,
    aContinuousEM = 10,
    aLogReg = 11,
  };

  class AlgTypeClass
  {

    char line[1024];

  public:
    int fold;

    AlgType algorithm;
    floatList *arguments;



      AlgTypeClass (AlgType algorithm, floatList * arguments = NULL)
    {
      this->algorithm = algorithm;

      this->arguments = NULL;
      if (arguments != NULL)
	this->arguments = new floatList (*arguments);
    }

     ~AlgTypeClass ()
    {
      zap (arguments);
    }

    static bool requiresDiscretization (AlgType algorithm)
    {
      switch (algorithm)
	{
	case aNB:
	case aTAN:
	case aGTAN:
	case aUAN:
	case aFUNC:
	case aC45:
	case aBT:
	case aEM:
	case aLogReg:
	  return true;
	  break;
	case aNN:
	case aContinuousC45:
	case aContinuousEM:
	  return false;
	  break;
	}
    }

  };

  ostream & operator<< (ostream & out, AlgTypeClass & p)
  {
    int stopCriterion;
    out << "\nLearning algorithm:\t\t";
    switch (p.algorithm)	//
      {				//
      case aEM:
	out << "EM classifier";
	break;

      case aContinuousEM:
	out << "EM continuous classifier";
	break;

      case aNB:
      case aTAN:
      case aGTAN:
      case aUAN:
	switch (p.algorithm)
	  {
	  case aNB:
	    out << "Naive Bayes";
	    break;
	  case aTAN:
	    out << "TAN Bayes";
	    break;
	  case aGTAN:
	    out << "SAN Bayes";
	    break;
	  case aUAN:
	    out << "user-defined Bayesian Network (file .mod)";
	    break;
	  };
	if (p.arguments != NULL && p.arguments->size () > 0
	    && p.arguments->getElement ((int) 0) != 0)
	  out << " direct inference";

	if (p.arguments != NULL && (p.arguments->size () > 1))
	  {
	    if (p.arguments->getElement ((int) 1) == 0)
	      out << ", MLE estimator ";
	    else
	      {

		out << ", MAP estimator with criterion ";
		switch ((BayesType) p.arguments->getElement ((int) 1))
		  {

		    //  case MLE: out << ""; break;
		  case UBalpha:
		    out << "uniform";
		    break;
		  case BDistanceUniform:
		    out << "uniform on distance";
		    break;
		  }
		if (p.arguments->size () > 2)
		  out << " and alpha=" << p.arguments->getElement ((int) 2);
		else
		  out << " and alpha=1 ";
	      }
	  }
	else
	  out << ",MAP estimator with criterion uniform and alpha 1 ";



	if (p.algorithm == aGTAN)
	  {
	    if (p.arguments != NULL && p.arguments->size () >= 3)
	      stopCriterion = (int) p.arguments->getElement (2);
	    else
	      stopCriterion = 1;
	    switch (stopCriterion)
	      {
	      case 0:
		cout << " and stop criterion=MDL";
		break;
	      case 1:
		cout << " and stop criterion=SRM";
		break;
	      }
	  }
/* eliminado pq no se necesita para NB, d¿en qué casos se necesita?
		 if (p.arguments!=NULL && p.arguments->size()>3)
          out << ", double log="<< (int)p.arguments->getElement(3);
        else out << ", double log=0"; 
		 if (p.arguments!=NULL && p.arguments->size()>4)
          out << ", alpha Bayes="<< (int)p.arguments->getElement(4);
        else out << ", alpha Bayes=0"; 
*/
	break;
      case aFUNC:
	cout << "FUNCDEP";
	break;			//
      case aC45:
	cout << "c4.5";
	break;
      case aContinuousC45:
	cout << "Continuous c4.5";
	break;
      case aBT:
	cout << "BT";
	break;
      case aNN:
	cout << "k-nearest neighbour";
	if (p.arguments != NULL && p.arguments->size () > 0)
	  out << ", k=" << (int) p.arguments->getElement (0);
	else
	  cout << ", k=1";
	if (p.arguments != NULL && p.arguments->size () > 1)
	  out << ", distance method=" << (int) p.arguments->getElement (1);
	else
	  out << ", distance method=square differences";
	break;
      case aLogReg:
	cout << "logistic regression ";
	if (p.arguments != NULL && p.arguments->size () > 0)
	  out << ", use weights";
	else
	  cout << ", no weights";
	if (p.arguments != NULL && p.arguments->size () > 1)
	  out << ", inverse code=" << (int) p.arguments->getElement (1);
	else
	  out << ", inverse code=0";
	if (p.arguments != NULL && p.arguments->size () > 2)
	  out << ", conditional independence=" << (int) p.arguments->getElement (2);
	else
	  out << ", conditional independence=1 (NBC)";
	if (p.arguments != NULL && p.arguments->size () > 3)
	  out << ", alpha Bayes=" << (int) p.arguments->getElement (3);
	else
	  out << ", alpha Bayes=1";
	break;

      }				//
    //  cout << "\n";
    return out;
  };

};				// Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
