

/* File: AdditiveClassifier.cpp */

#ifndef __AdditiveClassifier_cpp__
#define __AdditiveClassifier_cpp__




//using namespace UTILS;


namespace BIOS
{

	
	/*____________________________________________________________________________________ */

	float AdditiveClassifier::reverseCode ( float currentValue )
	{
		if ( !inverseCode ) return currentValue;
		switch ( ( int ) currentValue )
		{
			case 1:
				return 0;
				break;
			case 0: return 1;
				break;
		}
	}
	/*____________________________________________________________________________________ */

	double AdditiveClassifier::getLogOdds ( double num, double den )
	{
							if ( num==0) return -2; // it is a code meaning -inf
							if (num==1) return +2; // it is a code meaning +inf
 					return log(num)-log(den);
}

	/*____________________________________________________________________________________ */

	double AdditiveClassifier::getIntercept ()
	{
if (weights==NULL) throw NullValue("double AdditiveClassifier::getLogitMarginalDiseaseFreqs ()");
double result=0;
for (int i=0; i<totalAttributes;i++)
							result+=weights[i][0];
							
return result;
}

	/*____________________________________________________________________________________ */

	double AdditiveClassifier::getLogitMarginalDiseaseFreqs ()
	{
if (weights==NULL) throw NullValue("double AdditiveClassifier::getLogitMarginalDiseaseFreqs ()");
							return weights[classPosition][0];
}
	/*____________________________________________________________________________________ */

	void AdditiveClassifier::setWeights ( floatMLSample* sample )
	{
		try
		{
//cout << "setting weights: \n";
			weights = new double*[totalAttributes];
   double** counts=new double*[totalAttributes];
   int **totalInds=new int*[totalAttributes];
sizes=new int[totalAttributes];
			double logOdds, attForClassFreqs, attForNoClassFreqs, totalClassInds=0,totalNoAttsInds, totalNoClassInds=0, totalAttsInds, probAttForClass,
			probAttForNoClass, probClassForAtt, probClassForNoAtt, val, probClass, probNoClass, classVal;

int i=0, size, j=0;
Attribute* at;
for (ListOfAttributes::iterator a=sample->listOfAttributes->begin(); a!=sample->listOfAttributes->end(); a++)
{
at=sample->listOfAttributes->getElement(a);
size=at->getTotalModalidades();
weights[i]=Initialize(size,0.0);
counts[i]=Initialize(size,0.0);
totalInds[i]=Initialize(size,0);
sizes[i]=size;
i++;
}

floatList* ind;
	for ( floatSample::iterator it = sample->sample->begin(); it < sample->sample->end (); it++ )
{
ind=sample->sample->getElement(it);
i=0;
classVal=ind->getElement(classPosition);
	for ( floatList::iterator it2 = ind->begin(); it2 < ind->end (); it2++ )
{
val=ind->getElement(it2);
if (i!=classPosition) 
{
val=reverseCode(val);
if (classVal==1) counts[i][(int)val]++;
totalInds[i][(int)val]++;
}
else counts[i][(int)classVal]++;
i++;
}
}

totalNoClassInds=counts[classPosition][0];
totalClassInds=counts[classPosition][1];
probClass= ( totalClassInds+alphaBayes/2 ) / ( totalClassInds+totalNoClassInds+alphaBayes );
probNoClass= ( totalNoClassInds+alphaBayes/2 ) / ( totalClassInds+totalNoClassInds+alphaBayes );
weights[classPosition][0]=getLogOdds(probClass, probNoClass);
weights[classPosition][1]=weights[classPosition][0];
//cout << "totalclass:"<< totalClassInds <<" and totalnoclas:" << totalNoClassInds <<"\n";
//cout <<"prob class:" << probClass << "and probnoclass:" << probNoClass <<"\n";
//cout << "logOdds:" << weights[classPosition][0] << " and " << weights[classPosition][1] <<"\n";

for (int i=0; i<totalAttributes;i++)
if (i!=classPosition)
for (int j=0; j<sizes[i]; j++)
{
attForClassFreqs=counts[i][j];
attForNoClassFreqs=totalInds[i][j]-counts[i][j];
						probAttForClass = ( attForClassFreqs + alphaBayes / (2*sizes[i]) ) / ( totalClassInds + alphaBayes / 2 );
						probAttForNoClass = ( attForNoClassFreqs + alphaBayes / (2*sizes[i]) ) / ( totalNoClassInds + alphaBayes / 2 );
						if ( totalNoClassInds == 0 || totalClassInds == 0 )
							throw BadFormat ( "void AdditiveClassifier::setWeights()" );
							weights[i][j]=getLogOdds(probAttForClass, probAttForNoClass);
}
zaparr(counts);
zaparr(totalInds);
			}
			catch ( BasicException & be )
			{
				be.addMessage ( "\ncalled from void AdditiveClassifier::setWeights()" );
				throw;
			};

		}

		/*____________________________________________________________________________________ */

		AdditiveClassifier::AdditiveClassifier ( floatMLSample * sample, int att,
		        floatList * parameterList,
		        VerbosityClass * verbosity,
		        LossFunction *
		        lossFunction ) :Classifier ( sample,
				                                     att,
				                                     parameterList,
				                                     verbosity,
				                                     lossFunction )
		{
			try
			{
				if ( totalClasses != 2 )
					throw
					BadFormat
					( "AdditiveClassifier::AdditiveClassifier(floatMLSample* sample, int att, floatList* parameterList, DistanceMethodClass* distanceMethodClass, VerbosityClass* verbosity, LossFunction* lossFunction)" );
//cout << " parameter list is:"  << *parameterList <<" \n" ;
//exit(0);
				conditionalIndependence = 0;
				weights = NULL;
				alphaBayes = 0;
				inverseCode=0;
				if ( parameterList == NULL )
					return;

if (parameterList->size ()>4) throw BadFormat("logistic regression: found more parameters than required");
				if ( parameterList->size () >= 2 && parameterList->getElement ( 1 ) == 1 )
					inverseCode = 1;
				if ( parameterList->size () >= 3 && parameterList->getElement ( 2 ) == 1 )
					conditionalIndependence = 1;
				if ( parameterList->size () >= 4 )
					alphaBayes = parameterList->getElement ( 3 );
				if ( alphaBayes!=0 && conditionalIndependence==0 )
				{
					throw BadFormat ( "if no conditional independence, Bayes prior is not used" );
					exit ( 0 );
				}

				if ( parameterList->getFirstElement () == 1 && conditionalIndependence==1 )
				{
					setWeights ( sample );
					if ( verbosity != NULL && verbosity->verbosityR.structure )
						printWeights ();
				}
				if ( !conditionalIndependence ) throw NonImplemented ( "logistic regression under MLE non implemented yet" );

//if (!conditionalIndependence && alphaBayes==0) throw NonImplemented("AdditiveClassifier class: NBC under MLE is weird");
			}
			catch ( BasicException & be )
			{
				be.addMessage
				( "\ncalled from AdditiveClassifier::AdditiveClassifier(floatMLSample* sample, int att, floatList* parameterList, VerbosityClass* verbosity, LossFunction* lossFunction):Classifier(sample, att, parameterList, verbosity, lossFunction)" );
				throw;
			};
		};


		/*____________________________________________________________________________________ */

		AdditiveClassifier::~AdditiveClassifier ()
		{
			zaparr ( weights );
zaparr(sizes);
		};


		/*____________________________________________________________________________________ */

		void AdditiveClassifier::printWeights ()
		{
if (weights!=NULL)
for (int i=0; i<totalAttributes; i++)
{
			cout << "Weights for variable " << i <<" are: ";
printArray(weights[i], sizes[i]);
cout <<"\n";
}
		};



		/*___________________________________________________________ */

		double *AdditiveClassifier::getClassFrequencies ( floatList *
		        targetInputPattern )
		{
			try
			{
				double measure = 0, j = 0, v, beta;
				double *probs = new double[totalClasses];	// where totalClasses has to be 2
//cout << "weigths are:" << *weights <<"\n";
//cout << "pattern is: " << *targetInputPattern <<"\n";
//cout << " listoft:\n" ;
//cout << *listOfAttributes <<" \n" ;
int i=0;
				for ( floatList::iterator it = targetInputPattern->begin(); it < targetInputPattern->end(); it++ )
{
v=targetInputPattern->getElement ( it );
					if ( classPosition != i) v=reverseCode ( v );
beta=weights[i][(int)v];
if (beta==-2) // it is a code meaning -inf
{
probs[0]=1;
probs[1]=0;
return probs;
}
if (beta==2) // it is a code meaning inf
{
probs[0]=0;
probs[1]=1;
return probs;
}
measure +=beta;
i++;
					}
							probs[1] = 1 / ( exp ( -measure ) + 1 );
//cout << "classprob is: " << probs[1] <<"\n";
//exit(0);
				probs[0] = 1 - probs[1];
//cout << "-classprob is: " << probs[0] <<"\n";
				if ( probs[0] > 1 || probs[0] < 0 )
					throw NonProb ( "double* AdditiveClassifier::getClassFrequencies(floatList* targetInputPattern)",
					                probs[0] );
				return probs;
			}
			catch ( BasicException & be )
			{
				be.addMessage ( "\ncalled from double* BNC::getClassFrequencies(floatList* inputPattern)" );
				throw;
			};
		}

		/*___________________________________________________________ */

		char *AdditiveClassifier::print ()
		{
			sprintf ( line, "AdditiveClassifier" );
			return line;
		}



	};				// Fin del Namespace



#endif

	/* Fin Fichero: AdditiveClassifier.cpp */
