/* File: AdditiveClassifier.h */

#ifndef __AdditiveClassifier_h__
#define __AdditiveClassifier_h__



//using namespace UTILS;


namespace BIOS {

class Genotype;

class AdditiveClassifier: public Classifier
{
// this classifier requires binary classes and also, each attribute value in the sample represents how many times the individual has the "risk" or the "event" under study
// it is a logistic regression model
public:

doubleList* weights, *weights2;

double alphaBayes;

//floatList* weightsVector;
//void set(floatList* parameters);

bool symmetrical; // in this case, it is equivalent to a NBC 
bool inverseCode;// only used for binary input variables; if it is true, 2 means 0 (low risk value) 
bool negativeValues; // for binary values 0,1 will be -1,1; for ternary values 0,1,2 will be -2,0,2

public:

AdditiveClassifier(char* filename, floatList* parameterList);

AdditiveClassifier(floatMLSample* sample, int att, floatList* parameterList=NULL, VerbosityClass *verbosity=NULL, LossFunction* lossFunction=NULL);

//static floatList* getInputPattern(Genotype* genotype, intList* riskAllele);  
	
void setWeights(floatMLSample* sample);

~AdditiveClassifier();

double* getClassFrequencies(floatList* targetInputPattern);

float getCorrectValue(float currentValue,  int totalModalidades);

float getTotalCounts (float currentValue,  int totalModalidades);

void printWeights();

char* print();

};



ostream& operator<<(ostream& out, AdditiveClassifier& AdditiveClassifier)
       {

out << (Classifier&)AdditiveClassifier;
};









};  // Fin del Namespace

#endif

//#include "AdditiveClassifier.cpp"
/* Fin Fichero: AdditiveClassifier.h */
