

/* File: LogisticRegression.cpp */

#ifndef __LogisticRegression_cpp__
#define __LogisticRegression_cpp__




//using namespace UTILS;


namespace BIOS
{

	/*____________________________________________________________________________________ */
	/*
		float LogisticRegression::getCorrectValue ( float currentValue,
		        int totalModalities )
		{
		  if (totalModalities>2) return currentValue;
			int v = ( int ) currentValue;
			if ( inverseCode )
				switch ( v )
				{
					case 1:
						v = 0;
						break;
					case 0:v = 1;
						break;
					default:
					{
						cout << "val is: " << v << " ";
						throw
						BadFormat ( "only binary samples can be coded in inverse order" );
					}
				}

			return v;
		}

	/*____________________________________________________________________________________ */
/*
	float LogisticRegression::reverseCode ( float currentValue )
	{
		if ( !inverseCode ) return currentValue;
		switch ( ( int ) currentValue )
		{
			case 1:
				return 0;
				break;
			case 0: return 1;
				break;
		}
	}
	/*____________________________________________________________________________________ */

	double LogisticRegression::getLogOdds ( double num, double den )
	{
		if ( num==0 ) return -2; // it is a code meaning -inf
		if ( num==1 ) return +2; // it is a code meaning +inf
		return log ( num )-log ( den );
	}

	/*____________________________________________________________________________________ */

	double LogisticRegression::getIntercept ()
	{
		if ( weights==NULL ) throw NullValue ( "double LogisticRegression::getLogitMarginalDiseaseFreqs ()" );
		double result=0;
		for ( int i=0; i<totalAttributes;i++ )
			result+=weights[i][0];

		return result;
	}

	/*____________________________________________________________________________________ */

	double LogisticRegression::getLogitMarginalDiseaseFreqs ()
	{
		if ( weights==NULL ) throw NullValue ( "double LogisticRegression::getLogitMarginalDiseaseFreqs ()" );
		return weights[classPosition][0];
	}
	/*____________________________________________________________________________________ */

	void LogisticRegression::setWeights ( floatMLSample* sample )
	{
int totalA=0;
int totalI=0;
double totalClassInds=0;
double totalNoClassInds=0;
		try
		{
//cout << "setting weights: \n";
			weights = new double*[totalAttributes];
			double** counts=new double*[totalAttributes];
			int** totalIndsForInputAndClassesWithoutMissing=new int*[totalAttributes];
//cout << "total atrribues is: " << totalAttributes << "\n";
			int **totalInds=new int*[totalAttributes];
			sizes=new int[totalAttributes];
			double logOdds, attForClassFreqs, attForNoClassFreqs,totalNoAttsInds, totalAttsInds, probAttForClass,
			        probAttForNoClass, probClassForAtt, probClassForNoAtt, val, probClass, probNoClass, classVal;

			int i=0, size, j=0;
			Attribute* at;
			for ( ListOfAttributes::iterator a=sample->listOfAttributes->begin(); a!=sample->listOfAttributes->end(); a++ )
			{
				at=sample->listOfAttributes->getElement ( a );
				size=at->getTotalModalidades();
//cout << "totalmodalidades is:" << size <<"\n";
				weights[i]=Initialize ( size,0.0 );
				counts[i]=Initialize ( size,0.0 );
				totalInds[i]=Initialize ( size+1,0 ); // last positions is for missing
				totalIndsForInputAndClassesWithoutMissing[i]=Initialize(2,0);// the two classes
				sizes[i]=size;
				i++;
			}

			floatList* ind;
			for ( floatSample::iterator it = sample->sample->begin(); it < sample->sample->end (); it++ )
			{
				ind=sample->sample->getElement ( it );
//cout <<"ind is : " << *ind << "\n";
				i=0;
				classVal=ind->getElement ( classPosition );
 if (classVal>listOfAttributes->getElement(classPosition)->getTotalModalidades() ||  (classVal<0)) throw OutOfBounds(val, listOfAttributes->getElement(classPosition)->getTotalModalidades(), "at LogisticRegression::setWeights ( floatMLSample* sample )");
			
	for ( floatList::iterator it2 = ind->begin(); it2 < ind->end (); it2++ )
				{
					val=ind->getElement ( it2 );
					if ( i!=classPosition )
					{
						//val=reverseCode ( val );
						if (val>listOfAttributes->getElement(i)->getTotalModalidades() ||  (val<0)) throw OutOfBounds(val, listOfAttributes->getElement(i)->getTotalModalidades(), "at LogisticRegression::setWeights ( floatMLSample* sample )");
						else if (val!=listOfAttributes->getElement(i)->getTotalModalidades()) // not missing
						{
						if ( classVal==1 ) counts[i][ ( int ) val]++;
						totalIndsForInputAndClassesWithoutMissing[i][(int)classVal]++;
						}
						totalInds[i][ ( int ) val]++;			
					}
					else counts[i][ ( int ) classVal]++;
					i++;
				}
			}

			totalNoClassInds=counts[classPosition][0];
			totalClassInds=counts[classPosition][1];
 if ( totalNoClassInds == 0 || totalClassInds == 0 )
                                                        throw BadFormat ( "void LogisticRegression::setWeights()" );

			probClass= ( totalClassInds+alphaBayes/2 ) / ( totalClassInds+totalNoClassInds+alphaBayes );
			probNoClass= ( totalNoClassInds+alphaBayes/2 ) / ( totalClassInds+totalNoClassInds+alphaBayes );
			weights[classPosition][0]=getLogOdds ( probClass, probNoClass );
			weights[classPosition][1]=weights[classPosition][0];
//cout << "\n\ntotalclass:"<< totalClassInds <<" and totalnoclas:" << totalNoClassInds <<"\n";
//cout <<"prob class:" << probClass << "and probnoclass:" << probNoClass <<"\n\n\n\n";


			for ( int i=0; i<totalAttributes;i++ )
{
				if ( i!=classPosition )
				{	
						
					for ( int j=0; j<sizes[i]; j++ )
					{
						attForClassFreqs=counts[i][j];
						attForNoClassFreqs=totalInds[i][j]-counts[i][j];
						probAttForClass = ( attForClassFreqs + alphaBayes / ( 2*sizes[i] ) ) / ( totalIndsForInputAndClassesWithoutMissing[i][1] + alphaBayes / 2 );
						probAttForNoClass = ( attForNoClassFreqs + alphaBayes / ( 2*sizes[i] ) ) / ( totalIndsForInputAndClassesWithoutMissing[i][0] + alphaBayes / 2 );
			//			if ( totalNoClassInds == 0 || totalClassInds == 0 )
			//				throw BadFormat ( "void LogisticRegression::setWeights()" );
						weights[i][j]=getLogOdds ( probAttForClass, probAttForNoClass );
						//cout << "\nattForClassFreqs:"<< attForClassFreqs <<" and attForNoClassFreqs:" << attForNoClassFreqs <<"\n";
//cout <<"probAttForClass:" << probAttForClass << "and probAttForNoClass:" << probAttForNoClass <<"\n";
//cout << "logOdds for att " << i << " and position " << j <<": " << weights[i][j] <<"\n";
}
}
totalA=i;					}
			zaparr ( counts );
			zaparr (totalIndsForInputAndClassesWithoutMissing);
			zaparr ( totalInds );
		}
		catch ( BasicException & be )
		{
			be.addMessage ( ", totalClassInds is "); be.addMessage(tos(totalClassInds)); be.addMessage(", totalNoClassInds is "); be.addMessage(tos(totalNoClassInds)); be.addMessage("\ncalled from void LogisticRegression::setWeights()" );
			throw;
		};

	}

	/*____________________________________________________________________________________ */

	LogisticRegression::LogisticRegression ( floatMLSample * sample, int att,
	        floatList * parameterList, // 3 parameters at most: 1: whether to assume conditional independence; 2 whether to use logOdds as weights (in the case of conditional independence); and 3:  alphaBayes in the case of conditionalIndependence
	        VerbosityClass * verbosity,
	        LossFunction *
	        lossFunction ) :Classifier ( sample,
			                                     att,
			                                     parameterList,
			                                     verbosity,
			                                     lossFunction )
	{
		try
		{
			if ( totalClasses != 2 )
				throw
				BadFormat
				( "LogisticRegression::LogisticRegression(floatMLSample* sample, int att, floatList* parameterList, DistanceMethodClass* distanceMethodClass, VerbosityClass* verbosity, LossFunction* lossFunction)" );
//cout << " parameter list is:"  << *parameterList <<" \n" ;
//exit(0);
			conditionalIndependence = 0;
			weights = NULL;
			alphaBayes = 0;
			inverseCode=0;
			if ( parameterList == NULL )
				return;

			if ( parameterList->size () >3 ) throw BadFormat ( "logistic regression: found more parameters than required" );
			//if ( parameterList->size () >= 2 && parameterList->getElement ( 1 ) == 1 )
			//	inverseCode = 1;
			if ( parameterList->size () >= 1 && parameterList->getElement ( 0 ) == 1 )
				conditionalIndependence = 1;
			if ( parameterList->size () >= 2 )
				alphaBayes = parameterList->getElement ( 1 );
			if ( alphaBayes!=0 && conditionalIndependence==0 )
			{
				throw BadFormat ( "if no conditional independence, Bayes prior is not used" );
				exit ( 0 );
			}

			if ( parameterList->getElement (2) == 1 && conditionalIndependence==1 )
			{
				setWeights ( sample );
				if ( verbosity != NULL && verbosity->verbosityR.structure )
					printWeights (cout);
			}
			if ( !conditionalIndependence ) throw NonImplemented ( "logistic regression under MLE non implemented yet" );

//if (!conditionalIndependence && alphaBayes==0) throw NonImplemented("LogisticRegression class: NBC under MLE is weird");
		}
		catch ( BasicException & be )
		{
			be.addMessage
			( "\ncalled from LogisticRegression::LogisticRegression(floatMLSample* sample, int att, floatList* parameterList, VerbosityClass* verbosity, LossFunction* lossFunction):Classifier(sample, att, parameterList, verbosity, lossFunction)" );
			throw;
		};
	};


	/*____________________________________________________________________________________ */

	LogisticRegression::~LogisticRegression ()
	{
		zaparr ( weights );
		zaparr ( sizes );
	};


	/*____________________________________________________________________________________ */

	void LogisticRegression::printWeights (ostream& out)
	{
	 double OR;
		if ( weights!=NULL )
		{
			for ( int i=0; i<totalAttributes; i++ )
			{
				out << "Weights for variable " << i <<" are: ";
				printArray ( weights[i], sizes[i], out);
				if (sizes[i]==2)
				{
				  OR=exp(weights[i][1])/exp(weights[i][0]);
				out << " OR is: " << OR << " and prob is " << OR/((double)OR+1);
				}
				out <<"\n";
			}
		}
	};



	/*___________________________________________________________ */

	double *LogisticRegression::getClassFrequencies ( floatList *
	        targetInputPattern )
	{
		try
		{
			double measure = 0, j = 0, v, beta;
			double *probs = new double[totalClasses];	// where totalClasses has to be 2
/*cout << "weigths are:" ;
printWeights (cout);
cout <<"\n";
cout << "pattern is: " << *targetInputPattern <<"\n";
cout << " listoft:\n" ;
cout << *listOfAttributes <<" \n" ;
*/

			int i=0;
			for ( floatList::iterator it = targetInputPattern->begin(); it < targetInputPattern->end(); it++ )
			{
				v=targetInputPattern->getElement ( it );
  if (v>listOfAttributes->getElement(i)->getTotalModalidades() ||  (v<0)) throw OutOfBounds(v, listOfAttributes->getElement(i)->getTotalModalidades(), "at LogisticRegression::getClassFrequencies ( floatList* targetInputPattern )");
if (v!=listOfAttributes->getElement(i)->getTotalModalidades())

				//if ( classPosition != i ) v=reverseCode ( v );
				beta=weights[i][ ( int ) v];
else beta=0;
				if ( beta==-2 ) // it is a code meaning -inf
				{
					probs[0]=1;
					probs[1]=0;
					return probs;
				}
				if ( beta==2 ) // it is a code meaning inf
				{
					probs[0]=0;
					probs[1]=1;
					return probs;
				}
				measure +=beta;
				i++;
			}
			probs[1] = 1 / ( exp ( -measure ) + 1 );
//cout << "classprob is: " << probs[1] <<"\n";
//exit(0);
			probs[0] = 1 - probs[1];
//cout << "-classprob is: " << probs[0] <<"\n";
			if ( probs[0] > 1 || probs[0] < 0 )
				throw NonProb ( "double* LogisticRegression::getClassFrequencies(floatList* targetInputPattern)",
				                probs[0] );
			return probs;
		}
		catch ( BasicException & be )
		{
			be.addMessage ( "\ncalled from double* BNC::getClassFrequencies(floatList* inputPattern)" );
			throw;
		};
	}

	/*___________________________________________________________ */

	char *LogisticRegression::print ()
	{
		sprintf ( line, "LogisticRegression" );
		return line;
	}
	
	/*___________________________________________________________ */

	 void LogisticRegression::printStructure(ostream& out)
	 {
	    printWeights (out);
	 }



};				// Fin del Namespace



#endif

/* Fin Fichero: LogisticRegression.cpp */
