/* File: LogisticRegression.h */

#ifndef __LogisticRegression_h__
#define __LogisticRegression_h__



//using namespace UTILS;


namespace BIOS {

class Genotype;

class LogisticRegression: public Classifier
{
// this classifier requires binary classes and binary input variables
// it builds a logistic regression model
public:

double** weights;

double alphaBayes;

int *sizes;

//floatList* weightsVector;
//void set(floatList* parameters);

bool conditionalIndependence; //if it is true, parameters are computed under that assumption and it is equivalent to a NBC 
bool inverseCode;// only used for binary input variables; if it is true, 2 means 0 (low risk value) 

public:

double getIntercept();

double getLogitMarginalDiseaseFreqs();

LogisticRegression(char* filename, floatList* parameterList);

LogisticRegression(floatMLSample* sample, int att, floatList* parameterList=NULL, VerbosityClass *verbosity=NULL, LossFunction* lossFunction=NULL);

//static floatList* getInputPattern(Genotype* genotype, intList* riskAllele);  
	
void setWeights(floatMLSample* sample);

~LogisticRegression();

	double getLogOdds ( double num, double den );

double* getClassFrequencies(floatList* targetInputPattern);

//float getCorrectValue(float currentValue,  int totalModalidades);

float reverseCode(float currentValue);

float getTotalCounts (float currentValue,  int totalModalidades);

void printWeights(ostream& out);

char* print();

 virtual void printStructure(ostream& out);

};



ostream& operator<<(ostream& out, LogisticRegression& LogisticRegression)
       {

out << (Classifier&)LogisticRegression;
};









};  // Fin del Namespace

#endif

//#include "LogisticRegression.cpp"
/* Fin Fichero: LogisticRegression.h */
