/* File: Classifier.cpp */


#ifndef __Classifier_cpp__
#define __Classifier_cpp__


#include "Classifier.h"//



namespace BIOS
{


Classifier* Classifier::getClassifier(AlgType algType, DiscMode discMod, floatList* discretization, int classPosition, floatList* algorithmParameters, VerbosityClass* verbosity, LossFunction* lossFunction, floatMLSample* sample, char* fileName)
{
try{
Classifier* classifier=NULL;


switch (algType)
{
case aNB: classifier=new NB(sample, classPosition, algorithmParameters, verbosity, lossFunction); break;
case aTAN: classifier=new TAN(sample, classPosition, algorithmParameters, verbosity, lossFunction); break;
case aGTAN: classifier=new AN(sample, classPosition, algorithmParameters, verbosity, lossFunction); break;
case aUAN: classifier=new UAN(sample, classPosition, algorithmParameters, verbosity, lossFunction); break;
case aC45: classifier=new C45(sample, classPosition, algorithmParameters, verbosity, lossFunction, fileName); break;
case aNN: classifier=new KNN(sample, classPosition, algorithmParameters, NULL, verbosity, lossFunction); break;
case aContinuousC45: classifier=new C45(sample, classPosition, algorithmParameters, discMod, verbosity, lossFunction, fileName); break;
case aEM: classifier=new EMClassifier<int>(sample, classPosition, algorithmParameters, verbosity, lossFunction); break;
case aLogReg: classifier=new LogisticRegression(sample, classPosition, algorithmParameters, verbosity, lossFunction); break;
default: {cout <<"\nError in ClassifierTest::getClassifier: This learning algorithm is not implemented yet."; end();}
}

return classifier;
}
catch (BasicException & be) {be.addMessage ("\ncalled from Classifier* Classifier::getClassifier(AlgType algType, DiscMode discMod, floatList* discretization, int classPosition, floatList* algorithmParameters, VerbosityClass* verbosity, LossFunction* lossFunction, floatMLSample* sample)"); throw;};

}
	/*__________________________________________________________________________________ */

Classifier* Classifier::getClassifier(InputTUI* inputTUI)
{
try
{
char fileMas[256]="\0";;
changeExtension(inputTUI->filename, fileMas, "mas");


int totalAtts=getTotalColumns(inputTUI->filename);
cout <<"There are " << totalAtts-1 <<" attributes in the sample\n";

//exit(0);
if (!fileExists(fileMas)) {throw ErrorFile(fileMas, "Classifier* Classifier::getClassifier(InputTUI* inputTUI)");}

//if (inputTUI->testMode!=tHoldout) {throw BadFormat("Classifier* Classifier::getClassifier(InputTUI*inputTUI)");}

if (inputTUI->verbosity->getValue().progress)
  cout << "Reading floatMLSample from file " << inputTUI->filename <<"\n";

floatMLSample* sample=new floatMLSample(inputTUI->filename, inputTUI->verbosity);

if (inputTUI->verbosity->getValue().progress)
  cout <<"Actually getting classifier\n";
return Classifier::getClassifier(inputTUI->algType, inputTUI->discMode, inputTUI->discretization, sample->listOfAttributes->size()-1, inputTUI->algorithmParameters, inputTUI->verbosity, NULL, sample);

zap(sample);
/*
val=classifierTest->getAveragedAccuracy(inputTUI);
// if (inputTUI->verbosity.verbosityR.accuracy)
cout << "\nAUC: " << val->set.AUC << "\n";
cout << "\nAcc: " << val->set.averageAccuracy << "\n";
cout << "\nEsp: " << val->set.true_PredictedTable->getValue(0,0)/ (val->set.true_PredictedTable->getValue(0,0)+val->set.true_PredictedTable->getValue(0,1))<< "\n";


cout << "\nSens: " << val->set.true_PredictedTable->getValue(1,1)/ (val->set.true_PredictedTable->getValue(1,0)+val->set.true_PredictedTable->getValue(1,1))<< "\n";

if (inputTUI->verbosity->verbosityR.true_predictedValues)
cout << "\nTrue/Predicted table:\n" << *val->set.true_PredictedTable << "\n";

*/
}
catch ( BasicException& be ) {be.addMessage ( "\ncalled from Classifier::getClassifier(InputTUI* inputTUI)" ); throw;};
}

	/*__________________________________________________________________________________ */

	Classifier::Classifier()
	{
classFrequencies=NULL;
listOfAttributes=NULL;
//distancesVector=NULL;
	};
	/*__________________________________________________________________________________ */
	/*
	 void Classifier::extractDistancesVector(int firstPosition)
	{
	 if (parameterList->size()!=(firstPosition+totalAttributes))
	{
	cout <<"Error in Classifier::extractDistancesVector(algorithm, fisrtPosition), physical positions not found in " << *parameterList << "\ntotal is : " << parameterList->size() << " and the total number of attributes is: " << totalAttributes;
	end();
	}
	else
	{
	distancesVector=new floatList();
	for (int i=0;i<totalAttributes;i++)
	distancesVector->insertElement(parameterList->getElement(i+firstPosition));
	}

	}
	   /*__________________________________________________________________________________ */

	void Classifier::set ( floatMLSample* sample, int classPosition, floatList* parameterList, VerbosityClass *verbosity, LossFunction* lossFunction )
	{
try
{


  this->classFrequencies=NULL;
		this->verbosity=verbosity;
		this->parameterList=parameterList;
		floatMLSample* asample=new floatMLSample ( *sample );
listOfAttributes=sample->listOfAttributes; //->clone();
		this->classPosition=classPosition;

//cout <<"list of attrs: " << *listOfAttributes << "\n";
//cout <<"sample is: " << *asample << "\n";
		totalClasses=asample->listOfAttributes->getElement ( classPosition )->getTotalModalidades();
		classAttribute=listOfAttributes->getElement ( classPosition );

		floatList * inputPattern;

		if ( lossFunction==NULL )
			this->lossFunction=new LossFunction ( totalClasses );
		else this->lossFunction=new LossFunction ( *lossFunction );

		totalAttributes=asample->listOfAttributes->GetTotalAttributes();

		totalSelectedAttributes=asample->listOfAttributes->getTotalSelectedAttributes();
		try
		{
			inputPattern= ( floatList * )asample->sample->getElement ( sample->sample->getFirst() );

			if ( totalAttributes!=inputPattern->size() )
				throw BadSize();
		}
		catch ( BadSize bs ) {bs.PrintMessage ( "Classifier::set", totalAttributes, inputPattern->size() ); }

		zap(asample);


}
catch (BasicException & be) {be.addMessage ("\ncalled from void Classifier::set ( floatMLSample* sample, int classPosition, floatList* parameterList, VerbosityClass *verbosity, LossFunction* lossFunction )"); throw;};

	};


	/*__________________________________________________________________________________ */

	Classifier::Classifier ( floatMLSample* sample, int classPosition, floatList* parameterList, VerbosityClass *verbosity, LossFunction* lossFunction )
	{
try
{
		set ( sample, classPosition, parameterList, verbosity, lossFunction );
}
catch (BasicException & be) {be.addMessage ("\ncalled from Classifier::Classifier ( floatMLSample* sample, int classPosition, floatList* parameterList, VerbosityClass *verbosity, LossFunction* lossFunction )"); throw;};
	}

	/*__________________________________________________________________________________ */

	Classifier::~Classifier()
	{
		zap ( lossFunction );
  zaparr(classFrequencies);
  //zap(listOfAttributes);
	};

	/*___________________________________________________________________*/
/*
int Classifier::getClass (int pattern)
	{
return sample->sample->getElement(pattern)->getElement(classPosition);
}
	/*__________________________________________________________________________________ */
/*
	floatMLSample* Classifier::GetSample()
	{
		return ( sample );
	};
	/*__________________________________________________________________________________ */
/*
	ListOfAttributes* Classifier::GetAttributeList()
	{
		return ( sample->listOfAttributes );
	};
	/*__________________________________________________________________________________ */
	/*
	  int Classifier::GetClassAttribute()
	  {
	    return (listOfAttributes->GetClassAttribute());
	  };
	  /*__________________________________________________________________________________ */
	/*
	  ClassAttribute* Classifier::GetClassAttributePointer()
	  {
	    return (classAttribute);
	  };

	

	/*__________________________________________________________________________________ */

	BidimensionalTable<float>* Classifier::getDecisionCounts ( floatMLSample* targetSample, int stochastic )
	{
try
{
		floatList *pattern=NULL;
		int classValue, estimatedClassValue=0;
		
		if ( verbosity!=NULL && verbosity->verbosityR.individualAccuracy )
		{
			cout <<"\n";
			for ( int i=0;i<totalClasses;i++ )
				cout <<"p(" << classAttribute->getName() <<"=" << classAttribute->getStringValue ( i ) <<")\t";
			cout <<"p(doubt)\t";
			cout <<"\n";
		}

		int j=0;
		int pos[2];
		BidimensionalTable<float>* decisionCounts=new BidimensionalTable<float> ( totalClasses, totalClasses+1 );
		decisionCounts->initialize();
		for (floatSample::iterator p=targetSample->sample->getFirst(); p!=targetSample->sample->end(); p++ )
		{
			if ( verbosity!=NULL && verbosity->verbosityR.progress )
				if ( j%100==0 ) cout << "\nItem " << j+1 << " of " << targetSample->sample->size();
			pattern=targetSample->sample->getElement ( p );
			classValue= ( int ) pattern->getElement ( classPosition );
//cout <<"pattern\n";
//cout <<*pattern << "\n";
			pattern->removeNode ( classPosition );
//cout <<"class pos:" << classValue <<"\n";
//cout <<"afterpattern\n";
//cout <<*pattern << "\n";

			if ( classAttribute->isMissing ( classValue ) ) throw MissingValue ( "Classifier::getDecisionCounts" );
//cout <<"\nsizeb is:" << pattern->size();

  // if (sample->listOfAttributes->size()!=2)
			estimatedClassValue=getDecision ( pattern, stochastic );
  // else estimatedClassValue=0;
			if ( verbosity!=NULL && verbosity->verbosityR.individualAccuracy )
				cout  << j << ": " << estimatedClassValue <<" [" << classValue << "]\n";
			pos[0]=classValue;
			pos[1]=estimatedClassValue;
			decisionCounts->addValue ( pos[0], pos[1], 1 );
			pattern->insertElementAtPos ( ( float ) classValue, classPosition );
			j++;
		}

		return ( decisionCounts );
}
catch (BasicException & be) {be.addMessage ("\ncalled from BidimensionalTable<float>* Classifier::getDecisionCounts ( floatMLSample* targetSample, int stochastic )"); throw;};
	}
	/*__________________________________________________________________________________ */

	PairOfDoublesVector*  Classifier::getROC ( floatMLSample* targetSample, int stochastic )
	{
PairOfDoublesVector* result;
		if ( totalClasses!=2 ) throw BadFormat ( "float Classifier::getROC ( floatMLSample* targetSample, int stochastic )" );

  Pair<doubleList*> *values=getResults(targetSample, stochastic);
  result=computeROC(values->getFirst(), values->getSecond());
  zap(values);
		return result;
	}
/*__________________________________________________________________________________ */

	float Classifier::getAUC ( PairOfDoublesVector* roc )
	{
		if ( totalClasses!=2 ) throw BadFormat ( "float Classifier::getAUC ( PairOfDoublesVector* roc)" );
	return computeAUC(roc);
}
	/*__________________________________________________________________________________ */

	Pair<doubleList*>* Classifier::getResults ( floatMLSample* targetSample, int stochastic )
	{
  Pair<doubleList*> *result=new Pair<doubleList*>();
  result->First=new doubleList();
  result->Second=new doubleList();
		if ( totalClasses!=2 ) throw BadFormat ( "float Classifier::getAUC ( floatMLSample* targetSample, int stochastic )" );
		floatList *pattern=NULL;
		int classValue, estimatedClassValue=0;
		
		doubleList* positives=result->getFirst(), *negatives=result->getSecond();

		for( floatSample::iterator p=targetSample->sample->getFirst(); p!=targetSample->sample->end(); p++ )
		{
			pattern=targetSample->sample->getElement ( p );
			classValue= ( int ) pattern->getElement ( classPosition );
			pattern->removeNode ( classPosition );
			if ( classAttribute->isMissing ( classValue ) ) throw MissingValue ( "Classifier::getDecisionCounts" );
			zaparr ( classFrequencies );
			classFrequencies=getClassFrequencies ( pattern );
			if ( classValue == 1 ) positives->insertElement ( classFrequencies[1] );
			else negatives->insertElement ( classFrequencies[1] );
			zaparr ( classFrequencies );
			pattern->insertElementAtPos ( ( float ) classValue, classPosition );
		}
		return result;
	}

	/*__________________________________________________________________________________ */

	int Classifier::getDecision ( floatList* targetInputPattern, int stochastic )
	{
		try
		{
   zaparr(classFrequencies);
			classFrequencies=getClassFrequencies ( targetInputPattern );
			if ( sum ( classFrequencies, totalClasses ) !=0 )
				normalize ( classFrequencies, totalClasses );
			int decision=0;
			decision=getDecision ( classFrequencies, stochastic );
			zaparr ( classFrequencies );
			return decision;
}
catch (BasicException & be) {be.addMessage ("\ncalled from int Classifier::getDecision ( floatList* targetInputPattern, int stochastic )"); throw;};
	}
	/*__________________________________________________________________________________ */

	int Classifier::getDecision ( double* probs, int stochastic )
	{
try
{
		double *copyProbs=new double[totalClasses];
		for ( int i=0;i<totalClasses;i++ )
		{
			copyProbs[i]=probs[i];
		}
		Multinomial* multinomial=NULL;
		intList* ties=new intList();
		if ( verbosity!=NULL && Classifier::verbosity->verbosityR.individualAccuracy )
		{
			cout << "[";
			for ( int i=0;i<=totalClasses;i++ )
			{
				printf ( "%0.8f", copyProbs[i] );
				if ( i<totalClasses ) cout <<"\t "; else cout << "]\t";
			}
		}
		int maxClass;
		double max, secondMax=-1;
		bool tie=true;
		maxClass=GetMaxPos ( copyProbs, totalClasses );
		max=copyProbs[maxClass];
		ties->insertElement ( maxClass );
		do
		{
			copyProbs[maxClass]=-1;
			maxClass=GetMaxPos ( copyProbs, totalClasses );
			if ( secondMax==-1 ) secondMax=copyProbs[maxClass];
			if ( copyProbs[maxClass]==max ) ties->insertElement ( maxClass );
			else tie=false;
		}
		while ( tie==true );
		int result=ties->getElement ( ( int ) rand() %ties->size() );
		zap ( ties );
		if ( ( max-secondMax ) <lossFunction->decisionThreshold ) {zaparr ( copyProbs ); return totalClasses;}
		else if ( stochastic )
		{
			multinomial=new Multinomial ( 1, totalClasses, probs );
			result=multinomial->getNextValue();
			zap ( multinomial );
		}
		zaparr ( copyProbs );
		return result;
}
catch (BasicException & be) {be.addMessage ("\ncalled from 	int Classifier::getDecision ( double* probs, int stochastic )"); throw;};

	};
	/*___________________________________________________________ */

	floatList* Classifier::completeMissing ( floatMLSample* targetSample, int stochastic )
	{
		floatList* completedClassValues=new floatList();
		floatSample::iterator p;
		floatList* pattern;
		p=targetSample->sample->getFirst();
		int classValue;
//cout << "stochastic:" << stochastic;
		while ( p!=targetSample->sample->end() )
		{
			pattern=targetSample->sample->getElement ( p );
			classValue= ( int ) pattern->getElement ( classPosition );
			pattern->removeNode ( classPosition );
			if ( classAttribute->isMissing ( classValue ) )
				completedClassValues->insertElement ( ( float ) getDecision ( pattern, stochastic ) );
			else completedClassValues->insertElement ( ( float ) classValue );
			pattern->insertElementAtPos ( ( float ) classValue, classPosition );
			p=targetSample->sample->getNext ( p );
		}
		return completedClassValues;
	}
	/*__________________________________________________________________________________ */

	int* Classifier::getInferedMissing ( floatMLSample* targetSample, int stochastic )
	{
		int* allFrequencies=Initialize ( totalClasses, 0 );
		floatList* complete=completeMissing ( targetSample, stochastic );

		floatList::iterator p=complete->getFirst();

		while ( p!=complete->end() )
		{
			allFrequencies[ ( int ) complete->getElement ( p ) ]++;
			p=complete->getNext ( p );
		}
		zap ( complete );
		return allFrequencies;

	}

	/*___________________________________________________________ */

	ClassificationResults* Classifier::getAccuracy ( floatMLSample* testSample, int stochastic )
	{
try
{
// originalSample is the one used to build the classifier without missing class values removed
		int* allFrequencies=NULL, *knownFrequencies=NULL;
		float size=testSample->getSize();
//cout <<"threshold:" << lossFunction->decisionThreshold;
//cout <<*decisionCounts;
		double lost=0, freq;
		float uncovered=0;
		floatSample::iterator p;
		floatList* pattern;
		ClassificationResults *results=new ClassificationResults();
		int totalMissing=0, classValue;
  Pair<doubleList*> *values=NULL;
 // if (sample->listOfAttributes->size() !=2)

		results->set.true_PredictedTable=getDecisionCounts ( testSample, stochastic );
 // else results->set.true_PredictedTable=new BidimensionalTable<float> ( totalClasses, totalClasses+1 );

 // if (sample->listOfAttributes->size() !=2)
  if ( totalClasses==2 ) 
{

  results->set.ROC=getROC ( testSample, stochastic );

results->set.ROC->setOutputSeparator('\n');
//cout <<*results->set.ROC <<"\n";


  results->set.AUC=getAUC (results->set.ROC );

cout <<"AUC:" << results->set.AUC <<"\n";
  results->set.resultsforBinaryClassifiers=getResults(testSample, stochastic);

}
//  if (sample->listOfAttributes->size() !=2)
		for ( int i=0;i<results->set.true_PredictedTable->getSize();i++ )
		{
			lost=lost+results->set.true_PredictedTable->MultidimensionalTable<float>::getValue ( i ) *lossFunction->lossFunctionTable->MultidimensionalTable<float>::getValue ( i );
			if ( ( i+1 ) % ( totalClasses+1 ) ==0 )
				uncovered=uncovered+results->set.true_PredictedTable->MultidimensionalTable<float>::getValue ( i );
//size=size-decisionCounts->getValue(i);
		}
		MIDistances* mIDistances=NULL;
		float mean= ( ( float ) size-lost ) / ( float ) size;
		results->set.averageAccuracy=mean;
//cout <<"accuracy first is:" << accuracy.First;
		results->set.sd=getAccuraciesSampleSD ( ( int ) ( size-lost ), ( int ) size );
		results->set.totalClasses=totalClasses;

//if (results.true_PredictedTable!=NULL)
//cout << *results.true_PredictedTable;
//ClassificationResults* r=new ClassificationResults(results);
		return results;
}
catch (BasicException & be) {be.addMessage ("\ncalled from 	ClassificationResults* Classifier::getAccuracy ( floatMLSample* testSample, int stochastic )"); throw;};
	}
	/*
	 void Classifier::printStructure(ostream& out)
	 {
	    throw NonImplemented("Classifier::printStructure(ostream& out)"); 
	 }*/
	
};  // Fin del Namespace


#endif



/* Fin Fichero: Classifier.cpp */
