/* File: Classifier.h */


#ifndef __Classifier_h__
#define __Classifier_h__



//char FileName[63]; // para c45



namespace BIOS
{



  /*************************/
  /* Classifier DEFINITION */
  /*************************/


  /**
          @memo Classifier 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
	
	A classifier is built from sample by using the selected attributes in a listOfAttributes. 
	Different classes are defined depending on the algorithm required to learn the classifier.
	If the algorithm to learn a classifer requires discreted attributes, listOfAttributes must contain the intervals for all the continuous attributes. 
  */

class InputTUI;

  class Classifier
  {



  	  public:
	  
	  //  floatMLSample* sample;
	    
	    ListOfAttributes* listOfAttributes;

LossFunction* lossFunction;

double* classFrequencies;


//BayesType bayesType;

   int classPosition;

  int totalClasses;
   int totalAttributes, totalSelectedAttributes;

  Attribute *classAttribute;

    char line[256];
    
  VerbosityClass *verbosity;

floatList *parameterList;
   // floatList* selection;

    /* PUBLIC FUNCTIONS (INTERFACE) */


  public:

static Classifier* getClassifier(AlgType algType, DiscMode discMod, floatList* discretization, int classPosition, floatList* algorithmParameters, VerbosityClass* verbosity, LossFunction* lossFunction, floatMLSample* sample, char* fileName=NULL);

static Classifier* getClassifier(InputTUI* inputTUI);
    
     Classifier();


    Classifier(floatMLSample* sample, int classPosition, floatList* parameterList, VerbosityClass* verbosity=NULL, LossFunction* lossFunction=NULL);

  //  virtual void extractDistancesVector()=0;

    //void extractDistancesVector(int firstPosition);

    void set(floatMLSample* sample, int classPosition, floatList* parameterList, VerbosityClass* verbosity, LossFunction* lossFunction=NULL);
 
   void setValues(floatMLSample* sample, int classPosition);

    int GetMatches(floatMLSample* sample);

 BidimensionalTable<float>* getDecisionCounts(floatMLSample* sample, int stochastic);


    char* print(){};

    //virtual void setClassifier(){cout << "error in Classifier:setClassifier";exit(0);};

    virtual ~Classifier();

    int GetTrainingMatches();

    //  int GetSampleSize(){return sample->size();};

//    floatMLSample* GetSample();

  //  ListOfAttributes* GetAttributeList();

   	Pair<doubleList*>* getResults ( floatMLSample* targetSample, int stochastic );

//   int getClass(int pattern);
   
    virtual double* getClassFrequencies(floatList* inputPattern)=0;// {cout <<"error in Classifier:GetClass"; exit(0);};

 //   int GetClassAttribute();

   // ClassAttribute* GetClassAttributePointer();

ClassificationResults* getAccuracy(floatMLSample* testSample, int stochastic);

float getAUC ( PairOfDoublesVector* roc );
PairOfDoublesVector*  getROC ( floatMLSample* targetSample, int stochastic );
int getDecision (double* classFrequencies, int stochastic); 
int getDecision (floatList* targetInputPattern, int stochastic);
floatList* completeMissing(floatMLSample* testSample, int stochastic);

 int* getInferedMissing(floatMLSample* targetSample, int stochastic);
 
 virtual void printStructure(ostream& out)=0;
 
  protected:

     bool isSet(){cout <<"error in Classifier:isSet"; exit(0);};

     
    

 
  };  // End of class Classifier



ostream& operator<<(ostream& out, Classifier& classifier)
       {

//out <<"Classifier was learnt from sample\n" << *classifier.sample;
out <<"Loss function is\n" << *classifier.lossFunction;
out <<"Class is at position: "<< classifier.classPosition <<"\n";
out <<"and is defined as " << *classifier.classAttribute;
}


};  // Fin del Namespace

#endif


//#include "Classifier.cpp"

/* Fin Fichero: Classifier.h */
