#ifndef ClassifierTest_cpp//
#define ClassifierTest_cpp//






//using namespace UTILS;

namespace BIOS {


/*___________________________________________________________ */

void ClassifierTest::set(TestMode testMod, int numberOfFolds, VerbosityClass *verbosity, int classPosition, floatMLSample* wholeSample, floatMLSample* trainingSample, floatMLSample* testSample, LossFunction* lossFunction)
{
try
{
if (verbosity->verbosityR.progress) 
cout << "\nLearning phase...";
selectedAttributes=NULL;
completedClasses=NULL;
this->lossFunction=lossFunction;
this->trainingSample=NULL;
this->testSample=NULL;
this->verbosity=verbosity;
testMode=testMod;
this->numberOfFolds=numberOfFolds;
this->classPosition=classPosition;
this->originalClassPosition=classPosition;
this->algorithmParameters=NULL;
this->wholeSample=wholeSample;
switch (testMode)
{
case tLeaveOneOut:
case tCrossValidation:
if (trainingSample!=NULL || testSample!=NULL || wholeSample==NULL) 
if (trainingSample!=NULL)
throw BadFormat(string("Error 1-a in ClassifierTest::ClassifierTest")+string(", trainingSample is not null")); 
else
if  (testSample!=NULL)
throw BadFormat(string("Error 1-a in ClassifierTest::ClassifierTest")+string(", testSample is not null")); 
else
if (wholeSample==NULL) 
throw BadFormat(string("Error 1-a in ClassifierTest::ClassifierTest")+string(", wholeSample is null")); 
this->wholeSample=new floatMLSample(*wholeSample);
//this->wholeSample->removeMissingPatterns();
//clase=sample->sample->getElement(sample->sample->getFirst())->size()-1;
//sampleSize=sample->getSize();3
break;
case tTraining:
if (wholeSample!=NULL || trainingSample==NULL || testSample!=NULL)
throw BadFormat("Error 2 in ClassifierTest::ClassifierTest"); 
this->trainingSample=new floatMLSample(*trainingSample);
this->testSample=new floatMLSample(*trainingSample);
//this->trainingSample->removeMissingPatterns();
break;
case tHoldout:
if (testSample==NULL || wholeSample!=NULL || trainingSample==NULL)
throw BadFormat("Error 3 in ClassifierTest::ClassifierTest"); 
this->trainingSample=new floatMLSample(*trainingSample);
//this->trainingSample->removeMissingPatterns();
this->testSample=new floatMLSample(*testSample);
break;
}
}
catch (BasicException & be) {be.addMessage ("\ncalled from CClassifierTest::set(TestMode testMod, int numberOfFolds, VerbosityClass *verbosity, int classPosition, floatMLSample* wholeSample, floatMLSample* trainingSample, floatMLSample* testSample, LossFunction* lossFunction)"); throw;};

};
/*___________________________________________________________ */

ClassifierTest::ClassifierTest(floatMLSample* wholeSample, floatMLSample* trainingSample, floatMLSample* testSample, TestMode testMod, int numberOfFolds, VerbosityClass* verbosity, int classPosition, LossFunction* lossFunction)
{
try
{
set(testMod, numberOfFolds, verbosity, classPosition, wholeSample, trainingSample, testSample, lossFunction);
}
catch (BasicException & be) {be.addMessage ("\ncalled fromClassifierTest::ClassifierTest(floatMLSample* wholeSample, floatMLSample* trainingSample, floatMLSample* testSample, TestMode testMod, int numberOfFolds, VerbosityClass* verbosity, int classPosition, LossFunction* lossFunction)"); throw;};

};
/*___________________________________________________________ */

ClassificationResults* ClassifierTest::getAveragedAccuracy(InputTUI * inputTUI)
{
try
{
return getAveragedAccuracy(inputTUI->algType, inputTUI->discMode, inputTUI->algorithmParameters, inputTUI->discretization, inputTUI->selMode, inputTUI->selection, NULL, inputTUI->stochastic, inputTUI->filename, inputTUI->secondFilename);
}
catch (BasicException & be) {be.addMessage ("\ncalled from ClassificationResults* ClassifierTest::getAveragedAccuracy(InputTUI * inputTUI)"); throw;};
}
/*___________________________________________________________ */

ClassificationResults* ClassifierTest::getAveragedAccuracy(AlgType algType, DiscMode discMod, floatList* algorithmParameters, floatList* discretization, SelMode selMode, floatList* selection, char* selectionFile, int stochastic, char* filename, char * secondFilename)//, floatList* positions)
{
try
{
if (algorithmParameters==NULL) throw NullValue("ClassificationResults* ClassifierTest::getAveragedAccuracy(AlgType algType, DiscMode discMod, floatList* algorithmParameters, floatList* discretization, SelMode selMode, floatList* selection, char* selectionFile, int stochastic)");
if (verbosity->verbosityR.progress) 
cout << "\nbuilding the model ...";
ClassificationResults* accuracy;



this->algorithmParameters=algorithmParameters;
switch(testMode)
{
case tLeaveOneOut: accuracy=LeaveOneOut(algType, discMod, discretization, selMode, stochastic, filename, secondFilename, selection, selectionFile); break;
case tCrossValidation: accuracy=CrossValidation(algType, discMod, discretization, selMode,  stochastic, filename, secondFilename, selection, selectionFile); break;
case tHoldout:  accuracy=Holdout(algType, discMod, discretization, selMode,  stochastic, filename, secondFilename, selection, selectionFile); break;
//cout <<"later"; break;
case tTraining: accuracy=Training(algType, discMod, discretization, selMode,  stochastic, filename, secondFilename, selection, selectionFile); break;
default: throw BadFormat("\nClassifierTest::getAveragedAccuracy. testMode"); break;
}
return accuracy;
}
catch (BasicException & be) {be.addMessage ("\ncalled from ClassificationResults* ClassifierTest::getAveragedAccuracy(AlgType algType, DiscMode discMod, floatList* algorithmParameters, floatList* discretization, SelMode selMode, floatList* selection, char* selectionFile, int stochastic)"); throw;};
};
/*___________________________________________________________________*/

ClassifierTest::~ClassifierTest()
{ 
zap(trainingSample);
zap(testSample);
zap(selectedAttributes);
zap(wholeSample);
zap(completedClasses);
};
/*___________________________________________________________ */

intList* ClassifierTest::selectAttributes(SelMode selMode, AlgType algType, char* filename, char* secondFilename, floatList*selection, char* selectionFile)
{
try{
intList *selectedAttributes=NULL;
VerbosityClass* verbosity2=new VerbosityClass();
verbosity2->verbosityR.selectionScores=verbosity->verbosityR.selectionScores;
verbosity2->verbosityR.accuracy=true;
if (selMode!=todos)
{
classPosition=originalClassPosition;
floatMLSample* temp=NULL;
//if (trainingSample!=NULL)
zap (selectedAttributes);
selectedAttributes=trainingSample->select(classPosition, algType, selMode, verbosity2, lossFunction, filename, secondFilename, selection, selectionFile, algorithmParameters);//, positions);
zap(verbosity2);
}
return selectedAttributes;
}
catch (BasicException & be) {be.addMessage ("\ncalled from void ClassifierTest::selectAttributes(SelMode selMode, AlgType algType, floatList*selection, char* selectionFile)"); throw;};
}
/*___________________________________________________________ */

floatMLSample* ClassifierTest::getTrainingSample()
{
return trainingSample;
}
/*___________________________________________________________ */

floatMLSample* ClassifierTest::getTestSample()
{
return testSample;
}
/*___________________________________________________________ */

floatMLSample* ClassifierTest::getSample()
{
return wholeSample;
}
/*___________________________________________________________ */

void ClassifierTest::discretizeAttributes(DiscMode discMod, AlgType algType, floatMLSample* sample)
{
if (discMod!=NoDiscretization)
{
sample->listOfAttributes->removeIntervals();
sample->setIntervals(discMod, true, verbosity, classPosition);// true is supervised
if (sample->listOfAttributes->isContinuous())
if (verbosity->verbosityR.attributeDescription) 
cout << "\n" << *sample->listOfAttributes;
}
else
if (!sample->listOfAttributes->isDiscretized() && AlgTypeClass::requiresDiscretization(algType))
 {
	 cout <<"Error in ClassifierTest::discretizeAttributes, sample has continuous variables and you have chosen not to discretize.\n";
	 exit(0);
 }
//cout <<"m4";
}

/*____________________________________________________________________________________ */

Classifier* ClassifierTest::getClassifier(AlgType algType, DiscMode discMod, floatList* discretization, floatMLSample* sample, int currentClassPosition, char* filename)
{
//cout <<*trainingSample;
//cout <<"\nclasspos is" << classPosition;
try
{
return Classifier::getClassifier(algType, discMod, discretization, currentClassPosition, algorithmParameters, verbosity, lossFunction, sample, filename);
}
catch (ZeroValue zv){zv.PrintMessage("ClassifierTest::getClassifier");end();}

}
/*____________________________________________________________________________________ */

ClassificationResults* ClassifierTest::CrossValidation(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* selectionList, char* selectionFile)
{
try
{
int sampleSize=wholeSample->getSize();
ClassificationResults* result=new ClassificationResults();
int aciertos=0, foldSize, resto, last;
testSample=NULL, trainingSample=NULL;
ClassificationResults** partialResult=new ClassificationResults*[numberOfFolds];
resto=sampleSize%numberOfFolds;
 last=0;
 Sampling *sampling;
 sampling=new Sampling(sampleSize, false);

for (int i=0;i<numberOfFolds;i++)
 {
//cout << "fold is "<< i << "\n";
 foldSize=sampleSize/numberOfFolds;
 if ((resto>0) && (i<resto)) foldSize=foldSize+1;
 intList* indexVector=new intList();
 for (int j=0;j<foldSize;j++) 
  indexVector->insertElement(sampling->Pos[i*foldSize+j]);


 trainingSample=new floatMLSample(*wholeSample);

testSample=trainingSample->extractRowsWithPositionsIn(indexVector);

zap(indexVector);

//cout <<"\npos:" << *trainingSample->listOfAttributes->positionsVector;
partialResult[i]=Holdout(algType, discMod, discretization, selMode, stochastic, filename, secondFilename, selectionList, selectionFile);


//cout <<"FF:" << partialResult[i].First;
//partialResult[i]=new ClassificationResults();
zap(trainingSample);

zap(testSample);

  }

zap(sampling);
result->GetMean(partialResult, numberOfFolds);
zaparr(partialResult); //, numberOfFolds);
return result;
}
catch (BasicException & be) {be.addMessage ("\ncalled from ClassificationResults* ClassifierTest::CrossValidation(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, floatList* selectionList, char* selectionFile)"); throw;};

//return partialResult[0];
}
/*____________________________________________________________________________________ */

ClassificationResults* ClassifierTest::Holdout(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* selectionList, char* selectionFile)
{
try
{
floatMLSample *testCopy=NULL, *trainingCopy=NULL;
if (algType==aContinuousC45 && !this->trainingSample->listOfAttributes->isContinuous())
throw BadFormat("\nClassifierTest::getAveragedAccuracy. We recommend to use non continuous C45 (-a=4), as there is no continuous atts in this data set\n");
if (testSample->listOfAttributes->getElement(classPosition)->isContinuous())
throw BadFormat(string("\nClassifierTest::getAveragedAccuracy. Attribute at position ")+tos(classPosition)+string(" is continuous so cannot be used as a class")); 
this->trainingSample->removePatternsWithMissingAttribute(classPosition);
classPosition=originalClassPosition;
ClassificationResults* accuracy;
Classifier* classifier=NULL;
if (discMod!=NoDiscretization) discretizeAttributes(discMod, algType, trainingSample);
intList *selectedAttributes=selectAttributes(selMode, algType, filename, secondFilename, selectionList, selectionFile);
int currentClassPosition=classPosition;


if (selectedAttributes!=NULL)
{
trainingSample->listOfAttributes->select(selectedAttributes);
trainingCopy=trainingSample->copySelection();
testSample->listOfAttributes->select(selectedAttributes);
testCopy=testSample->copySelection();

int max=classPosition;
selectedAttributes->sort();
for (int i=0; i<max;i++)
  if (selectedAttributes->findElement(i)==selectedAttributes->end())
   currentClassPosition--;

if (selectedAttributes->findElement(classPosition)==selectedAttributes->end())
{
cout << "class should be selected\n";
throw BadFormat("ClassificationResults* ClassifierTest::Holdout(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, floatList* selectionList, char* selectionFile)");
}
}
else
{
trainingCopy=trainingSample->clone();
testCopy=testSample->clone();
}

if (verbosity->verbosityR.progress) 
cout << "\nlearning parameters ...";


classifier=getClassifier(algType, discMod, discretization, trainingCopy, currentClassPosition, filename);

//algType, discMod, discretization, classPosition, algorithmParameters, verbosity, lossFunction, sample
if (verbosity->verbosityR.progress) 
cout << "\nTesting phase ...";
accuracy=classifier->getAccuracy(testCopy, stochastic);

zap(classifier);
zap(testCopy);
zap(trainingCopy);
zap(selectedAttributes);
return accuracy;
}
catch (BasicException & be) {be.addMessage ("\ncalled from ClassificationResults* ClassifierTest::Holdout(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, floatList* selectionList, char* selectionFile)"); throw;};
}
/*____________________________________________________________________________________ */

ClassificationResults* ClassifierTest::Training(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* selectionList, char* selectionFile)
{
return Holdout(algType, discMod, discretization, selMode, stochastic, filename, secondFilename, selectionList, selectionFile);
}

/*____________________________________________________________________________________ */

ClassificationResults* ClassifierTest::LeaveOneOut(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* selectionList, char* selectionFile)
{
numberOfFolds=wholeSample->getSize();
return CrossValidation(algType, discMod, discretization, selMode, stochastic, filename, secondFilename, selectionList, selectionFile);
}
} // end namespace
#endif
