#ifndef ClassifierTest_h//
#define ClassifierTest_h//






namespace BIOS {


class InputTUI;


////////////////////////////
class ClassifierTest {

/** This class is used to obtain the accuracy of a learning algorithmParameters.
If the algorithmParameters requires discrete attributes, a filtered discretization is done for each subsample in the class Classifier, so that a classifier will be learnt from that
subsample with discretized attributes.
If the algorithmParameters requires selection, a filtered selection is done for each subsample in the class Classifier, so that a classifier will be learnt from that
subsample with selected attributes.
If the goal is to compare different ways to apply discretization (i.e., filtered and/or embeded versus wrapped), class DiscretizationTest should be impemented. 
It allows to obtain average accuracy and sd of a classifier using a given sample, testMode with numOfFolds, trainingSample, discMode, listOfAttributes and parameterList.

*/
public:
intList* selectedAttributes;

floatList* completedClasses;



private:


//char filename[256];
char line[256];
int sampleSize;
TestMode testMode;
int numberOfFolds;
floatMLSample* trainingSample, * testSample, *wholeSample;


private:


int classPosition, originalClassPosition;
//floatList* positions;
floatList* algorithmParameters;
//// methods

ClassificationResults* Holdout(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* attList=NULL, char* selectionFile=NULL);
ClassificationResults* Training(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* attList=NULL, char* selectionFile=NULL);
ClassificationResults* LeaveOneOut(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* attList=NULL, char* selectionFile=NULL);
ClassificationResults* CrossValidation(AlgType algType, DiscMode discMod, floatList* discretization, SelMode selMode, int stochastic, char* filename, char* secondFilename, floatList* attList=NULL, char* selectionFile=NULL);
int GetMatches(Classifier * classifier);
void set(TestMode testMod, int numberOfFolds, VerbosityClass *verbosity, int classPosition, floatMLSample* sample, floatMLSample* trainingSample, floatMLSample* testSample, LossFunction* lossFunction);
void discretizeAttributes(DiscMode discMod, AlgType algType, floatMLSample* sample);
ClassificationResults* getAccuracy(Classifier* classifier);
intList* selectAttributes(SelMode selMode, AlgType algType, char* filename, char* secondFilename, floatList*selection=NULL, char* selectionFile=NULL);
Classifier* getClassifier(AlgType algType, DiscMode discMod, floatList* discretization, floatMLSample* sample, int currentClassPosition, char* filename);

public:
VerbosityClass *verbosity;
LossFunction* lossFunction;

//ClassifierTest(char texto[128], unsigned int dependiente, intList*parameterLis);
ClassifierTest(floatMLSample* sample, floatMLSample* trainingSample, floatMLSample* testSample, TestMode testMod, int numberOfFolds, VerbosityClass *verbosity, int classPosition, LossFunction* lossFunction);
//ClassifierTest(char filename[256], TestMode testMod, int numberOfFolds, intList* verbosity, int classPosition);
~ClassifierTest();
ClassificationResults* getAveragedAccuracy(AlgType algType, DiscMode discMod, floatList* algorithmParameters, floatList* discretization, SelMode selMode, floatList*selection, char* selectionFile, int stochastic, char* filename, char* secondFilename);
ClassificationResults* getAveragedAccuracy(InputTUI * inputTUI);
//MLSample *getSample();
floatMLSample* getTrainingSample();
floatMLSample* getTestSample();
floatMLSample* getSample();
};

} // end namespace
#endif

