/* File: DiscreteEM.cpp */

#ifndef __DiscreteEM_cpp__
#define __DiscreteEM_cpp__


#include "DiscreteEM.h"

//using namespace UTILS;


namespace BIOS {




/*____________________________________________________________________________________ */



/*____________________________________________________________________________________ */

DiscreteEM::DiscreteEM(floatMLSample* sample, int att, floatList* parameterList, VerbosityClass verbosity, LossFunction* lossFunction, int iterations):EM(sample, att, parameterList, verbosity, lossFunction, iterations)
{	
frequencyTable=NULL;
MLEstimations=NULL;
};

/*____________________________________________________________________________________ */

DiscreteEM::DiscreteEM():EM()
{
frequencyTable=NULL;
MLEstimations=NULL;
};

/*____________________________________________________________________________________ */

DiscreteEM::~DiscreteEM()
{
zap (frequencyTable);
zap(MLEstimations);
};
/*____________________________________________________________________________________ */

double* DiscreteEM::getFrequencies()
{
int pos;
double *classFrequencies=new double[totalClasses];
intList* varList=new intList();
varList->insertElement(classPosition);
VarsTable<double> marginal=MLEstimations->marginalize(varList);
for (int i=0;i<totalClasses;i++)
 classFrequencies[i]=marginal->getValue(i);
zap (varList);
zap(marginal)
return classFrequencies; 
}

/*____________________________________________________________________________________ */

void DiscreteEM::setMLEstimations()
{
Multinomial* m=new Multinomial(1, MLEstimations->size()-1);
intList* varList=new intList(sample->listOfAttributes->size());
intList* dimensionList=sample->listOfAttributes->getDimensionList(varList));
MLEstimations=new VarsTable<double>(varList, dimensionList);
double* total=0.0;
for (int i=0; i<(MLEstimations->size()-1);i++)
{
 total=total+m->getProbs()[i];
 MLEstimations->setValue(i)=m->getProbs()[i];
}
 MLEstimations->setValue((MLEstimations->size()-1))=total;
//positionsOfCurrentPattern=
}
/*____________________________________________________________________________________ */

void DiscreteEM::setExpectation()
{
frequencyTable=new ProbabilityTable(sample->sample, sample->listOfAttributes);
floatSample::iterator p=NULL;
floatList* pattern;
float* tablePattern, *originalTablePattern=targetInputPattern->getTable();
Attribute* attribute;
intList* missingPos=new intList();
MultidimensionalTable<int>* table=NULL;
intList* dimensionList=new intList();
for (int c=0;c<targetInputPattern->size();c++)
{
attribute=sample->listOfAttributes->getElement(c);
if (attribute->isMissing(targetInputPattern->getElement(c)))
{
dimensionList->insertElement(attribute->GetTotalDimensions());
missingPos->insertElement(c);
}
}

table=new MultidimensionalTable(dimensionList);
zap(dimensionList);
for (int c=0;c<table->getSize();c++)
for (int i=0;i<dimensionList->getSize();i++)
{
originalTablePattern[missingPos->getElement(i)]=table->getIndexPositionOfIndexVar(c, i);
p=sample->sample->getFirst();
while (p!=NULL)
{
tablePattern=pattern->getTable();
frequencyTable->setValue(originalTablePattern, frequencyTable->getValue(originalTablePattern)+
MLEstimations->getValue(originalTablePattern)/MLEstimations->getValue(tablePattern);
zap(tablePattern);
p=sample->sample->getNext(p);
}
zap(originalTablePattern);
zap(table);
zap(missingPos);
}
/*____________________________________________________________________________________ */

void DiscreteEM::maximize()
{
for (int i=0; i<MLEstimations->size();i++)
  MLEstimations->setValue(i)=frequencyTable->getProbability(i);
zap(frequencyTable);
}
 /*___________________________________________________________ */

double* DiscreteEM::GetClassFrequencies(floatList* targetInputPattern)
{
this->targetInputPattern=targetInputPattern;
reducedSample=sample.getCompatibleSample(targetInputFile);
setMLEstimations();
runEMAlgorithm();
zap(reducedSample);
double* results=getFrequencies();
zap(MLEstimations);
return results;
};

 




};  // Fin del Namespace

#endif

/* Fin Fichero: DiscreteEM.cpp */
