/* File: EMClassifier.h */

#ifndef __EMClassifier_h__
#define __EMClassifier_h__



//using namespace UTILS;


namespace BIOS {



template <class T> class EMClassifier: public Classifier
{

protected:

int iterations;

MLSample<T>* sample;

VarsTable<double> * frequencyTable; // it computes the expectation of the sufficient statistics given the incomplete sample and the current MLEstimations

VarsTable<double> * knownFrequencyTable; // it computes the expectation of the sufficient statistics given the incomplete sample and the current MLEstimations


VarsTable<double> * MLEstimations; // it computes the MLE given the expectations


private:

void set(floatMLSample* sample, int iterations);
 void setMLEstimations();
 void runEMClassifierAlgorithm(int it=0);
 double* getFrequencies(struct Vector<T>::Class* inputPattern);
 void setExpectation();
 void setFrequencies();
 void maximize();

void set ();

public:



//EMClassifier(char* filename, floatList* parameterList);

EMClassifier(floatMLSample* sample, int att, floatList* parameterList, VerbosityClass *verbosity, LossFunction* lossFunction, int iterations=20);

	
~EMClassifier();

virtual double* getClassFrequencies(floatList* targetInputPattern);

 virtual void printStructure(ostream& out);

};
};  // Fin del Namespace

#endif

//#include "EMClassifier.cpp"
/* Fin Fichero: EMClassifier.h */
