/* File: LossFunction.h */


#ifndef __LossFunction_h__
#define __LossFunction_h__



//char FileName[63]; // para c45



namespace BIOS
{



  /*************************/
  /* LossFunction DEFINITION */
  /*************************/


  /**
          @memo LossFunction 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
	
	A LossFunction is built from sample by using the selected attributes in a listOfAttributes. 
	Different classes are defined depending on the algorithm required to learn the LossFunction.
	If the algorithm to learn a classifer requires discreted attributes, listOfAttributes must contain the intervals for all the continuous attributes. 
  */

  class LossFunction
  {


  public:
	  
	    

BidimensionalTable<float>* lossFunctionTable;

float decisionThreshold;



/*_____________________________*/

void set(int totalClasses)
{
int pos[2];
for (int i=0;i<totalClasses;i++)
{
pos[0]=i;
for (int j=0;j<totalClasses+1;j++)
{
pos[1]=j;
if (i!=j)
this->lossFunctionTable->MultidimensionalTable<float>::setValue(&pos[0], (float)1);
else this->lossFunctionTable->MultidimensionalTable<float>::setValue(&pos[0], (float)0);
}
}
decisionThreshold=0;
}

/*______________________________________________*/

LossFunction(int totalClasses)
{
this->lossFunctionTable=new BidimensionalTable<float>(totalClasses, totalClasses+1);
set(totalClasses);
}

/*______________________________________________*/

LossFunction(LossFunction & otherLossFunction)
{
this->lossFunctionTable=new BidimensionalTable<float>(*otherLossFunction.lossFunctionTable);
this->decisionThreshold=otherLossFunction.decisionThreshold;
}

/*______________________________________________*/

LossFunction(bool useFileForLossFunction, int totalClasses, char* filenameS)
{
int pos[2], totalRows;
char filename[256];
changeExtension(filenameS, filename, "los");
this->lossFunctionTable=new BidimensionalTable<float>(totalClasses, totalClasses+1);
//cout << "loos function is: " << useFileForLossFunction <<"\n";
if (! useFileForLossFunction || !fileExists(filename))
set(totalClasses);
else
if (useFileForLossFunction && !fileExists(filename))
{
cout <<"\nError in LossFunction(): file \".los\" does not exist and you have chosen to use a file for the loss function definition";
end();
}
else
{
TextFile* tf=new TextFile(filename);
totalRows=tf->getTotalLines();
if (totalRows!=(totalClasses*(totalClasses+1)+1))
{
cout << "Error in LossFunction";
end();
}
stringList* row;
for (int i=0;i<totalRows;i++)
{
row=tf->readLine();
if (i<(totalRows-1))
lossFunctionTable->MultidimensionalTable<float>::setValue(i, atof(row->getFirstElement().c_str()));
else decisionThreshold=atof(row->getFirstElement().c_str());
zap(row);
}
}
};

/*________________________________________*/

~LossFunction()
{
zap(lossFunctionTable);
};
};  // End of class LossFunction


ostream& operator<<(ostream& out, LossFunction& lossFunction)
       {
out <<"Loss function table: \n" << *lossFunction.lossFunctionTable;
out <<"Decision threshold is " << lossFunction.decisionThreshold<<"\n";
}


};  // Fin del Namespace

#endif


//#include "LossFunction.cpp"

/* Fin Fichero: LossFunction.h */
