#ifndef MIDistances_h//
#define MIDistances_h//



#include <fstream>
#include <string>
#include <stdio.h>//




namespace BIOS {





////////////////////////////
class MIDistances {


/** 
*/
public:

floatMLSample *originalSample, *completeSample;
int*allFrequencies, *knownFrequencies;
int totalClasses;

MIDistances(floatMLSample *originalSample, floatMLSample *completeSample)
{
this->originalSample=originalSample;
this->completeSample=completeSample;
set();
};

/*_____________________________________________________________*/


MIDistances()
{
this->originalSample=NULL;
this->completeSample=NULL;
set();
};
/*_____________________________________________________________*/


~MIDistances()
{
zaparr(allFrequencies);
zaparr(knownFrequencies);
}
/*_____________________________________________________________*/

private:


void set ()
{
allFrequencies=NULL;
knownFrequencies=NULL;
}
/*_____________________________________________________________*/

void getFrequencies(int classPosition)
{
// it computes the frequencies for the original sample (before some values were removed to use imputation) and after imputation
// knownFrequencies will have the true counts (i.e., using the original sample) for each class modality
// allFrequencies will have total counts after imputation (the values that were known in the original sample and were not removed plus the imputed values)
Attribute* classAttribute=originalSample->listOfAttributes->getElement(classPosition);
int totalClasses=classAttribute->getTotalModalidades();
zaparr(allFrequencies);
zaparr(knownFrequencies);
allFrequencies=Initialize(totalClasses, 0);
knownFrequencies=Initialize(totalClasses, 0);
int classValue, classValue2;
floatSample::iterator p=originalSample->sample->getFirst(), p2=completeSample->sample->getFirst();
while (p!=originalSample->sample->end())
{
classValue=(int)originalSample->sample->getElement(p)->getElement(classPosition);
classValue2=(int)completeSample->sample->getElement(p2)->getElement(classPosition);
// Note: classValue2 is equal to classValue when value was not removed for imputation
// if the value was not missing in the original sample we can count it:
if (!classAttribute->isMissing(classValue)) 
{
allFrequencies[classValue2]++;
knownFrequencies[classValue]++;
}
p=originalSample->sample->getNext(p);   
p2=completeSample->sample->getNext(p2);   
}
}

/*_____________________________________________________________*/
public:
double getEuclideanDistance(int* allFrequencies, int* knownFrequencies, int totalClasses)
{
float euclideanDistance=0;
int total=0, totalKnown=0;

for (int i=0;i<totalClasses;i++)
{
total=total+allFrequencies[i];
totalKnown=totalKnown+knownFrequencies[i];
}

if (total!=totalKnown)
{
cout <<"Error in MIDistance::getEuclideanDistance, total: " << total << " versus " << totalKnown;
end();
}

for (int i=0;i<totalClasses;i++)
euclideanDistance=euclideanDistance+std::pow(allFrequencies[i]/(float)total-knownFrequencies[i]/(float)totalKnown,2);

euclideanDistance=sqrt(euclideanDistance);

return euclideanDistance;
//cout << "fin:" << results.euclideanDistance;

}
/*_____________________________________________________________*/

double getEuclideanDistance(int classPosition)
{
if (allFrequencies==NULL || knownFrequencies==NULL)
if (originalSample==NULL || completeSample==NULL)
{
cout << "MIDistance::getEuclidenDistance(i)";
throw NullValue("MIDistance::getEuclidenDistance(i)");
end();
}
totalClasses=originalSample->listOfAttributes->getElement(classPosition)->getTotalModalidades();

getFrequencies(classPosition);
return getEuclideanDistance(allFrequencies, knownFrequencies, totalClasses);
};
/*_____________________________________________________________*/

};

} // end namespace
#endif

