/* File: TestModeClass.h */

#ifndef __TestModeClass_cpp__
#define __TestModeClass_cpp__



using namespace std;


namespace BIOS {


 	
TestModeClass::TestModeClass(TestMode tm, int parameter)
{
// parameter is numberOfFolds for crossValidation, rateTrainingTest for Holdout and fractionOfDefaultTrainingSize for Training

try
{
this->parameter=parameter;
this->tm=tm;
this->numberOfFolds=1;
this->fractionOfDefaultTrainingSize=1;
this->rateTrainingTest=1;
switch (tm)
{
case tCrossValidation:
this->numberOfFolds=parameter;
if (numberOfFolds<=0)
throw BadFormat("TestModeClass::TestModeClass(TestMode tm, int numberOfFolds)");
break;
case tTraining:
this->fractionOfDefaultTrainingSize=parameter;
if (fractionOfDefaultTrainingSize<1)
{
cout << "tm is:" << *this <<"\n";
throw BadFormat("TestModeClass::TestModeClass(TestMode tm, int numberOfFolds)");
}
break;
case tHoldout:
this->rateTrainingTest=parameter;
if ( rateTrainingTest!=1 && rateTrainingTest!=2)
{
// for holdout numberOfFolds means the ratio between the training and the test sample
cout << "tm is:" << *this <<"\n";
throw BadFormat("TestModeClass::TestModeClass(TestMode tm, int parameter)");
}
break;
}
}
catch (BasicException& be){be.addMessage("\ncalled from  TestModeClass::TestModeClass(TestMode tm, int numberOfFolds)"); throw;};
}

/*_______________________________________________________________________*/

TestModeClass* TestModeClass::clone()
{
return new TestModeClass(tm, parameter);
//else return new TestModeClass(tm);
}

/*_______________________________________________________________________*/

TestMode TestModeClass::getValue()
{
return tm;
}

/*_______________________________________________________________________*/

int TestModeClass::getNumberOfFolds()
{
return numberOfFolds;
}

/*_______________________________________________________________________*/
/*
void TestModeClass::setNumberOfFoldsTo2ForHoldout() // used for GWAS
{
if (tm==tHoldout) numberOfFolds=2;
}

/*_______________________________________________________________________*/

string TestModeClass::print ()
{
  switch (tm) //
  { //
   case tLeaveOneOut: return string("LeaveOneOut"); break;  //
   case tCrossValidation: return string("CrossValidation_fold")+tos(numberOfFolds);break; //
   case tHoldout: if (rateTrainingTest==1) return string("Holdout"); else return string("Holdout")+tos(rateTrainingTest); break; //
   case tTraining: if (fractionOfDefaultTrainingSize==1) return string("Training");  else return string("Training")+tos(fractionOfDefaultTrainingSize); break; //
  // case tHalfTraining: return string("HalfTraining"); break;
     } //
};

/*_______________________________________________________________________*/

char* TestModeClass::printLong ()
{
try
{
 strcpy(line, "\nTest mode:\t\t\t");
 strcat(line, print().c_str());
 if (tm==tCrossValidation) sprintf (line, "%s fold=%d", line, numberOfFolds);
return line;
}
catch (BasicException& be){be.addMessage("\ncalled from  char* TestModeClass::print ()"); throw;};
};

/*_______________________________________________________________________*/


string TestModeClass::getShortName()
{

	switch(tm){
   		case tLeaveOneOut: return string("Leave1out"); break;  //
   		case tCrossValidation: return string("Xval")+tos(numberOfFolds);break; //
   case tHoldout: if (rateTrainingTest==1) return string("Holdout"); else return string("Holdout")+tos(rateTrainingTest); break; //
   		case tTraining: if (fractionOfDefaultTrainingSize==1) return string("Training");  else return string("Training")+tos(fractionOfDefaultTrainingSize);
   		//case tHalfTraining: return string("HalfTraining"); break;
		default:		
			return "aa";
			break;
	}
}


/*_______________________________________________________________________*/

ostream& operator<<(ostream& out, TestModeClass& p)
{
try
{
out << p.printLong();
return out;
}
catch (BasicException& be){be.addMessage("\ncalled from  TestModeClass::ostream& operator<<(ostream& out, TestModeClass& p)"); throw;};

}


};  // Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
