/* File: besttree.h */


#ifndef __besttree_h__
#define __besttree_h__

//#include "defns.h"// C4.5//
//#include "types.h"//
//#include "extern.h"//


namespace BIOS {
	/************************************************************************* //
								 */ //
/*	Routines to manage tree growth, pruning and evaluation		 */ //
/*	------------------------------------------------------		 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
 //
 //
ItemNo		*TargetClassFreq; //
TreeC45		*Raw; //
TreeC45	*Pruned; //
 //
 //
 //
/*************************************************************************/ //
/*									 */ //
/*	Grow and prune a single tree from all data			 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
    void OneTree(short int criterio);

 //
 //
/*************************************************************************/ //
/*									 */ //
/*  The windowing approach seems to work best when the class		 */ //
/*  distribution of the initial window is as close to uniform as	 */ //
/*  possible.  FormTarget generates this initial target distribution,	 */ //
/*  setting up a TargetClassFreq value for each class.			 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
    void FormTarget(ItemNo Size);

 //
/*************************************************************************/ //
/*									 */ //
/*		Shuffle the data items randomly				 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
    void Shuffle();

 //
/*************************************************************************/ //
/*									 */ //
/*  Form initial window, attempting to obtain the target class profile	 */ //
/*  in TargetClassFreq.  This is done by placing the targeted number     */ //
/*  of items of each class at the beginning of the set of data items.	 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
    void FormInitialWindow();

 //
 //
 //
 //
/*************************************************************************/ //
/*									 */ //
/*	Grow and prune TRIALS trees and select the best of them		 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
short BestTree();

 //
 //
/*************************************************************************/ //
/*									 */ //
/*  Grow a tree iteratively with initial window size Window and		 */ //
/*  initial window increment IncExceptions.				 */ //
/*									 */ //
/*  Construct a classifier tree using the data items in the		 */ //
/*  window, then test for the successful classification of other	 */ //
/*  data items by this tree.  If there are misclassified items,		 */ //
/*  put them immediately after the items in the window, increase	 */ //
/*  the size of the window and build another classifier tree, and	 */ //
/*  so on until we have a tree which successfully classifies all	 */ //
/*  of the test items or no improvement is apparent.			 */ //
/*									 */ //
/*  On completion, return the tree which produced the least errors.	 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
TreeC45 Iterate(ItemNo Window, ItemNo IncExceptions, short int criterio);

 //
/*************************************************************************/ //
/*									 */ //
/*	Print report of errors for each of the trials			 */ //
/*									 */ //
/*************************************************************************/ //
 //
 //
    unsigned int Evaluate(Boolean CMInfo, short Saved, short salida);


}
#endif
