#ifndef __info_h__
#define __info_h__

#include <iostream>//
#include <fstream>//                                                    
#include <cstring>//
#include <cstdio>//
#include <cstdlib>//
#include <cmath>//

#include "defns.h"// C4.5//
#include "types.h"//
#include "extern.h"//



//using namespace UTILS;

namespace BIOS {
/*************************************************************************/// 
/*									 */// 
/*	Calculate information, information gain, and print dists	 */// 
/*	--------------------------------------------------------	 */// 
/*									 */// 
/*************************************************************************/// 
// 
// 
// 
// 
/*************************************************************************/// 
/*									 */// 
/*  Determine the worth of a particular split according to the		 */// 
/*  operative criterion							 */// 
/*									 */// 
/*	    Parameters:							 */// 
/*		SplitInfo:	potential info of the split		 */// 
/*		SplitGain:	gain in info of the split		 */// 
/*		MinGain:	gain above which the Gain Ratio		 */// 
/*				may be used				 */// 
/*									 */// 
/*  If the Gain criterion is being used, the information gain of	 */// 
/*  the split is returned, but if the Gain Ratio criterion is		 */// 
/*  being used, the ratio of the information gain of the split to	 */// 
/*  its potential information is returned.				 */// 
/*									 */// 
/*************************************************************************/// 
// 
// 
float Worth(float ThisInfo, float ThisGain, float MinGain);

    void ResetFreq(DiscrValue MaxVal);

float ComputeGain(float BaseInfo, float UnknFrac, DiscrValue MaxVal, ItemCount TotalItems);

float TotalInfo(ItemCount V[], DiscrValue MinVal, DiscrValue MaxVal);

float TotalRisk(ItemCount V[], DiscrValue MinVal, DiscrValue MaxVal);

    void PrintDistribution(AttributeC45 Att, DiscrValue MaxVal, Boolean ShowNames);

// 
float ComputeRisk(DiscrValue MaxVal, ItemCount TotalItems, short int criterio);

}
#endif
