#ifndef GenericMLTest_cpp//
#define GenericMLTest_cpp//






//using namespace UTILS;

namespace BIOS
{

GenericMLTest::GenericMLTest ( char* fileSample, TestModeClass *internalTestMod, TestModeClass *externalTestMod, int jointRows, int verbose )
{
    try
    {
        this->verbose=verbose;
        char timestr[256];
        struct timeval  tv;
        gettimeofday ( &tv, NULL );
        sprintf ( timestr, "%u.%06u", ( unsigned int ) tv.tv_sec, ( unsigned int ) tv.tv_usec );
        timeMark=string ( timestr );

        this->internalTestMod=internalTestMod->clone();
        this->externalTestMod=externalTestMod->clone();

        // if (testMod->tm==tHalfTraining && testModeForInsideMeasure) throw BadFormat("GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows, bool testModeForInsideMeasure)");
//cout <<testMod->numberOfFolds <<"\n";
        fileName=new char[256];
        strcpy ( fileName,fileSample );
        secondFileName=NULL;
//this->pos=pos;
        this->size=0;
        totalAtts=GenericSample::divideSample ( timeMark, fileSample, internalTestMod, externalTestMod, jointRows );

        internalSamplesForTraining=NULL;
        internalSamplesForTest=NULL;
        wholeInternalSamples=NULL;
        externalSamples=NULL;
        genericInternalCountsForTraining=NULL;
        genericInternalCountsForTest=NULL;
        genericExternalCounts=NULL;
        wholeInternalCounts=NULL;
    }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from  GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows)" );
        throw;
    };
}

/*________________________________________________________________________________________________________________________________*/

GenericMLTest::GenericMLTest ( char* fileSample, char* secondFileSample, int jointRows, int verbose )
{
    try
    {
        this->verbose=verbose;
        internalTestMod=new TestModeClass ( tHoldout, 1 );

//if (internalTestMode==tHoldout)
//internalTestModeClass->setNumberOfFoldsTo2ForHoldout();


        externalTestMod=new TestModeClass ( tTraining );




        // if (testMod->tm==tHalfTraining && testModeForInsideMeasure) throw BadFormat("GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows, bool testModeForInsideMeasure)");
//cout <<testMod->numberOfFolds <<"\n";
        fileName=new char[256];
        strcpy ( fileName,fileSample );
        secondFileName=new char[256];
        strcpy ( secondFileName,secondFileSample );

        //wholeFileName=new char[256];
        //strcpy ( wholeFileName,wholeFileSample );
//this->pos=pos;
        this->size=0;
        totalAtts=getTotalColumns ( fileSample );


        internalSamplesForTraining=NULL;
        internalSamplesForTest=NULL;
        wholeInternalSamples=NULL;
        externalSamples=NULL;
        genericInternalCountsForTraining=NULL;
        genericInternalCountsForTest=NULL;
        genericExternalCounts=NULL;
        wholeInternalCounts=NULL;
    }
    catch ( BasicException & be ) {
        be.addMessage ( "\ncalled from  GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows)" );
        throw;
    };
}
/*___________________________________________________________ */

int GenericMLTest::getSize()
{
    if ( size==0 ) setSize();
    if ( size==0 ) throw NullValue ( "void  GenericMLTest::getSize()" );
    return size;
}

/*___________________________________________________________ */

GenericMLTest::~GenericMLTest()
{
    emptyCounts();
//cout <<"numberof folds:" << testMod->numberOfFolds <<"\n";
//for (int i=0; i<testMod->numberOfFolds; i++)
//{
//cout <<"zap i:" << i <<"\n";
//zap(samplesForTraining);
//}
//cout <<*testMod <<"\n";
    for ( int i=0; i<externalTestMod->numberOfFolds; i++ )
    {
        zaparr ( internalSamplesForTraining[i], internalTestMod->numberOfFolds );
        zaparr ( internalSamplesForTest[i], internalTestMod->numberOfFolds );
    }
    zaparr ( internalSamplesForTraining, externalTestMod->numberOfFolds );
    zaparr ( internalSamplesForTest, externalTestMod->numberOfFolds );
    zaparr ( wholeInternalSamples, externalTestMod->numberOfFolds );
    zaparr ( externalSamples, externalTestMod->numberOfFolds );

    zaparr ( fileName );
    zaparr ( secondFileName );
    zap ( internalTestMod );
    zap ( externalTestMod );
}
/*___________________________________________________________ */

void GenericMLTest::emptyCounts()
{
    for ( int i=0; i<externalTestMod->numberOfFolds; i++ )
    {
        if ( genericInternalCountsForTraining != NULL )
            zaparr ( genericInternalCountsForTraining[i], internalTestMod->numberOfFolds );
        if ( genericInternalCountsForTest != NULL )
            zaparr ( genericInternalCountsForTest[i], internalTestMod->numberOfFolds );
    }
    zaparr ( genericInternalCountsForTraining, externalTestMod->numberOfFolds );
    zaparr ( genericInternalCountsForTest, externalTestMod->numberOfFolds );
    zaparr ( wholeInternalCounts,  externalTestMod->numberOfFolds );
    if ( genericExternalCounts!=NULL ) zaparr ( genericExternalCounts,  externalTestMod->numberOfFolds );
}
/*___________________________________________________________ */

SampleGenericCounts*** GenericMLTest::getGenericInternalCountsForTraining()
{
    return genericInternalCountsForTraining;
}
/*___________________________________________________________ */

SampleGenericCounts*** GenericMLTest::getGenericInternalCountsForTest()
{
    return genericInternalCountsForTest;
}
/*___________________________________________________________ */

SampleGenericCounts** GenericMLTest::getGenericExternalCounts()
{
    return genericExternalCounts;
}
/*___________________________________________________________ */

int GenericMLTest::getRealNumberOfAtts()
{
    return totalAtts;
}
/*___________________________________________________________ */

void GenericMLTest::setSize()
{
//defaultPositions=true;
    this->size=getRealNumberOfAtts();
//this->pos=initializeFrom(0, size);
}
/*___________________________________________________________ */

char* GenericMLTest::getFileName()
{
//defaultPositions=true;
    return fileName;
//this->pos=initializeFrom(0, size);
}
/*___________________________________________________________ */

void  GenericMLTest::setSubsamples ( int iniPos, int length )
{
    try
    {
//cout << "insidesubsamples:\n";
//     cout << "externalTestMode: " << *externalTestMod <<"\n";
//     cout << "internalTestMode: " << *internalTestMod <<"\n";
        internalSamplesForTraining=new GenericSample**[externalTestMod->numberOfFolds];
        internalSamplesForTest=new GenericSample**[externalTestMod->numberOfFolds];
        char file[1024];
        string t, t2;
        GenericSample*** genericSamples=NULL;
        if ( length==-1 ) length=getSize();
        int* pos=initializeFrom ( iniPos, length );
        wholeInternalSamples=new GenericSample*[externalTestMod->numberOfFolds];
        if ( externalTestMod->tm!=tTraining ) externalSamples=new GenericSample*[externalTestMod->numberOfFolds];
        char * fileNoPath=NULL;
        //wholeSample=this->getSample ( fileName, pos, length );
        for ( int i=0; i<externalTestMod->numberOfFolds;i++ )
        {
            t=timeMark+string ( "testE" ) +tos ( i );
            t2=timeMark+string ( "datE" ) +tos ( i );
            if ( externalTestMod->tm==tTraining && externalTestMod->fractionOfDefaultTrainingSize==1 && internalTestMod->tm==tTraining && internalTestMod->fractionOfDefaultTrainingSize==1 )
            {
                strcpy ( file, fileName );
                //			externalSamples[i]=this->getSample ( file, pos, length );
                wholeInternalSamples[i]=this->getSample ( file, pos, length );
            }
            else
            {

                changeExtension ( fileName, file,t.c_str() );
                fileNoPath = removeDir ( file );
                if ( externalTestMod->tm!=tTraining ) externalSamples[i]=this->getSample ( fileNoPath, pos, length );

                unlink ( fileNoPath );
                zaparr ( fileNoPath );
                changeExtension ( fileName, file,t2.c_str() );
                fileNoPath = removeDir ( file );
                wholeInternalSamples[i]=this->getSample ( fileNoPath, pos, length );
                unlink ( fileNoPath );
                delete fileNoPath;
            }
            internalSamplesForTraining[i]=new GenericSample*[internalTestMod->numberOfFolds];
            internalSamplesForTest[i]=new GenericSample*[internalTestMod->numberOfFolds];
            for ( int j=0; j<internalTestMod->numberOfFolds;j++ )
            {
                for ( int k=0; k<2;k++ ) // Training and test
                {
                    if ( k==0 ) {
                        t=timeMark+string ( "datE" ) +tos ( i ) +string ( "datI" ) +tos ( j ) ;
                        genericSamples=internalSamplesForTraining;
                    }
                    else {
                        t=timeMark+string ( "datE" ) +tos ( i ) +string ( "testI" ) +tos ( j ) ;
                        genericSamples=internalSamplesForTest;
                    }
                    if ( externalTestMod->tm==tTraining && externalTestMod->fractionOfDefaultTrainingSize==1 && internalTestMod->tm==tTraining && internalTestMod->fractionOfDefaultTrainingSize==1 )
                    {
                        strcpy ( file, fileName );
                        genericSamples[i][j]=this->getSample ( file, pos, length );


                    }
                    else
                    {

                        changeExtension ( fileName, file,t.c_str() );
                        fileNoPath = removeDir ( file );
//cout << "internal sample " << k << " from file " << fileNoPath <<"\n";
                        genericSamples[i][j]=this->getSample ( fileNoPath, pos, length );
                        unlink ( fileNoPath );
                        zaparr ( fileNoPath );
                    }
                }
            }

        }
        zap ( pos );
//exit(0);
    }
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from void  GenericMLTest::setSubsamples(int* pos, int length) " );
        throw;
    };

}

/*___________________________________________________________ */

void  GenericMLTest::setSubsamplesForTrainingTestFiles ( int iniPos, int length )
{
    try
    {
        if ( externalTestMod->numberOfFolds!=1 || internalTestMod->numberOfFolds!=1 )
            throw BadFormat ( "void  GenericMLTest::setSubsamplesForTrainingTestFiles ( int iniPos, int length )" );

        internalSamplesForTraining=new GenericSample**[1];
        internalSamplesForTest=new GenericSample**[1];
        if ( length==-1 ) length=getSize();
        int* pos=initializeFrom ( iniPos, length );
        wholeInternalSamples=new GenericSample*[1];
        externalSamples=NULL;
        internalSamplesForTraining[0]=new GenericSample*[1];
        internalSamplesForTest[0]=new GenericSample*[1];
        internalSamplesForTraining[0][0]=this->getSample ( fileName, pos, length );
        internalSamplesForTest[0][0]=this->getSample ( secondFileName, pos, length );
        wholeInternalSamples[0]=this->mergeSamples ( internalSamplesForTraining[0][0], internalSamplesForTest[0][0] );

        zaparr ( pos );
    }
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from void  GenericMLTest::setSubsamples(int* pos, int length) " );
        throw;
    };
}
/*___________________________________________________________ */

void  GenericMLTest::setSampleGenericCounts ( int* pos, int windowLength)
{
  try
    {
        if ( pos==NULL ) throw NullValue ( "void  GenericMLTest::setSampleGenericCounts(int* pos, int length)" );
        if ( genericInternalCountsForTraining!=NULL || genericInternalCountsForTest!=NULL || wholeInternalCounts!=NULL ) emptyCounts();
        genericInternalCountsForTraining=new SampleGenericCounts**[externalTestMod->numberOfFolds];
        genericInternalCountsForTest=new SampleGenericCounts**[externalTestMod->numberOfFolds];
        wholeInternalCounts=new SampleGenericCounts*[externalTestMod->numberOfFolds];

        if ( externalTestMod->tm==tTraining ) genericExternalCounts=NULL;
        else genericExternalCounts=new SampleGenericCounts*[externalTestMod->numberOfFolds];


        SampleGenericCounts*** genericCounts=NULL;
        GenericSample*** samples=NULL;
        if (verbose>0) cout <<"Getting SampleGenetiCounts from samples\n";

        for ( int i=0; i<externalTestMod->numberOfFolds;i++ )
        {
//if (wholeInternalSamples==NULL || wholeInternalSamples[i]==NULL) cout <<"error, null\n";
//BIOS::print(pos, length);
            if (verbose>0) cout <<"Fold: " << i << "\n";
            wholeInternalCounts[i]=this->getCounts ( wholeInternalSamples[i], pos, windowLength );
            if (verbose>0) cout <<"size of  wholeInternalCounts is " << wholeInternalCounts[i]->size() <<"\n";
            if ( externalTestMod->tm!=tTraining )
            {
                genericExternalCounts[i]=this->getCounts ( externalSamples[i], pos, windowLength );
//cout <<"size of genericExternalCounts is: " << genericExternalCounts[i]->size() <<"\n";
            }
            genericInternalCountsForTraining[i]=new SampleGenericCounts*[internalTestMod->numberOfFolds];
            genericInternalCountsForTest[i]=new SampleGenericCounts*[internalTestMod->numberOfFolds];
//if (1==0)
            for ( int j=0; j<internalTestMod->numberOfFolds;j++ )
                for ( int k=0; k<2;k++ ) // training and test
                {
                    if ( k==0 ) {
                        genericCounts=genericInternalCountsForTraining;
                        samples=internalSamplesForTraining;
                    }
                    else {
                        genericCounts=genericInternalCountsForTest;
                        samples=internalSamplesForTest;
                    }
                    //cout << "before getCounts in traning/test\n";
                    if (samples[i][j]==NULL) throw NullValue("GenericMLTest::setSampleGenericCounts ( int* pos, int windowLength)");
                    genericCounts[i][j]=this->getCounts ( samples[i][j], pos, windowLength );
                    //cout << "after\n";
                }
        }
    }
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from void  GenericMLTest::setSampleGenericCounts(int* pos, int length) " );
        throw;
    };
}

/*___________________________________________________________ */

GenericSample*  GenericMLTest::mergeSamples (GenericSample* first, GenericSample* second) //char* file, int*pos, int length)
{
    try
    {
        GenericSample* result=first->clone();
        result->copyPaste(second);
        return result;
    }
    catch (BasicException& be) {
        be.addMessage ("\ncalled from GenericSample*  GenericMLTest::mergeSamples (GenericSample* first, GenericSample* second)  ");
        throw;
    };
}
/*___________________________________________________________ */

MeasureResults**  GenericMLTest::getResults ( ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams) //, int*subRegion, int length)
{
    try
    {

        if (verbose>0) cout <<"Getting results using GenericMLTest\n";
        MeasureResults*** results=new MeasureResults**[measures->size() ], **finalResults=new MeasureResults*[measures->size() ];
        GenericMeasure* training=NULL, *test=NULL;
        stringSample*sample, *result;
        if (verbose>0)		cout << "size of training:" << genericInternalCountsForTraining[0][0]->size() <<" plus " << genericInternalCountsForTest[0][0]->size() <<"\n";
        if (verbose && genericExternalCounts!=NULL) cout << "size of test:" << genericExternalCounts[0]->size() <<"\n";

//exit(0);

        for ( int m=0; m<measures->size();m++ )
        {
            if (verbose>0) cout <<"Computing results for measure " << measures->getElement(m)->getName() <<"\n";
            results[m]=new MeasureResults*[externalTestMod->numberOfFolds];
            for ( int i=0; i<externalTestMod->numberOfFolds;i++ )
            {
                if (verbose>0) cout << "Fold number " << i+1 <<"\n";
                results[m][i]=NULL;
                training=measures->getElement ( m )->getNewGenericMeasure ( wholeInternalCounts[i], genericInternalCountsForTraining[i], genericInternalCountsForTest[i] );

                if ( training==NULL ) throw NullValue ( "MeasureResults**  GenericMLTest::getResults ( ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams ): training is null" );


                if (verbose==1)
                {
                    cout <<"testmode in training:" << ((GroupBasedTDTMeasure*&)training)->testMode <<"\n";
//	results[m][i]=training->getResults();
                    cout << "measure is: " << training->getName() << "\n";
                    cout <<"training:\n" << *training <<"\n";
                    cout <<"pval:\n" << *training->getResults() <<"\n";
                    cout <<  "internal training counts:" << *genericInternalCountsForTraining[i][0] <<"\n";

                    cout <<  "internal test counts:" << *genericInternalCountsForTest[i][0] <<"\n";
                }
                if ( externalTestMod->tm==tTraining )
                {
                    test=training; //->clone();

                    if (verbose==1) cout <<"test:\n" << *test <<"\n";

//cout <<"test:\n" << *test <<"\n";
//exit(0);
                }
                else
                {
                    if (verbose==1)
                    {
                        if ( genericExternalCounts[i]==NULL) cout <<"null\n";
                        else cout << * genericExternalCounts[i] <<"\n";
                        cout <<"testmode in training:" << ((GroupBasedTDTMeasure*&)training)->testMode <<"\n";
                    }
                    test=training->inferGenericMeasure ( genericExternalCounts[i] );//outsideTestMode crossVal or holdout

//cout <<"testmode in test:" << ((GroupBasedTDTMeasure<HaplotypeTUCountsVector>*&)test)->testMode <<"\n";
//cout <<  "test counts:" << *genericExternalCounts[i] <<"\n";

//cout <<"testmode in test:" << ((TDTPMeasure<HaplotypeTUCountsVector>*&)test)->testMode <<"\n";
                }

                if ( test==NULL ) throw NullValue ( "MeasureResults**  GenericMLTest::getResults (ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams)" );
//cout << "now\n";
//cout <<"test:\n" << *test <<"\n";
//exit(0);
//cout << "now2\n";
                if (verbose>0) cout << "size is:" << listOfStreams->size() <<"\n";
                if ( listOfStreams!=NULL )
                    if ( listOfStreams->size() <=m )
                        throw OutOfBounds ( m, listOfStreams->size(), "MeasureResults**  GenericMLTest::getResults (ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams)" );
                    else
                    {
                        *listOfStreams->getElement ( m )  << *test <<"\n";
                    }
                // OBTAIN P-VALUES
                if (verbose>0) cout <<"Obtaining results\n";
//cout << "BEFORE getresults\n";
                results[m][i]=test->getResults();
                // DELETE TEMPORAL MEASURES


                if (verbose>0) cout << "Releasing measure memory\n";
                zap ( training );
//if (verbose) cout << "External test mode: " << *externalTestMod << " \n";
                if ( externalTestMod->tm!=tTraining )
                    zap ( test );
                else test=NULL;

//exit(0);
            } // end foreach fold
        } // end foreach measure

        if (verbose>0) cout <<"averaging for all folds\n";
        for ( int m=0; m<measures->size();m++ )
        {
            finalResults[m]=results[m][0]->getAverage ( results[m], externalTestMod->numberOfFolds );
            zaparr ( results[m], externalTestMod->numberOfFolds );
        }


        if (verbose>0) cout << "Releasing memory for temporary measures\n";
        zaparr ( results, measures->size() );
        return finalResults;
    }
    catch ( BasicException& be ) {
        be.addMessage ( "\ncalled from MeasureResults**  GenericMLTest::getResults(ListOfGenericMeasures* measures) " );
        throw;
    };
}
} // end namespace
#endif
