#ifndef GenericMLTest_h//
#define GenericMLTest_h//



namespace BIOS {


class InputTUI;


////////////////////////////

class GenericMLTest {

/** This class is used as a generalization of any sample (ML Sample, genetic samples, etc.) so that they all can be divided in order to use tests, classifier or any other measure using different testting comfigurations (cross-validation, holdout, training).
*/



protected:


char* fileName;

char* secondFileName;

int verbose;

//char* wholeFileName;

string timeMark;


int size, totalAtts;// size is the total number of effective attributes considering the type of sample (eg. genotype samples in makeped format does also include phenotypes and have to be ignored), totalAtts is the total number of attrib. in each file



SampleGenericCounts*** genericInternalCountsForTraining, ***genericInternalCountsForTest, **genericExternalCounts, **wholeInternalCounts;



GenericSample*** internalSamplesForTraining, *** internalSamplesForTest, **externalSamples, **wholeInternalSamples;

TestModeClass* internalTestMod, *externalTestMod;


protected:

virtual int getRealNumberOfAtts(); 

void setSize();

public:

GenericMLTest(char* fileSample, TestModeClass *internalTestMod, TestModeClass *externalTestMod, int jointRows, int verbatim=0);
GenericMLTest(char* fileSample, char* secondFileSample, int jointRows, int verbatim=0);
~GenericMLTest();
void emptyCounts();
MeasureResults** getResults(ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams=NULL); //, int* subRegion, int length);
virtual SampleGenericCounts* getCounts(GenericSample* sample, int*pos, int length)=0;
virtual GenericSample*  mergeSamples (GenericSample* first, GenericSample* second);
void setSampleGenericCounts(int*realtivePositions, int length);
void setSubsamples(int iniPos, int length);
void  setSubsamplesForTrainingTestFiles ( int iniPos, int length );
int getSize();
char* getFileName();
SampleGenericCounts*** getGenericInternalCountsForTraining();
SampleGenericCounts*** getGenericInternalCountsForTest();
SampleGenericCounts** getGenericExternalCounts();
virtual GenericSample* getSample(char* file, int* pos, int length)=0;
};

} // end namespace
#endif

