#ifndef GenericSample_cpp//
#define GenericSample_cpp//






//using namespace UTILS;

namespace BIOS
{

	/*___________________________________________________________ */
	/*

	GenericSample::GenericSample(char* fileSample, TestModeClass *testMod)
	{
	fileName=fileSample;
	this->testMod=testMod;
	wholeSample=NULL;
	}
	/*___________________________________________________________ */

	intList* GenericSample::selectPositions ( int foldSize, intList* positions )
	{
		try
		{
			intList* result=new intList();
			for ( int i=0;i<foldSize;i++ )
				result->insertElement ( positions->pop() );
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	intList* GenericSample::selectPositions ( int foldSize, intList* positions)" );throw;};
	}
	/*___________________________________________________________ */

	intList* GenericSample::addPositions ( intList* positions, int jointRows )
	{
		try
		{
			if ( jointRows==1 ) return positions->clone();
			intList* result=new intList();
			int basicPos;
			for ( int i=0;i<positions->size();i++ )
				for ( int j=0; j<jointRows; j++ )
				{
					if ( j==0 ) basicPos=positions->getElement ( i ) ;
					result->insertElement ( basicPos*jointRows+j );
				}
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 		intList* GenericSample::addPositions ( intList* positions, int jointRows)" ); throw;};
	}

	/*___________________________________________________________ */

	void GenericSample::writeFile ( char* filename, const char* timeMark, stringList* sample )
	{
		try
		{

			char block[1024];
			strcpy ( block, filename );
			strcat ( block, "temp" );
			strcat ( block, timeMark );

			time_t start, end;
			time ( &start );
			while ( fileExists ( filename ) || fileExists ( block ) )
			{
				time ( &end );
				if ( difftime ( end, start ) >300 )
				{
					if ( fileExists ( filename ) ) throw AlreadyExist ( filename, "int GenericSample::writeFile (c char* filename, const char* timeMark, stringList* sample)" );
					if ( fileExists ( block ) ) throw AlreadyExist ( block, "int GenericSample::writeFile ( char* filename, const char* timeMark, stringList* sample)" );
				}
			}
			OpenOutput ( block, &OutputFile2 );
			OpenOutput ( filename, &OutputFile );
//cout << "file " << filename << " created\n";
			sample->setOutputSeparator ( '\n' );
//cout << "total inds:" << sample->size() <<"\n";
			OutputFile << *sample;
			OutputFile.close();
			OutputFile2.close();
			unlink ( block );
//cout << "\nfile "<< block <<" erased\n";
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GenericSample:::writeFile ( char* filename, const char* timeMark, stringList* sample )" );throw;};
	}
	/*___________________________________________________________ */
	/*
		stringList* GenericSample::shrinkSample ( stringList* sample, int newSize, int jointRows )
		{
	// it shrinks sample and it also returns the remaining rows
			try
			{
	stringList*result=NULL;
	if (newSize>sample->size()) throw OutOfBounds(newSize,sample->size());
	if (newSize==sample->size()) return NULL;
		Sampling *sampling=new Sampling ( sample->size() /jointRows, false );
	intList* posList=sampling->getPositionsList();
	intList* indexVector=selectPositions ( newSize, posList, jointRows);
						result=sample->extractElementsWithPositionsIn ( indexVector );
	zap(indexVector);
	zap(sampling);
	return result;
			}
			catch ( BasicException& be ) {be.addMessage ( "\ncalled from GenericSample::divideSample (char* fileSample, TestModeClass* testMod, int jointRows)" );throw;};
		}
	/*___________________________________________________________ */

	int GenericSample::getSizeOfCrossValidationFold ( int numberOfFolds, int fold,int wholeSize, bool training )
	{
		try
		{
			int size=wholeSize/numberOfFolds;
			int remaining=wholeSize%numberOfFolds;
			if ( remaining>0 && fold<remaining ) size++;
			if ( training ) return wholeSize-size;
			else return size;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	int GenericSample::getSizeOfCrossValidationFold( int fold,int wholeSize   )" );throw;};
	}
	/*___________________________________________________________ */

	int GenericSample::getSize ( TestModeClass* internalTestMod, TestModeClass* externalTestMod, int internalFold, int externalFold, int type, int wholeSize )
	{
// type is: 0 for externalTest, 1 for externalTraining, 2 for internalTest and 3 for internalTraining
		try
		{
			int externalTestSize, externalTrainingSize, internalTestSize, internalTrainingSize, internalResto, externalResto;
// externalTrainingSize is internalTestSize+internalTrainingSize
			if ( internalTestMod->tm==tHoldout && internalTestMod->rateTrainingTest>1 )
				throw BadFormat ( "int GenericSample::getSize (TestModeClass* internalTestMod, TestModeClass* externalTestMod, int fold, bool internal, int wholeSize   )" );

			if ( internalTestMod->tm==tTraining && externalTestMod->tm==tTraining && internalTestMod->fractionOfDefaultTrainingSize>1 )
				throw BadFormat ( "int GenericSample::getSize (TestModeClass* internalTestMod, TestModeClass* externalTestMod, int fold, bool internal, int wholeSize   )-A" );

			switch ( externalTestMod->tm )
			{
				case tCrossValidation:
					externalTestSize=getSizeOfCrossValidationFold ( externalTestMod->numberOfFolds, externalFold, wholeSize, false );
					externalTrainingSize=getSizeOfCrossValidationFold ( externalTestMod->numberOfFolds, externalFold, wholeSize, true );
					if ( internalTestMod->tm==tTraining && internalTestMod->fractionOfDefaultTrainingSize>1 )
					{
						externalTrainingSize=externalTrainingSize/internalTestMod->fractionOfDefaultTrainingSize;
						externalTestSize=externalTestSize/internalTestMod->fractionOfDefaultTrainingSize;
					}
					break;
				case tHoldout:
					externalTestSize=wholeSize/ ( 2*externalTestMod->rateTrainingTest );
					externalTrainingSize=wholeSize/2;
					if ( internalTestMod->tm==tTraining && internalTestMod->fractionOfDefaultTrainingSize>1 )
					{
//externalTestSize=externalTestSize/internalTestMod->fractionOfDefaultTrainingSize;
						externalTrainingSize=externalTrainingSize/internalTestMod->fractionOfDefaultTrainingSize;
					}
					break;
				case tTraining:
					externalTrainingSize=wholeSize/ ( externalTestMod->fractionOfDefaultTrainingSize );
					externalTestSize=externalTrainingSize;
			}

			if ( type>=2 )
			{
				switch ( internalTestMod->tm )
				{
					case tCrossValidation:
						internalTestSize=getSizeOfCrossValidationFold ( internalTestMod->numberOfFolds, internalFold, externalTrainingSize, false );
						internalTrainingSize=getSizeOfCrossValidationFold ( internalTestMod->numberOfFolds, internalFold, externalTrainingSize, true );
						break;
					case tHoldout:
						internalTestSize=externalTrainingSize/2;
						internalTrainingSize=externalTrainingSize-internalTestSize;
						break;
					case tTraining:
						internalTestSize=externalTrainingSize;
						internalTrainingSize=externalTrainingSize;
				}


				if ( internalTestMod->tm!=tTraining && externalTrainingSize!= ( internalTestSize+internalTrainingSize ) )
					throw BadFormat ( "int GenericSample::getSize (TestModeClass* internalTestMod, TestModeClass* externalTestMod, int fold, bool internal, int wholeSize)-B" );

				if ( internalTestMod->tm==tTraining && ( externalTrainingSize!=internalTestSize || externalTrainingSize!=internalTrainingSize ) )
					throw BadFormat ( "int GenericSample::getSize (TestModeClass* internalTestMod, TestModeClass* externalTestMod, int fold, bool internal, int wholeSize)-C" );
			}
			switch ( type )
			{
				case 0: return externalTestSize; break;
				case 1: return externalTrainingSize; break;
				case 2: return internalTestSize; break;
				case 3: return internalTrainingSize; break;
			}

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	int GenericSample::getSize (TestModeClass* internalTestMod, TestModeClass* externalTestMod, int fold, bool internal  )" );throw;};
	}
	/*___________________________________________________________ */

	int GenericSample::divideSample ( string timeMark, char* fileSample, TestModeClass* internalTestMod, TestModeClass* externalTestMod, int jointRows )
	{
		try
		{
			if ( internalTestMod->tm==tTraining && internalTestMod->fractionOfDefaultTrainingSize==1 && externalTestMod->tm==tTraining && externalTestMod->fractionOfDefaultTrainingSize==1 ) return getTotalColumns ( fileSample );
			stringList* wholeSample=new stringList ( fileSample );
			stringList* newSample, *internalTestSample, *internalTrainingSample, *externalTrainingSample, *externalTestSample, *unusedSample;
			char filename[512], filename2[512], *noFilePath=NULL;
			string extension;
			intList* indexVector=NULL, *internalIndexVector=NULL, *indexVector2=NULL, *internalIndexVector2=NULL, * completeIndexVector=NULL, *completeInternalIndexVector=NULL, *completeIndexVector2=NULL, *completeInternalIndexVector2=NULL;
			Sampling *sampling=new Sampling ( wholeSample->size() /jointRows, false ), *internalSampling=NULL, *sampling2=NULL, *internalSampling2=NULL;
			intList* randomPositions=sampling->getPositionsList();
			stringList* row=getStringVector ( ( char* ) wholeSample->getElement ( 0 ).c_str(), " \t," );
			int totalAtts=row->size();
			zap ( row );
			char * fileSampleNoPath = removeDir ( fileSample );
			int internalFoldSize, internalTrainingSize, externalFoldSize, externalTrainingSize;

			for ( int i=0;i<externalTestMod->numberOfFolds;i++ )
			{
				externalFoldSize= GenericSample::getSize ( internalTestMod, externalTestMod, -1, i, 0, wholeSample->size() /jointRows );
				externalTrainingSize= GenericSample::getSize ( internalTestMod, externalTestMod, -1, i, 1, wholeSample->size() /jointRows );
				indexVector=selectPositions ( externalTrainingSize, randomPositions );
		//		cout << "positions chosen for external Training:" << *indexVector <<"\n";
				completeIndexVector=addPositions ( indexVector, jointRows );
				externalTrainingSample=wholeSample->copyElementsWithPositionsIn ( completeIndexVector );
				if ( externalTestMod->tm==tTraining ) indexVector2=indexVector->clone();
				else	indexVector2=selectPositions ( externalFoldSize, randomPositions );
 //   cout << "positions chosen for external test:" << *indexVector2 <<"\n";
				completeIndexVector2=addPositions ( indexVector2, jointRows );
				externalTestSample=wholeSample->copyElementsWithPositionsIn ( completeIndexVector2 );
				//cout << "total size in external training sample:" << externalTrainingSample->size() <<"\n";
			//	cout << "total size in external test sample:" << externalTestSample->size() <<"\n";
				if ( externalTrainingSample->size() ==0 )
					throw NullValue ( "int GenericSample::divideSample ( string timeMark, char* fileSample, TestModeClass* internalTestMod, TestModeClass* externalTestMod, int jointRows ): externalTrainingSample has no values" );
				if ( externalTestSample->size() ==0 )
				{
					throw NullValue ( "int GenericSample::divideSample ( string timeMark, char* fileSample, TestModeClass* internalTestMod, TestModeClass* externalTestMod, int jointRows ): externalTestSample has no values" );
				}
				changeExtension ( fileSampleNoPath, filename, ( timeMark+string ( "testE" ) +tos ( i ) ).c_str() );
				writeFile ( filename, ( timeMark+string ( "testE" ) +tos ( i ) ).c_str(), externalTestSample );
				changeExtension ( fileSampleNoPath, filename, ( timeMark+string ( "datE" ) +tos ( i ) ).c_str() );
				writeFile ( filename, ( timeMark+string ( "datE" ) +tos ( i ) ).c_str(), externalTrainingSample );
				for ( int j=0;j<internalTestMod->numberOfFolds;j++ )
				{
					internalFoldSize= getSize ( internalTestMod, externalTestMod, j, i, 2, wholeSample->size() /jointRows );
					internalTrainingSize= getSize ( internalTestMod, externalTestMod, j, i, 3, wholeSample->size() /jointRows );

					//cout << "internalfold size:" << internalFoldSize << "  and internal training:" << internalTrainingSize <<"\n";

					internalIndexVector=selectPositions ( internalFoldSize, indexVector );


	if ( internalTestMod->tm==tTraining ) internalIndexVector2=internalIndexVector->clone();
					else	internalIndexVector2=selectPositions ( internalFoldSize, indexVector );


					completeInternalIndexVector=addPositions ( internalIndexVector2, jointRows );
					internalTrainingSample=wholeSample->copyElementsWithPositionsIn ( completeInternalIndexVector );
				
//cout << "positions chosen in internalTraining:" << *internalIndexVector2 <<"\n";
//cout << "positions chosen in internalTest:" << *internalIndexVector <<"\n";
					completeInternalIndexVector2=addPositions ( internalIndexVector, jointRows );
					internalTestSample=wholeSample->copyElementsWithPositionsIn ( completeInternalIndexVector2 );



					changeExtension ( fileSampleNoPath, filename, ( timeMark+string ( "datE" ) +tos ( i ) +string ( "datI" ) +tos ( j ) ).c_str() );
					changeExtension ( fileSampleNoPath, filename2, ( timeMark+string ( "datE" ) +tos ( i ) +string ( "testI" ) +tos ( j ) ).c_str() );
					if ( internalTrainingSample->size() ==0 )
						throw NullValue ( "int GenericSample::divideSample ( string timeMark, char* fileSample, TestModeClass* internalTestMod, TestModeClass* externalTestMod, int jointRows ): internalTrainingSample has no values" );
					if ( internalTestSample->size() ==0 )
						throw NullValue ( "int GenericSample::divideSample ( string timeMark, char* fileSample, TestModeClass* internalTestMod, TestModeClass* externalTestMod, int jointRows ): internalTestSample has no values" );
					writeFile ( filename, ( timeMark+string ( "datE" ) +tos ( i ) +string ( "datI" ) +tos ( j ) ).c_str(), internalTrainingSample );
					writeFile ( filename2, ( timeMark+ string ( "datE" ) +tos ( i ) +string ( "testI" ) +tos ( j ) ).c_str(), internalTestSample );

					zap ( internalTrainingSample );
					zap ( internalTestSample );
					zap ( internalIndexVector );
					zap ( internalIndexVector2 );
					zap ( completeInternalIndexVector );
					zap ( completeInternalIndexVector2 );
					zaparr ( noFilePath );
				} // end for each subsample
//cout << "indexVector:" << *indexVector <<"\n";
				zap ( indexVector );
//cout << "indexVector:" << *indexVector2 <<"\n";
				zap ( indexVector2 );
				zap ( completeIndexVector );
				zap ( completeIndexVector2 );
				zap ( internalSampling );
				zap ( externalTrainingSample );
				zap ( externalTestSample );
			} // end for each sample
			zap ( sampling );
			zap ( wholeSample );
			zaparr ( fileSampleNoPath );
//exit(0);
			return totalAtts;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GenericSample::divideSample (char* fileSample, TestModeClass* testMod, int jointRows)" );throw;};
	}


	/*___________________________________________________________ */
	/*
	void GenericSample::merge(GenericSample* otherSample)
	{
	  throw NonImplemented("GenericSample::copyPaste(GenericSample* otherSample)");
	  exit(0);
	}


	/*___________________________________________________________ */



} // end namespace
#endif
