#ifndef GenericSample_h//
#define GenericSample_h//



namespace BIOS {


class InputTUI;


////////////////////////////

class GenericSample {

/** This class is used as a generalization of any sample (ML Sample, genetic samples, etc.) so that they all can be divided in order to use tests, classifier or any other measure using different testting comfigurations (cross-validation, holdout, training).
It stores information about the extension of auxiliar files depending on the sublcasses (eg. .mas for MLSample, .pou and .rs for TrioSamples).
It also stores the number of rows that cannot be splitted: 3 for trioSamples, 1 default
*/



public:
  int verbose;
  char outputSeparator, rightDelimiter, leftDelimiter;


public:

GenericSample(int verbose, char outputSeparator='\0', char leftDelimiter='\0', char rightDelimiter='\n' )
{
  this->verbose=verbose;
  this->outputSeparator=outputSeparator;
  this->leftDelimiter=leftDelimiter;
  this->rightDelimiter=rightDelimiter;
  
};
static int divideSample(string timeMark, char* filename, TestModeClass* internalTestMod, TestModeClass* externalTestMod, int jointRows=1);
static void writeFile ( char* filename, const char* timeMark, stringList* sample );
static intList* selectPositions ( int foldSize, intList* positions);	
static 	int getSizeOfCrossValidationFold( int numberOfFolds, int fold,int wholeSize, bool training   );
static	int getSize (TestModeClass* internalTestMod, TestModeClass* externalTestMod, int internalFold, int externalFold, int type, int wholeSize   );
static	intList* addPositions ( intList* positions, int jointRows=1);
virtual int size()  const=0;
virtual GenericSample* clone()=0;
virtual void copyPaste(GenericSample* otherSample)=0;
//static stringList* shrinkSample ( stringList* sample, int newSize, int jointRows );

friend ostream& operator<<(ostream& out, GenericSample& l) 
{
try
{
l.print(out); 
}
catch (BasicException& be){be.addMessage("\ncalled from ostream& operator<<(ostream& out, GenericSample& l)  "); throw;};
return out;
};

virtual void print(ostream&)=0;
virtual ~GenericSample(){};
};

} // end namespace
#endif

