#ifndef MLSample_cpp//
#define MLSample_cpp//

#include "MLSample.h"

namespace BIOS
{


	/*___________________________________________________________________*/

	template <class T> MLSample<T>::MLSample ( char* filename, VerbosityClass *verbosity, char* tokens )
	{
		try
		{
char filePos[256];
			changeExtension ( filename, filePos, "pos" );
			this->verbosity=verbosity;
			if ( fileExists ( filePos ) )
				this->listOfAttributes=new ListOfOrderedAttributes ( filename );
			else this->listOfAttributes=new ListOfAttributes ( filename );
			set ( filename, this->listOfAttributes, tokens );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from MLSample<T>::MLSample ( char* filename, VerbosityClass *verbosity, char* tokens )" ); throw;};
	};
	/*___________________________________________________________________*/
	/*
	  template <class T> void MLSample<T>::set(char* filename, ListOfAttributes *listOfAttributes, char* tokens)
	  {
	strcpy(this->filename, filename);
	//this->bayesType= bayesType;
	//this->alpha=alpha;
	   Sample<vector, vector, string>* l=new Sample<vector, vector, string>(filename, tokens);
	    typename Sample<vector, vector, string>::iterator p=l->getFirst();
	    stringList *patternL;
	   sample=new  Sample<vector, vector, T>();
	   Container<vector, T>* patternPos;

	   while (p!=l->end())
	   {
	    patternL=l->getElement(p);
	    patternPos=listOfAttributes->getValues(patternL);
	    sample->insertElement(patternPos);
	    zap(patternPos);
	    p=l->getNext(p);
	    }
	    zap(l);
	    };
	*/



	/*___________________________________________________________________*/

	template <> void MLSample<float>::set ( char* filename, ListOfAttributes *listOfAttributes, char* tokens )
	{
int cont=0;
		try
		{
//			strcpy ( this->filename, filename );


			stringSample* l=new stringSample ( filename, tokens );


			stringList *patternL;
			sample=new  floatSample();
			floatList* patternPos;
			for ( stringSample::iterator p=l->getFirst(); p!=l->end(); p++ )
			{
				patternL=l->getElement ( p );
				if ( patternL==NULL ) throw NullValue ( "void MLSample<float>::set ( char* filename, ListOfAttributes *listOfAttributes, char* tokens )" );
				patternPos=listOfAttributes->getValues ( patternL );
				sample->insertElement ( patternPos, sample->end() );
                                cont ++;
				//zap(patternPos);
			}
			zap ( l );
		}
                catch ( BasicException & be ) {be.addMessage ("\nand pattern number"); be.addMessage(tos(cont)); be.addMessage("\ncalled from void MLSample<float>::set ( char* filename, ListOfAttributes *listOfAttributes, char* tokens )" );throw;};

	};

	/*___________________________________________________________________*/

	template <class T> MLSample<T>::MLSample ( ListOfAttributes *listOfAttributes, struct VectorSample<T>::Class *sample, VerbosityClass * verbosity )
	{
		this->listOfAttributes=listOfAttributes->clone();
		this->sample=new struct VectorSample<T>::Class ( *sample );
		//filePos[0]='\0';
		//filename[0]='\0';
		verbosity=NULL;
		//size=sample->size();
	};
	/*___________________________________________________________________*/

	template <class T> MLSample<T>::MLSample()
	{
		this->listOfAttributes=NULL;
		this->sample=NULL;
		//filePos[0]='\0';
		//filename[0]='\0';
		verbosity=NULL;
		//size=0;
	};

	/*___________________________________________________________________*/

	template <class T> int MLSample<T>::size ()
	{
		return sample->size();
	}


	/*___________________________________________________________________*/

	template <class T>  MLSample<T>::MLSample ( MLSample<T> &source, typename  VectorSample<T>::Class::iterator first, typename  VectorSample<T>::Class::iterator last )
	{
		this->verbosity=source.verbosity;
//		strcpy ( this->filename, source.filename );
//		strcpy ( this->filePos, source.filePos );
		sample=new struct VectorSample<T>::Class ( *source.sample, first, last );
		listOfAttributes=source.listOfAttributes->clone();
	}
	/*___________________________________________________________________*/

	template <class T>  MLSample<T>::MLSample ( MLSample<T> &source )
	{
		this->verbosity=source.verbosity;
		//strcpy ( this->filename, source.filename );
		//strcpy ( this->filePos, source.filePos );
		sample=new struct VectorSample<T>::Class ( *source.sample );
		listOfAttributes=source.listOfAttributes->clone();
	}

	/*________________________________________________________________________________________*/

	template <class T>  MLSample<T>* MLSample<T>::clone()
	{
		return new MLSample<T> ( *this, this->sample->begin(), this->sample->end() );
	};

	/*____________________________________________________________ */


	template <class T>   MLSample<T>* MLSample<T>::extractRowsWithPositionsIn ( intList* posList )
	{
		try
		{
			MLSample<T> *newList=new MLSample<T>();
			newList->sample=this->sample->extractRowsWithPositionsIn ( posList );
			newList->listOfAttributes=this->listOfAttributes->clone();
//			strcpy ( newList->filename, this->filename );
//			strcpy ( newList->filePos, this->filePos );
			newList->verbosity=this->verbosity;
			return newList;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from MLSample<T>* MLSample<T>::extractRowsWithPositionsIn ( intList* posList )" ); throw;};

	};

	/*___________________________________________________________________*/

	template <class T>   MLSample<T>::~MLSample()
	{
		zap ( this->listOfAttributes );
		zap ( this->sample );
	};
	/*___________________________________________________________________*/

	template <class T> MLSample<T>*  MLSample<T>::removeClass()
	{
		int totalAttributes=this->listOfAttributes->GetTotalAttributes();
		ListOfAttributes* listOfAttributes=this->listOfAttributes->clone();
		if ( strcmp ( listOfAttributes->getLastElement()->getName().c_str(), "class" ) ==0 ) // it has class
			totalAttributes--;// class not used

		intList* attList=new intList ( totalAttributes );

		MLSample<T>* result=this->copyColumns ( attList );
		zap ( attList );
		return result;
	}

	/*____________________________________________________________________________________________*/

	template <class T> int MLSample<T>::getTotalModalidades ( int att )
	{
		try
		{
			Modalidades *classModalidades=listOfAttributes->getElement ( att )->getModalidades();
			stringList::iterator p=classModalidades->getFirst();
			int cont=0, cont2=0;
			AttPatternVector* attPatterns;// it should have to be Set
			AttPattern* attPattern;

			while ( p!=classModalidades->end() )
			{
				attPattern=new AttPattern ( att, cont, cont );
				attPatterns=new AttPatternVector ( true );
				attPatterns->insertElement ( attPattern );
				// zap(attPattern);
				if ( sample->GetAbsoluteFrequency ( attPatterns ) > ( long int ) 0 ) cont2++;
				p=classModalidades->getNext ( p );
				zap ( attPatterns );
				cont++;
			}

			return cont2;
		}
		catch ( OutOfBounds ob ) {ob.PrintMessage ( " MLSample<T>::getTotalModalidades" );end();}
	}
	/*___________________________________________________________ */

	template <class T>   void MLSample<T>::setIntervals ( DiscMode discMod, bool supervised, VerbosityClass *verbosity, int classAttribute )
	{
		Discretization* discretization;

		discretization=new Discretization ( this, discMod, supervised, verbosity, classAttribute );

		zap ( discretization );

	}

	/*___________________________________________________________ */

	template <class T> intList* MLSample<T>::select ( int classNum, AlgType algType, SelMode selMode, VerbosityClass* verbosity, LossFunction* lossFunction, char* filename, char* secondFilename, floatList* selectionList, char* selectionFile, floatList* algorithmParameters )
	{
		try
		{
//cout <<"classnum is " << classNum;
			intList* selectedList=NULL;
			Selection* selection=new Selection ( this, classNum, verbosity );
			selectedList=selection->getSelection ( selMode, algType, lossFunction, filename, secondFilename, selectionList, selectionFile, algorithmParameters );
			zap ( selection );
			return selectedList;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from intList* MLSample<T>::select ( int classNum, AlgType algType, SelMode selMode, VerbosityClass* verbosity, LossFunction* lossFunction, floatList* selectionList, char* selectionFile, floatList* algorithmParameters )" ); throw;};
	}
	/*___________________________________________________________ */

	template <class T> MLSample<T>* MLSample<T>::copySelection()
	{
		MLSample<T>* newMLSample=new MLSample<T>();
		ListOfAttributes* newListOfAttributes=listOfAttributes->select();
		newMLSample->listOfAttributes=newListOfAttributes;
//		strcpy ( newMLSample->filename, this->filename );
//		strcpy ( newMLSample->filePos, this->filePos );
		intList* selectedAtts=listOfAttributes->getSelection();
		if ( selectedAtts->size() ==0 )
		{
			cout <<"Error in MLSample:: copySelection, 0 attributes selected";
			end();
		}
		//cout << "selected atts:" << *selectedAtts << "\n";
		struct VectorSample<T>::Class* newSample=this->sample->copyColumns ( selectedAtts );
		//cout << "newsample:" << *newSample << "\n";
//		strcpy ( newMLSample->filename, this->filename );
//		strcpy ( newMLSample->filePos, this->filePos );
		newMLSample->sample=newSample;
		zap ( selectedAtts );
		newMLSample->verbosity=this->verbosity;
//newMLSample->bayesType=this->bayesType;
//newMLSample->alpha=this->alpha;
		return newMLSample;
	}
	/*___________________________________________________________ */
/*
	template <class T>    MLSample<T>::MLSample ( char* filename, char* filepos, struct VectorSample<T>::Class* sample, VerbosityClass *verbosity, ListOfAttributes* listOfAttributes ) //
	{
		//strcpy ( this->filename, filename );
		//strcpy ( this->filePos, filePos );
		this->verbosity=verbosity;
		this->sample=sample;
		this->listOfAttributes=listOfAttributes;//order in columns
	}
	/*___________________________________________________________ */

	template <class T>   MLSample<T>* MLSample<T>::copyColumns ( intList* columns, bool orderedByThis ) //
	{
		struct VectorSample<T>::Class * s=this->sample->copyColumns ( columns, orderedByThis );
		ListOfAttributes* l=listOfAttributes->copyAttributesWithPositionsIn ( columns, false );//order in columns
		MLSample<T>* res=new MLSample ( l, s, verbosity );
		return res;
	}
	/*___________________________________________________________________________________*/
	/*
	  template <class T, template <class T> class Cont>   char* MLSample<T>::print()
	  {
	    int totalAttributes=listOfAttributes->GetTotalAttributes();
	    bool* seleccionados=new bool[totalAttributes], * integer=new bool[totalAttributes];



	    InitializeList(seleccionados, totalAttributes, false);
	    InitializeList(seleccionados, totalAttributes, false);

	    for (int i=0;i<totalAttributes;i++)
	      if (listOfAttributes->getElement(i)->isSelected())
	      {
	        seleccionados[i]=true;
	        if (!listOfAttributes->getElement(i)->IsContinuous())
	          integer[i]=true;
	      }

	    // zaparr(sample->line);
	    // sample->line=new char[sample->Size*sample->getElement((int)0)->size()*20];

	    // strcpy(line, sample->print(seleccionados, integer));
	    sample->print();
	//    zaparr(seleccionados);
	    zaparr(integer);
	    return sample->line;
	  }
	  /*___________________________________________________________________________________*/
	/*
	  template <class T, template <class T> class Cont>   char* MLSample<T>::print()
	  {
	    zaparr(sample->line);
	    sample->line=new char[sample->Size*sample->getElement((int)0)->size()*20];
	    //  char* l=&sline[0];
	    strcpy(sample->line, "\0");
	    //  ofstream  OutputFile;
	    //OpenOutput(filename, &OutputFile);
	    list<T> *pattern;
	    typename Sample<T>::iterator p=sample->getFirst();
	    int totalAttributes=listOfAttributes->GetTotalAttributes();
	    bool missing[totalAttributes];

	    while (p!=NULL)
	    {
	      pattern=getElement(p);
	     // for (int i=0;i<totalAttributes;i++)
	    //    if (listOfAttributes->getElement(i)->isMissing(pattern->getElement(i)))
	     //     missing[i]=true;
	      //  else missing[i]=false;
	      strcat(sample->line, pattern->print();
	      strcat(sample->line, "\n");
	      p=getNext(p);
	    }
	    // OutputFile.close();
	    return sample->line;
	  }
	  /*___________________________________________________________________________________*/

	template <class T>    void MLSample<T>::removePatternsWithMissingAttribute ( int attNumber )
	{
		if ( attNumber>= listOfAttributes->size() )
		{
			cout <<"Error in MLSample::removePatternsWithMissingAttribute, att " << attNumber <<", out of range, max is " << listOfAttributes->size();
			end();
		}
		struct Vector<T>::Class *pattern;
		typename VectorSample<T>::Class::iterator p=sample->getFirst(), p2;
		Attribute* attribute=listOfAttributes->getElement ( attNumber );
		while ( p!=sample->end() )
		{
			pattern=sample->getElement ( p );
			if ( attribute->isMissing ( pattern->getElement ( attNumber ) ) )
			{
				cout << "ismiss in MLSample<T>::removePatternsWithMissingAttribute\n";
				p2=sample->getNext ( p );
				sample->removeNode ( p );
				p=p2;
			}
			else
			{
				p=sample->getNext ( p );
			}
		}
	}
	/*___________________________________________________________________________________*/
	/*
	  template <class T>   void MLSample<T>::selectColumns(intList* columns)//
	  {
	sample->Sample<T, list, ListOfPointers>::selectColumns(columns);
	sample->listOfAttributes->selectElements(columns);
	 };
	 /*___________________________________________________________________________________*/

	template <class T>   void MLSample<T>::removeMissingPatterns()
	{
		sample->removeMissingPatterns ( listOfAttributes );

	}
	/*___________________________________________________________________*/

	template <class T> intMLSample*  MLSample<T>::convertToDiscreteSample()
	{
		intMLSample* result=new intMLSample();
		result->sample=new intSample();
		result->listOfAttributes=this->listOfAttributes->getDiscreteListOfAttributes();
		typename VectorSample<T>::Class ::iterator p=sample->getFirst();
		floatList *pattern;
		intList* discretePattern;
		while ( p!=sample->end() )
		{
			pattern=sample->getElement ( p );
			discretePattern=listOfAttributes->getDiscretePositions ( pattern );
			result->sample->insertElement ( discretePattern );
			//  zap(discretePattern);
			p=sample->getNext ( p );
		}
//		strcpy ( result->filename, this->filename );
		//strcpy ( result->filePos, this->filePos );
		result->verbosity=this->verbosity;

		return result;
	};

	/*___________________________________________________________________*/

	template <> intMLSample*  floatMLSample::getDiscreteSample()
	{

		if ( !this->listOfAttributes->allAttributesAreOrdinalOrCategorical() )
			throw BadFormat ( " intMLSample*  MLSample<T>::getDiscreteSample()" );

		intMLSample* result=new intMLSample();
		result->sample=new intSample();
		result->listOfAttributes=new ListOfAttributes ( *this->listOfAttributes );
		floatList *pattern;
		intList* discretePattern;
		for ( floatSample::iterator p=sample->getFirst();p!=sample->end(); p++ )
		{
			pattern=sample->getElement ( p );
			discretePattern=listOfAttributes->getDiscretePositions ( pattern );
			result->sample->insertElement ( discretePattern, result->sample->end() );
		}
//		strcpy ( result->filename, this->filename );
//		strcpy ( result->filePos, this->filePos );
		result->verbosity=this->verbosity;

		return result;
	}
	/*___________________________________________________________________________________*/

	template<class T> MLSample<string>* MLSample<T>::convertToStringWithClassAtTheEnd ( int classPosition )
	{
//throw NonImplemented("MLSample<T>::convertToStringWithClassAtTheEnd");

		intList*columns=new intList ( listOfAttributes->size(), 0 );
		columns->removeNode ( classPosition );
		columns->insertElementAtPos ( classPosition, listOfAttributes->size()-1 );
		stringMLSample* result=convertToString(), *result2=result->copyColumns ( columns, false );
		zap ( result );
		zap ( columns );
//		strcpy ( result2->filename, this->filename );
	//	strcpy ( result2->filePos, this->filePos );
		result2->verbosity=this->verbosity;
		return result2;
	}

	/*___________________________________________________________________________________*/

	template<class T> MLSample<string>* MLSample<T>::convertToString()
	{
		stringMLSample* result=new stringMLSample();
		result->sample=new stringSample();
		result->listOfAttributes=this->listOfAttributes->clone();
		Container<vector<T>,T> *pattern;
		stringList* stringPattern;
		for ( typename VectorSample<T>::Class::iterator p=sample->getFirst(); p!=sample->end(); p++ )
		{
			pattern=sample->getElement ( p );
			stringPattern=listOfAttributes->getStringPattern ( pattern );
			result->sample->insertElement ( stringPattern );
		}
//		strcpy ( result->filename, this->filename );
		//strcpy ( result->filePos, this->filePos );
		result->verbosity=this->verbosity;
		return result;
	}



	/*______________________________________________________*/

	template <class T> float MLSample<T>::getEmpiricalRisk ( intList* varList, intList* conditionantList )
	{
		return getMeasure ( mERM, varList, conditionantList );

	}
	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getEntropy ( intList* varList, intList* conditionantList )
	{
		return getMeasure ( mEntropy, varList, conditionantList );
	}
	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getSymmetricalUncertainty ( intList* varList, intList* conditionantList )
	{
		return getMeasure ( mSymmetricalUncertainty, varList, conditionantList );
	}
	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getInformationGain ( intList* varList, intList* conditionantList )
	{
		return getMeasure ( mInformationGain, varList, conditionantList );
	}

	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getCorrelation ( int classNum, intList* varList, Correlation<T>* correlation )
	{

		double measure=correlation->getMeasure ( this, varList );
		zap ( correlation );
		return measure;
	}
	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getMDL ( intList* varList, intList* conditionantList )
	{
		return getMeasure ( mMDL, varList, conditionantList );
	}
	/*______________________________________________________*/

	template <class T>   void MLSample<T>::checkPattern ( struct Vector<T>::Class* targetInputPattern )
	{
		try
		{
			for ( typename Vector<T>::Class::iterator it=targetInputPattern->begin(); it!=targetInputPattern->end(); it++ )
				listOfAttributes->getElement ( targetInputPattern->getPosition ( it ) )->checkValue ( *it );
		}
		catch ( BadFormat & bf ) {bf.addMessage ( "\ncalled from MLSample<T>::checkPattern" );throw;}
	}
	/*______________________________________________________*/

	template <class T>   void MLSample<T>::insertElement ( struct Vector<T>::Class* targetInputPattern )
	{
		checkPattern ( targetInputPattern );
		sample->insertElement ( targetInputPattern );
	}
	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getMeasure ( MeasureType measureType, intList* varList, intList* conditionantList )
	{
		float measure;
		if ( measureType==mEntropy || measureType==mMDL )  //entropy
			measure=getMeasureBasic ( mEntropy, varList, conditionantList );
		else
			if ( measureType==mBayesianScore )  //bayes score
				measure=getMeasureBasic ( mBayesianScore, varList, conditionantList );
			else measure=getMeasureBasic ( mERM, varList, conditionantList );
		/*
		if (measureType==mMDL)
		{
		cout <<"Error in getMeasure: mMDL not implemented yet";
		end();
		}
		*/
		if ( measureType==mSRM )
		{
			cout <<"Error in getMeasure: mSRM not implemented yet";
			end();
		}
		return measure;
	}
	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getMeasureBasic ( MeasureType measureType, intList* varList, intList* conditionantList, BayesType bayesType, float alpha )
	{

		DependenceMeasure<T>* dependenceMeasure;
		switch ( measureType )
		{
			case mEntropy: dependenceMeasure=new Entropy<T> ( bayesType, alpha ); break;
			case mERM: dependenceMeasure=new EmpiricalRisk<T> ( bayesType, alpha ); break;
			case mBayesianScore: dependenceMeasure=new BayesScore<T> ( bayesType, alpha ); break;
			case mSymmetricalUncertainty: dependenceMeasure=new SymmetricalUncertainty<T> ( bayesType, alpha ); break;
			case mInformationGain: dependenceMeasure=new InformationGain<T> ( bayesType, alpha ); break;
			case mMDL: dependenceMeasure=new MDL<T> ( bayesType, alpha ); break;
			case mSRM:
			{
				cout <<"Error in getMeasure: mSRM not implemented yet";
				end();
			}
			break;
		}

//MLSample<int>* discreteSample=this->getDiscreteSample();

		double measure=dependenceMeasure->getMeasure ( this->sample, this->listOfAttributes, varList, conditionantList );
		zap ( dependenceMeasure );
//zap(discreteSample);
		return measure;


		/*
		    intList* dimensionList=NULL, *allVars=NULL, *dimensionConditionantList=NULL;
		    PotentialTable *pt=NULL, *pt2=NULL;
		    if (conditionantList!=NULL)
		{
		allVars=new intList(*conditionantList);
		dimensionList=listOfAttributes->getDimensionList(conditionantList);
		dimensionConditionantList=listOfAttributes->getDimensionList(conditionantList);
		}
		else
		{
		allVars=new intList();
		dimensionList=new intList();
		}
		      allVars->copyPaste(varList);
		      dimensionList->paste(listOfAttributes->getDimensionList(varList));

		    float measure=0;
		    Prob freq, freq2=Prob(1,1), maxFreq, f;

		    pt=new PotentialTable(this, allVars, dimensionList, first, last);

		    int size=pt->getSize();
		    int size2=1, *pos;
		    if (conditionantList!=NULL) { pt2=new PotentialTable(this, conditionantList, dimensionConditionantList, first, last); size2=pt2->getSize();};
		    int *positions=NULL, offset=0;
		    for (int j2=0;j2<size2;j2++)//para cada configuraci�n de las variables condicionantes
		    {
		      if (conditionantList!=NULL){pos=pt2->getPositions(j2);freq2=pt2->getValue(pos);zaparr(pos);}
		      maxFreq=Prob(0,1);
		      for (int j=offset;j<offset+size/size2;j++) // para cada configuracion de variables independientes dada la configuracion actual de las condicionantes
		      {

		         freq=pt->getValue(j);

		         if (freq2.convert()!=0 && freq.convert()!=0 && (conditionantList!=NULL))
		            f=Prob(freq.getNumerator(),freq2.getNumerator());
			 else f=Prob(freq);
		         if (measureType==mEntropy)  //entropy
		{
				    if (f.convert()!=0) measure=measure-f.convert()*(f.log2());
		    //      cout <<"\nmeasure:" << measure;

			    }
		            else // accuracy
				if (maxFreq<f) maxFreq=f;
		       }

		      offset=offset+size/size2;


		if (measureType==mERM)
		measure=measure+freq2.convert()*(1-maxFreq.convert());

		    }; // end for
		zap(pt);
		zap(pt2);
		    zap(dimensionList);
		    zap(dimensionConditionantList);
		    zap(allVars);
		 // cout <<"\nmeasure:" << measure;

		     return measure;
		*/
	};//


	/*______________________________________________________*/

	template <class T>    float MLSample<T>::getMutualInformation ( intList* vars, intList* secondVars, intList* conditionants )
	{


		intList* vars3=new intList ( *secondVars );
		if ( conditionants!=NULL ) vars3->copyPaste ( conditionants );

		float mi=getEntropy ( vars, conditionants )-getEntropy ( vars, vars3 );
//cout << "entropu for the first:" << getEntropy(vars, conditionants) << " and for the second: " << getEntropy(vars, vars3);
		zap ( vars3 );
		return mi;
	};




	/*___________________________________________________________ */

	template <class T> KElementVector * MLSample<T>::getKClosestPatterns ( struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass *distanceMethodClass, bool useMissing, bool classWasRemovedOnlyInTarget, bool disregardClass, int classPosition, int classValue ) throw ( BadFormat , OutOfRange<int> )
// if classWasRemovedOnlyInTarget=true, it considers that the targetInputPattern comes without the class value
// if disregardClass, it gets the k closest elements without using any attribute as a class
	{
		if ( !disregardClass &&  ! classWasRemovedOnlyInTarget && ( classPosition<0 || classPosition > listOfAttributes->size() ) )
			throw BadFormat ( " KElementVector * MLSample<T>::getKClosestPatterns(struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass distanceMethodClass, bool noClass, int classPosition, int classValue)" );
		if ( classWasRemovedOnlyInTarget && ( classPosition<0 || classPosition > listOfAttributes->size() ) )
			throw BadFormat ( " 0. KElementVector * MLSample<T>::getKClosestPatterns(struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass distanceMethodClass, bool noClass, int classPosition, int classValue)" );
		if ( disregardClass && !classWasRemovedOnlyInTarget && ( classPosition<-1 || classPosition > listOfAttributes->size() ) )
			throw BadFormat ( " 1. KElementVector * MLSample<T>::getKClosestPatterns(struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass distanceMethodClass, bool noClass, int classPosition, int classValue)" );
		if ( classWasRemovedOnlyInTarget && targetInputPattern->size() != ( listOfAttributes->getTotalSelectedAttributes()-1 ) )
			throw BadFormat ( " 2. KElementVector * MLSample<T>::getKClosestPatterns(struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass distanceMethodClass, bool noClass, int classPosition, int classValue)" );
		if ( !classWasRemovedOnlyInTarget && targetInputPattern->size() !=listOfAttributes->getTotalSelectedAttributes() )
			throw BadFormat ( " 3. KElementVector * MLSample<T>::getKClosestPatterns(struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass distanceMethodClass, bool noClass, int classPosition, int classValue)" );
		struct Vector<T>::Class *inputPattern=NULL;
		long int cont=0;
		KElementVector::iterator p2, p3;
		KElement *kElement=NULL;
		KElementVector * kList= new KElementVector ( true );
		KElementVector::iterator pk;
		try
		{
			for ( typename VectorSample<T>::Class::iterator p=sample->begin(); p!=sample->end(); p++ )
			{
				if ( disregardClass || ( !disregardClass && ( classValue==sample->getElement ( p )->getElement ( classPosition ) ) ) )
				{
					kElement=new KElement();
					inputPattern=new struct Vector<T>::Class ( *sample->getElement ( p ) );
					kElement->SetClas ( ( int ) inputPattern->getElement ( classPosition ) );
					if ( classWasRemovedOnlyInTarget ) inputPattern->removeNode ( classPosition );
//  inputPattern->removeNode(classPosition);
					kElement->SetDistance ( listOfAttributes->getDistance ( inputPattern, targetInputPattern, useMissing, disregardClass, distanceMethodClass, classPosition ) );
					kElement->SetElementPos ( cont );
					pk=kList->getClosestGreaterPointerToElement ( kElement, false );

//cout << "pk is:" << *pk <<  "\n";
					kList->insertElement ( kElement, pk );
					zap ( inputPattern );
					if ( kList->size() >k )
					{
						p2=kList->getNode ( k-1 );
						while ( kList->size() >k && kList->getLastElement()->getDistance() >kList->getElement ( p2 )->getDistance() )
						{
							kElement=kList->pop();
							zap ( kElement );
						}
					}
				}//end if
				cont++;
			}
			; // end for
		}
		catch ( OutOfRange<int>& ore ) {ore.addMessage ( "\ncalled from MLSample<T>::getKClosestPatterns" ); throw;}
		catch ( BadFormat& bf ) {bf.addMessage ( "\ncalled from MLSample<T>::getKClosestPatterns" ); throw;}
		return kList;//
	};
	/*___________________________________________________________ */

	template <class T> MLSample<T>* MLSample<T>::getCompatibleSample ( struct Vector<T>::Class* targetInputPattern, bool useClass, int classPosition )
	{

		struct VectorSample<T>::Class* s=this->sample->getCompatibleSample ( targetInputPattern, this->listOfAttributes, useClass, classPosition );
		ListOfAttributes* l=new ListOfAttributes ( *this->listOfAttributes );
		MLSample<T>* result=new MLSample<T> ( s, verbosity, l );
		return result;
	}




} // end namespace
#endif
