#ifndef MLSample_h//
#define MLSample_h//


#include "../classifier/AlgTypeClass.h"

namespace BIOS
{

////////////////////////////

//typedef Sample<T, list> intSample;

	template <class T> class Correlation;

	template <class T> class MLSample

	{



			/**
			        @memo MLSample

			// It has a Sample plus a ListOfAttributes to describe it
			// If T=string, Sample has the original values
			// If T=float, Sample values have been converted according to type of attribute (categorical, ordina, discrete, continuous)

			// If T=int, there cannot be continuous attributes (they must have been discretized(

				@doc


			    @author Maria M. Abad
				@version 1.0
			*/
		public:


//float alpha;

//BayesType bayesType;

			VerbosityClass *verbosity;
			//char filename[256], filePos[256];
			ListOfAttributes* listOfAttributes;
			struct VectorSample<T>::Class * sample;

			void set ( char* filename, ListOfAttributes *listOfAttributes, char* tokens=NULL );

			int size();

			MLSample<T>* clone();

			MLSample ( ListOfAttributes *listOfAttributes,  struct VectorSample<T>::Class *sample,  VerbosityClass * verbosity=NULL );

//  MLSample(const MLSample &source){cout <<"MLSample(Const) not implemented yet"; end();};
//  MLSample(MLSample &source){cout <<"MLSample(&) not implemented yet"; end();};


			MLSample();
			MLSample ( MLSample &source );

			MLSample ( MLSample &source, typename  VectorSample<T>::Class::iterator first, typename  VectorSample<T>::Class::iterator last );

			/*___________________________________________________________ */

		//	MLSample ( char* filename, char* filepos, struct VectorSample<T>::Class* sample, VerbosityClass * verbosity, ListOfAttributes* listOfAttributes );

		//	MLSample ( struct VectorSample<T>::Class* sample, VerbosityClass * verbosity, ListOfAttributes* listOfAttributes );


			float getSNPDistance ( int att, int att2 );



// MLSample<T>* ExtractList(int indexVector[], int size);

			//void selectAndOrderColumns(intList* columns);


			MLSample ( char* filename, VerbosityClass *verbosity=NULL, char* tokens=NULL );


			MLSample<string>* convertToStringWithClassAtTheEnd ( int classPosition );



			void setIntervals ( DiscMode discMod, bool supervised, VerbosityClass *verbosity, int classPosition=-1 );

			intList* select ( int classNum, AlgType algType, SelMode selMode, VerbosityClass *verbosity, LossFunction* lossFunction, char* filename, char* secondFilename, floatList* selectionList=NULL, char* selectionFile=NULL, floatList* algorithmParameters=NULL );


			void removeMissingPatterns();
			MLSample<T>* copyColumns ( intList* columns, bool orderedByThis=true );//

			MLSample<T>* extractRowsWithPositionsIn ( intList* posList );

			MLSample<int> * getDiscreteSample();// {cout <<"not implemented"; end();};

			MLSample<int>*  convertToDiscreteSample();

			MLSample<string>* convertToString();

			MLSample<T>* getCompatibleSample ( struct Vector<T>::Class* targetInputPattern, bool useClass=false, int classPosition=-1 );//

			void insertElement ( struct Vector<T>::Class* targetInputPattern );

			void checkPattern ( struct Vector<T>::Class* targetInputPattern );
			//char* print();


//char* print(bool* seleccionados, bool* integer);

			void changeDomain();


//    MLSample(char* filename):Sample<T>::Sample(filename){};

// void HardCopy(char filename[256], bool* seleccionados);
//template <class T>  void Sample<T>::HardCopy(char filename[256], bool* seleccionados=NULL)

// MLSample(char* filename): para leer directamente de un fichero

			~MLSample();



//void HardCopy();

			int GetTotalInputAttributes();

//void setListOfAttributes(ListOfAttributes *listOfAttributes){this->listOfAttributes=listOfAttributes;};

			void HardCopy ( char filename[256] );

//void HardCopy(char filename[256], bool* seleccionados, bool* integer);
			/*
			MLSample<T>* moveColumn(int oldPos, int newPos, ListOfAttributes* listOfAttributes)
			{
			Sample<vector, vector, T>*s=Sample<vector, vector, T>::moveColumn(oldPos, newPos);
			MLSample<T>* ms=new MLSample<T>((MLSample<T>&)*s);
			ms->listOfAttributes=listOfAttributes;
			zap(s);
			return ms;
			};
			*/



			MLSample<T>* copySelection();

			void removePatternsWithMissingAttribute ( int attNumber );
			int getTotalModalidades ( int att );
			int getSize() {return sample->size();};

			float getMutualInformation ( intList* vars, intList* secondVars, intList* conditionants );

			float getEntropy ( intList* varList, intList* conditionantList );

			float getMDL ( intList* varList, intList* conditionantListL );

			float getBayesScore ( intList* varList, intList* conditionantList );

			float getCorrelation ( int classNum, intList* varList, Correlation<T>* correlation );

			float getSymmetricalUncertainty ( intList* varList, intList* conditionantList );

			float getInformationGain ( intList* varList, intList* conditionantList );

//float getJointMeasure(MeasureType measureType, intList* varList, intList* conditionantList);

			float getMeasure ( MeasureType measureType, intList* varList, intList* conditionantList=NULL );

			float getMeasureBasic ( MeasureType measureType, intList* varList, intList* conditionantList=NULL, BayesType bayesType=MLE, float alpha=0 );


			float getEmpiricalRisk ( intList* varList, intList* conditionantList );

			MLSample<T>* removeClass();

			KElementVector* getKClosestPatterns ( struct Vector<T>::Class* targetInputPattern, int k, DistanceMethodClass *distanceMethod, bool useMissing=false,  bool classWasRemovedOnlyInTarget=true, bool disregardClass=true, int classPosition=-1, int classValue=-1 ) throw ( BadFormat, OutOfRange<int> );


	};//

	/*______________________________________________________*/

	template<class T> ostream& operator<< ( ostream& out, MLSample<T>& lista )
	{
		// out << "\n";
		out << *lista.sample;
		out << *lista.listOfAttributes;
		return out;
	}

	typedef MLSample<int> intMLSample;
	typedef MLSample<float> floatMLSample;
	typedef MLSample<double> doubleMLSample;
	typedef MLSample<string> stringMLSample;
//#include "MLSample.cpp"


} // end namespace
#endif
