#ifndef MLSample_cpp//
#define MLSample_cpp//

#include "MLSample.h"

namespace BIOS
{
  
  
  /*___________________________________________________________________*/

  template <class T> MLSample<T>::MLSample(char* filename, ListOfAttributes *listOfAttributes, char* tokens)
  {
if (listOfAttributes==NULL)  this->listOfAttributes=new ListOfAttributes(filename);
else  this->listOfAttributes=new ListOfAttributes(*listOfAttributes, this->verbosity);
    set(filename, this->listOfAttributes, tokens);
     };
    /*___________________________________________________________________*/

  template <class T> void MLSample<T>::set(char* filename, ListOfAttributes *listOfAttributes, char* tokens)
  {

strcpy(this->filename, filename);

   Sample<string, list, ListOfPointers>* l=new Sample<string, list, ListOfPointers>(filename, tokens);
    typename Sample<string, list, ListOfPointers>::iterator p=l->getFirst();
    stringList *patternL;
   sample=new  Sample<T, list, ListOfPointers>();
   Container<T, list>* patternPos;     

   while (p!=NULL)
   {
    patternL=l->getElement(p);
    patternPos=listOfAttributes->getPositions(patternL);
    sample->insertElement(patternPos);
    zap(patternPos);
    p=l->getNext(p);
    }
    zap(l);
    };
    
 /*___________________________________________________________________*/
 template <class T>    MLSample<T>::MLSample(){listOfAttributes=NULL; sample=NULL;};
 /*___________________________________________________________________*/

   template <class T>  MLSample<T>::MLSample(MLSample<T> &source)
  {
  sample=new Sample<T, list, ListOfPointers>(*source.sample);
  listOfAttributes=new ListOfAttributes(*source.listOfAttributes, this->verbosity);
strcpy(this->filename, source.filename);
  };

    
 /*____________________________________________________________ */


  template <class T>   MLSample<T>* MLSample<T>::extractRowsWithPositionsIn(intList* posList)
        {
//Sample<Container<T> >
        MLSample<T> *newList=new MLSample<T>();
        newList->sample=this->sample->extractRowsWithPositionsIn(posList);
        newList->listOfAttributes=new ListOfAttributes(*this->listOfAttributes, this->verbosity);
        return newList;
           };

  /*___________________________________________________________________*/

  template <class T>   MLSample<T>::~MLSample()
  {zap(listOfAttributes); zap(sample);};

 /*____________________________________________________________________________________________*/

  template <class T> int MLSample<T>::getTotalModalidades(int att, typename Sample<T, list, ListOfPointers>::iterator first, typename Sample<T, list, ListOfPointers>::iterator last)
  {
    Modalidades *classModalidades=listOfAttributes->getElement(att)->GetModalidades();
    stringList::iterator p=classModalidades->getFirst();
    int cont=0, cont2=0;
    Set<AttPattern, ListOfPointers>* attPatterns;
    AttPattern* attPattern;
    while (p!=NULL)
    {
      attPattern=new AttPattern(1, cont, cont);
      attPatterns=new Set<AttPattern, ListOfPointers>();
      attPatterns->insertElement(attPattern);
        if (sample->GetAbsoluteFrequency(attPatterns, NULL, NULL)>(long int) 0)
        cont2++;
      p=classModalidades->getNext(p);
      zap(attPatterns);
      cont++;
    }
    return cont2;
  }
  /*___________________________________________________________ */

  template <class T>   void MLSample<T>::setIntervals(DiscMode discMod, bool supervised, int classAttribute)
  {
    Discretization* discretization;

    discretization=new Discretization(this, discMod, supervised, classAttribute);
    zap (discretization);

  }

  /*___________________________________________________________ */

 template <class T> intList* MLSample<T>::select(int classNum, AlgType algType, SelMode selMode, intList* verbosity, intList* attList, floatList* algorithm)
  {
//cout <<"classnum is " << classNum;
intList* selectedList=NULL;
      Selection* selection=new Selection(this, classNum);
      selectedList=selection->getSelection(selMode, algType, verbosity, attList, algorithm);
      zap (selection);
      return selectedList;
  }
  /*___________________________________________________________ */

 template <class T> MLSample<T>* MLSample<T>::copySelection()
  {
 MLSample<T>* newMLSample=new MLSample<T>();

ListOfAttributes* newListOfAttributes=listOfAttributes->select();
newMLSample->listOfAttributes=newListOfAttributes;
intList* selectedAtts=listOfAttributes->getSelection();
if (selectedAtts->size()==0)
{
cout <<"Error in MLSample::select, 0 attributes selected";
end();
}
Sample<T, list, ListOfPointers>* newSample=this->sample->copyColumns(selectedAtts);
strcpy(newMLSample->filename, this->filename);
newMLSample->sample=newSample;
zap(selectedAtts);
return newMLSample;    
    }
  /*___________________________________________________________ */

   template <class T>   MLSample<T>* MLSample<T>::copyColumns(intList* columns, bool orderedByThis)//
 {
MLSample<T>* res=new MLSample();
strcpy(res->filename, this->filename);

 res->sample=this->sample->copyColumns(columns, orderedByThis);
//cout <<res->sample->print() << "dd\n";

 res->listOfAttributes=(ListOfAttributes*)listOfAttributes->copyElementsWithPositionsIn(columns, false);//order in columns
return res;
 }
  /*___________________________________________________________________________________*/
/*
  template <class T, template <class T> class Cont>   char* MLSample<T>::print()
  {
    int totalAttributes=listOfAttributes->GetTotalAttributes();
    bool* seleccionados=new bool[totalAttributes], * integer=new bool[totalAttributes];



    InitializeList(seleccionados, totalAttributes, false);
    InitializeList(seleccionados, totalAttributes, false);

    for (int i=0;i<totalAttributes;i++)
      if (listOfAttributes->getElement(i)->isSelected())
      {
        seleccionados[i]=true;
        if (!listOfAttributes->getElement(i)->IsContinuous())
          integer[i]=true;
      }

    // zaparr(sample->line);
    // sample->line=new char[sample->Size*sample->getElement((int)0)->size()*20];

    // strcpy(line, sample->print(seleccionados, integer));
    sample->print();
//    zaparr(seleccionados);
    zaparr(integer);
    return sample->line;
  }
  /*___________________________________________________________________________________*/
/*
  template <class T, template <class T> class Cont>   char* MLSample<T>::print()
  {
    zaparr(sample->line);
    sample->line=new char[sample->Size*sample->getElement((int)0)->size()*20];
    //  char* l=&sline[0];
    strcpy(sample->line, "\0");
    //  ofstream  OutputFile;
    //OpenOutput(filename, &OutputFile);
    list<T> *pattern;
    typename Sample<T>::iterator p=sample->getFirst();
    int totalAttributes=listOfAttributes->GetTotalAttributes();
    bool missing[totalAttributes];

    while (p!=NULL)
    {
      pattern=getElement(p);
     // for (int i=0;i<totalAttributes;i++)
    //    if (listOfAttributes->getElement(i)->isMissing(pattern->getElement(i)))
     //     missing[i]=true;
      //  else missing[i]=false;
      strcat(sample->line, pattern->print();
      strcat(sample->line, "\n");
      p=getNext(p);
    }
    // OutputFile.close();
    return sample->line;
  }
  /*___________________________________________________________________________________*/

 template <class T>    void MLSample<T>::removePatternsWithMissingAttribute(int attNumber)
  {
    if (attNumber>= listOfAttributes->size())
{
cout <<"Error in MLSample::removePatternsWithMissingAttribute, att " << attNumber <<", out of range, max is " << listOfAttributes->size();
}
    list<T> *pattern;
    typename Sample<T, list, ListOfPointers>::iterator p=sample->getFirst(), p2;
    Attribute* attribute=listOfAttributes->getElement(attNumber);
    while (p!=NULL)
    {
      pattern=sample->getElement(p);
      if (attribute->isMissing(pattern->getElement(attNumber)))
      {
        p2=sample->getNext(p);
        sample->removeNode(p);
        p=p2;
      }
      else
        p=sample->getNext(p);

    }
  }
/*___________________________________________________________________________________*/
/*
  template <class T>   void MLSample<T>::selectColumns(intList* columns)//
  {
sample->Sample<T, list, ListOfPointers>::selectColumns(columns);
sample->listOfAttributes->selectElements(columns);
 };
 /*___________________________________________________________________________________*/

  template <class T>   void MLSample<T>::removeMissingPatterns()
  {
    list<T> *pattern;
    typename Sample<T, list, ListOfPointers>::iterator p=sample->getFirst(), p2;
//cout <<"NEWLIST IS:" << *listOfAttributes;
    while (p!=NULL)
    {
      pattern=sample->getElement(p);
      if (listOfAttributes->isMissing(pattern))
{
//cout <<"\nnode " << *pattern <<" is missing";
      p=sample->removeNode(p);
}
      else p=sample->getNext(p);
    }
  }
 /*___________________________________________________________________*/

template <class T> intMLSample*  MLSample<T>::getDiscreteSample()
  {
   intMLSample* result=new intMLSample();
    result->sample=new Sample<int, list, ListOfPointers>();
    result->listOfAttributes=new ListOfAttributes(*this->listOfAttributes);
//cout << *result->listOfAttributes;
//end();
    typename Sample<T, list, ListOfPointers>::iterator p=sample->getFirst();
    floatList *pattern;
    intList* discretePattern;
   while (p!=NULL)
   {
    pattern=sample->getElement(p);
    discretePattern=listOfAttributes->getDiscretePositions(pattern);
     result->sample->insertElement(discretePattern);
    zap(discretePattern);
    p=sample->getNext(p);
    }
    return result;
    };
  /*___________________________________________________________________________________*/
/*
   template<class T> MLSample<int>* MLSample<T>::getDiscreteSample;
()
  {
     MLSample<int>* discreteMLSample;
    discreteMLSample=new MLSample<int>();
    typename Sample<T, list, ListOfPointers>::iterator p=sample->getFirst();
    ListOfAttributes::iterator pA;
    floatList::iterator pp;
    intList* pattern;
    floatList *sourcePattern;
    discreteMLSample->sample=new Sample<int, list, ListOfPointers>();
    strcpy(discreteMLSample->filename, this->filename);
    while (p!=NULL)
    {
      sourcePattern=(floatList*)sample->getElement(p);
      pp=sourcePattern->getFirst();
      pA=listOfAttributes->getFirst();
      pattern=new intList();

      while(pA!=NULL)
      {
        pattern->insertElement((int)listOfAttributes->getElement(pA)->GetPureValue(sourcePattern->getElement(pp)));
        pA=listOfAttributes->getNext(pA);
        pp=sourcePattern->getNext(pp);
      }

      discreteMLSample->sample->insertElement(pattern);
      zap(pattern);
      p=sample->getNext(p);
    }
    discreteMLSample->listOfAttributes=listOfAttributes->GetDiscreteListOfAttributes();
    return discreteMLSample;
  }
/*___________________________________________________________________________________*/

   template<class T> MLSample<string>* MLSample<T>::convertToStringWithClassAtTheEnd(int classPosition)
  {
intList*columns=new intList();
for (int i=0;i<listOfAttributes->size();i++)
 columns->insertElement(i);
columns->moveElement(classPosition, listOfAttributes->size()-1);
     stringMLSample* result=convertToString(), *result2=result->copyColumns(columns, false);
zap(result);
zap(columns);
return result2;
}

/*___________________________________________________________________________________*/

   template<class T> MLSample<string>* MLSample<T>::convertToString()
  {
      stringMLSample* result=new stringMLSample();
    result->sample=new Sample<string, list, ListOfPointers>();
    result->listOfAttributes=new ListOfAttributes(*this->listOfAttributes, this->verbosity);
    typename Sample<T, list, ListOfPointers>::iterator p=sample->getFirst();
    list<T> *pattern;
    stringList* stringPattern;
    T value;
  
   while (p!=NULL)
   {
    pattern=sample->getElement(p);
    stringPattern=listOfAttributes->getStringPattern(pattern);
    result->sample->insertElement(stringPattern);
    zap(stringPattern);
    p=sample->getNext(p);
    }

    return result;
  }


  /*____________________________________________________________________________________________*/

  template <class T> float MLSample<T>::getJointMeasure(MeasureType measureType, int attClass, intList* varList, intList* conditionantList, float alpha, typename Sample<T, list, ListOfPointers>::iterator first, typename Sample<T, list, ListOfPointers>::iterator last, typename Sample<T, list, ListOfPointers>::iterator between)
  {
    int NL, NR, N;
    NL=sample->GetPos(between)+1-sample->GetPos(first);
    NR=sample->GetPos(last)-sample->GetPos(between);
    N=NL+NR;

    if (N==0 || NL==0 || NR==0)
    {
      cout <<"error, no values";
      exit(0);
    }
    return (getMeasure(measureType, attClass, varList, conditionantList, alpha, first, between)*NL+getMeasure(measureType, attClass, varList, conditionantList, alpha, sample->getNext(between), last)*NR)/(float)N;
  }

  /*______________________________________________________*/

  template <class T> float MLSample<T>::getEmpiricalRisk(int attClass, intList* varList, intList* conditionantList, float alpha, typename Sample<T, list, ListOfPointers>::iterator first, typename Sample<T, list, ListOfPointers>::iterator last)
  {
    return getMeasure(1, attClass, varList, conditionantList, alpha, first, last);

  }
  /*______________________________________________________*/

  template <class T>    float MLSample<T>::getEntropy(MeasureType measureType, int attClass, intList* varList, intList* conditionantList, float alpha, typename Sample<T, list, ListOfPointers>::iterator first, typename Sample<T, list, ListOfPointers>::iterator last)
  {
    return getMeasure(measureType, attClass, varList, conditionantList, alpha, first, last);
  }
  /*______________________________________________________*/

  template <class T>    float MLSample<T>::getMeasure(MeasureType measureType, int attClass, intList* varList, intList* conditionantList, float alpha, typename Sample<T, list, ListOfPointers>::iterator first, typename Sample<T, list, ListOfPointers>::iterator last)
  {
    if (conditionantList!=NULL && conditionantList->size()==0)
    {
      cout <<"Error in MLSample::getMeasure. Empty list of conditionant attributes";
      end();
    }
    intList* dimensionList=new intList(), *allVars=new intList(), *dimensionConditionantList=new intList();
    PotentialTable *pt=NULL, *pt2=NULL;
    if (conditionantList!=NULL)
      for (int i=0;i<conditionantList->size();i++)
      {
        allVars->insertElement(conditionantList->getElement(i));
        dimensionList->insertElement(listOfAttributes->getElement(conditionantList->getElement(i))->GetTotalModalidades());
        dimensionConditionantList->insertElement(listOfAttributes->getElement(conditionantList->getElement(i))->GetTotalModalidades());
      }
    for (int i=0;i<varList->size();i++)
    {
      allVars->insertElement(varList->getElement(i));
        dimensionList->insertElement(listOfAttributes->getElement(varList->getElement(i))->GetTotalModalidades());
      }
    float measure=0;
    Prob freq, freq2=Prob(1,1), maxFreq, f;
//     cout <<"\ng" << *allVars << "dimlist:" << *dimensionList <<"first" << first <<"last" << last <<"\n";
pt=new PotentialTable (this, allVars, dimensionList, alpha, first, last);
    int size=pt->getSize();
    int size2=1, *pos;
    if (conditionantList!=NULL) { pt2=new PotentialTable(this, conditionantList, dimensionConditionantList, alpha, first, last); size2=pt2->getSize();};


    int *positions=NULL, offset=0;
    for (int j2=0;j2<size2;j2++)
    {
      if (conditionantList!=NULL){pos=pt2->getPositions(j2);freq2=pt2->getProbability(pos);zaparr(pos);}
      maxFreq=Prob(0,1);
      for (int j=offset;j<offset+size/size2;j++)
      {
         freq=pt->getProbability(j);
         if (freq2.convert()!=0 && freq.convert()!=0 && (conditionantList!=NULL))
            f=Prob(freq.getNumerator(),freq2.getNumerator());
	 else f=Prob(freq);
         if (measureType==mEntropy || measureType==mMDL)  //entropy
	 {
	    if (f.convert()!=0)
	    measure=measure-freq.convert()*(f.log2());
            if (measureType==mMDL)
{
double N=(double)sample->getTotalPatterns(first, last);

measure=measure+getTotalModalidades(attClass, first, last)*measure/(double)N-log_2(N-1)/(double)N;
}
	    }
            else // accuracy 
		if (maxFreq<f) maxFreq=f;
       }
      offset=offset+size/size2;
      if (measureType==mERM || measureType==mSRM) 
{
measure=measure+freq2.convert()*(1-maxFreq.convert());
if (measureType==mSRM)
{
cout <<"Error in MLSample<T>::getMeasure, not implemente yet";
end();
}
}
    }; // end for
    zap(dimensionList);
    zap(dimensionConditionantList);
    zap(allVars);

     return measure;
    };//


  /*______________________________________________________*/

  template <class T>    float MLSample<T>::getMutualInformation(int classNum, intList* vars, intList* secondVars, intList* conditionants, float alpha, typename Sample<T, list, ListOfPointers>::iterator first=NULL, typename Sample<T, list, ListOfPointers>::iterator last=NULL)
  {

    intList* vars3=NULL;
    float mi=0.0;
    int tam=secondVars->size();
    if (conditionants!=NULL)
    {
      vars3=new intList();// it will contain secondVars plus conditionants;

      for (int i=0;i<tam;i++)
        vars3->insertElement(secondVars->getElement(i));
      for (int i=0;i<conditionants->size();i++)
        vars3->insertElement(conditionants->getElement(i));
    }
    else vars3=secondVars;
    mi=getEntropy(mEntropy, classNum, vars, conditionants, alpha)-getEntropy(mEntropy, classNum, vars, vars3, alpha, first, last);
    //  cout <<"mi:" << mi;

    if (conditionants!=NULL) zap(vars3);
    return mi;
  }







} // end namespace
#endif
