#ifndef EntropyAttributeDiscretization_cpp //
#define EntropyAttributeDiscretization_cpp //




//////

//using namespace UTILS;


namespace BIOS {

/*____________________________________________________________________________________________*/

EntropyAttributeDiscretization::EntropyAttributeDiscretization(floatMLSample* sample, bool half, bool puntos, bool parada, int minNumberOfInstancesPerInterval):IterativeDiscretization(sample, half, puntos, parada, minNumberOfInstancesPerInterval)
{
}
/*____________________________________________________________________________________________*/

EntropyAttributeDiscretization::~EntropyAttributeDiscretization()
{
}

/*____________________________________________________________________________________________*/

double EntropyAttributeDiscretization::getMargen2(intMLSample *currentSample, int position)
{
intSample::iterator p=currentSample->sample->getNode(position);
intMLSample* sL=new intMLSample(*currentSample, currentSample->sample->getFirst(), currentSample->sample->end()), *sR=new intMLSample(*currentSample, currentSample->sample->getNext(p), currentSample->sample->getLast());
intList* classList=new intList();
classList->insertElement(0);

double N=(double)currentSample->getSize();
double EL=sL->getEntropy(classList, NULL);
double ER=sR->getEntropy(classList, NULL);
zap(classList);
double NL=(double)sL->getSize();
double NR=(double)sR->getSize();
double jointEntropy=(NL*EL+NR*ER)/(float)N;
double margen=jointEntropy+
  		       log_2(pow(3,(int)currentSample->getTotalModalidades(0)-2))/(double)N+
		(sL->getTotalModalidades(0)*EL)/(double)N+
			(sR->getTotalModalidades(0)*ER)/(double)N; //
zap(sL);
zap(sR);
//return margen;
}
/*____________________________________________________________________________________________*/

double EntropyAttributeDiscretization::getMargen1(intMLSample *currentSample)
{
intList* varList=new intList();
varList->insertElement(0);
double margen=currentSample->getEntropy(varList,NULL);//
zap(varList);
return margen;
}

}


#endif
