#ifndef Extraction_cpp
#define Extraction_cpp



#include "Extraction.h"//
//////

//using namespace UTILS;


namespace BIOS {


  /*____________________________________________________________________________________________*/

  Extraction::~Extraction()
  {
zap(allAttributes);
zap(correlation);
zap(discSample);
  };
   /*____________________________________________________________________________________________*/

  Extraction::Extraction(floatMLSample* sample, int classNum, VerbosityClass verbosity)
  {
selModeClass=NULL;
this->verbosity=verbosity;
   this->classNum=classNum;
 //  this->listOfAttributes=sample->listOfAttributes; 
this->sample=sample;
allAttributes=new intList(sample->listOfAttributes->size());
discSample=sample->getDiscreteSample();
  }
   /*____________________________________________________________________________________________*/

  intList* Extraction::getExtraction(SelMode selMode, AlgType algType, LossFunction* lossFunction, floatList* selectionParameters, char* selectionFile, floatList* algorithmParameters)
  {
  try{
  int m, K;
  double threshold;
//intList *selectionList=NULL;
selModeClass= new SelModeClass(selMode, selectionParameters);
//if (positions==NULL) this->positions=NULL;
//else this->positions=positions;
intList *selectedAttributes=NULL, *selectedAttributes2=NULL;
  // listOfAttributes->removeExtraction();

correlation=NULL; 
double* weights=NULL;
if (selMode==forwardHillclimbingCorrelation)
correlation=new Correlation<int>(classNum, discSample); 
float maxDistanceThreshold;
ClassificationResults* rightResults; 
bool left=true;
int size0=0;
floatList* currentVars;
ClassifierTest* classifierTest;
NB *classifier=NULL;
   switch (selMode)
    {
    case todos: sample->listOfAttributes->selectAll(); break;
    case forwardHillclimbingSRM: 
    case forwardHillclimbingERM: 
    case forwardHillclimbingMDL:
    case forwardHillclimbingBayesScore: 
    case forwardHillclimbingEntropy: 
    case forwardHillclimbingCorrelation:
    case forwardHillclimbingWrapper: 
  	selectedAttributes=hillClimbingExtraction(selMode, true,  algType, algorithmParameters, lossFunction); 
//listOfAttributes->select(selectedAttributes); 
	break;
    case oneByOneBayesScore: 
    case oneByOneBayesScoreGenotypeLD: 
    case oneByOneEntropy:
    case oneByOneMDL:
    case oneByOneMDLGenotypeLD:
    case oneByOneLDMDL:
    case oneByOneLDBayesScore:
     selectedAttributes=classAssociationExtraction(selMode, selectionParameters);
break;
    case oneByOneAndConditionalBayesScore: 
    case oneByOneAndConditionalEntropy:
    case oneByOneAndConditionalMDL:
     selectedAttributes=classAssociationExtraction(selMode, selectionParameters);
     selectedAttributes=classAssociationExtraction(selMode, selectionParameters, selectedAttributes);     
break;
    case oneByOneAndPairsBayesScore: 
    case oneByOneAndPairsMDL:
     selectedAttributes=classAssociationExtraction(selMode, selectionParameters);
     selectedAttributes2=classAssociationByPairsExtraction(selMode, selectionParameters, selectedAttributes);     
     selectedAttributes->paste(selectedAttributes2);
break;
case oneByOneWrapper:
selectedAttributes=oneByOneWrapperExtraction(selMode, algType, algorithmParameters, lossFunction);
    break;  
    case manual: 
	if (selectionParameters==NULL) 
	{cout <<"Error 1 in manual selection"; exit(0);}; 
        selectedAttributes= selectionParameters->getIntList();
	//sample->listOfAttributes->select(selectedAttributes); 
       // selectedAttributes=new intList(*selectionList);
//zap(listOfAttributes);
        break;
    case treeWrapper: 
classifierTest=new ClassifierTest(sample, NULL, NULL, tCrossValidation, 2, verbosity, classNum, lossFunction);
currentVars=new floatList();
for (int i=0; i<sample->listOfAttributes->size();i++)
 currentVars->insertElement(i);
maxDistanceThreshold=sample->listOfAttributes->getMaxBasicDistance(classNum);
rightResults=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, currentVars, NULL, 0);
currentVars=treeWrapperExtraction(lossFunction, algType, algorithmParameters, maxDistanceThreshold, maxDistanceThreshold/2, rightResults, currentVars, size0);
zap(classifierTest);
selectedAttributes=currentVars->getIntList();
zap(currentVars);
break;
    case reliefF: 
    classifier=new NB(sample, classNum, algorithmParameters, verbosity, lossFunction);
    m=discSample->sample->size(), K=10;
    if (selectionParameters->size()>0 && selectionParameters->getElement(0)!=0) m= (int)selectionParameters->getElement(0);
    if (selectionParameters->size()>1 && selectionParameters->getElement(1)!=0) K= (int)selectionParameters->getElement(1);
    threshold=1/sqrt((double)m);
    if (selectionParameters->size()>2 && selectionParameters->getElement(2)!=0) threshold= selectionParameters->getElement(2);
    weights=getAttributesQualityUsingReliefF(m, K, classNum, classifier->probTables);
    selectedAttributes=new intList();
   // cout <<"thres:" << threshold;
    for (int i=0;i<discSample->listOfAttributes->size();i++)
     if (weights[i]>threshold) selectedAttributes->insertElement(i);
     zaparr(weights);
    zap(classifier);
// cout <<*selectedAttributes <<"\n";
    break;
    case manualFromFile: 

        SelSubmodeClass selSubmodeClass=SelSubmodeClass((SelSubmode)(int)selectionParameters->getFirstElement(), selectionFile);

        if (strcmp(selectionFile,"")==0) 
	{cout <<"Error 2 in manual selection"; exit(0);}; 
 	switch (selSubmodeClass.selSubmode)
	{
	case rows: // lines

        selectedAttributes=selSubmodeClass.rowExtractionStartingAt1(classNum);

	break;
	case rowsStartingAt0: // lines
        selectedAttributes=selSubmodeClass.rowExtraction(classNum);
	break;
	case blocks: // blocks
        selectedAttributes=selSubmodeClass.blockExtraction(classNum);
	}
        break;
// case filterKernel: selectedAttributes=filterKernelExtraction();break;
      }

zap(selModeClass);
// cout <<*selectedAttributes <<"\n";

return selectedAttributes;
}
catch (ZeroValue zv){zv.PrintMessage("Extraction::getExtraction");end();}

};

/*____________________________________________________________________________________________*/

intList*  Extraction::classAssociationExtraction(SelMode selMod, floatList* selectionParameters, intList *originalSelectedAttributes)
{
//cout << *((ListOfOrderedAttributes*)(discSample->listOfAttributes))->positionsVector;
bool conditional=false;
if (originalSelectedAttributes!=NULL) conditional=true;
sample->listOfAttributes->selectAll(); 
intList *selectedAttributes;
intList* vars=new intList(), *vars2=NULL, *vars3=NULL, *allVars=new intList();
bool genotypes=true, genotypes2;

if (!conditional) 
{
selectedAttributes=new intList(); selectedAttributes->insertElement(classNum);
allVars->insertElement(classNum);
vars3=new intList();
vars3->insertElement(1);
}
else 
{
selectedAttributes=new intList(*originalSelectedAttributes);
allVars->copyPaste(originalSelectedAttributes);
vars2=new intList();
vars2->insertElement(originalSelectedAttributes->size());
vars3=new intList(originalSelectedAttributes->size()+1);
vars3->removeNode(0);
} 
vars->insertElement(0);

intMLSample* narrowSample=NULL;
DependenceMeasure<int>* dependenceMeasure=NULL;
float alpha=0;
BayesType bayesType=MLE;
if (selectionParameters->size()>=1) bayesType=(BayesType)(selectionParameters->getElement(0));
if (selectionParameters!=NULL && selectionParameters->size()>=2) alpha=selectionParameters->getElement(1);
//cout <<"bayesType:" << bayesType <<", alpha: " << alpha;
double measureOnlyClass, measureConditional;
switch(selMod)
{
case oneByOneEntropy: 
case oneByOneAndConditionalEntropy: dependenceMeasure=new Entropy<int>(bayesType, alpha); break;
case oneByOneBayesScore:  
case oneByOneAndPairsBayesScore: 
case oneByOneLDBayesScore: 
case oneByOneBayesScoreGenotypeLD: 
case oneByOneAndConditionalBayesScore: dependenceMeasure=new BayesScore<int>(bayesType, alpha); break;
case oneByOneMDL:
case oneByOneMDLGenotypeLD:
case oneByOneLDMDL: 
case oneByOneAndConditionalMDL:
case oneByOneAndPairsMDL:
dependenceMeasure=new MDL<int>(bayesType, alpha); break;
default: cout <<"Extraction::classAssociationExtraction not implemented yet"; end();
}
//cout <<"\nClassNUM:" << classNum;
for (int i=0;i<allVars->size();i++)
 if (sample->listOfAttributes->getTotalModalidades(allVars->getElement(i))!=3) 
genotypes=false;

for (int i=0;i<sample->listOfAttributes->size();i++)
if ((!conditional && i!=classNum) || (conditional && originalSelectedAttributes->findElement(i)==NULL))
{
//cout <<"att:" << i;
genotypes2=true;
if (sample->listOfAttributes->getTotalModalidades(i)!=3) genotypes2=false;
allVars->insertElement(i);
narrowSample=discSample->copyColumns(allVars, false);
narrowSample->removeMissingPatterns();//required because DependenceMeasure class only remove selected vars
//cout << "VARS:" << *vars;// <<" \nsample: " << *narrowSample;

if ((selMod==oneByOneLDMDL || selMod==oneByOneLDBayesScore) && genotypes && genotypes2)
measureOnlyClass=dependenceMeasure->getLDMeasure(narrowSample, vars, vars2);
else measureOnlyClass=dependenceMeasure->getMeasure(narrowSample, vars, vars2);
if (selMod==oneByOneLDMDL || selMod==oneByOneLDBayesScore)
measureConditional=dependenceMeasure->getLDMeasure(narrowSample, vars, vars3);
else measureConditional=dependenceMeasure->getMeasure(narrowSample, vars, vars3);

//cout <<"\nclass meas:" << measureOnlyClass;
//cout <<"\ncond meas:" << measureConditional;
// a > b is equivalent to a(a+b)>0.5, we use a/(a+b)+weight>0.5 and thus, a>(0.5-eight)(a+b)
if ((selMod==oneByOneMDLGenotypeLD || selMod==oneByOneBayesScoreGenotypeLD))
measureConditional=(0.5-narrowSample->listOfAttributes->getWeight(0,1))*(measureConditional+measureOnlyClass);
//cout <<"\nweight:" << narrowSample->listOfAttributes->getWeight(0,1);

if (((selMod==oneByOneLDMDL || selMod==oneByOneLDBayesScore) && genotypes && genotypes2 &&  dependenceMeasure->better(measureConditional,  measureOnlyClass)) 
|| (selMod!=oneByOneLDMDL && selMod!=oneByOneLDBayesScore &&  dependenceMeasure->better(measureConditional,  measureOnlyClass)))
selectedAttributes->insertElement(i);


if (verbosity.verbosityR.selectionScores)
{
cout   << "\nConditional: " << measureConditional << " , marginal: " << measureOnlyClass;
}
allVars->Pop();
zap(narrowSample);
//end();
}
zap(allVars);
zap(vars);
zap(vars2);
zap(vars3);
zap(originalSelectedAttributes);
return (selectedAttributes);
}
/*____________________________________________________________________________________________*/

intList*  Extraction::classAssociationByPairsExtraction(SelMode selMod, floatList* selectionParameters, intList *originalSelectedAttributes)
{
sample->listOfAttributes->selectAll(); 
intList *selectedAttributes;
intList* vars=new intList(), *vars2=NULL, *allVars=new intList();

selectedAttributes=new intList(); 
allVars->insertElement(classNum);
vars2=new intList();
vars2->insertElement(0);
vars2->insertElement(2);
vars->insertElement(1);

intMLSample* narrowSample=NULL;
DependenceMeasure<int>* dependenceMeasure=NULL;
float alpha=0;
BayesType bayesType=MLE;
if (selectionParameters->size()>=1) bayesType=(BayesType)(selectionParameters->getElement(0));
if (selectionParameters!=NULL && selectionParameters->size()>=2) alpha=selectionParameters->getElement(1);
double measureOnlyVar;
switch(selMod)
{
case oneByOneAndPairsBayesScore: dependenceMeasure=new BayesScore<int>(bayesType, alpha); break;
case oneByOneAndPairsMDL: dependenceMeasure=new MDL<int>(bayesType, alpha); break;
default: cout <<"Extraction::classAssociationByPairsExtraction not implemented yet"; end();
}
bool first, second;

for (int i=0;i<sample->listOfAttributes->size();i++)
if (i!=classNum)
{
allVars->insertElement(i);
first=false;
if (originalSelectedAttributes!=NULL && originalSelectedAttributes->findElement(i)!=NULL)
 first=true; 
for (int j=i+1;j<sample->listOfAttributes->size();j++)
if (j!=classNum)
{
second=false;
if (originalSelectedAttributes!=NULL && originalSelectedAttributes->findElement(j)!=NULL) 
second=true;
if (!first || !second)
{
allVars->insertElement(j);
narrowSample=discSample->copyColumns(allVars, false);
measureOnlyVar=dependenceMeasure->getMeasure(narrowSample, vars);
if (dependenceMeasure->better(dependenceMeasure->getMeasure(narrowSample, vars, vars2),  measureOnlyVar))
{
if (!first && selectedAttributes->findElement(i)==NULL) selectedAttributes->insertElement(i);
if (!second && selectedAttributes->findElement(j)==NULL) selectedAttributes->insertElement(j);
}
//end();
allVars->Pop();
zap(narrowSample);
}
}
allVars->Pop();
}
zap(allVars);
zap(vars);
zap(vars2);
return (selectedAttributes);
}
 /*____________________________________________________________________________________________*/
/*
intList* Extraction::treeWrapperExtraction(LossFunction* lossFunction, AlgType algType, floatList* algorithmParameters)
{
// It only has sense whenever attributes are ordered, so .pos must exists.
// It returns a list with the set of consecutive input attributes with the highest accuracy.
// It uses a binary-search selection beginning with the sets of attributes with less and more of half of the total distance to the class.

floatList* currentVars=new floatList();
float currentDistanceThreshold=sample->listOfAttributes->getMaxBasicDistance(classNum);
Pair<int>  extremes=sample->listOfAttributes->getExtremes(classNum, currentDistanceThreshold);
for (int i=extremes.First; i<=extremes.Second;i++)
 if (i<extremes.Second || extremes.Second!=extremes.First)
 currentVars->insertElement((float)i);

cout <<"allextremes:" << *currentVars;

// alternative: floatList* currentVars=new floatList(listOfAttributes->size());

end();

ClassifierTest* classifierTest=new ClassifierTest(sample, NULL, NULL, tCrossValidation, 2, verbosity, classNum, lossFunction);
ClassificationResults cr=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, currentVars, NULL);


treeWrapperExtraction(lossFunction, currentDistanceThreshold/2, currentDistanceThreshold, currentVars, algType, algorithmParameters, cr, classifierTest);

zap(classifierTest);
//if (currentVars==NULL) cout <<"null"; else cout <<"nonull";
//cout <<"\n\nresults:\n" << *currentVars <<"\n";
intList* currentIntList=currentVars->getIntList();

zap(currentVars);
//cout <<*currentIntList <<"\n";
//end();
return currentIntList;
}
*/
  /*____________________________________________________________________________________________*/

floatList* Extraction::treeWrapperExtraction(LossFunction* lossFunction, AlgType& algType, floatList*& algorithmParameters, float rightDistanceThreshold, float leftDistanceThreshold, ClassificationResults* rightResults, floatList*& currentVars, int& otherVarsSize)
{
// It only has sense whenever attributes are ordered, so .pos must exists.
// It returns a list with the set of consecutive input attributes with the highest accuracy.
// It uses a binary-search selection beginning with the sets of attributes with less and more of half of the total distance to the class.

//cout <<"\n\ncurrent vars: " << *currentVars;
floatList* leftVars=new floatList();
int newSize;
Pair<int>  extremes;
extremes=sample->listOfAttributes->getExtremes(classNum, leftDistanceThreshold);
//cout << extremes;
//cout <<"maxdist:" << leftDistanceThreshold;
//cout <<"class num is:" << classNum;
//end();
for (int i=extremes.First; i<=extremes.Second;i++)
//if (i<extremes.Second || extremes.Second!=extremes.First)
 leftVars->insertElement((float)i);
/*
cout <<"\n\ncurrent vars: " << *currentVars;
if (otherVars!=NULL)
cout <<"\nother vars: " << *otherVars;
cout <<"\nleft vars: " << *leftVars;
*/
//if (*currentVars!=*leftVars && (otherVars==NULL || (*otherVars!=*leftVars)))
if (currentVars->size()!=leftVars->size() && otherVarsSize!=leftVars->size())
{
//cout <<"\ncurrentVars:" << *currentVars;
//cout <<"\newVars:" << *newVars;
ClassificationResults* leftResults;
ClassifierTest* classifierTest=new ClassifierTest(sample, NULL, NULL, tCrossValidation, 2, verbosity, classNum, lossFunction);
leftResults=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, leftVars, NULL, 0);
zap(classifierTest);
//cout <<"\nacc leftResults:" << leftResults.set.averageAccuracy << " for " << *leftVars << " and distance " << leftDistanceThreshold;
//cout <<"\nacc rightResults:" << rightResults.set.averageAccuracy << " for " << *currentVars << " and distance " << rightDistanceThreshold;
//if (abs(currentVars->size()-leftVars->size())>40)
if (leftResults->set.averageAccuracy!=rightResults->set.averageAccuracy) 
if (leftResults->set.averageAccuracy>rightResults->set.averageAccuracy) 
{
newSize=currentVars->size();
zap(currentVars);
currentVars=treeWrapperExtraction(lossFunction, algType, algorithmParameters, leftDistanceThreshold, leftDistanceThreshold/2, leftResults, leftVars, newSize);
}
else // worse
{
newSize=leftVars->size();
zap(leftVars);
currentVars=treeWrapperExtraction(lossFunction, algType, algorithmParameters, rightDistanceThreshold, (rightDistanceThreshold+leftDistanceThreshold)/2, rightResults, currentVars, newSize);
}
}
else zap(leftVars);
return (currentVars);
}
  /*____________________________________________________________________________________________*/

intList*  Extraction::oneByOneWrapperExtraction(SelMode selMod, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction)
{
intList *selectedAttributes=NULL;
bool reachedThreshold=false;
int newExtraction;
float currentThreshold=maxreal;

selectedAttributes=new intList();
selectedAttributes->insertElement(classNum);


newExtraction=findAttribute(selectedAttributes, selMod, true, currentThreshold, algType, algorithmParameters, lossFunction);
//cout <<"HOLA2\natt list is :" << *listOfAttributes;
selectedAttributes->insertElement(newExtraction);

//end();
return selectedAttributes;
}
  /*____________________________________________________________________________________________*/

intList*  Extraction::hillClimbingExtraction(SelMode selMod, bool forward, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction)
{
intList *selectedAttributes=NULL;
bool reachedThreshold=false;
int newExtraction;
float currentThreshold=maxreal;
if (!forward) 
selectedAttributes=new intList(*allAttributes);
else 
{
selectedAttributes=new intList();
selectedAttributes->insertElement(classNum);
}
int iteration=0;
do
{
newExtraction=findAttribute(selectedAttributes, selMod, forward, currentThreshold, algType, algorithmParameters, lossFunction);
//cout <<"HOLA2\natt list is :" << *listOfAttributes;
if (newExtraction==-1) reachedThreshold=true;
else if (forward) selectedAttributes->insertElement(newExtraction);
else selectedAttributes->removeNode(selectedAttributes->findElement(newExtraction)); 
iteration++;
//cout <<"\nit: " << iteration <<"\n";
}
while ((iteration<(sample->listOfAttributes->size()-1)) && !reachedThreshold);

//end();
return selectedAttributes;
}
  /*____________________________________________________________________________________________*/

int Extraction::findAttribute(intList* selectedAttributes, SelMode selMod, bool forward, float &currentThreshold, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction)
{
intList* newList=NULL, *remainingAttributes=allAttributes->copyElementsNotIn(selectedAttributes);
int remaining=remainingAttributes->size(), att, selectedAttribute=-1;
float newThreshold; //, partialThreshold=maxreal;
if (!forward) remaining=selectedAttributes->size()-1;

for (int i=0; i<remaining; i++)
{
newList=new intList(*selectedAttributes);
if (forward)
{
 att=remainingAttributes->getElement(i);
 newList->insertElement(att);
}
else if (att!=classNum) att=newList->removeNode(i);
sample->listOfAttributes->select(newList);
newThreshold=getThreshold(selMod, newList, algType, lossFunction, algorithmParameters);
if (currentThreshold>newThreshold)
{
currentThreshold=newThreshold;
selectedAttribute=att;
}
//cout <<"\nFind attributs:\nSelected attrs:" << *selectedAttributes << ", PLUS" << selectedAttribute;

//cout <<"\nFind attributs :\n" << * listOfAttributes;

sample->listOfAttributes->removeExtraction();
zap(newList);
}
return selectedAttribute;
}
  /*____________________________________________________________________________________________*/

double Extraction::getThreshold(SelMode selMode, intList* selectedAtts, AlgType algType, LossFunction* lossFunction, floatList* algorithmParameters)
{
MeasureType measureType;
ClassificationResults* result;
intList *conditionalList=NULL, *varList=NULL;
ClassifierTest* classifierTest=NULL;
//MLSample<float>* trainingSample=NULL, *testSample=NULL;
//intList* indexVector=NULL;
//Sampling* sampling=NULL;

switch (selMode)
{
case forwardHillclimbingSRM: measureType=mSRM; break;
case forwardHillclimbingERM: measureType=mERM; break;
case forwardHillclimbingMDL: measureType=mMDL; break;
case forwardHillclimbingEntropy: measureType=mEntropy; break;
case forwardHillclimbingBayesScore: measureType=mBayesianScore; break;
case forwardHillclimbingCorrelation: measureType=mCorrelation; break;
}
floatList* selectedAtts2=NULL;



float measure;
switch (selMode)
{
case forwardHillclimbingSRM: 
case forwardHillclimbingERM: 
case forwardHillclimbingMDL: 
case forwardHillclimbingEntropy: 
case forwardHillclimbingBayesScore:
conditionalList=new intList(*selectedAtts);
varList=new intList();
conditionalList->removeNode(conditionalList->findElement(classNum));
varList->insertElement(classNum);

//float alpha;
//if (algorithmParameters->getFirst()==NULL) alpha=0;
//else alpha=(float)algorithmParameters->getFirstElement();

measure=discSample->getMeasure(measureType, varList, conditionalList);
zap(varList);
zap(conditionalList);
if (forwardHillclimbingBayesScore) measure=-measure;
return measure;
break;
case forwardHillclimbingCorrelation:
varList=new intList(*selectedAtts);
varList->removeNode(varList->findElement(classNum));
measure=correlation->getMeasure(varList);
zap(varList);
return -measure;
break;
case forwardHillclimbingWrapper: 
classifierTest=new ClassifierTest(sample, NULL, NULL, tCrossValidation, 2, verbosity, classNum, lossFunction);
//if (sample->listOfAttributes->isDiscretized()) cout <<"disct"; else cout <<"no disc";
selectedAtts2=selectedAtts->getFloatList();
result=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, selectedAtts2, NULL, 0);

zap(classifierTest);
zap(selectedAtts2);
//zap(trainingSample);
//zap(testSample);
return 1-result->set.averageAccuracy;
break;
default: cout <<"Error in Extraction::getThreshold"; end();
break;
}
}
 /*______________________________________________________*/

double* Extraction::getAttributesQualityUsingReliefF(int m, int k, int classPosition, CPT** probTables)
  {
       try{
     int totalClassValues=discSample->listOfAttributes->getElement(classPosition)->GetTotalModalidades();

  CPT* classTable=probTables[classNum];
  double* results=Initialize(discSample->listOfAttributes->size(),(double)0);
  results[classPosition]=1;
  int tSampling=m;
  if (m==0) tSampling=discSample->getSize();
  Sampling* sampling=new Sampling(tSampling);

  int* pos=sampling->getPositionsTable();
  Container<int, list>* pattern;
  int classValue;
  ListOfPointers<KElement> **neighList=NULL;
  ListOfPointers<KElement>::iterator p;
  int e1, e2, cont;
  float distance;
  int e2Class;
  DistanceMethodClass distanceMethodClass;
  distanceMethodClass.numericalAttributeDistanceMethod=normalizedAbsoluteDifference;
  distanceMethodClass.distanceMethod=Sum;
try{
  for (int i=0;i<tSampling;i++)
  {
  neighList=new ListOfPointers<KElement>*[totalClassValues];
 
  pattern=new Container<int, list>(*discSample->sample->getElement(pos[i]));
  discSample->sample->removeNode(pos[i]);
  classValue=pattern->removeNode(classNum);

  for (int j=0;j<totalClassValues;j++)
    neighList[j]=discSample->getKClosestPatterns(pattern, k, distanceMethodClass, classNum, j);
  cont=0;
  for (int a=0;a<discSample->listOfAttributes->size();a++)
  if (a!=classPosition)
  {
  e1=pattern->getElement(cont);
  for (int j=0;j<totalClassValues;j++)
  {
  p=neighList[j]->getFirst();
  while(p!=NULL)
  {
  e2=discSample->sample->getElement(neighList[j]->getElement(p)->getElementPos())->getElement(cont);
  e2Class=discSample->sample->getElement(neighList[j]->getElement(p)->getElementPos())->getElement(classNum);
  distance=discSample->listOfAttributes->getElement(a)->getDistance(e1, e2, normalizedAbsoluteDifference, true, classValue, e2Class, probTables[a]);
  if (j==classValue) results[a]=results[a]-distance/(neighList[j]->size()*tSampling);
  else results[a]=results[a]+distance*classTable->getValue(j).convert()/(1-classTable->getValue(classValue).convert())/(neighList[j]->size()*tSampling);
  p=neighList[j]->getNext(p);
  }
  } 
  cont++;
  }
  zaparr(neighList, totalClassValues);
  pattern->insertElementAtPos(classValue, classNum);
  discSample->sample->insertElementAtPos(pattern, pos[i]);
  zap(pattern);
  }
}
catch (NonProb np){np.PrintMessage(" Extraction::getAttributesQualityUsingReliefF");};

  zap(sampling);
  return results;
  }
catch (ZeroValue zv){zv.PrintMessage("MLSample<T>::getAttributesQualityUsingReliefF");end();}

  }
  /*____________________________________________________________________________________________*/
/*
intList*  Extraction::wrapperExtraction()
{
// Returns a list with the set of consecutive input attributes with the highest accuracy.
// It uses a forward selection beginning with the attribute in the middle.
 
bool encontrado;
unsigned int TotalInputAttributes=listOfInputAttributes->size(), i;
ListOfInputAttributes *listOfSelectedAttributes, *copyListOfInputAttributes;
*copyListOfInputAttributes=*listOfInputAttributes;
listOfSelectedAttributes= new ListOfInputAttributes();
ListOfInputAttributes::iterator pA;
Attribute attribute;
do 
{
encontrado=false;
pA=copyListOfInputAttributes->getFirst;
while (pA!=NULL)
{
 listOfSelectedAttributes->InsertElement(copyListOfInputAttributes->getElement(pA));
 texto2=ProjectSample(texto, listOfSelectedAttributes);
 classifier=new Classifier(texto2, dependiente, parameters);
 TasaAciertos=classifier->GetAveragedAccuracy(testMethod);  
 attribute=listOfSelectedAttributes->PopElement();
 if (TasaAciertos>MaxTasa) 
 { 
  MaxTasa=TasaAciertos; 
  encontrado=true;
  attNumber=copyListOfInputAttributes->GetPos(pA);
 } 
 pA=copyListOfInputAttributes->getNext(pA);  
}  
 if (encontrado) 
{
 listOfSelectedAttributes->InsertElement(copyListOfInputAttributes->getElement(GetNode(attNumber));
 copyListOfInputAttributes->RemoveElement(copyListOfInputAttributes->getElement(GetNode(attNumber));
}
}
 while (encontrado); //
};

/*____________________________________________________________________________________________*/

  
}
#endif
