#ifndef Extraction_h
#define Extraction_h






namespace BIOS {

class ClassifierTest;
class ClassificationResults;
class CPT;

class Extraction {

/**
Extraction can be done in three ways:
1. Embeded in a learning algorithmParameters (not in this class)
2. Filtered before using the sample to learn a classifier or whatever. 
3. Wrapping a learning algorithmParameters so that accuracy will drive the selected attributes, as the treeWrapper selmode

There is other classification:
1. by-user selection (when selected attributes are chosen by the user).
2. Class-driven discretization

Any of them can be filtered or embedded, while wrapping forces class-driven
*/

private:


Correlation<int>* correlation;
SelModeClass *selModeClass;
//ListOfAttributes* listOfAttributes;
int classNum;
intList* allAttributes;
floatMLSample* sample;
intMLSample* discSample;
//SelMode selMode;
//AttributeExtraction* attributeExtraction;
floatList* selectAttributes(floatMLSample* narrowSample);
double getThreshold(SelMode selMode, intList* selectedAtts, AlgType algType, LossFunction* lossFunction, floatList* algorithmParameters=NULL);
VerbosityClass verbosity;

public:

        Extraction(floatMLSample* sample, int classNum, VerbosityClass verbosity); //
	
	intList* getExtraction(SelMode selMode, AlgType algType, LossFunction* lossFunction, floatList* selectionParameters=NULL, char* selectionFile=NULL, floatList* algorithmParameters=NULL);
	~Extraction();
    	intList*  hillClimbingExtraction(SelMode selMod, bool forward, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction);
	int findAttribute(intList* selectedAttributes, SelMode selMod, bool forward, float &currentThreshold, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction);
intList*  classAssociationExtraction(SelMode selMod, floatList* selectionParameters=NULL, intList *selectedAttributes=NULL);
intList*  classAssociationByPairsExtraction(SelMode selMod, floatList* selectionParameters=NULL, intList *originalSelectedAttributes=NULL);
//	intList* treeWrapperExtraction(LossFunction* lossFunction, AlgType algType, floatList* algorithmParameters);

floatList* treeWrapperExtraction(LossFunction* lossFunction, AlgType& algType, floatList*& algorithmParameters, float rightDistanceThreshold, float leftDistanceThreshold, ClassificationResults* rightResults, floatList*& currentVars, int& otherVarsSize);



intList*  oneByOneWrapperExtraction(SelMode selMod, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction);

double* getAttributesQualityUsingReliefF(int m, int k, int classPosition, CPT** probTables);


};


}
#endif

//#include "Extraction.cpp"//
